/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.core.AbstractProjectWebServiceViewImpl;
import org.netbeans.modules.websvc.core.ProjectWebServiceView;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsClientNode;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsNode;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

final class ProjectJaxWsWebServiceView
extends AbstractProjectWebServiceViewImpl
implements PropertyChangeListener {
    private JaxWsModel jaxWsModel;
    private JAXWSSupport jaxwsSupport;
    private JAXWSClientSupport jaxwsClientSupport;
    private PropertyChangeListener weakModelListener;

    ProjectJaxWsWebServiceView(Project project) {
        super(project);
        this.jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class);
        this.weakModelListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.jaxWsModel);
        FileObject fileObject = project.getProjectDirectory();
        this.jaxwsSupport = JAXWSSupport.getJAXWSSupport((FileObject)fileObject);
        this.jaxwsClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)fileObject);
    }

    public Node[] createView(ProjectWebServiceView.ViewType viewType) {
        switch (viewType) {
            case SERVICE: {
                return this.createServiceNodes();
            }
            case CLIENT: {
                return this.createClientNodes();
            }
        }
        return new Node[0];
    }

    private Node[] createServiceNodes() {
        Object object;
        Service[] serviceArray = this.jaxWsModel.getServices();
        if (serviceArray == null || serviceArray.length <= 0) {
            return new Node[0];
        }
        Sources sources = (Sources)this.getProject().getLookup().lookup(Sources.class);
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        if (sources != null && (object = sources.getSourceGroups("java")) != null) {
            for (SourceGroup sourceGroup : object) {
                arrayList.add(sourceGroup.getRootFolder());
            }
        }
        if (arrayList.isEmpty()) {
            return new Node[0];
        }
        object = new ArrayList();
        block1: for (SourceGroup sourceGroup : serviceArray) {
            String string = sourceGroup.getImplementationClass();
            if (string == null) continue;
            for (FileObject fileObject : arrayList) {
                FileObject fileObject2 = fileObject.getFileObject(string.replace('.', '/') + ".java");
                if (fileObject2 == null) continue;
                ((ArrayList)object).add(new JaxWsNode(this.jaxWsModel, (Service)sourceGroup, fileObject, fileObject2));
                continue block1;
            }
        }
        return ((ArrayList)object).toArray(new Node[((ArrayList)object).size()]);
    }

    private Node[] createClientNodes() {
        ArrayList<JaxWsClientNode> arrayList = new ArrayList<JaxWsClientNode>();
        Client[] clientArray = this.jaxWsModel.getClients();
        if (clientArray != null && clientArray.length > 0) {
            for (Client client : clientArray) {
                arrayList.add(new JaxWsClientNode(this.jaxWsModel, client, this.getProject().getProjectDirectory()));
            }
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    public boolean isViewEmpty(ProjectWebServiceView.ViewType viewType) {
        switch (viewType) {
            case SERVICE: {
                return this.jaxWsModel == null || this.jaxwsSupport == null || this.jaxWsModel.getServices().length == 0;
            }
            case CLIENT: {
                return this.jaxWsModel == null || this.jaxwsClientSupport == null || this.jaxWsModel.getClients().length == 0;
            }
        }
        return true;
    }

    public void addNotify() {
        if (this.jaxWsModel != null) {
            this.jaxWsModel.addPropertyChangeListener(this.weakModelListener);
        }
    }

    public void removeNotify() {
        if (this.jaxWsModel != null) {
            this.jaxWsModel.removePropertyChangeListener(this.weakModelListener);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        if (object instanceof Service || object2 instanceof Service) {
            this.fireChange(ProjectWebServiceView.ViewType.SERVICE);
        }
        if (object instanceof Client || object2 instanceof Client) {
            this.fireChange(ProjectWebServiceView.ViewType.CLIENT);
        }
    }
}

