/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.core.ProjectWebServiceViewImpl;
import org.netbeans.modules.websvc.core.ProjectWebServiceViewProvider;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectWebServiceView {
    private static final Lookup.Result<ProjectWebServiceViewProvider> implementations = Lookup.getDefault().lookup(new Lookup.Template(ProjectWebServiceViewProvider.class));
    private static final LookupListener lookupListener = new LookupListener(){

        public void resultChanged(LookupEvent lookupEvent) {
            if (views == null) {
                return;
            }
            for (ProjectWebServiceView projectWebServiceView : views.values()) {
                projectWebServiceView.updateImpls(true);
            }
        }
    };
    private static Hashtable<Project, ProjectWebServiceView> views;
    private Project project;
    private List<ProjectWebServiceViewImpl> impls;
    private List<ChangeListener> serviceListeners;
    private List<ChangeListener> clientListeners;
    private ChangeListener serviceListener;
    private ChangeListener clientListener;

    private ProjectWebServiceView(Project project) {
        this.project = project;
        this.serviceListener = new ChangeListenerDelegate(ViewType.SERVICE);
        this.clientListener = new ChangeListenerDelegate(ViewType.CLIENT);
    }

    List<ProjectWebServiceViewImpl> getWebServiceViews() {
        return this.impls != null ? Collections.unmodifiableList(this.impls) : this.impls;
    }

    final void addChangeListener(ChangeListener changeListener, ViewType viewType) {
        switch (viewType) {
            case SERVICE: {
                if (this.serviceListeners == null) {
                    this.serviceListeners = new ArrayList<ChangeListener>();
                }
                this.serviceListeners.add(changeListener);
                break;
            }
            case CLIENT: {
                if (this.clientListeners == null) {
                    this.clientListeners = new ArrayList<ChangeListener>();
                }
                this.clientListeners.add(changeListener);
            }
        }
    }

    final void removeChangeListener(ChangeListener changeListener, ViewType viewType) {
        switch (viewType) {
            case SERVICE: {
                if (this.serviceListeners == null) break;
                this.serviceListeners.remove(changeListener);
                break;
            }
            case CLIENT: {
                if (this.clientListeners == null) break;
                this.clientListeners.remove(changeListener);
            }
        }
    }

    final void fireChange(ChangeEvent changeEvent, ViewType viewType) {
        if (changeEvent == null) {
            changeEvent = new ChangeEvent(this);
        }
        try {
            switch (viewType) {
                case SERVICE: {
                    for (ChangeListener changeListener : this.serviceListeners) {
                        changeListener.stateChanged(changeEvent);
                    }
                    return;
                }
                case CLIENT: {
                    for (ChangeListener changeListener : this.clientListeners) {
                        changeListener.stateChanged(changeEvent);
                    }
                    return;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private final Node[] createView(ViewType viewType) {
        this.initImpls();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (ProjectWebServiceViewImpl projectWebServiceViewImpl : this.getWebServiceViews()) {
            if (projectWebServiceViewImpl.isViewEmpty(viewType)) continue;
            arrayList.addAll(Arrays.asList(projectWebServiceViewImpl.createView(viewType)));
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    final boolean isViewEmpty(ViewType viewType) {
        this.initImpls();
        for (ProjectWebServiceViewImpl projectWebServiceViewImpl : this.getWebServiceViews()) {
            if (projectWebServiceViewImpl.isViewEmpty(viewType)) continue;
            return false;
        }
        return true;
    }

    void addNotify() {
        if (views == null) {
            views = new Hashtable();
        }
        views.put(this.project, this);
        this.initImpls();
        for (ProjectWebServiceViewImpl projectWebServiceViewImpl : this.getWebServiceViews()) {
            projectWebServiceViewImpl.addNotify();
            projectWebServiceViewImpl.addChangeListener(this.serviceListener, ViewType.SERVICE);
            projectWebServiceViewImpl.addChangeListener(this.clientListener, ViewType.CLIENT);
        }
    }

    void removeNotify() {
        if (views != null && views.get(this.project) == this) {
            views.remove(this.project);
        }
        if (this.getWebServiceViews() != null) {
            for (ProjectWebServiceViewImpl projectWebServiceViewImpl : this.getWebServiceViews()) {
                projectWebServiceViewImpl.removeChangeListener(this.serviceListener, ViewType.SERVICE);
                projectWebServiceViewImpl.removeChangeListener(this.clientListener, ViewType.CLIENT);
                projectWebServiceViewImpl.removeNotify();
            }
        }
    }

    private void callImplAddNotify(ProjectWebServiceViewImpl projectWebServiceViewImpl) {
        projectWebServiceViewImpl.addNotify();
        projectWebServiceViewImpl.addChangeListener(this.serviceListener, ViewType.SERVICE);
        projectWebServiceViewImpl.addChangeListener(this.clientListener, ViewType.CLIENT);
    }

    private void callImplRemoveNotify(ProjectWebServiceViewImpl projectWebServiceViewImpl) {
        projectWebServiceViewImpl.removeChangeListener(this.serviceListener, ViewType.SERVICE);
        projectWebServiceViewImpl.removeChangeListener(this.clientListener, ViewType.CLIENT);
        projectWebServiceViewImpl.removeNotify();
    }

    private void initImpls() {
        if (this.getWebServiceViews() == null) {
            this.impls = new ArrayList<ProjectWebServiceViewImpl>(ProjectWebServiceView.createWebServiceViews(this.project));
        }
    }

    private void updateImpls(boolean bl) {
        ArrayList<ProjectWebServiceViewImpl> arrayList;
        if (this.getWebServiceViews() == null) {
            this.initImpls();
            if (bl) {
                for (ProjectWebServiceViewImpl projectWebServiceViewImpl : this.getWebServiceViews()) {
                    this.fireChange(new ChangeEvent(projectWebServiceViewImpl), ViewType.SERVICE);
                    this.fireChange(new ChangeEvent(projectWebServiceViewImpl), ViewType.CLIENT);
                    this.callImplAddNotify(projectWebServiceViewImpl);
                }
            }
            return;
        }
        ArrayList<ProjectWebServiceViewImpl> arrayList2 = new ArrayList<ProjectWebServiceViewImpl>(this.getWebServiceViews());
        if (arrayList2.containsAll(arrayList = new ArrayList<ProjectWebServiceViewImpl>(ProjectWebServiceView.createWebServiceViews(this.project)))) {
            arrayList2.removeAll(arrayList);
            for (ProjectWebServiceViewImpl projectWebServiceViewImpl : arrayList2) {
                if (bl) {
                    this.fireChange(new ChangeEvent(projectWebServiceViewImpl), ViewType.SERVICE);
                    this.fireChange(new ChangeEvent(projectWebServiceViewImpl), ViewType.CLIENT);
                    this.callImplRemoveNotify(projectWebServiceViewImpl);
                }
                this.impls.remove(projectWebServiceViewImpl);
            }
            return;
        }
        if (arrayList.containsAll(arrayList2)) {
            arrayList.removeAll(arrayList2);
            for (ProjectWebServiceViewImpl projectWebServiceViewImpl : arrayList) {
                if (bl) {
                    this.fireChange(new ChangeEvent(projectWebServiceViewImpl), ViewType.SERVICE);
                    this.fireChange(new ChangeEvent(projectWebServiceViewImpl), ViewType.CLIENT);
                    this.callImplAddNotify(projectWebServiceViewImpl);
                }
                this.impls.add(projectWebServiceViewImpl);
            }
            return;
        }
        arrayList2.removeAll(arrayList);
        arrayList.removeAll(this.getWebServiceViews());
        for (ProjectWebServiceViewImpl projectWebServiceViewImpl : arrayList2) {
            if (bl) {
                this.fireChange(new ChangeEvent(projectWebServiceViewImpl), ViewType.SERVICE);
                this.fireChange(new ChangeEvent(projectWebServiceViewImpl), ViewType.CLIENT);
                this.callImplRemoveNotify(projectWebServiceViewImpl);
            }
            this.impls.remove(projectWebServiceViewImpl);
        }
        for (ProjectWebServiceViewImpl projectWebServiceViewImpl : arrayList) {
            if (bl) {
                this.fireChange(new ChangeEvent(projectWebServiceViewImpl), ViewType.SERVICE);
                this.fireChange(new ChangeEvent(projectWebServiceViewImpl), ViewType.CLIENT);
                this.callImplAddNotify(projectWebServiceViewImpl);
            }
            this.impls.add(projectWebServiceViewImpl);
        }
    }

    static Lookup.Result<ProjectWebServiceViewProvider> getProviders() {
        return implementations;
    }

    static ProjectWebServiceView getProjectWebServiceView(Project project) {
        ProjectWebServiceView projectWebServiceView;
        if (views == null || (projectWebServiceView = views.get(project)) == null) {
            return new ProjectWebServiceView(project);
        }
        return projectWebServiceView;
    }

    private static List<ProjectWebServiceViewImpl> createWebServiceViews(Project project) {
        Collection collection = ProjectWebServiceView.getProviders().allInstances();
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ProjectWebServiceViewImpl> arrayList = new ArrayList<ProjectWebServiceViewImpl>();
        for (ProjectWebServiceViewProvider projectWebServiceViewProvider : collection) {
            arrayList.add(projectWebServiceViewProvider.createProjectWebServiceView(project));
        }
        return arrayList;
    }

    public Node[] getServiceNodes(Project project) {
        return ProjectWebServiceView.createWebServiceNodes(project, ViewType.SERVICE);
    }

    public Node[] getClientNodes(Project project) {
        return ProjectWebServiceView.createWebServiceNodes(project, ViewType.CLIENT);
    }

    private static Node[] createWebServiceNodes(Project project, ViewType viewType) {
        List<ProjectWebServiceViewImpl> list = ProjectWebServiceView.createWebServiceViews(project);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (ProjectWebServiceViewImpl projectWebServiceViewImpl : list) {
            if (projectWebServiceViewImpl.isViewEmpty(viewType)) continue;
            arrayList.addAll(Arrays.asList(projectWebServiceViewImpl.createView(viewType)));
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    static {
        implementations.addLookupListener(lookupListener);
    }

    private final class ChangeListenerDelegate
    implements ChangeListener {
        private final ViewType viewType;

        private ChangeListenerDelegate(ViewType viewType) {
            this.viewType = viewType;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ProjectWebServiceView.this.fireChange(changeEvent, this.viewType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ViewType {
        SERVICE,
        CLIENT;

    }
}

