/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.Car;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.core.JaxWsStackProvider;
import org.netbeans.modules.websvc.core.ServerType;
import org.netbeans.modules.websvc.serverapi.api.WSStackFeature;
import org.openide.filesystems.FileObject;

public class ProjectInfo {
    private Project project;
    private int projectType;
    public static final int JSE_PROJECT_TYPE = 0;
    public static final int WEB_PROJECT_TYPE = 1;
    public static final int EJB_PROJECT_TYPE = 2;
    public static final int CAR_PROJECT_TYPE = 3;
    private boolean jsr109Supported = false;
    private boolean wsgenSupported = false;
    private boolean wsimportSupported = false;
    private ServerType serverType;

    public ProjectInfo(Project project) {
        Car car;
        EjbJar ejbJar;
        String string;
        this.project = project;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null && (string = j2eeModuleProvider.getServerInstanceID()) != null) {
            try {
                ejbJar = Deployment.getDefault().getServerInstance(string).getJ2eePlatform();
                car = JaxWsStackProvider.getJaxWsStackForTool((J2eePlatform)ejbJar, "tool_wsimport");
                if (car != null) {
                    this.jsr109Supported = car.getServiceFeatures().contains(WSStackFeature.JSR_109);
                    this.wsgenSupported = car.getServiceFeatures().contains("tool_wsgen");
                    this.wsimportSupported = true;
                    this.serverType = this.getServerType(project);
                }
            }
            catch (InstanceRemovedException instanceRemovedException) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Failed to find J2eePlatform", instanceRemovedException);
            }
        }
        string = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        ejbJar = EjbJar.getEjbJar((FileObject)project.getProjectDirectory());
        car = Car.getCar((FileObject)project.getProjectDirectory());
        this.projectType = ejbJar != null ? 2 : (string != null ? 1 : (car != null ? 3 : 0));
    }

    public int getProjectType() {
        return this.projectType;
    }

    public Project getProject() {
        return this.project;
    }

    public boolean isJsr109Supported() {
        return this.jsr109Supported;
    }

    public boolean isWsgenSupported() {
        return this.wsgenSupported;
    }

    public boolean isWsimportSupported() {
        return this.wsimportSupported;
    }

    public ServerType getServerType() {
        return this.serverType;
    }

    private ServerType getServerType(Project project) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider.getServerInstanceID() == null) {
            return ServerType.NOT_SPECIFIED;
        }
        String string = j2eeModuleProvider.getServerID();
        if (string.startsWith("Tomcat")) {
            return ServerType.TOMCAT;
        }
        if (string.equals("J2EE")) {
            return ServerType.GLASSFISH;
        }
        if (string.equals("GlassFish")) {
            return ServerType.GLASSFISH;
        }
        if (string.equals("APPSERVER")) {
            return ServerType.GLASSFISH;
        }
        if (string.equals("JavaEE")) {
            return ServerType.GLASSFISH;
        }
        if (string.startsWith("JBoss")) {
            return ServerType.JBOSS;
        }
        if (string.startsWith("WebLogic")) {
            return ServerType.WEBLOGIC;
        }
        if (string.startsWith("WebSphere")) {
            return ServerType.WEBSPHERE;
        }
        return ServerType.UNKNOWN;
    }
}

