/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core;

import java.util.Collection;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.websvc.core.jaxwsstack.IdeJaxWsStack;
import org.netbeans.modules.websvc.core.jaxwsstack.JdkJaxWsStack;
import org.netbeans.modules.websvc.serverapi.api.WSStack;
import org.netbeans.modules.websvc.serverapi.api.WSStackProvider;
import org.netbeans.modules.websvc.serverapi.spi.WSStackFactory;
import org.netbeans.modules.websvc.serverapi.spi.WSStackSPI;

public class JaxWsStackProvider {
    private static WSStack jdkJaxWsStack;
    private static WSStack ideJaxWsStack;

    public static WSStack getJaxWsStack(J2eePlatform j2eePlatform) {
        Collection collection = j2eePlatform.getLookup().lookupAll(WSStack.class);
        for (WSStack wSStack : collection) {
            if (!"stack_jax_ws".equals(wSStack.getName())) continue;
            return wSStack;
        }
        return null;
    }

    public static WSStack getJaxWsStackForTool(J2eePlatform j2eePlatform, String string) {
        Collection collection = j2eePlatform.getLookup().lookupAll(WSStack.class);
        for (WSStack wSStack : collection) {
            if (!"stack_jax_ws".equals(wSStack.getName()) || !wSStack.getSupportedTools().contains(string)) continue;
            return wSStack;
        }
        return JaxWsStackProvider.getIdeJaxWsStack();
    }

    public static synchronized WSStack getJdkJaxWsStack() {
        String string;
        if (jdkJaxWsStack == null && (string = JaxWsStackProvider.getJaxWsStackVersion(System.getProperty("java.version"))) != null) {
            jdkJaxWsStack = WSStackFactory.createWSStack((WSStackSPI)new JdkJaxWsStack(string), (WSStackProvider)WSStackProvider.JDK);
        }
        return jdkJaxWsStack;
    }

    public static synchronized WSStack getIdeJaxWsStack() {
        if (ideJaxWsStack == null) {
            ideJaxWsStack = WSStackFactory.createWSStack((WSStackSPI)new IdeJaxWsStack(), (WSStackProvider)WSStackProvider.IDE);
        }
        return ideJaxWsStack;
    }

    private static String getJaxWsStackVersion(String string) {
        if (string.startsWith("1.6")) {
            int n = string.indexOf("_");
            if (n > 0) {
                String string2 = string.substring(n + 1);
                try {
                    Integer n2 = Integer.valueOf(string2);
                    if (n2 >= 4) {
                        return "2.1.1";
                    }
                    return "2.0";
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            return null;
        }
        try {
            Float f = Float.valueOf(string.substring(0, 3));
            if ((double)f.floatValue() > 1.6) {
                return "2.1.3";
            }
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

