/*
 * Decompiled with CFR 0.152.
 */
package net.java.bd.tools.security;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sun.misc.BASE64Encoder;
import sun.misc.HexDumpEncoder;
import sun.security.pkcs.PKCS7;
import sun.security.util.DerOutputStream;
import sun.security.util.ObjectIdentifier;
import sun.tools.jar.Main;

class CredentialUtil {
    static final String DEFAULT_GRANTOR_STORE = "grantor.store";
    static final String DEFAULT_GRANTOR_STOREPASS = "keystorepassword";
    static final String DEFAULT_GRANTOR_ALIAS = "appcert";
    static final String DEFAULT_GRANTOR_KEYPASS = "appcertpassword";
    static final String DEFAULT_GRANTEE_STORE = "keystore.store";
    static final String DEFAULT_GRANTEE_STOREPASS = "keystorepassword";
    static final String DEFAULT_GRANTEE_ROOT_ALIAS = "rootcert";
    String grantorKeyStore;
    String grantorStorePass;
    String grantorAlias;
    String grantorPassword;
    String granteeKeyStore;
    String granteeStorePass;
    String granteeRootAlias;
    String jarFileName;
    boolean debug;
    String permReqFile;
    List<? extends Certificate> grantorCerts;
    static final String SIG_BLOCK_FILE = "META-INF/SIG-BD00.RSA";
    static ObjectIdentifier digestAlgorithmID;
    static final String SHA1OID = "1.3.14.3.2.26";
    static final String SIG_ALGO = "SHA1withRSA";
    static final String ENCR_ALGO = "RSA";
    static final String PERM_REQ_FILE_TAG = "permissionrequestfile";
    static final String FILE_CRED_TAG = "persistentfilecredential";
    static final String GRANTOR_ID_TAG = "grantoridentifier";
    static final String EXP_DATE_TAG = "expirationdate";
    static final String FILE_NAME_TAG = "filename";
    static final String SIGNATURE_TAG = "signature";
    static final String FILE_ID_TAG = "certchainfileid";

    private CredentialUtil(Builder b) {
        this.grantorKeyStore = b.grantorKeyStore;
        this.grantorStorePass = b.grantorStorePass;
        this.grantorAlias = b.grantorAlias;
        this.grantorPassword = b.grantorPassword;
        this.granteeKeyStore = b.granteeKeyStore;
        this.granteeStorePass = b.granteeStorePass;
        this.granteeRootAlias = b.granteeRootAlias;
        this.jarFileName = b.jarFileName;
        this.debug = b.debug;
        this.permReqFile = b.permReqFile;
        if (this.debug) {
            CredentialUtil.printDebugMsg("grantor keystore:" + this.grantorKeyStore + ", grantor alias: " + this.grantorAlias + ", grantee keystore:" + this.granteeKeyStore + ", grantee root alias:" + this.granteeRootAlias + ", permReqFile:" + this.permReqFile + ", jarFile    :" + this.jarFileName);
        }
    }

    static void printDebugMsg(String msg) {
        System.out.println("[debug]:" + msg);
    }

    public void genCredentials() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = factory.newDocumentBuilder().parse(new File(this.permReqFile));
        Element e = doc.getDocumentElement();
        String orgId = e.getAttribute("orgid");
        String appId = e.getAttribute("appid");
        Node credNode = CredentialUtil.getNodeWithTag(e, FILE_CRED_TAG);
        ArrayList<Files> fileList = new ArrayList<Files>();
        NodeList cns = credNode.getChildNodes();
        String gaOrgId = null;
        String expDate = null;
        for (int i = 0; i < cns.getLength(); ++i) {
            Node cNode = cns.item(i);
            if (cNode.getNodeName().equals(GRANTOR_ID_TAG)) {
                gaOrgId = ((Element)cNode).getAttribute("id");
                continue;
            }
            if (cNode.getNodeName().equals(EXP_DATE_TAG)) {
                expDate = ((Element)cNode).getAttribute("date");
                continue;
            }
            if (!cNode.getNodeName().equals(FILE_NAME_TAG)) continue;
            String filePath = cNode.getTextContent();
            NamedNodeMap fileAttrs = cNode.getAttributes();
            String read = fileAttrs.getNamedItem("read").getNodeValue();
            String write = fileAttrs.getNamedItem("write").getNodeValue();
            Files f = new Files(read, write, filePath);
            fileList.add(f);
        }
        String fileId = this.genCertChainFileId();
        byte credentialUsage = 0;
        String signature = this.genCredSignature(credentialUsage, orgId, appId, gaOrgId, expDate, fileList);
        Element se = (Element)CredentialUtil.getNodeWithTag(credNode, SIGNATURE_TAG);
        if (se == null) {
            se = doc.createElement(SIGNATURE_TAG);
        }
        se.setTextContent(signature);
        Element fe = (Element)CredentialUtil.getNodeWithTag(credNode, FILE_ID_TAG);
        if (fe == null) {
            fe = doc.createElement(FILE_ID_TAG);
        }
        fe.setTextContent(fileId);
        credNode.appendChild(se);
        credNode.appendChild(fe);
        DOMSource domSource = new DOMSource(doc);
        StreamResult fileResult = new StreamResult(new File(this.permReqFile));
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer transformer = tfactory.newTransformer();
        transformer.transform(domSource, fileResult);
        this.removeEntityReference(this.permReqFile);
    }

    static Node getNodeWithTag(Node node, String tag) throws Exception {
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !n.getNodeName().equals(tag)) continue;
            return n;
        }
        CredentialUtil.printDebugMsg("No elements with tag:" + tag);
        return null;
    }

    private String genCertChainFileId() throws Exception {
        Certificate[] certs = this.getCerts(this.grantorKeyStore, this.grantorStorePass, this.grantorAlias);
        this.grantorCerts = this.getCertPath(certs);
        X509Certificate leafCert = (X509Certificate)this.grantorCerts.get(0);
        if (this.debug) {
            CredentialUtil.printDebugMsg("Using the grantor cert for generating <certchainfileid> :" + leafCert);
        }
        byte[] issuerName = leafCert.getIssuerX500Principal().getEncoded();
        BigInteger certificateSerialNumber = leafCert.getSerialNumber();
        DerOutputStream seq = new DerOutputStream();
        DerOutputStream issuerAndSerialNumber = new DerOutputStream();
        issuerAndSerialNumber.write(issuerName, 0, issuerName.length);
        issuerAndSerialNumber.putInteger(certificateSerialNumber);
        seq.write((byte)48, issuerAndSerialNumber);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BASE64Encoder base64 = new BASE64Encoder();
        base64.encode(seq.toByteArray(), (OutputStream)out);
        return out.toString("US-ASCII");
    }

    private List<? extends Certificate> getCertPath(Certificate[] certs) throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        List<Certificate> certList = Arrays.asList(certs);
        CertPath cp = cf.generateCertPath(certList);
        return cp.getCertificates();
    }

    private Certificate[] getCerts(String keystore, String storepass, String alias) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(new FileInputStream(keystore), storepass.toCharArray());
        return ks.getCertificateChain(alias);
    }

    private PrivateKey getGrantorKey() throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(new FileInputStream(this.grantorKeyStore), this.grantorStorePass.toCharArray());
        PrivateKey grantorKey = (PrivateKey)ks.getKey(this.grantorAlias, this.grantorPassword.toCharArray());
        return grantorKey;
    }

    private String genCredSignature(byte credentialUsage, String granteeOrgIdStr, String granteeAppIdStr, String grantorOrgIdStr, String expDateStr, List<Files> fileList) throws Exception {
        if (this.debug) {
            CredentialUtil.printDebugMsg("Generating the signature using- granteeId:" + granteeOrgIdStr + ", granteeAppId:" + granteeAppIdStr + ", grantorOrgId:" + grantorOrgIdStr + ", expDate:" + expDateStr + ", file permissions:" + fileList);
        }
        int granteeOrgId = Integer.parseInt(granteeOrgIdStr.substring(2), 16);
        short granteeAppId = (short)Integer.parseInt(granteeAppIdStr.substring(2), 16);
        KeyStore gs = KeyStore.getInstance("JKS");
        gs.load(new FileInputStream(this.granteeKeyStore), this.granteeStorePass.toCharArray());
        Certificate[] granteeCerts = gs.getCertificateChain(this.granteeRootAlias);
        byte[] granteeCertDigest = CredentialUtil.getCertDigest(granteeCerts[0]);
        HexDumpEncoder hexDump = null;
        if (this.debug) {
            CredentialUtil.printDebugMsg("GranteeCertDigest:");
            hexDump = new HexDumpEncoder();
            System.out.println(hexDump.encodeBuffer(granteeCertDigest));
        }
        int grantorOrgId = Integer.parseInt(grantorOrgIdStr.substring(2), 16);
        byte[] grantorRootCertDigest = CredentialUtil.getCertDigest(this.grantorCerts.get(this.grantorCerts.size() - 1));
        if (this.debug) {
            CredentialUtil.printDebugMsg("GrantorRootCertDigest:");
            System.out.println(hexDump.encodeBuffer(grantorRootCertDigest));
        }
        byte[] expiryDate = CredentialUtil.getAscii(expDateStr);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(450);
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeByte(credentialUsage);
        dos.writeInt(granteeOrgId);
        dos.writeShort(granteeAppId);
        dos.write(granteeCertDigest, 0, granteeCertDigest.length);
        dos.writeInt(grantorOrgId);
        dos.write(grantorRootCertDigest, 0, grantorRootCertDigest.length);
        dos.write(expiryDate, 0, expiryDate.length);
        for (Files f : fileList) {
            byte[] readPerm = CredentialUtil.getAscii(f.read);
            byte[] writePerm = CredentialUtil.getAscii(f.write);
            byte[] filepath = CredentialUtil.getAscii(f.filepath);
            short fileLength = (short)filepath.length;
            dos.write(readPerm, 0, readPerm.length);
            dos.write(writePerm, 0, writePerm.length);
            dos.writeShort(fileLength);
            dos.write(filepath, 0, filepath.length);
        }
        dos.close();
        byte[] data = baos.toByteArray();
        if (this.debug) {
            CredentialUtil.printDebugMsg("Concatenated binary data to be signed (length: " + data.length + " bytes) is:");
            System.out.println(hexDump.encodeBuffer(data));
        }
        PrivateKey grantorKey = this.getGrantorKey();
        Signature sig = Signature.getInstance(SIG_ALGO);
        sig.initSign(grantorKey);
        sig.update(data);
        byte[] signature = sig.sign();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BASE64Encoder base64 = new BASE64Encoder();
        base64.encode(signature, (OutputStream)out);
        return out.toString("US-ASCII");
    }

    static void printHex(byte[] value) {
        int count = 0;
        int i = 0;
        while (i < value.length) {
            System.out.format("%2x ", value[i]);
            if (count == 20) {
                count = 0;
                System.out.println();
            }
            ++i;
            ++count;
        }
        System.out.println();
    }

    public void updateCerts() throws Exception {
        int len;
        JarFile jf = new JarFile(this.jarFileName);
        JarEntry je = jf.getJarEntry(SIG_BLOCK_FILE);
        if (je == null) {
            System.out.println("No entry found:META-INF/SIG-BD00.RSA");
        }
        InputStream pkcs7Is = jf.getInputStream(je);
        PKCS7 signBlockFile = new PKCS7(pkcs7Is);
        pkcs7Is.close();
        jf.close();
        X509Certificate[] certs = signBlockFile.getCertificates();
        Certificate[] grantorCerts = this.getCerts(this.grantorKeyStore, this.grantorStorePass, this.grantorAlias);
        X509Certificate[] addedCerts = new X509Certificate[certs.length + grantorCerts.length];
        for (len = 0; len < certs.length; ++len) {
            addedCerts[len] = certs[len];
        }
        for (int i = 0; i < grantorCerts.length; ++i) {
            addedCerts[len] = (X509Certificate)grantorCerts[i];
            ++len;
        }
        if (this.debug) {
            CredentialUtil.printDebugMsg("Updated Certs:");
            for (X509Certificate cert : addedCerts) {
                System.out.println("CERT:" + cert.getSubjectX500Principal());
            }
        }
        PKCS7 newSignBlockFile = new PKCS7(signBlockFile.getDigestAlgorithmIds(), signBlockFile.getContentInfo(), addedCerts, signBlockFile.getSignerInfos());
        File mif = new File("META-INF");
        if (!mif.isDirectory()) {
            if (!mif.mkdir()) {
                System.err.println("Could not create a META-INF directory");
            }
            return;
        }
        File sbf = new File(mif, "SIG-BD00.RSA");
        FileOutputStream fos = new FileOutputStream(sbf);
        newSignBlockFile.encodeSignedData(fos);
        fos.close();
        String[] jarArgs = new String[]{"-uvf", this.jarFileName, SIG_BLOCK_FILE};
        Main jar = new Main(System.out, System.err, "jar");
        jar.run(jarArgs);
    }

    static byte[] getAscii(String str) throws Exception {
        return str.getBytes("US-ASCII");
    }

    static byte[] getCertDigest(Certificate cert) throws Exception {
        byte[] encCertInfo = cert.getEncoded();
        MessageDigest md = MessageDigest.getInstance("SHA1");
        return md.digest(encCertInfo);
    }

    void removeEntityReference(String fileName) throws Exception {
        int ch;
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        CharArrayWriter caw = new CharArrayWriter(2000);
        while ((ch = br.read()) != -1) {
            if (ch == 38) {
                if (br.skip(4L) == 4L) continue;
                System.out.println("ERROR removing character references from PRF file; Could not skip 4 chars");
                br.close();
                System.exit(1);
                continue;
            }
            caw.write(ch);
        }
        br.close();
        FileWriter fw = new FileWriter(fileName);
        fw.write(caw.toCharArray());
        fw.close();
    }

    static class Files {
        String read;
        String write;
        String filepath;

        Files(String read, String write, String filepath) {
            this.read = read;
            this.write = write;
            this.filepath = filepath;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("read:" + this.read);
            sb.append(", write:" + this.write);
            sb.append(", filepath:" + this.filepath);
            return sb.toString();
        }
    }

    public static class Builder {
        String grantorKeyStore = "grantor.store";
        String grantorStorePass = "keystorepassword";
        String grantorAlias = "appcert";
        String grantorPassword = "appcertpassword";
        String granteeKeyStore = "keystore.store";
        String granteeStorePass = "keystorepassword";
        String granteeRootAlias = "rootcert";
        String jarFileName;
        String permReqFile;
        boolean debug = false;

        public Builder grantorKeyStore(String storefile) {
            this.grantorKeyStore = storefile;
            return this;
        }

        public Builder grantorStorePass(String storepass) {
            this.grantorStorePass = storepass;
            return this;
        }

        public Builder grantorAlias(String alias) {
            this.grantorAlias = alias;
            return this;
        }

        public Builder granteeKeyStore(String storefile) {
            this.granteeKeyStore = storefile;
            return this;
        }

        public Builder granteeStorePass(String storepass) {
            this.granteeStorePass = storepass;
            return this;
        }

        public Builder granteeRootAlias(String alias) {
            this.granteeRootAlias = alias;
            return this;
        }

        public Builder permReqFile(String file) {
            this.permReqFile = file;
            return this;
        }

        public Builder jarFile(String file) {
            this.jarFileName = file;
            return this;
        }

        public Builder debug() {
            this.debug = true;
            return this;
        }

        public CredentialUtil build() {
            return new CredentialUtil(this);
        }
    }
}

