/*
 * Decompiled with CFR 0.152.
 */
package net.java.bd.tools.security;

import java.util.ArrayList;
import net.java.bd.tools.security.CredentialUtil;
import net.java.bd.tools.security.CredentialVerifier;
import net.java.bd.tools.security.SecurityUtil;
import sun.tools.jar.Main;

public class BDCredentialSigner {
    static boolean debug = false;
    static String jarFileName;
    static String permReqFileName;
    static SecurityUtil.Builder sBuilder;
    static CredentialUtil.Builder cBuilder;

    public static void main(String[] args) throws Exception {
        BDCredentialSigner.parseArgs(args);
        if (debug) {
            System.out.println("[Debug] extracting permission request file from the jar ..");
        }
        BDCredentialSigner.extractFile(jarFileName, permReqFileName);
        if (debug) {
            System.out.println("[Debug] Generating the credentials...");
        }
        CredentialUtil cUtil = cBuilder.build();
        cUtil.genCredentials();
        if (debug) {
            System.out.println("[Debug] Updating the jar file with permissionrequest file that has credentials..");
        }
        BDCredentialSigner.updateJar(jarFileName, permReqFileName);
        if (debug) {
            System.out.println("[Debug] Signing the updated jar file...");
        }
        SecurityUtil sUtil = sBuilder.build();
        sUtil.signJars();
        if (debug) {
            System.out.println("[Debug] Updating the signed jar file with grantor's certs....");
        }
        cUtil.updateCerts();
        if (debug) {
            CredentialVerifier.verify(jarFileName, permReqFileName, "app.discroot.crt");
        }
    }

    private static void extractFile(String jarFileName, String fileToExtract) {
        String[] jarArgs;
        Main jar;
        String jarOpt = "-xf";
        if (debug) {
            jarOpt = "-xvf";
        }
        if (!(jar = new Main(System.out, System.err, "jar")).run(jarArgs = new String[]{jarOpt, jarFileName, fileToExtract})) {
            System.out.println("Unable to extract file:" + fileToExtract);
            System.exit(1);
        }
    }

    private static void updateJar(String jarFileName, String newPermReqFile) {
        String[] jarArgs;
        Main jar;
        String jarOpt = "-uf";
        if (debug) {
            jarOpt = "-uvf";
        }
        if (!(jar = new Main(System.out, System.err, "jar")).run(jarArgs = new String[]{jarOpt, jarFileName, newPermReqFile})) {
            System.out.println("Unable to update the jar file:" + jarFileName);
            System.exit(1);
        }
    }

    public static void parseArgs(String[] args) {
        if (args.length < 2) {
            BDCredentialSigner.printUsageAndExit("");
        }
        boolean nextOptJar = false;
        cBuilder = new CredentialUtil.Builder();
        sBuilder = new SecurityUtil.Builder();
        for (int i = 0; i < args.length; ++i) {
            String opt = args[i];
            if (opt.equals("-debug")) {
                debug = true;
                cBuilder = cBuilder.debug();
                sBuilder = sBuilder.debug();
                continue;
            }
            if (opt.equals("-gastore")) {
                if (++i == args.length) {
                    BDCredentialSigner.errorNeedArgument(opt);
                }
                cBuilder = cBuilder.grantorKeyStore(args[i]);
                continue;
            }
            if (opt.equals("-gastorepass")) {
                if (++i == args.length) {
                    BDCredentialSigner.errorNeedArgument(opt);
                }
                cBuilder = cBuilder.grantorStorePass(args[i]);
                continue;
            }
            if (opt.equals("-gaalias")) {
                if (++i == args.length) {
                    BDCredentialSigner.errorNeedArgument(opt);
                }
                cBuilder = cBuilder.grantorAlias(args[i]);
                continue;
            }
            if (opt.equals("-gestore")) {
                if (++i == args.length) {
                    BDCredentialSigner.errorNeedArgument(opt);
                }
                cBuilder = cBuilder.granteeKeyStore(args[i]);
                sBuilder = sBuilder.keystoreFile(args[i]);
                continue;
            }
            if (opt.equals("-gestorepass")) {
                if (++i == args.length) {
                    BDCredentialSigner.errorNeedArgument(opt);
                }
                cBuilder = cBuilder.granteeStorePass(args[i]);
                sBuilder = sBuilder.storepass(args[i]);
                continue;
            }
            if (opt.equals("-gerootalias")) {
                if (++i == args.length) {
                    BDCredentialSigner.errorNeedArgument(opt);
                }
                cBuilder = cBuilder.granteeRootAlias(args[i]);
                continue;
            }
            if (opt.equals("-alias")) {
                if (++i == args.length) {
                    BDCredentialSigner.errorNeedArgument(opt);
                }
                sBuilder = sBuilder.jarSignerAlias(args[i]);
                continue;
            }
            if (opt.equals("-keypass")) {
                if (++i == args.length) {
                    BDCredentialSigner.errorNeedArgument(opt);
                }
                sBuilder = sBuilder.appPassword(args[i]);
                continue;
            }
            if (opt.equals("-help")) {
                BDCredentialSigner.printUsageAndExit("");
                continue;
            }
            if (!nextOptJar) {
                cBuilder = cBuilder.permReqFile(opt);
                nextOptJar = true;
                permReqFileName = opt;
                continue;
            }
            cBuilder = cBuilder.jarFile(opt);
            ArrayList<String> list = new ArrayList<String>();
            list.add(args[i]);
            sBuilder = sBuilder.jarfiles(list);
            jarFileName = opt;
        }
    }

    private static void printUsageAndExit(String reason) {
        if (!reason.isEmpty()) {
            System.err.println("Failed: " + reason);
        }
        System.err.println("\n-----------------------------------------------------------------------");
        System.err.println("This tool is for generating credentials, signing the jar and updating\nthe signed jar with the grantor's certificates as per the BD-J specificiation.");
        System.err.println("The permission request file should have all other fields\nof persistent credentials but the <signature> and the <certchainfileid>\nfields/elements. This tool generates the credentials using the keystores\nof the grantor and the grantee and updates permission request file\nin the given jar file with file credentials.");
        System.err.println("-----------------------------------------------------------------------\n");
        System.err.println("usage: BDCredentialSigner [options] permission-request-file jarfile\n");
        System.err.println("Valid Options:");
        System.err.println(" -gastore filename \t:Grantor's keystore;default used:\"grantor.store\"");
        System.err.println("                      \t from the current working directory");
        System.err.println(" -gastorepass password\t:Grantor's keystore password");
        System.err.println(" -gaalias alias       \t:Grantor's alias");
        System.err.println(" -gestore filename \t:Grantee's keystore;default used:\"keystore.store\"");
        System.err.println("                      \t from the current working directory");
        System.err.println(" -gestorepass password\t:Grantee's keystore password");
        System.err.println(" -gerootalias alias   \t:Grantee's root certificate alias");
        System.err.println(" -alias alias         \t:Alias for the signing key");
        System.err.println(" -keypass password    \t:Password for accessing the signing key");
        System.err.println(" -debug               \t:Prints debug messages");
        System.err.println(" -help                \t:Prints this message");
        System.err.println();
        System.exit(1);
    }

    private static void tinyHelp() {
        System.err.println("Try BDCredentialSigner -help");
        System.exit(1);
    }

    private static void errorNeedArgument(String flag) {
        System.err.println("Command option <flag> needs an argument.");
        BDCredentialSigner.tinyHelp();
    }
}

