/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.util;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.websvc.wsitconf.util.SourceUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenerationUtils
extends SourceUtils {
    static final String CLASS_TEMPLATE = "Templates/Classes/Class.java";
    static final String INTERFACE_TEMPLATE = "Templates/Classes/Interface.java";
    private static final String MODIFIERS_TREE = "modifiersTree";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String PROPERTY_TYPE = "propertyType";

    private GenerationUtils(WorkingCopy workingCopy, TypeElement typeElement) {
        super((CompilationController)workingCopy, typeElement);
    }

    private GenerationUtils(WorkingCopy workingCopy, ClassTree classTree) {
        super((CompilationController)workingCopy, classTree);
    }

    public static GenerationUtils newInstance(WorkingCopy workingCopy, TypeElement typeElement) {
        Parameters.notNull((CharSequence)"copy", (Object)workingCopy);
        Parameters.notNull((CharSequence)"typeElement", (Object)typeElement);
        return new GenerationUtils(workingCopy, typeElement);
    }

    public static GenerationUtils newInstance(WorkingCopy workingCopy, ClassTree classTree) {
        Parameters.notNull((CharSequence)"copy", (Object)workingCopy);
        Parameters.notNull((CharSequence)"classTree", (Object)classTree);
        return new GenerationUtils(workingCopy, classTree);
    }

    public static GenerationUtils newInstance(WorkingCopy workingCopy) throws IOException {
        Parameters.notNull((CharSequence)"copy", (Object)workingCopy);
        ClassTree classTree = GenerationUtils.findPublicTopLevelClass((CompilationController)workingCopy);
        if (classTree != null) {
            return GenerationUtils.newInstance(workingCopy, classTree);
        }
        return null;
    }

    public static FileObject createClass(FileObject fileObject, String string, String string2) throws IOException {
        return GenerationUtils.createClass(CLASS_TEMPLATE, fileObject, string, string2);
    }

    public static FileObject createInterface(FileObject fileObject, String string, String string2) throws IOException {
        return GenerationUtils.createClass(INTERFACE_TEMPLATE, fileObject, string, string2);
    }

    public static FileObject createClass(String string, FileObject fileObject, String string2, String string3) throws IOException {
        Parameters.notNull((CharSequence)"template", (Object)string);
        Parameters.notNull((CharSequence)"targetFolder", (Object)fileObject);
        Parameters.javaIdentifier((CharSequence)"className", (CharSequence)string2);
        FileObject fileObject2 = GenerationUtils.createDataObjectFromTemplate(string, fileObject, string2).getPrimaryFile();
        return fileObject2;
    }

    public static FileObject createClass(String string, FileObject fileObject, String string2, String string3, Map<String, ? extends Object> map) throws IOException {
        Parameters.notNull((CharSequence)"template", (Object)string);
        Parameters.notNull((CharSequence)"targetFolder", (Object)fileObject);
        Parameters.javaIdentifier((CharSequence)"className", (CharSequence)string2);
        FileObject fileObject2 = GenerationUtils.createDataObjectFromTemplate(string, fileObject, string2, map).getPrimaryFile();
        return fileObject2;
    }

    private static DataObject createDataObjectFromTemplate(String string, FileObject fileObject, String string2) throws IOException {
        assert (string != null);
        assert (fileObject != null);
        assert (string2 != null && string2.trim().length() > 0);
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject2 = fileSystem.findResource(string);
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        return dataObject.createFromTemplate(dataFolder, string2);
    }

    private static DataObject createDataObjectFromTemplate(String string, FileObject fileObject, String string2, Map<String, ? extends Object> map) throws IOException {
        assert (string != null);
        assert (fileObject != null);
        assert (string2 != null && string2.trim().length() > 0);
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject2 = fileSystem.findResource(string);
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        return dataObject.createFromTemplate(dataFolder, string2, map);
    }

    public Tree createType(String string) {
        TypeKind typeKind = null;
        if ("boolean".equals(string)) {
            typeKind = TypeKind.BOOLEAN;
        } else if ("byte".equals(string)) {
            typeKind = TypeKind.BYTE;
        } else if ("short".equals(string)) {
            typeKind = TypeKind.SHORT;
        } else if ("int".equals(string)) {
            typeKind = TypeKind.INT;
        } else if ("long".equals(string)) {
            typeKind = TypeKind.LONG;
        } else if ("char".equals(string)) {
            typeKind = TypeKind.CHAR;
        } else if ("float".equals(string)) {
            typeKind = TypeKind.FLOAT;
        } else if ("double".equals(string)) {
            typeKind = TypeKind.DOUBLE;
        }
        if (typeKind != null) {
            return this.getTreeMaker().PrimitiveType(typeKind);
        }
        return this.createQualIdent(string);
    }

    public ModifiersTree createModifiers(Modifier modifier) {
        return this.getTreeMaker().Modifiers(EnumSet.of(modifier), Collections.emptyList());
    }

    public AnnotationTree createAnnotation(String string) {
        Parameters.notNull((CharSequence)"annotationType", (Object)string);
        return this.createAnnotation(string, Collections.emptyList());
    }

    public AnnotationTree createAnnotation(String string, List<? extends ExpressionTree> list) {
        Parameters.notNull((CharSequence)"annotationType", (Object)string);
        Parameters.notNull((CharSequence)"arguments", list);
        ExpressionTree expressionTree = this.createQualIdent(string);
        return this.getTreeMaker().Annotation((Tree)expressionTree, list);
    }

    public ExpressionTree createAnnotationArgument(String string, Object object) {
        Parameters.javaIdentifierOrNull((CharSequence)"argumentName", (CharSequence)string);
        Parameters.notNull((CharSequence)"argumentValue", (Object)object);
        TreeMaker treeMaker = this.getTreeMaker();
        LiteralTree literalTree = treeMaker.Literal(object);
        if (string == null) {
            return literalTree;
        }
        return treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)string), (ExpressionTree)literalTree);
    }

    public ExpressionTree createAnnotationArgument(String string, List<? extends ExpressionTree> list) {
        Parameters.javaIdentifierOrNull((CharSequence)"argumentName", (CharSequence)string);
        Parameters.notNull((CharSequence)"argumentValues", list);
        TreeMaker treeMaker = this.getTreeMaker();
        NewArrayTree newArrayTree = treeMaker.NewArray(null, Collections.emptyList(), list);
        if (string == null) {
            return newArrayTree;
        }
        return treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)string), (ExpressionTree)newArrayTree);
    }

    public ExpressionTree createAnnotationArgument(String string, String string2, String string3) {
        Parameters.javaIdentifierOrNull((CharSequence)"argumentName", (CharSequence)string);
        Parameters.notNull((CharSequence)"argumentType", (Object)string2);
        Parameters.javaIdentifier((CharSequence)"argumentTypeField", (CharSequence)string3);
        TreeMaker treeMaker = this.getTreeMaker();
        MemberSelectTree memberSelectTree = treeMaker.MemberSelect(this.createQualIdent(string2), (CharSequence)string3);
        if (string == null) {
            return memberSelectTree;
        }
        return treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)string), (ExpressionTree)memberSelectTree);
    }

    public ClassTree ensureNoArgConstructor(ClassTree classTree) throws IOException {
        Tree tree;
        this.getWorkingCopy().toPhase(JavaSource.Phase.RESOLVED);
        ExecutableElement executableElement = this.getNoArgConstructor();
        MethodTree methodTree = executableElement != null ? this.getWorkingCopy().getTrees().getTree(executableElement) : null;
        MethodTree methodTree2 = null;
        TreeMaker treeMaker = this.getTreeMaker();
        if (executableElement != null) {
            if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
                tree = methodTree.getModifiers();
                EnumSet<Modifier> enumSet = EnumSet.of(Modifier.PUBLIC);
                for (Modifier modifier : tree.getFlags()) {
                    if (Modifier.PROTECTED.equals((Object)modifier) || Modifier.PRIVATE.equals((Object)modifier)) continue;
                    enumSet.add(modifier);
                }
                methodTree2 = treeMaker.Constructor(treeMaker.Modifiers(enumSet), methodTree.getTypeParameters(), methodTree.getParameters(), methodTree.getThrows(), methodTree.getBody());
            }
        } else {
            methodTree2 = treeMaker.Constructor(this.createModifiers(Modifier.PUBLIC), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{ }");
        }
        tree = classTree;
        if (methodTree2 != null) {
            if (methodTree != null) {
                tree = treeMaker.removeClassMember((ClassTree)tree, (Tree)methodTree);
            }
            tree = treeMaker.addClassMember((ClassTree)tree, (Tree)methodTree2);
        }
        return tree;
    }

    public MethodTree createAssignmentConstructor(ModifiersTree modifiersTree, String string, List<VariableTree> list) {
        Parameters.notNull((CharSequence)MODIFIERS_TREE, (Object)modifiersTree);
        Parameters.javaIdentifier((CharSequence)"constructorName", (CharSequence)string);
        Parameters.notNull((CharSequence)"parameters", list);
        StringBuilder stringBuilder = new StringBuilder(list.size() * 30);
        stringBuilder.append("{");
        for (VariableTree variableTree : list) {
            String string2 = variableTree.getName().toString();
            stringBuilder.append("this." + string2 + " = " + string2 + ";");
        }
        stringBuilder.append("}");
        TreeMaker treeMaker = this.getTreeMaker();
        return treeMaker.Constructor(modifiersTree, Collections.emptyList(), list, Collections.emptyList(), stringBuilder.toString());
    }

    public VariableTree createField(ModifiersTree modifiersTree, String string, String string2) {
        Parameters.notNull((CharSequence)MODIFIERS_TREE, (Object)modifiersTree);
        Parameters.javaIdentifier((CharSequence)"fieldName", (CharSequence)string);
        Parameters.notNull((CharSequence)"fieldType", (Object)string2);
        return this.getTreeMaker().Variable(modifiersTree, (CharSequence)string, this.createType(string2), null);
    }

    public VariableTree createVariable(String string, String string2) {
        Parameters.javaIdentifier((CharSequence)"variableName", (CharSequence)string);
        Parameters.notNull((CharSequence)"variableType", (Object)string2);
        return this.createField(this.createEmptyModifiers(), string, string2);
    }

    public VariableTree createVariable(String string, Tree tree) {
        Parameters.javaIdentifier((CharSequence)"variableName", (CharSequence)string);
        Parameters.notNull((CharSequence)"variableType", (Object)tree);
        return this.getTreeMaker().Variable(this.createEmptyModifiers(), (CharSequence)string, tree, null);
    }

    public VariableTree removeModifiers(VariableTree variableTree) {
        Parameters.notNull((CharSequence)"variableTree", (Object)variableTree);
        TreeMaker treeMaker = this.getTreeMaker();
        return treeMaker.Variable(this.createEmptyModifiers(), (CharSequence)variableTree.getName(), variableTree.getType(), variableTree.getInitializer());
    }

    public MethodTree createPropertyGetterMethod(ModifiersTree modifiersTree, String string, String string2) throws IOException {
        Parameters.notNull((CharSequence)MODIFIERS_TREE, (Object)modifiersTree);
        Parameters.javaIdentifier((CharSequence)PROPERTY_NAME, (CharSequence)string);
        Parameters.notNull((CharSequence)PROPERTY_TYPE, (Object)string2);
        this.getWorkingCopy().toPhase(JavaSource.Phase.RESOLVED);
        return this.createPropertyGetterMethod(modifiersTree, string, this.createType(string2));
    }

    public MethodTree createPropertyGetterMethod(ModifiersTree modifiersTree, String string, Tree tree) throws IOException {
        Parameters.notNull((CharSequence)MODIFIERS_TREE, (Object)modifiersTree);
        Parameters.javaIdentifier((CharSequence)PROPERTY_NAME, (CharSequence)string);
        Parameters.notNull((CharSequence)PROPERTY_TYPE, (Object)tree);
        this.getWorkingCopy().toPhase(JavaSource.Phase.RESOLVED);
        return this.getTreeMaker().Method(modifiersTree, (CharSequence)this.createPropertyAccessorName(string, true), tree, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{ return " + string + "; }", null);
    }

    public MethodTree createPropertySetterMethod(ModifiersTree modifiersTree, String string, String string2) throws IOException {
        Parameters.notNull((CharSequence)MODIFIERS_TREE, (Object)modifiersTree);
        Parameters.javaIdentifier((CharSequence)PROPERTY_NAME, (CharSequence)string);
        Parameters.notNull((CharSequence)PROPERTY_TYPE, (Object)string2);
        this.getWorkingCopy().toPhase(JavaSource.Phase.RESOLVED);
        return this.createPropertySetterMethod(modifiersTree, string, this.createType(string2));
    }

    public MethodTree createPropertySetterMethod(ModifiersTree modifiersTree, String string, Tree tree) throws IOException {
        Parameters.notNull((CharSequence)MODIFIERS_TREE, (Object)modifiersTree);
        Parameters.javaIdentifier((CharSequence)PROPERTY_NAME, (CharSequence)string);
        Parameters.notNull((CharSequence)PROPERTY_TYPE, (Object)tree);
        this.getWorkingCopy().toPhase(JavaSource.Phase.RESOLVED);
        TreeMaker treeMaker = this.getTreeMaker();
        return treeMaker.Method(modifiersTree, (CharSequence)this.createPropertyAccessorName(string, false), (Tree)treeMaker.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.singletonList(this.createVariable(string, tree)), Collections.emptyList(), "{ this." + string + " = " + string + "; }", null);
    }

    public ClassTree addAnnotation(ClassTree classTree, AnnotationTree annotationTree) {
        Parameters.notNull((CharSequence)"classTree", (Object)classTree);
        Parameters.notNull((CharSequence)"annotationTree", (Object)annotationTree);
        TreeMaker treeMaker = this.getTreeMaker();
        return treeMaker.Class(treeMaker.addModifiersAnnotation(classTree.getModifiers(), annotationTree), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), classTree.getImplementsClause(), classTree.getMembers());
    }

    public MethodTree addAnnotation(MethodTree methodTree, AnnotationTree annotationTree) {
        Parameters.notNull((CharSequence)"methodTree", (Object)methodTree);
        Parameters.notNull((CharSequence)"annotationTree", (Object)annotationTree);
        TreeMaker treeMaker = this.getTreeMaker();
        return treeMaker.Method(treeMaker.addModifiersAnnotation(methodTree.getModifiers(), annotationTree), (CharSequence)methodTree.getName(), methodTree.getReturnType(), methodTree.getTypeParameters(), methodTree.getParameters(), methodTree.getThrows(), methodTree.getBody(), (ExpressionTree)methodTree.getDefaultValue());
    }

    public VariableTree addAnnotation(VariableTree variableTree, AnnotationTree annotationTree) {
        Parameters.notNull((CharSequence)"variableTree", (Object)variableTree);
        Parameters.notNull((CharSequence)"annotationTree", (Object)annotationTree);
        TreeMaker treeMaker = this.getTreeMaker();
        return treeMaker.Variable(treeMaker.addModifiersAnnotation(variableTree.getModifiers(), annotationTree), (CharSequence)variableTree.getName(), variableTree.getType(), variableTree.getInitializer());
    }

    public ClassTree addClassFields(ClassTree classTree, List<? extends VariableTree> list) {
        Parameters.notNull((CharSequence)"classTree", (Object)classTree);
        Parameters.notNull((CharSequence)"fieldTrees", list);
        int n = 0;
        Iterator<? extends Tree> iterator = classTree.getMembers().iterator();
        while (iterator.hasNext() && iterator.next().getKind() == Tree.Kind.VARIABLE) {
            ++n;
        }
        TreeMaker treeMaker = this.getTreeMaker();
        ClassTree classTree2 = this.getClassTree();
        for (VariableTree variableTree : list) {
            classTree2 = treeMaker.insertClassMember(classTree2, n, (Tree)variableTree);
            ++n;
        }
        return classTree2;
    }

    public ClassTree addImplementsClause(ClassTree classTree, String string) {
        if (this.getTypeElement().getKind() != ElementKind.CLASS) {
            throw new IllegalStateException("Cannot add an implements clause to the non-class type " + this.getTypeElement().getQualifiedName());
        }
        ExpressionTree expressionTree = this.createQualIdent(string);
        return this.getTreeMaker().addClassImplementsClause(classTree, (Tree)expressionTree);
    }

    private WorkingCopy getWorkingCopy() {
        return (WorkingCopy)this.getCompilationController();
    }

    private TreeMaker getTreeMaker() {
        return this.getWorkingCopy().getTreeMaker();
    }

    private ModifiersTree createEmptyModifiers() {
        return this.getTreeMaker().Modifiers(Collections.emptySet(), Collections.emptyList());
    }

    private ExpressionTree createQualIdent(String string) {
        TypeElement typeElement = this.getWorkingCopy().getElements().getTypeElement(string);
        if (typeElement == null) {
            throw new IllegalArgumentException("Type " + string + " cannot be found");
        }
        return this.getTreeMaker().QualIdent((Element)typeElement);
    }

    private String createPropertyAccessorName(String string, boolean bl) {
        assert (string.length() > 0);
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
        return (bl ? "get" : "set") + stringBuffer;
    }
}

