/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.subpanels;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMDeliveryAssurance;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMSequenceBinding;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.openide.util.NbBundle;

public class AdvancedRMPanel
extends JPanel {
    private Binding binding;
    private boolean inSync = false;
    private DefaultFormatterFactory milisecondsff = null;
    private DefaultFormatterFactory maxBufff = null;
    private ConfigVersion cfgVersion = null;
    private JComboBox deliveryAssuranceCombo;
    private JLabel deliveryAssuranceLabel;
    private JCheckBox flowControlChBox;
    private JLabel inactivityTimeoutLabel;
    private JFormattedTextField inactivityTimeoutTextfield;
    private JLabel maxBufLabel;
    private JFormattedTextField maxBufTextField;

    public AdvancedRMPanel(Binding binding, ConfigVersion configVersion) {
        this.binding = binding;
        this.cfgVersion = configVersion;
        this.milisecondsff = new DefaultFormatterFactory();
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(false);
        NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
        numberFormat.setMaximumIntegerDigits(8);
        numberFormatter.setCommitsOnValidEdit(true);
        numberFormatter.setMinimum(Integer.valueOf(0));
        numberFormatter.setMaximum(Integer.valueOf(99999999));
        this.milisecondsff.setDefaultFormatter(numberFormatter);
        this.maxBufff = new DefaultFormatterFactory();
        NumberFormat numberFormat2 = NumberFormat.getIntegerInstance();
        numberFormat2.setGroupingUsed(false);
        NumberFormatter numberFormatter2 = new NumberFormatter(numberFormat2);
        numberFormat2.setMaximumIntegerDigits(8);
        numberFormatter2.setCommitsOnValidEdit(true);
        numberFormatter2.setMinimum(Integer.valueOf(0));
        numberFormatter2.setMaximum(Integer.valueOf(99999999));
        this.maxBufff.setDefaultFormatter(numberFormatter2);
        this.initComponents();
        this.inSync = true;
        for (RMDeliveryAssurance rMDeliveryAssurance : RMDeliveryAssurance.values()) {
            this.deliveryAssuranceCombo.addItem(rMDeliveryAssurance);
        }
        this.inSync = false;
        this.sync();
    }

    private void sync() {
        this.inSync = true;
        String string = RMModelHelper.getInstance(this.cfgVersion).getInactivityTimeout(this.binding);
        if (string == null) {
            this.setTextField(this.inactivityTimeoutTextfield, "600000");
        } else {
            this.setTextField(this.inactivityTimeoutTextfield, string);
        }
        String string2 = RMModelHelper.getMaxReceiveBufferSize(this.binding);
        if (string2 == null) {
            this.setTextField(this.maxBufTextField, "32");
        } else {
            this.setTextField(this.maxBufTextField, string2);
        }
        this.setChBox(this.flowControlChBox, RMModelHelper.isFlowControl(this.binding));
        RMDeliveryAssurance rMDeliveryAssurance = RMDeliveryAssurance.getValue(this.cfgVersion, this.binding);
        if (rMDeliveryAssurance == null) {
            rMDeliveryAssurance = RMDeliveryAssurance.getDefault();
        }
        this.setCombo(this.deliveryAssuranceCombo, (Object)rMDeliveryAssurance);
        RMSequenceBinding rMSequenceBinding = RMSequenceBinding.getValue(this.cfgVersion, this.binding);
        if (rMSequenceBinding == null) {
            rMSequenceBinding = RMSequenceBinding.getDefault();
        }
        this.enableDisable();
        this.inSync = false;
    }

    protected void setCombo(JComboBox jComboBox, Object object) {
        if (object == null) {
            jComboBox.setSelectedIndex(0);
        } else {
            jComboBox.setSelectedItem(object);
        }
    }

    private Number getTextField(JFormattedTextField jFormattedTextField) {
        return (Number)jFormattedTextField.getValue();
    }

    private void setTextField(JFormattedTextField jFormattedTextField, String string) {
        jFormattedTextField.setText(string);
    }

    protected void setChBox(JCheckBox jCheckBox, Boolean bl) {
        if (bl == null) {
            jCheckBox.setSelected(false);
        } else {
            jCheckBox.setSelected(bl);
        }
    }

    public void storeState() {
        Number number;
        boolean bl = this.flowControlChBox.isSelected();
        if (bl != RMModelHelper.isFlowControl(this.binding)) {
            RMModelHelper.getInstance(this.cfgVersion).enableFlowControl(this.binding, bl);
        }
        if ((number = this.getTextField(this.inactivityTimeoutTextfield)) == null || "600000".equals(number.toString())) {
            RMModelHelper.getInstance(this.cfgVersion).setInactivityTimeout(this.binding, null);
        } else {
            RMModelHelper.getInstance(this.cfgVersion).setInactivityTimeout(this.binding, number.toString());
        }
        Number number2 = this.getTextField(this.maxBufTextField);
        if (number2 == null || "32".equals(number2.toString())) {
            RMModelHelper.setMaxReceiveBufferSize(this.binding, null);
        } else {
            RMModelHelper.setMaxReceiveBufferSize(this.binding, number2.toString());
        }
        ((RMDeliveryAssurance)((Object)this.deliveryAssuranceCombo.getSelectedItem())).set(this.cfgVersion, this.binding);
    }

    private void enableDisable() {
        boolean bl = this.flowControlChBox.isSelected();
        this.maxBufLabel.setEnabled(bl);
        this.maxBufTextField.setEnabled(bl);
    }

    private void initComponents() {
        this.flowControlChBox = new JCheckBox();
        this.maxBufLabel = new JLabel();
        this.inactivityTimeoutLabel = new JLabel();
        this.inactivityTimeoutTextfield = new JFormattedTextField();
        this.maxBufTextField = new JFormattedTextField();
        this.deliveryAssuranceLabel = new JLabel();
        this.deliveryAssuranceCombo = new JComboBox();
        this.flowControlChBox.setText(NbBundle.getMessage(AdvancedRMPanel.class, (String)"LBL_AdvancedRM_FlowControlChBox"));
        this.flowControlChBox.setMargin(new Insets(0, 0, 0, 0));
        this.flowControlChBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedRMPanel.this.flowControlChBoxActionPerformed(actionEvent);
            }
        });
        this.maxBufLabel.setText(NbBundle.getMessage(AdvancedRMPanel.class, (String)"LBL_AdvancedRM_maxBufLabel"));
        this.inactivityTimeoutLabel.setText(NbBundle.getMessage(AdvancedRMPanel.class, (String)"LBL_AdvancedRM_InactivityTimeoutLabel"));
        this.inactivityTimeoutTextfield.setFormatterFactory(this.milisecondsff);
        this.maxBufTextField.setColumns(8);
        this.maxBufTextField.setFormatterFactory(this.maxBufff);
        this.deliveryAssuranceLabel.setText(NbBundle.getMessage(AdvancedRMPanel.class, (String)"LBL_AdvancedRM_DeliveryAssurance"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.flowControlChBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.maxBufLabel).add((Component)this.inactivityTimeoutLabel).add((Component)this.deliveryAssuranceLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.deliveryAssuranceCombo, 0, 135, Short.MAX_VALUE).add((Component)this.inactivityTimeoutTextfield, -1, 135, Short.MAX_VALUE).add((Component)this.maxBufTextField, -1, 135, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.deliveryAssuranceLabel).add((Component)this.deliveryAssuranceCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.flowControlChBox).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.maxBufLabel).add((Component)this.maxBufTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.inactivityTimeoutLabel).add((Component)this.inactivityTimeoutTextfield, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.deliveryAssuranceCombo, this.inactivityTimeoutTextfield, this.maxBufTextField}, 2);
        this.flowControlChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedRMPanel.class, (String)"LBL_AdvancedRM_FlowControl_ACSD"));
        this.maxBufLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedRMPanel.class, (String)"LBL_AdvancedRM_MaxFlowBufSize_ACSD"));
        this.inactivityTimeoutLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedRMPanel.class, (String)"LBL_AdvancedRM_InactTimeout_ACSD"));
        this.inactivityTimeoutTextfield.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdvancedRMPanel.class, (String)"TXT_AdvancedRM_InactTimeout_ACSN"));
        this.inactivityTimeoutTextfield.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedRMPanel.class, (String)"TXT_AdvancedRM_InactTimeout_ACSD"));
        this.maxBufTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdvancedRMPanel.class, (String)"TXT_AdvancedRM_MaxBuf_ACSN"));
        this.maxBufTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedRMPanel.class, (String)"TXT_AdvancedRM_MaxBuf_ACSD"));
    }

    private void flowControlChBoxActionPerformed(ActionEvent actionEvent) {
        this.enableDisable();
    }
}

