/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.netbeans.modules.websvc.wsitconf.spi.features.VersionedFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;

public abstract class ProfileBaseForm
extends JPanel {
    protected boolean inSync = false;
    protected WSDLComponent comp;
    protected SecurityProfile secProfile = null;
    protected ConfigVersion cfgVersion = null;

    private ProfileBaseForm() {
    }

    protected ProfileBaseForm(WSDLComponent wSDLComponent, SecurityProfile securityProfile) {
        this.comp = wSDLComponent;
        this.secProfile = securityProfile;
        this.cfgVersion = securityProfile instanceof VersionedFeature ? ((VersionedFeature)((Object)securityProfile)).getVersion() : PolicyModelHelper.getConfigVersion(wSDLComponent);
    }

    protected void setCombo(JComboBox jComboBox, boolean bl) {
        jComboBox.setSelectedIndex(bl ? 1 : 0);
    }

    protected void setCombo(JComboBox jComboBox, String string) {
        if (string == null) {
            jComboBox.setSelectedIndex(0);
        } else {
            jComboBox.setSelectedItem(string);
        }
    }

    protected void setChBox(JCheckBox jCheckBox, Boolean bl) {
        if (bl == null) {
            jCheckBox.setSelected(false);
        } else {
            jCheckBox.setSelected(bl);
        }
    }

    protected void fillKeySize(JComboBox jComboBox) {
        jComboBox.removeAllItems();
        jComboBox.addItem(ComboConstants.ISSUED_KEYSIZE_128);
        jComboBox.addItem(ComboConstants.ISSUED_KEYSIZE_192);
        jComboBox.addItem(ComboConstants.ISSUED_KEYSIZE_256);
    }

    protected void fillWssCombo(JComboBox jComboBox) {
        jComboBox.removeAllItems();
        jComboBox.addItem(ComboConstants.WSS10);
        jComboBox.addItem(ComboConstants.WSS11);
    }

    protected void fillSamlCombo(JComboBox jComboBox) {
        jComboBox.removeAllItems();
        jComboBox.addItem(ComboConstants.SAML_V1010);
        jComboBox.addItem(ComboConstants.SAML_V1011);
        jComboBox.addItem(ComboConstants.SAML_V1110);
        jComboBox.addItem(ComboConstants.SAML_V1111);
        jComboBox.addItem(ComboConstants.SAML_V2011);
    }

    protected void fillLayoutCombo(JComboBox jComboBox) {
        jComboBox.removeAllItems();
        jComboBox.addItem(ComboConstants.STRICT);
        jComboBox.addItem(ComboConstants.LAX);
        jComboBox.addItem(ComboConstants.LAXTSFIRST);
        jComboBox.addItem(ComboConstants.LAXTSLAST);
    }

    protected void fillAlgoSuiteCombo(JComboBox jComboBox) {
        jComboBox.removeAllItems();
        jComboBox.addItem(ComboConstants.BASIC256);
        jComboBox.addItem(ComboConstants.BASIC192);
        jComboBox.addItem(ComboConstants.BASIC128);
        jComboBox.addItem(ComboConstants.TRIPLEDES);
        jComboBox.addItem(ComboConstants.BASIC256RSA15);
        jComboBox.addItem(ComboConstants.BASIC192RSA15);
        jComboBox.addItem(ComboConstants.BASIC128RSA15);
        jComboBox.addItem(ComboConstants.TRIPLEDESRSA15);
        jComboBox.addItem(ComboConstants.BASIC256SHA256);
        jComboBox.addItem(ComboConstants.BASIC192SHA256);
        jComboBox.addItem(ComboConstants.BASIC128SHA256);
        jComboBox.addItem(ComboConstants.TRIPLEDESSHA256);
        jComboBox.addItem(ComboConstants.BASIC256SHA256RSA15);
        jComboBox.addItem(ComboConstants.BASIC192SHA256RSA15);
        jComboBox.addItem(ComboConstants.BASIC128SHA256RSA15);
        jComboBox.addItem(ComboConstants.TRIPLEDESSHA256RSA15);
    }

    protected abstract void sync();

    protected abstract void enableDisable();

    protected abstract void setValue(JComponent var1);
}

