/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Dialog;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.spi.features.ClientDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.SecureConversationFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ServiceDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.MessageAuthentication;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.ProfileBase;
import org.netbeans.modules.websvc.wsitconf.util.UndoCounter;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.AlgoSuiteModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.policy.PolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.security.BootstrapPolicy;
import org.netbeans.modules.websvc.wsitmodelext.security.SecurityPolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.security.TransportBinding;
import org.netbeans.modules.websvc.wsitmodelext.security.TrustElement;
import org.netbeans.modules.websvc.wsitmodelext.security.WssElement;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;

public class MessageAuthenticationProfile
extends ProfileBase
implements SecureConversationFeature,
ClientDefaultsFeature,
ServiceDefaultsFeature {
    private static final String DEFAULT_USERNAME = "wsit";
    private static final String DEFAULT_PASSWORD = "wsitPassword";

    public int getId() {
        return 40;
    }

    public String getDisplayName() {
        return ComboConstants.PROF_MSGAUTHSSL;
    }

    public String getDescription() {
        return ComboConstants.PROF_MSGAUTHSSL_INFO;
    }

    public boolean isCurrentProfile(WSDLComponent wSDLComponent) {
        return this.getDisplayName().equals(ProfilesModelHelper.getWSITSecurityProfile(wSDLComponent));
    }

    public void displayConfig(WSDLComponent wSDLComponent, UndoManager undoManager) {
        UndoCounter undoCounter = new UndoCounter();
        WSDLModel wSDLModel = wSDLComponent.getModel();
        wSDLModel.addUndoableEditListener((UndoableEditListener)undoCounter);
        MessageAuthentication messageAuthentication = new MessageAuthentication(wSDLComponent, this);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)messageAuthentication, this.getDisplayName());
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.CANCEL_OPTION) {
            for (int i = 0; i < undoCounter.getCounter(); ++i) {
                if (!undoManager.canUndo()) continue;
                undoManager.undo();
            }
        }
        wSDLModel.removeUndoableEditListener((UndoableEditListener)undoCounter);
    }

    public void setServiceDefaults(WSDLComponent wSDLComponent, Project project) {
        ProprietarySecurityPolicyModelHelper.clearValidators(wSDLComponent);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, null, false, false);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, null, true, false);
    }

    public void setClientDefaults(WSDLComponent wSDLComponent, WSDLComponent wSDLComponent2, Project project) {
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, null, false, true);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, null, true, true);
        ProprietarySecurityPolicyModelHelper.removeCallbackHandlerConfiguration((Binding)wSDLComponent);
        ProprietarySecurityPolicyModelHelper.setCallbackHandler((Binding)wSDLComponent, "usernameHandler", null, DEFAULT_USERNAME, true);
        ProprietarySecurityPolicyModelHelper.setCallbackHandler((Binding)wSDLComponent, "passwordHandler", null, DEFAULT_PASSWORD, true);
    }

    public boolean isServiceDefaultSetupUsed(WSDLComponent wSDLComponent, Project project) {
        if (ProprietarySecurityPolicyModelHelper.isAnyValidatorSet(wSDLComponent)) {
            return false;
        }
        String string = ProprietarySecurityPolicyModelHelper.getStoreAlias(wSDLComponent, false);
        String string2 = ProprietarySecurityPolicyModelHelper.getStoreAlias(wSDLComponent, true);
        String string3 = ProprietarySecurityPolicyModelHelper.getStoreLocation(wSDLComponent, true);
        String string4 = ProprietarySecurityPolicyModelHelper.getStoreLocation(wSDLComponent, false);
        String string5 = ProprietarySecurityPolicyModelHelper.getStorePassword(wSDLComponent, false);
        String string6 = ProprietarySecurityPolicyModelHelper.getStorePassword(wSDLComponent, true);
        return string == null && string2 == null && string3 == null && string4 == null && string6 == null && string5 == null;
    }

    public boolean isClientDefaultSetupUsed(WSDLComponent wSDLComponent, Binding binding, Project project) {
        if (ProprietarySecurityPolicyModelHelper.isAnyValidatorSet(wSDLComponent)) {
            return false;
        }
        String string = ProprietarySecurityPolicyModelHelper.getStoreLocation(wSDLComponent, true);
        String string2 = ProprietarySecurityPolicyModelHelper.getStoreLocation(wSDLComponent, false);
        String string3 = ProprietarySecurityPolicyModelHelper.getStorePassword(wSDLComponent, false);
        String string4 = ProprietarySecurityPolicyModelHelper.getStorePassword(wSDLComponent, true);
        String string5 = ProprietarySecurityPolicyModelHelper.getStoreAlias(wSDLComponent, false);
        String string6 = ProprietarySecurityPolicyModelHelper.getStoreAlias(wSDLComponent, true);
        if (string5 == null && string6 == null && string == null && string2 == null && string4 == null && string3 == null) {
            String string7 = ProprietarySecurityPolicyModelHelper.getDefaultUsername((Binding)wSDLComponent);
            String string8 = ProprietarySecurityPolicyModelHelper.getDefaultPassword((Binding)wSDLComponent);
            if (DEFAULT_PASSWORD.equals(string8) && DEFAULT_USERNAME.equals(string7) && string == null && string4 == null && string3 != null && string2 == null) {
                return true;
            }
        }
        return false;
    }

    public boolean isSecureConversation(WSDLComponent wSDLComponent) {
        WSDLComponent wSDLComponent2 = SecurityTokensModelHelper.getSupportingToken(wSDLComponent, 2);
        return wSDLComponent2 != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableSecureConversation(WSDLComponent wSDLComponent, boolean bl) {
        ConfigVersion configVersion = PolicyModelHelper.getConfigVersion(wSDLComponent);
        SecurityTokensModelHelper securityTokensModelHelper = SecurityTokensModelHelper.getInstance(configVersion);
        if (bl) {
            WSDLModel wSDLModel = wSDLComponent.getModel();
            boolean bl2 = wSDLModel.isIntransaction();
            if (!bl2) {
                wSDLModel.startTransaction();
            }
            try {
                SecurityPolicyModelHelper securityPolicyModelHelper = SecurityPolicyModelHelper.getInstance(configVersion);
                AlgoSuiteModelHelper algoSuiteModelHelper = AlgoSuiteModelHelper.getInstance(configVersion);
                RMModelHelper rMModelHelper = RMModelHelper.getInstance(configVersion);
                PolicyModelHelper policyModelHelper = PolicyModelHelper.getInstance(configVersion);
                securityPolicyModelHelper.enableTrust(wSDLComponent, configVersion);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
                WSDLComponent wSDLComponent2 = securityTokensModelHelper.setSupportingTokens(wSDLComponent, ComboConstants.SECURECONVERSATION, 2);
                Policy policy = (Policy)policyModelHelper.createElement(wSDLComponent2, PolicyQName.POLICY.getQName(configVersion), Policy.class, false);
                BootstrapPolicy bootstrapPolicy = (BootstrapPolicy)policyModelHelper.createElement((WSDLComponent)policy, SecurityPolicyQName.BOOTSTRAPPOLICY.getQName(configVersion), BootstrapPolicy.class, false);
                policy = (Policy)policyModelHelper.createElement((WSDLComponent)bootstrapPolicy, PolicyQName.POLICY.getQName(configVersion), Policy.class, false);
                TransportBinding transportBinding = (TransportBinding)policyModelHelper.createElement((WSDLComponent)policy, SecurityPolicyQName.TRANSPORTBINDING.getQName(configVersion), TransportBinding.class, false);
                boolean bl3 = rMModelHelper.isRMEnabled(wSDLComponent);
                securityPolicyModelHelper.setDefaultTargets((WSDLComponent)policy, true, bl3);
                securityTokensModelHelper.setTokenType((WSDLComponent)transportBinding, ComboConstants.TRANSPORT, ComboConstants.HTTPS);
                securityPolicyModelHelper.setLayout((WSDLComponent)transportBinding, ComboConstants.STRICT);
                securityPolicyModelHelper.enableIncludeTimestamp((WSDLComponent)transportBinding, true);
                algoSuiteModelHelper.setAlgorithmSuite((WSDLComponent)transportBinding, ComboConstants.BASIC128);
                securityTokensModelHelper.setSupportingTokens((WSDLComponent)policy, ComboConstants.USERNAME, 1);
                WssElement wssElement = securityPolicyModelHelper.enableWss((WSDLComponent)bootstrapPolicy, true);
                securityPolicyModelHelper.enableMustSupportRefIssuerSerial(wssElement, true);
                securityPolicyModelHelper.enableMustSupportRefThumbprint(wssElement, true);
                securityPolicyModelHelper.enableMustSupportRefEncryptedKey(wssElement, true);
                TrustElement trustElement = securityPolicyModelHelper.enableTrust((WSDLComponent)bootstrapPolicy, configVersion);
                securityPolicyModelHelper.enableMustSupportIssuedTokens(trustElement, true);
                securityPolicyModelHelper.enableRequireClientEntropy(trustElement, true);
                securityPolicyModelHelper.enableRequireServerEntropy(trustElement, true);
            }
            finally {
                if (!bl2) {
                    wSDLModel.endTransaction();
                }
            }
        } else {
            SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
            securityTokensModelHelper.setSupportingTokens(wSDLComponent, ComboConstants.USERNAME, 1);
        }
    }

    public void profileSelected(WSDLComponent wSDLComponent, boolean bl, ConfigVersion configVersion) {
        ProfilesModelHelper profilesModelHelper = ProfilesModelHelper.getInstance(configVersion);
        RMModelHelper rMModelHelper = RMModelHelper.getInstance(configVersion);
        profilesModelHelper.setSecurityProfile(wSDLComponent, this.getDisplayName(), bl);
        boolean bl2 = rMModelHelper.isRMEnabled(wSDLComponent);
        if (bl2) {
            this.enableSecureConversation(wSDLComponent, true);
        }
    }
}

