/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.ui.SelectClassPanel;
import org.netbeans.modules.websvc.wsitconf.util.AbstractTask;
import org.netbeans.modules.websvc.wsitconf.util.SourceUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDialog {
    private Dialog dialog;
    private SelectClassPanel sPanel;
    private SelectClassDialogDesc dlgDesc;

    public ClassDialog(Project project, String string) {
        this.sPanel = new SelectClassPanel(project);
        this.dlgDesc = new SelectClassDialogDesc(this.sPanel, string);
        this.dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.dlgDesc);
    }

    public void show() {
        this.dialog.setVisible(true);
    }

    public boolean okButtonPressed() {
        return this.dlgDesc.getValue() == DialogDescriptor.OK_OPTION;
    }

    public Set<String> getSelectedClasses() {
        HashSet<String> hashSet = new HashSet<String>();
        Node[] nodeArray = this.sPanel.getSelectedNodes();
        for (int i = 0; i < nodeArray.length; ++i) {
            String string = this.getClassNameFromNode(nodeArray[i]);
            hashSet.add(string);
        }
        return hashSet;
    }

    private String getClassNameFromNode(Node node) {
        final String[] stringArray = new String[1];
        FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        try {
            javaSource.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    SourceUtils sourceUtils = SourceUtils.newInstance(compilationController);
                    stringArray[0] = sourceUtils.getTypeElement().getQualifiedName().toString();
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return stringArray[0];
    }

    static class SelectClassDialogDesc
    extends DialogDescriptor {
        String extendingClass;
        final SelectClassPanel sPanel;
        private Object[] closingOptionsWithoutOK = new Object[]{DialogDescriptor.CANCEL_OPTION, DialogDescriptor.CLOSED_OPTION};
        private Object[] closingOptionsWithOK = new Object[]{DialogDescriptor.CANCEL_OPTION, DialogDescriptor.CLOSED_OPTION, DialogDescriptor.OK_OPTION};

        public SelectClassDialogDesc(SelectClassPanel selectClassPanel, String string) {
            super((Object)selectClassPanel, "Select Class");
            this.extendingClass = string;
            this.sPanel = selectClassPanel;
            this.setButtonListener(new AddClassActionListener(selectClassPanel));
        }

        private boolean isWantedClass(JavaSource javaSource) {
            final Boolean[] booleanArray = new Boolean[]{false};
            try {
                javaSource.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                    public void run(CompilationController compilationController) throws IOException {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        SourceUtils sourceUtils = SourceUtils.newInstance(compilationController);
                        booleanArray[0] = sourceUtils.isSubtype(SelectClassDialogDesc.this.extendingClass);
                    }
                }, true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            return booleanArray[0];
        }

        class AddClassActionListener
        implements ActionListener {
            SelectClassPanel sPanel;

            public AddClassActionListener(SelectClassPanel selectClassPanel) {
                this.sPanel = selectClassPanel;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == NotifyDescriptor.OK_OPTION) {
                    boolean bl = true;
                    String string = null;
                    Node[] nodeArray = this.sPanel.getSelectedNodes();
                    for (int i = 0; i < nodeArray.length; ++i) {
                        Node node = nodeArray[i];
                        FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
                        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
                        if (javaSource == null) {
                            string = NbBundle.getMessage(ClassDialog.class, (String)"TXT_NotJavaClass_msg");
                            bl = false;
                            break;
                        }
                        if (SelectClassDialogDesc.this.isWantedClass(javaSource)) continue;
                        string = NbBundle.getMessage(ClassDialog.class, (String)"TXT_NotWantedClass_msg", (Object)fileObject.getName(), (Object)SelectClassDialogDesc.this.extendingClass);
                        bl = false;
                        break;
                    }
                    if (!bl) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message(string, 0);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
                        SelectClassDialogDesc.this.setClosingOptions(SelectClassDialogDesc.this.closingOptionsWithoutOK);
                    } else {
                        SelectClassDialogDesc.this.setClosingOptions(SelectClassDialogDesc.this.closingOptionsWithOK);
                    }
                }
            }
        }
    }
}

