/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.inspector;

import java.awt.Component;
import java.beans.PropertyVetoException;
import java.util.Collection;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.modules.vmd.api.inspector.InspectorRegistry;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DesignDocumentAwareness;
import org.netbeans.modules.vmd.api.io.IOUtils;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.DesignListener;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.netbeans.modules.vmd.inspector.InspectorPanel;
import org.netbeans.modules.vmd.inspector.InspectorUI;
import org.netbeans.modules.vmd.inspector.InspectorWrapperTree;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InspectorManagerView
implements DesignDocumentAwareness,
ActiveDocumentSupport.Listener,
DesignListener {
    private static WeakHashMap<DataObjectContext, InspectorManagerView> INSTANCES = new WeakHashMap();
    private static final JLabel emptyPanel = new JLabel(NbBundle.getMessage(InspectorManagerView.class, (String)"LBL_emptyPanel"), 0);
    private DesignDocument document;
    private InspectorWrapperTree folderWrapperTree;
    private InspectorUI ui;
    private DataObjectContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(DataObjectContext dataObjectContext) {
        assert (dataObjectContext != null);
        Class<InspectorManagerView> clazz = InspectorManagerView.class;
        synchronized (InspectorManagerView.class) {
            if (INSTANCES.get(dataObjectContext) == null) {
                INSTANCES.put(dataObjectContext, new InspectorManagerView(dataObjectContext));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private InspectorManagerView(DataObjectContext dataObjectContext) {
        this.context = dataObjectContext;
        dataObjectContext.addDesignDocumentAwareness((DesignDocumentAwareness)this);
    }

    public void setDesignDocument(DesignDocument designDocument) {
        if (designDocument != null) {
            this.document = designDocument;
            this.ui = new InspectorUI(designDocument);
            this.folderWrapperTree = new InspectorWrapperTree(designDocument, this.ui);
            ActiveDocumentSupport.getDefault().addActiveDocumentListener((ActiveDocumentSupport.Listener)this);
            designDocument.getListenerManager().addDesignListener((DesignListener)this, new DesignEventFilter(new DesignEventFilter[0]).setGlobal(true));
            IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

                public void run() {
                    if (InspectorManagerView.this.folderWrapperTree == null) {
                        return;
                    }
                    InspectorManagerView.this.folderWrapperTree.buildTree(null);
                    InspectorManagerView.this.ui.getExplorerManager().setRootContext((Node)InspectorManagerView.this.folderWrapperTree.getRootWrapperFolder().getNode());
                }
            });
        } else if (this.document != null && designDocument == null) {
            ActiveDocumentSupport.getDefault().removeActiveDocumentListener((ActiveDocumentSupport.Listener)this);
            this.document.getListenerManager().removeDesignListener((DesignListener)this);
            this.folderWrapperTree.terminate();
            this.ui = null;
            this.folderWrapperTree = null;
            this.document = null;
            INSTANCES.remove(this.context);
            this.context = null;
        }
    }

    private void notifyUIContentChanged(final DesignEvent designEvent) {
        IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

            public void run() {
                if (InspectorManagerView.this.folderWrapperTree.isLocked()) {
                    Debug.warning((Object[])new Object[]{"Access to the Navigator is locked"});
                }
                InspectorManagerView.this.folderWrapperTree.buildTree(designEvent);
                InspectorManagerView.this.ui.setRootNode((Node)InspectorManagerView.this.folderWrapperTree.getRootWrapperFolder().getNode());
            }
        });
    }

    private void notifyUISelectionChanged() {
        IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

            public void run() {
                Collection<Node> collection;
                if (InspectorManagerView.this.folderWrapperTree.isLocked()) {
                    Debug.warning((Object[])new Object[]{"Access to the Navigator is locked"});
                }
                if (InspectorManagerView.this.document == null || InspectorManagerView.this.document.getListenerManager() == null) {
                    return;
                }
                if (InspectorManagerView.this.folderWrapperTree.getRootWrapperFolder().getNode() != null && (collection = InspectorManagerView.this.folderWrapperTree.getSelectedNodes()) != null) {
                    try {
                        if (!collection.isEmpty() && !InspectorManagerView.this.folderWrapperTree.isLocked()) {
                            InspectorManagerView.this.ui.getExplorerManager().setSelectedNodes(collection.toArray(new Node[collection.size()]));
                        }
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        propertyVetoException.printStackTrace();
                    }
                }
                if (InspectorManagerView.this.folderWrapperTree.getRootWrapperFolder().getNode() == null) {
                    InspectorManagerView.this.ui.setRootNode(Node.EMPTY);
                }
            }
        });
    }

    public synchronized void activeDocumentChanged(DesignDocument designDocument, DesignDocument designDocument2) {
        if (designDocument == this.document && designDocument2 == null) {
            IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

                public void run() {
                    JComponent jComponent = InspectorPanel.getInstance().getComponent();
                    jComponent.removeAll();
                    jComponent.add((Component)emptyPanel, "Center");
                    jComponent.revalidate();
                    jComponent.repaint();
                }
            });
            return;
        }
        if (designDocument2 == this.document) {
            IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

                public void run() {
                    if (InspectorPanel.getInstance() == null) {
                        return;
                    }
                    JComponent jComponent = InspectorPanel.getInstance().getComponent();
                    jComponent.removeAll();
                    jComponent.add((Component)((Object)InspectorManagerView.this.ui), "Center");
                    jComponent.revalidate();
                    jComponent.repaint();
                }
            });
        }
    }

    public void activeComponentsChanged(Collection<DesignComponent> collection) {
    }

    public void designChanged(DesignEvent designEvent) {
        if (this.document.getRootComponent() == null) {
            return;
        }
        if (designEvent.isStructureChanged()) {
            this.notifyUIContentChanged(designEvent);
        }
        if (designEvent.isSelectionChanged()) {
            this.notifyUISelectionChanged();
        }
        InspectorRegistry.getInstance(this.document).cleanUpRegistry();
    }
}

