/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.inspector;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class InspectorBeanTreeView
extends BeanTreeView {
    public InspectorBeanTreeView(final ExplorerManager explorerManager) {
        final JPopupMenu jPopupMenu = new JPopupMenu();
        Image image = Utilities.loadImage((String)"org/netbeans/modules/vmd/inspector/resources/collapse-all.png");
        Image image2 = Utilities.loadImage((String)"org/netbeans/modules/vmd/inspector/resources/expand-all.png");
        this.setAllowedDragActions(3);
        jPopupMenu.add(new MenuAction(NbBundle.getMessage(InspectorBeanTreeView.class, (String)"CTL_InspectorExpandAction"), image2){

            public void actionPerformed(ActionEvent actionEvent) {
                InspectorBeanTreeView.this.expandAll();
            }
        });
        jPopupMenu.add(new MenuAction(NbBundle.getMessage(InspectorBeanTreeView.class, (String)"CTL_InspectorCollapseAction"), image){

            public void actionPerformed(ActionEvent actionEvent) {
                Node[] nodeArray;
                if (explorerManager.getRootContext().getChildren().getNodes() == null || explorerManager.getRootContext().getChildren().getNodes().length == 0) {
                    return;
                }
                for (Node node : nodeArray = explorerManager.getRootContext().getChildren().getNodes()) {
                    this.deepDive(node);
                }
            }

            private void deepDive(Node node) {
                for (Node node2 : node.getChildren().getNodes()) {
                    this.deepDive(node2);
                }
                InspectorBeanTreeView.this.collapseNode(node);
            }
        });
        this.tree.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3 && explorerManager.getSelectedNodes().length == 1 && explorerManager.getSelectedNodes()[0] == explorerManager.getRootContext()) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
    }

    private abstract class MenuAction
    extends AbstractAction {
        public MenuAction(String string, Image image) {
            this.putValue("Name", string);
            this.putValue("SmallIcon", new ImageIcon(image));
        }
    }
}

