/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.inspector.common;

import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vmd.api.inspector.InspectorFolderPresenter;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.api.model.presenters.actions.ActionContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class RenameAction
extends SystemAction
implements ActionContext {
    public static final String DISPLAY_NAME = NbBundle.getMessage(RenameAction.class, (String)"NAME_RenameAction");
    private NotifyDescriptor.InputLine descriptor;
    private boolean canRename;
    private WeakReference<DesignComponent> component;

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.component == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (RenameAction.this.component == null || RenameAction.this.component.get() == null) {
                    throw new IllegalArgumentException("No DesignComponent attached to DeleteAction");
                }
                ((DesignComponent)RenameAction.this.component.get()).getDocument().getTransactionManager().writeAccess(new Runnable(){

                    public void run() {
                        InfoPresenter infoPresenter = (InfoPresenter)((DesignComponent)RenameAction.this.component.get()).getPresenter(InfoPresenter.class);
                        if (infoPresenter == null) {
                            Debug.warning((Object[])new Object[]{"No necessary presenter for this operation - component: " + RenameAction.this.component});
                            return;
                        }
                        RenameAction.this.getDialogDescriptor().setInputText(infoPresenter.getEditableName());
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)RenameAction.this.getDialogDescriptor());
                        if ((Integer)RenameAction.this.descriptor.getValue() == 0 && RenameAction.this.descriptor.getInputText().trim().length() > 0) {
                            infoPresenter.setEditableName(RenameAction.this.descriptor.getInputText().trim());
                        }
                    }
                });
            }
        });
    }

    private NotifyDescriptor.InputLine getDialogDescriptor() {
        if (this.descriptor != null) {
            return this.descriptor;
        }
        this.descriptor = new NotifyDescriptor.InputLine(NbBundle.getMessage(RenameAction.class, (String)"TITLE_RenameQuestion"), NbBundle.getMessage(RenameAction.class, (String)"TITLE_RenameDialog"));
        return this.descriptor;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isEnabled() {
        if (this.component == null) {
            return false;
        }
        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                if (((DesignComponent)RenameAction.this.component.get()).getDocument().getSelectedComponents().size() > 1) {
                    RenameAction.this.canRename = false;
                    return;
                }
                InspectorFolderPresenter inspectorFolderPresenter = (InspectorFolderPresenter)((DesignComponent)RenameAction.this.component.get()).getPresenter(InspectorFolderPresenter.class);
                if (inspectorFolderPresenter != null) {
                    RenameAction.this.canRename = inspectorFolderPresenter.getFolder().canRename();
                } else {
                    RenameAction.this.canRename = false;
                }
            }
        });
        return this.canRename;
    }

    public String getName() {
        return DISPLAY_NAME;
    }

    public void setComponent(DesignComponent designComponent) {
        this.component = new WeakReference<DesignComponent>(designComponent);
    }
}

