/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.websvcmgr.codegen;

import com.sun.tools.ws.processor.model.java.JavaParameter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.visualweb.websvcmgr.codegen.DataProviderInfo;
import org.netbeans.modules.visualweb.websvcmgr.codegen.DataProviderModelMethod;
import org.netbeans.modules.visualweb.websvcmgr.codegen.DataProviderParameter;
import org.netbeans.modules.visualweb.websvcmgr.util.Util;
import org.netbeans.modules.websvc.manager.util.ManagerUtil;

public class DataProviderWriter
extends PrintWriter {
    private static String[] PRIMITIVE_TYPES = new String[]{"char", "byte", "short", "int", "long", "float", "double", "boolean"};
    private static String[] PRIMITIVE_WRAPPERS = new String[]{"Character", "Byte", "Short", "Integer", "Long", "Float", "Double", "Boolean"};
    private DataProviderInfo dataProviderInfo;
    private Set imports = new HashSet();
    private boolean isJ2EE_15;
    private ClassLoader classLoader;

    public DataProviderWriter(Writer writer, DataProviderInfo dataProviderInfo, boolean bl) {
        super(writer);
        this.dataProviderInfo = dataProviderInfo;
        this.isJ2EE_15 = bl;
    }

    public void addImport(String string) {
        this.imports.add(string);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void writeClass() {
        Object object;
        int n;
        Object object2;
        boolean bl = Util.isPrimitiveType(this.dataProviderInfo.getMethod().getMethodReturnType());
        this.println("package " + this.dataProviderInfo.getPackageName() + ";");
        this.println("/**");
        this.println(" * Source code created on " + new Date());
        this.println(" */");
        this.println();
        if (!this.imports.isEmpty()) {
            object2 = this.imports.iterator();
            while (object2.hasNext()) {
                this.println("import " + object2.next() + ";");
            }
            this.println();
        }
        this.println("import com.sun.data.provider.*;");
        this.println("import com.sun.data.provider.impl.*;");
        this.println("import java.lang.reflect.Method;");
        if (this.isJ2EE_15) {
            this.println("import java.lang.reflect.ParameterizedType;");
            this.println("import java.lang.reflect.Type;");
        }
        this.println("import java.beans.*;");
        this.println("import java.util.ArrayList;");
        this.println();
        object2 = "MethodResultTableDataProvider";
        String string = this.dataProviderInfo.getClassName();
        this.println("public class " + string + " extends " + (String)object2 + " {");
        this.println();
        String string2 = this.dataProviderInfo.getClientWrapperClassName();
        String string3 = ManagerUtil.makeValidJavaBeanName((String)ManagerUtil.decapitalize((String)string2));
        this.println("    protected " + string2 + " " + string3 + ";");
        this.println("    // Properties. One per method parameter.");
        for (DataProviderParameter dataProviderParameter : this.dataProviderInfo.getMethod().getParameters()) {
            this.println("    protected " + dataProviderParameter.getType() + " " + dataProviderParameter.getName() + ";");
        }
        this.println();
        this.println("    public " + string + "() {");
        this.println("    }");
        this.println();
        this.println("    public " + string2 + " get" + string2 + "() {");
        this.println("        return  this." + string3 + ";");
        this.println("    }");
        this.println();
        this.println("    public void set" + string2 + "( " + string2 + " " + string3 + " ) { ");
        this.println("        this." + string3 + " = " + string3 + ";");
        this.println("        try { ");
        this.println("            setDataProviderProperties(); ");
        if (this.isJ2EE_15) {
            this.println("            Method dataMethod = super.getDataMethod(); ");
            this.println("            Class returnClass = dataMethod.getReturnType();");
            this.println("            if (java.util.Collection.class.isAssignableFrom(returnClass)) {");
            this.println("                Type returnType = dataMethod.getGenericReturnType();");
            this.println("                if (returnType instanceof ParameterizedType) { ");
            this.println("                    ParameterizedType paramType = (ParameterizedType)returnType;");
            this.println("                    Type[] actualTypes = paramType.getActualTypeArguments();");
            this.println("                    if (actualTypes.length == 1 && actualTypes[0] instanceof Class) { ");
            this.println("                        super.setCollectionElementType((Class)actualTypes[0]);");
            this.println("                    }");
            this.println("                }");
            this.println("            }");
        }
        this.println("        } catch( java.lang.NoSuchMethodException ne ) { ");
        this.println("            ne.printStackTrace();");
        this.println("        }");
        this.println("    }");
        this.println();
        for (DataProviderParameter dataProviderParameter : this.dataProviderInfo.getMethod().getParameters()) {
            this.println("    public " + dataProviderParameter.getType() + " get" + ManagerUtil.upperCaseFirstChar((String)dataProviderParameter.getName()) + "() {");
            this.println("        return " + dataProviderParameter.getName() + ";");
            this.println("    }");
            this.println();
            this.println("    public void set" + ManagerUtil.upperCaseFirstChar((String)dataProviderParameter.getName()) + "( " + dataProviderParameter.getType() + " " + dataProviderParameter.getName() + " ) { ");
            this.println("        this." + dataProviderParameter.getName() + " = " + dataProviderParameter.getName() + ";");
            this.println("    }");
            this.println();
        }
        this.println();
        if (!bl && this.dataProviderInfo.getOutputHolderIndex() < 0 && this.dataProviderInfo.getWrappedProperty() == null) {
            this.println("    public Object[] getDataMethodArguments() {");
        } else {
            this.println("    private Object[] getOriginalDataMethodArguments() {");
        }
        int n2 = this.dataProviderInfo.getMethod().getParameters().size();
        this.println("        try { ");
        this.println("            Object[] values = new Object[" + n2 + "];");
        this.println();
        for (n = 0; n < n2; ++n) {
            object = this.dataProviderInfo.getMethod().getParameters().get(n);
            this.println("            values[" + n + "] = " + this.convertPrimitiveType(((DataProviderParameter)object).getName(), ((DataProviderParameter)object).getType()) + ";");
        }
        this.println("            return values;");
        this.println("        } catch( Exception e ) { ");
        this.println("            e.printStackTrace();");
        this.println("            return null; ");
        this.println("        }");
        this.println();
        this.println("    }");
        this.println();
        this.println("    public FieldKey[] getFieldKeys() throws DataProviderException {");
        this.println("        FieldKey[] fieldKeys = super.getFieldKeys(); ");
        this.println("        ArrayList finalKeys = new ArrayList(); ");
        this.println("        for( int i = 0; i < fieldKeys.length; i ++ ) { ");
        this.println("            if( !fieldKeys[i].getFieldId().equals( \"class\" ) )");
        this.println("                finalKeys.add( fieldKeys[i] ); ");
        this.println("        } ");
        this.println("        return (FieldKey[])finalKeys.toArray( new FieldKey[0] ); ");
        this.println("    } ");
        n = this.dataProviderInfo.getOutputHolderIndex();
        if (this.dataProviderInfo.getWrappedProperty() != null) {
            this.println("    private void setDataProviderProperties() throws NoSuchMethodException { ");
            this.println("        super.setDataClassInstance( this );");
            this.println("        originalDataMethod = " + string2 + ".class.getMethod(");
            this.println("            \"" + this.dataProviderInfo.getMethod().getMethodName() + "\", new Class[] {" + this.getMethodParamTypes() + "} );");
            this.println("        super.setDataMethod( getWrapperMethod() ); ");
            this.println("    }");
            this.writeUnwrapMethod(string3, this.dataProviderInfo.getMethod().getMethodReturnType(), this.dataProviderInfo.getWrappedProperty().getName(), this.dataProviderInfo.getWrappedProperty().getType());
        } else if (n >= 0) {
            object = ((DataProviderModelMethod)this.dataProviderInfo.getMethod()).getJavaMethod().getParametersList();
            String string4 = ((JavaParameter)object.get(n)).getType().getRealName();
            this.println("    private void setDataProviderProperties() throws NoSuchMethodException { ");
            for (DataProviderParameter dataProviderParameter : this.dataProviderInfo.getMethod().getParameters()) {
                if (!dataProviderParameter.getType().startsWith("javax.xml.ws.Holder")) continue;
                String string5 = dataProviderParameter.getName();
                String string6 = dataProviderParameter.getType();
                this.println("        " + string5 + " = new " + string6 + "();");
            }
            this.println("        super.setDataClassInstance( this );");
            this.println("        originalDataMethod = " + string2 + ".class.getMethod(");
            this.println("            \"" + this.dataProviderInfo.getMethod().getMethodName() + "\", new Class[] {" + this.getMethodParamTypes() + "} );");
            this.println("        super.setDataMethod( getWrapperMethod() ); ");
            this.println("    }");
            this.writeOutputHolderMethodWrapper(string3, string4);
        } else if (!bl) {
            this.println("    private void setDataProviderProperties() throws NoSuchMethodException { ");
            this.println("        super.setDataClassInstance( " + string3 + ");");
            this.println("        java.lang.reflect.Method dataMethod = " + string2 + ".class.getMethod(");
            this.println("            \"" + this.dataProviderInfo.getMethod().getMethodName() + "\", new Class[] {" + this.getMethodParamTypes() + "} );");
            this.println("        super.setDataMethod( dataMethod );");
            this.println("    }");
        } else {
            this.println("    private void setDataProviderProperties() throws NoSuchMethodException { ");
            this.println("        super.setDataClassInstance( this );");
            this.println("        originalDataMethod = " + string2 + ".class.getMethod(");
            this.println("            \"" + this.dataProviderInfo.getMethod().getMethodName() + "\", new Class[] {" + this.getMethodParamTypes() + "} );");
            this.println("        super.setDataMethod( getWrapperMethod() ); ");
            this.println("    }");
            this.writePrimitiveMethodWrapper(string3);
        }
        this.println("}");
    }

    private void writeOutputHolderMethodWrapper(String string, String string2) {
        int n = this.dataProviderInfo.getOutputHolderIndex();
        String string3 = "get" + ManagerUtil.upperCaseFirstChar((String)this.dataProviderInfo.getMethod().getParameters().get(n).getName()) + "()";
        String string4 = "null";
        if (ManagerUtil.isJavaPrimitive((String)string2)) {
            string4 = this.getDefaultPrimitiveRepresentation(string2);
        }
        this.println("");
        this.println("    private Method originalDataMethod; ");
        this.println("");
        this.println("    public " + string2 + " invokeMethod() {");
        this.println("        try { ");
        this.println("            originalDataMethod.invoke(" + string + ", getOriginalDataMethodArguments()); ");
        this.println("            " + string2 + " methodResult = this." + string3 + ".value;");
        this.println("            return methodResult; ");
        this.println("        }catch (Exception ex) { ");
        this.println("            ex.printStackTrace(); ");
        this.println("            return " + string4 + "; ");
        this.println("        }");
        this.println("    } ");
        this.println("");
        this.println("    private Method getWrapperMethod() throws NoSuchMethodException {");
        this.println("        return this.getClass().getMethod(\"invokeMethod\", new Class[0]); ");
        this.println("    } ");
        this.println("");
    }

    private void writeUnwrapMethod(String string, String string2, String string3, String string4) {
        Method method = Util.getPropertyGetter(string2, string3, this.classLoader);
        String string5 = method.getName() + "()";
        String string6 = "null";
        if (Util.isJavaPrimitive(string4)) {
            string6 = this.getDefaultPrimitiveRepresentation(string4);
        }
        this.println("");
        this.println("    private Method originalDataMethod; ");
        this.println("");
        this.println("    public " + string4 + " invokeMethod() {");
        this.println("        try { ");
        this.println("            " + string2 + " result = (" + string2 + ") originalDataMethod.invoke(" + string + ", getOriginalDataMethodArguments()); ");
        this.println("            " + string4 + " methodResult = result." + string5 + ";");
        this.println("            return methodResult; ");
        this.println("        }catch (Exception ex) { ");
        this.println("            ex.printStackTrace(); ");
        this.println("            return " + string6 + "; ");
        this.println("        }");
        this.println("    } ");
        this.println("");
        this.println("    private Method getWrapperMethod() throws NoSuchMethodException {");
        this.println("        return this.getClass().getMethod(\"invokeMethod\", new Class[0]); ");
        this.println("    } ");
        this.println("");
    }

    private void writePrimitiveMethodWrapper(String string) {
        String string2 = this.dataProviderInfo.getMethod().getMethodReturnType();
        if (Util.isJavaPrimitive(string2)) {
            string2 = Util.getWrapperForPrimitive(string2);
        }
        this.println("");
        this.println("    private Method originalDataMethod; ");
        this.println("");
        this.println("    public ResultBean invokeMethod() {");
        this.println("        try { ");
        this.println("            " + string2 + " result = (" + string2 + ")originalDataMethod.invoke(" + string + ", getOriginalDataMethodArguments()); ");
        this.println("            ResultBean methodResult = new ResultBean(); ");
        this.println("            methodResult.setMethodResult(result); ");
        this.println("            return methodResult; ");
        this.println("        }catch (Exception ex) { ");
        this.println("            ex.printStackTrace(); ");
        this.println("            return null; ");
        this.println("        }");
        this.println("    } ");
        this.println("");
        this.println("    private Method getWrapperMethod() throws NoSuchMethodException {");
        this.println("        return this.getClass().getMethod(\"invokeMethod\", new Class[0]); ");
        this.println("    } ");
        this.println("");
        this.println("    public static final class ResultBean { ");
        this.println("        private " + string2 + " methodResult; ");
        this.println("");
        this.println("        public ResultBean() { ");
        this.println("        } ");
        this.println("");
        this.println("        public " + string2 + " getMethodResult() { ");
        this.println("            return this.methodResult; ");
        this.println("        }");
        this.println("");
        this.println("        public void setMethodResult(" + string2 + " result) { ");
        this.println("            this.methodResult = result; ");
        this.println("        } ");
        this.println("    } ");
    }

    private String convertPrimitiveType(String string, String string2) {
        for (int i = 0; i < PRIMITIVE_TYPES.length; ++i) {
            String string3 = PRIMITIVE_TYPES[i];
            if (string2 == null || !string3.equals(string2.trim())) continue;
            return PRIMITIVE_WRAPPERS[i] + ".valueOf(this." + string + ")";
        }
        return "this." + string;
    }

    private String getMethodParamTypes() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (DataProviderParameter dataProviderParameter : this.dataProviderInfo.getMethod().getParameters()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            int n = this.separateGenericType(dataProviderParameter.getType());
            String string = dataProviderParameter.getType().substring(0, n);
            stringBuffer.append(string);
            stringBuffer.append(".class");
        }
        return stringBuffer.toString();
    }

    private int separateGenericType(String string) {
        int n = string.length();
        if (n < 2 || string.charAt(n - 1) != '>') {
            return n;
        }
        int n2 = 1;
        for (int i = n - 2; i >= 0; --i) {
            if (string.charAt(i) == '>') {
                ++n2;
            } else if (string.charAt(i) == '<') {
                --n2;
            }
            if (n2 != 0) continue;
            return i;
        }
        return n;
    }

    private String getDefaultPrimitiveRepresentation(String string) {
        if (string.equals("boolean")) {
            return "false";
        }
        return "0";
    }
}

