/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.util;

import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatus;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.config.HgConfigFiles;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.util.HgProxySettings;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgCommand {
    public static final String HG_COMMAND = "hg";
    public static final String HG_WINDOWS_EXE = ".exe";
    public static final String HG_WINDOWS_CMD = ".cmd";
    public static final String HGK_COMMAND = "hgk";
    private static final String HG_STATUS_CMD = "status";
    private static final String HG_OPT_REPOSITORY = "--repository";
    private static final String HG_OPT_BUNDLE = "--bundle";
    private static final String HG_OPT_CWD_CMD = "--cwd";
    private static final String HG_OPT_USERNAME = "--user";
    private static final String HG_OPT_FOLLOW = "--follow";
    private static final String HG_STATUS_FLAG_ALL_CMD = "-marduicC";
    private static final String HG_FLAG_REV_CMD = "--rev";
    private static final String HG_STATUS_FLAG_TIP_CMD = "tip";
    private static final String HG_STATUS_FLAG_REM_DEL_CMD = "-rd";
    private static final String HG_STATUS_FLAG_INCLUDE_CMD = "-I";
    private static final String HG_STATUS_FLAG_INCLUDE_GLOB_CMD = "glob:";
    private static final String HG_STATUS_FLAG_INCLUDE_END_CMD = "*";
    private static final String HG_STATUS_FLAG_INTERESTING_CMD = "-marduC";
    private static final String HG_STATUS_FLAG_UNKNOWN_CMD = "-u";
    private static final String HG_HEAD_STR = "HEAD";
    private static final String HG_FLAG_DATE_CMD = "--date";
    private static final String HG_COMMIT_CMD = "commit";
    private static final String HG_COMMIT_OPT_LOGFILE_CMD = "--logfile";
    private static final String HG_COMMIT_TEMPNAME = "hgcommit";
    private static final String HG_COMMIT_TEMPNAME_SUFFIX = ".hgm";
    private static final String HG_COMMIT_DEFAULT_MESSAGE = "[no commit message]";
    private static final String HG_REVERT_CMD = "revert";
    private static final String HG_REVERT_NOBACKUP_CMD = "--no-backup";
    private static final String HG_ADD_CMD = "add";
    private static final String HG_BRANCH_CMD = "branch";
    private static final String HG_BRANCH_REV_CMD = "tip";
    private static final String HG_BRANCH_REV_TEMPLATE_CMD = "--template={rev}\\n";
    private static final String HG_BRANCH_SHORT_CS_TEMPLATE_CMD = "--template={node|short}\\n";
    private static final String HG_BRANCH_INFO_TEMPLATE_CMD = "--template={branches}:{rev}:{node|short}\\n";
    private static final String HG_GET_PREVIOUS_TEMPLATE_CMD = "--template={files}\\n";
    private static final String HG_CREATE_CMD = "init";
    private static final String HG_CLONE_CMD = "clone";
    private static final String HG_UPDATE_ALL_CMD = "update";
    private static final String HG_UPDATE_FORCE_ALL_CMD = "-C";
    private static final String HG_REMOVE_CMD = "remove";
    private static final String HG_REMOVE_FLAG_FORCE_CMD = "--force";
    private static final String HG_LOG_CMD = "log";
    private static final String HG_OUT_CMD = "out";
    private static final String HG_LOG_LIMIT_ONE_CMD = "-l 1";
    private static final String HG_LOG_LIMIT_CMD = "-l";
    private static final String HG_LOG_TEMPLATE_SHORT_CMD = "--template={rev}\\n{desc|firstline}\\n{date|hgdate}\\n{node|short}\\n";
    private static final String HG_LOG_TEMPLATE_LONG_CMD = "--template={rev}\\n{desc}\\n{date|hgdate}\\n{node|short}\\n";
    private static final String HG_LOG_NO_MERGES_CMD = "-M";
    private static final String HG_LOG_DEBUG_CMD = "--debug";
    private static final String HG_LOG_TEMPLATE_HISTORY_CMD = "--template=rev:{rev}\\nauth:{author}\\ndesc:{desc}\\ndate:{date|hgdate}\\nid:{node|short}\\nparents:{parents}\\nfile_mods:{files}\\nfile_adds:{file_adds}\\nfile_dels:{file_dels}\\nfile_copies:{file_copies}\\nendCS:\\n";
    private static final String HG_LOG_TEMPLATE_HISTORY_NO_FILEINFO_CMD = "--template=rev:{rev}\\nauth:{author}\\ndesc:{desc}\\ndate:{date|hgdate}\\nid:{node|short}\\n\\nendCS:\\n";
    private static final String HG_LOG_REV_TIP_RANGE = "tip:0";
    private static final String HG_LOG_REVISION_OUT = "rev:";
    private static final String HG_LOG_AUTHOR_OUT = "auth:";
    private static final String HG_LOG_DESCRIPTION_OUT = "desc:";
    private static final String HG_LOG_DATE_OUT = "date:";
    private static final String HG_LOG_ID_OUT = "id:";
    private static final String HG_LOG_PARENTS_OUT = "parents:";
    private static final String HG_LOG_FILEMODS_OUT = "file_mods:";
    private static final String HG_LOG_FILEADDS_OUT = "file_adds:";
    private static final String HG_LOG_FILEDELS_OUT = "file_dels:";
    private static final String HG_LOG_FILECOPIESS_OUT = "file_copies:";
    private static final String HG_LOG_ENDCS_OUT = "endCS:";
    private static final String HG_LOG_PATCH_CMD = "-p";
    private static final String HG_LOG_TEMPLATE_EXPORT_FILE_CMD = "--template=# Mercurial Export File Diff\\n# changeset: \\t{rev}:{node|short}\\n# user:\\t\\t{author}\\n# date:\\t\\t{date|isodate}\\n# summary:\\t{desc}\\n\\n";
    private static final String HG_CSET_TEMPLATE_CMD = "--template={rev}:{node|short}\\n";
    private static final String HG_REV_TEMPLATE_CMD = "--template={rev}\\n";
    private static final String HG_CSET_TARGET_TEMPLATE_CMD = "--template={rev} ({node|short})\\n";
    private static final String HG_CAT_CMD = "cat";
    private static final String HG_FLAG_OUTPUT_CMD = "--output";
    private static final String HG_COMMONANCESTOR_CMD = "debugancestor";
    private static final String HG_ANNOTATE_CMD = "annotate";
    private static final String HG_ANNOTATE_FLAGN_CMD = "--number";
    private static final String HG_ANNOTATE_FLAGU_CMD = "--user";
    private static final String HG_EXPORT_CMD = "export";
    private static final String HG_IMPORT_CMD = "import";
    private static final String HG_RENAME_CMD = "rename";
    private static final String HG_RENAME_AFTER_CMD = "-A";
    private static final String HG_MERGE_CMD = "merge";
    private static final String HG_MERGE_FORCE_CMD = "-f";
    private static final String HG_MERGE_ENV = "EDITOR=success || $TEST -s";
    public static final String HG_HGK_PATH_SOLARIS10 = "/usr/demo/mercurial";
    private static final String HG_HGK_PATH_SOLARIS10_ENV = "PATH=/usr/bin/:/usr/sbin:/bin:/usr/demo/mercurial";
    private static final String HG_PULL_CMD = "pull";
    private static final String HG_UPDATE_CMD = "-u";
    private static final String HG_PUSH_CMD = "push";
    private static final String HG_UNBUNDLE_CMD = "unbundle";
    private static final String HG_ROLLBACK_CMD = "rollback";
    private static final String HG_BACKOUT_CMD = "backout";
    private static final String HG_BACKOUT_MERGE_CMD = "--merge";
    private static final String HG_BACKOUT_COMMIT_MSG_CMD = "-m";
    private static final String HG_REV_CMD = "-r";
    private static final String HG_STRIP_CMD = "strip";
    private static final String HG_STRIP_EXT_CMD = "extensions.mq=";
    private static final String HG_STRIP_NOBACKUP_CMD = "-n";
    private static final String HG_STRIP_FORCE_MULTIHEAD_CMD = "-f";
    private static final String HG_VERIFY_CMD = "verify";
    private static final String HG_VERSION_CMD = "version";
    private static final String HG_INCOMING_CMD = "incoming";
    private static final String HG_OUTGOING_CMD = "outgoing";
    private static final String HG_VIEW_CMD = "view";
    private static final String HG_VERBOSE_CMD = "-v";
    private static final String HG_CONFIG_OPTION_CMD = "--config";
    private static final String HG_FETCH_EXT_CMD = "extensions.fetch=";
    private static final String HG_FETCH_CMD = "fetch";
    public static final String HG_PROXY_ENV = "http_proxy=";
    private static final String HG_MERGE_NEEDED_ERR = "(run 'hg heads' to see heads, 'hg merge' to merge)";
    public static final String HG_MERGE_CONFLICT_ERR = "conflicts detected in ";
    public static final String HG_MERGE_CONFLICT_WIN1_ERR = "merging";
    public static final String HG_MERGE_CONFLICT_WIN2_ERR = "failed!";
    private static final String HG_MERGE_MULTIPLE_HEADS_ERR = "abort: repo has ";
    private static final String HG_MERGE_UNCOMMITTED_ERR = "abort: outstanding uncommitted merges";
    private static final String HG_MERGE_UNAVAILABLE_ERR = "is not recognized as an internal or external command";
    private static final String HG_NO_CHANGES_ERR = "no changes found";
    private static final String HG_CREATE_NEW_BRANCH_ERR = "abort: push creates new remote ";
    private static final String HG_HEADS_CREATED_ERR = "(+1 heads)";
    private static final String HG_NO_HG_CMD_FOUND_ERR = "hg: not found";
    private static final String HG_ARG_LIST_TOO_LONG_ERR = "Arg list too long";
    private static final String HG_HEADS_CMD = "heads";
    private static final String HG_NO_REPOSITORY_ERR = "There is no Mercurial repository here";
    private static final String HG_NO_RESPONSE_ERR = "no suitable response from remote hg!";
    private static final String HG_NOT_REPOSITORY_ERR = "does not appear to be an hg repository";
    private static final String HG_REPOSITORY = "repository";
    private static final String HG_NOT_FOUND_ERR = "not found!";
    private static final String HG_UPDATE_SPAN_BRANCHES_ERR = "abort: update spans branches";
    private static final String HG_ALREADY_TRACKED_ERR = " already tracked!";
    private static final String HG_NOT_TRACKED_ERR = " no tracked!";
    private static final String HG_CANNOT_READ_COMMIT_MESSAGE_ERR = "abort: can't read commit message";
    private static final String HG_CANNOT_RUN_ERR = "Cannot run program";
    private static final String HG_ABORT_ERR = "abort: ";
    private static final String HG_ABORT_PUSH_ERR = "abort: push creates new remote ";
    private static final String HG_ABORT_NO_FILES_TO_COPY_ERR = "abort: no files to copy";
    private static final String HG_ABORT_NO_DEFAULT_PUSH_ERR = "abort: repository default-push not found!";
    private static final String HG_ABORT_NO_DEFAULT_ERR = "abort: repository default not found!";
    private static final String HG_ABORT_POSSIBLE_PROXY_ERR = "abort: error: node name or service name not known";
    private static final String HG_ABORT_UNCOMMITTED_CHANGES_ERR = "abort: outstanding uncommitted changes";
    private static final String HG_BACKOUT_MERGE_NEEDED_ERR = "(use \"backout --merge\" if you want to auto-merge)";
    private static final String HG_ABORT_BACKOUT_MERGE_CSET_ERR = "abort: cannot back out a merge changeset without --parent";
    private static final String HG_COMMIT_AFTER_MERGE_ERR = "abort: cannot partially commit a merge (do not specify files or patterns)";
    private static final String HG_NO_CHANGE_NEEDED_ERR = "no change needed";
    private static final String HG_NO_ROLLBACK_ERR = "no rollback information available";
    private static final String HG_NO_UPDATES_ERR = "0 files updated, 0 files merged, 0 files removed, 0 files unresolved";
    private static final String HG_NO_VIEW_ERR = "hg: unknown command 'view'";
    private static final String HG_HGK_NOT_FOUND_ERR = "sh: hgk: not found";
    private static final String HG_NO_SUCH_FILE_ERR = "No such file";
    private static final String HG_NO_REV_STRIP_ERR = "abort: unknown revision";
    private static final String HG_LOCAL_CHANGES_STRIP_ERR = "abort: local changes found";
    private static final String HG_MULTIPLE_HEADS_STRIP_ERR = "no rollback information available";
    private static final char HG_STATUS_CODE_MODIFIED = 'm';
    private static final char HG_STATUS_CODE_ADDED = 'a';
    private static final char HG_STATUS_CODE_REMOVED = 'r';
    private static final char HG_STATUS_CODE_CLEAN = 'c';
    private static final char HG_STATUS_CODE_DELETED = 'A';
    private static final char HG_STATUS_CODE_NOTTRACKED = '_';
    private static final char HG_STATUS_CODE_IGNORED = 'i';
    private static final char HG_STATUS_CODE_CONFLICT = 'x';
    private static final char HG_STATUS_CODE_ABORT = '\u00c3';
    public static final String HG_STR_CONFLICT_EXT = ".conflict~";
    private static final String HG_EPOCH_PLUS_ONE_YEAR = "1971-01-01";

    public static List<String> doMerge(File file, String string) throws HgException {
        if (file == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_MERGE_CMD);
        arrayList.add("-f");
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        if (string != null) {
            arrayList.add(string);
        }
        arrayList2.add(HG_MERGE_ENV);
        List<String> list = HgCommand.execEnv(arrayList, arrayList2);
        return list;
    }

    public static List<String> doUpdateAll(File file, boolean bl, String string, boolean bl2) throws HgException {
        if (file == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_UPDATE_ALL_CMD);
        arrayList.add(HG_VERBOSE_CMD);
        if (bl) {
            arrayList.add(HG_UPDATE_FORCE_ALL_CMD);
        }
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        if (string != null) {
            arrayList.add(string);
        }
        List<String> list = HgCommand.exec(arrayList);
        if (bl2 && !list.isEmpty()) {
            if (HgCommand.isErrorUpdateSpansBranches(list.get(0))) {
                throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_WARN_UPDATE_MERGE_TEXT"));
            }
            if (HgCommand.isMergeAbortUncommittedMsg(list.get(0))) {
                throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_WARN_UPDATE_COMMIT_TEXT"));
            }
        }
        return list;
    }

    public static List<String> doUpdateAll(File file, boolean bl, String string) throws HgException {
        return HgCommand.doUpdateAll(file, bl, string, true);
    }

    public static List<String> doRollback(File file, OutputLogger outputLogger) throws HgException {
        if (file == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_ROLLBACK_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        List<String> list = HgCommand.exec(arrayList);
        if (list.isEmpty()) {
            HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_ROLLBACK_FAILED"), outputLogger);
        }
        return list;
    }

    public static List<String> doBackout(File file, String string, boolean bl, String string2, OutputLogger outputLogger) throws HgException {
        List<String> list;
        if (file == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(HgCommand.getHgCommand());
        arrayList2.add(HG_BACKOUT_CMD);
        if (bl) {
            arrayList2.add(HG_BACKOUT_MERGE_CMD);
            arrayList.add(HG_MERGE_ENV);
        }
        if (string2 != null && !string2.equals("")) {
            arrayList2.add(HG_BACKOUT_COMMIT_MSG_CMD);
            arrayList2.add(string2);
        } else {
            arrayList2.add(HG_BACKOUT_COMMIT_MSG_CMD);
            arrayList2.add(NbBundle.getMessage(HgCommand.class, (String)"MSG_BACKOUT_MERGE_COMMIT_MSG", (Object)string));
        }
        arrayList2.add(HG_OPT_REPOSITORY);
        arrayList2.add(file.getAbsolutePath());
        if (string != null) {
            arrayList2.add(HG_REV_CMD);
            arrayList2.add(string);
        }
        if ((list = bl ? HgCommand.execEnv(arrayList2, arrayList) : HgCommand.exec(arrayList2)).isEmpty()) {
            HgCommand.handleError(arrayList2, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_BACKOUT_FAILED"), outputLogger);
        }
        return list;
    }

    public static List<String> doStrip(File file, String string, boolean bl, boolean bl2, OutputLogger outputLogger) throws HgException {
        List<String> list;
        if (file == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_CONFIG_OPTION_CMD);
        arrayList.add(HG_STRIP_EXT_CMD);
        arrayList.add(HG_STRIP_CMD);
        if (bl) {
            arrayList.add("-f");
        }
        if (!bl2) {
            arrayList.add(HG_STRIP_NOBACKUP_CMD);
        }
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        if (string != null) {
            arrayList.add(string);
        }
        if ((list = HgCommand.exec(arrayList)).isEmpty()) {
            HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_STRIP_FAILED"), outputLogger);
        }
        return list;
    }

    public static List<String> doVerify(File file, OutputLogger outputLogger) throws HgException {
        if (file == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_VERIFY_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        List<String> list = HgCommand.exec(arrayList);
        if (list.isEmpty()) {
            HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_VERIFY_FAILED"), outputLogger);
        }
        return list;
    }

    public static String getHgVersion() {
        List<Object> list = new LinkedList();
        try {
            list = HgCommand.execForVersionCheck();
        }
        catch (HgException hgException) {
            return null;
        }
        if (!list.isEmpty()) {
            int n = ((String)list.get(0)).indexOf(40);
            int n2 = ((String)list.get(0)).indexOf(41);
            if (n != -1 && n2 != -1) {
                return ((String)list.get(0)).substring(n + 9, n2);
            }
        }
        return null;
    }

    public static List<String> doPull(File file, OutputLogger outputLogger) throws HgException {
        return HgCommand.doPull(file, null, outputLogger);
    }

    public static List<String> doPull(File file, String string, OutputLogger outputLogger) throws HgException {
        List<String> list;
        String string2;
        String string3;
        if (file == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_VERBOSE_CMD);
        arrayList.add(HG_PULL_CMD);
        arrayList.add("-u");
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        if (string != null) {
            arrayList.add(string);
        }
        if ((string3 = HgCommand.getGlobalProxyIfNeeded(string2 = new HgConfigFiles(file).getDefaultPull(false), true, outputLogger)) != null) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(HG_PROXY_ENV + string3);
            list = HgCommand.execEnv(arrayList, arrayList2);
        } else {
            list = HgCommand.exec(arrayList);
        }
        if (!list.isEmpty() && HgCommand.isErrorAbort(list.get(list.size() - 1))) {
            HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), outputLogger);
        }
        return list;
    }

    public static List<String> doUnbundle(File file, File file2, OutputLogger outputLogger) throws HgException {
        List<String> list;
        if (file == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_VERBOSE_CMD);
        arrayList.add(HG_UNBUNDLE_CMD);
        arrayList.add("-u");
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        if (file2 != null) {
            arrayList.add(file2.getAbsolutePath());
        }
        if (!(list = HgCommand.exec(arrayList)).isEmpty() && HgCommand.isErrorAbort(list.get(list.size() - 1))) {
            HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), outputLogger);
        }
        return list;
    }

    public static List<String> doIncoming(File file, OutputLogger outputLogger) throws HgException {
        return HgCommand.doIncoming(file, null, null, outputLogger);
    }

    public static List<String> doIncoming(File file, String string, File file2, OutputLogger outputLogger) throws HgException {
        List<String> list;
        String string2;
        String string3;
        if (file == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_INCOMING_CMD);
        arrayList.add(HG_VERBOSE_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        if (file2 != null) {
            arrayList.add(HG_OPT_BUNDLE);
            arrayList.add(file2.getAbsolutePath());
        }
        if (string != null) {
            arrayList.add(string);
        }
        if ((string3 = HgCommand.getGlobalProxyIfNeeded(string2 = new HgConfigFiles(file).getDefaultPull(false), false, null)) != null) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(HG_PROXY_ENV + string3);
            list = HgCommand.execEnv(arrayList, arrayList2);
        } else {
            list = HgCommand.exec(arrayList);
        }
        if (!list.isEmpty() && HgCommand.isErrorAbort(list.get(list.size() - 1))) {
            HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), outputLogger);
        }
        return list;
    }

    public static List<String> doOutgoing(File file, String string, OutputLogger outputLogger) throws HgException {
        List<String> list;
        if (file == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_OUTGOING_CMD);
        arrayList.add(HG_VERBOSE_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        arrayList.add(string);
        String string2 = new HgConfigFiles(file).getDefaultPush(false);
        String string3 = HgCommand.getGlobalProxyIfNeeded(string2, false, null);
        if (string3 != null) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(HG_PROXY_ENV + string3);
            list = HgCommand.execEnv(arrayList, arrayList2);
        } else {
            list = HgCommand.exec(arrayList);
        }
        if (!list.isEmpty() && HgCommand.isErrorAbort(list.get(list.size() - 1))) {
            HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), outputLogger);
        }
        return list;
    }

    public static List<String> doPush(File file, String string, OutputLogger outputLogger) throws HgException {
        List<String> list;
        if (file == null || string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_PUSH_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        arrayList.add(string);
        String string2 = new HgConfigFiles(file).getDefaultPush(false);
        String string3 = HgCommand.getGlobalProxyIfNeeded(string2, true, outputLogger);
        if (string3 != null) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(HG_PROXY_ENV + string3);
            list = HgCommand.execEnv(arrayList, arrayList2);
        } else {
            list = HgCommand.exec(arrayList);
        }
        if (!list.isEmpty() && !HgCommand.isErrorAbortPush(list.get(list.size() - 1)) && HgCommand.isErrorAbort(list.get(list.size() - 1))) {
            HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), outputLogger);
        }
        return list;
    }

    public static List<String> doView(File file, OutputLogger outputLogger) throws HgException {
        List<String> list;
        if (file == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_VIEW_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        if (HgUtils.isSolaris()) {
            arrayList2.add(HG_HGK_PATH_SOLARIS10_ENV);
            list = HgCommand.execEnv(arrayList, arrayList2);
        } else {
            list = HgCommand.exec(arrayList);
        }
        if (!list.isEmpty()) {
            if (HgCommand.isErrorNoView(list.get(list.size() - 1))) {
                throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_WARN_NO_VIEW_TEXT"));
            }
            if (HgCommand.isErrorHgkNotFound(list.get(0))) {
                throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_WARN_HGK_NOT_FOUND_TEXT"));
            }
            if (HgCommand.isErrorAbort(list.get(list.size() - 1))) {
                HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), outputLogger);
            }
        }
        return list;
    }

    private static String getGlobalProxyIfNeeded(String string, boolean bl, OutputLogger outputLogger) {
        HgProxySettings hgProxySettings;
        String string2 = null;
        if (string != null && (string.startsWith("http:") || string.startsWith("https:")) && (hgProxySettings = new HgProxySettings()).isManualSetProxy()) {
            if (string.startsWith("http:") && !hgProxySettings.getHttpHost().equals("") || string.startsWith("https:") && !hgProxySettings.getHttpHost().equals("") && hgProxySettings.getHttpsHost().equals("")) {
                string2 = hgProxySettings.getHttpHost();
                string2 = string2 != null && !string2.equals("") ? string2 + (hgProxySettings.getHttpPort() > -1 ? ":" + Integer.toString(hgProxySettings.getHttpPort()) : "") : null;
            } else if (string.startsWith("https:") && !hgProxySettings.getHttpsHost().equals("")) {
                string2 = hgProxySettings.getHttpsHost();
                string2 = string2 != null && !string2.equals("") ? string2 + (hgProxySettings.getHttpsPort() > -1 ? ":" + Integer.toString(hgProxySettings.getHttpsPort()) : "") : null;
            }
        }
        if (string2 != null && bl) {
            outputLogger.output(NbBundle.getMessage(HgCommand.class, (String)"MSG_USING_PROXY_INFO", string2));
        }
        return string2;
    }

    public static List<String> doFetch(File file, OutputLogger outputLogger) throws HgException {
        List<String> list;
        if (file == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_CONFIG_OPTION_CMD);
        arrayList.add(HG_FETCH_EXT_CMD);
        arrayList.add(HG_FETCH_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        String string = new HgConfigFiles(file).getDefaultPull(false);
        String string2 = HgCommand.getGlobalProxyIfNeeded(string, true, outputLogger);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(HG_MERGE_ENV);
        if (string2 != null) {
            arrayList2.add(HG_PROXY_ENV + string2);
        }
        if (!(list = HgCommand.execEnv(arrayList, arrayList2)).isEmpty() && HgCommand.isErrorAbort(list.get(list.size() - 1))) {
            HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), outputLogger);
        }
        return list;
    }

    private static List<HgLogMessage> processLogMessages(String string, List<File> list, List<String> list2, List<HgLogMessage> list3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list2 != null && !list2.isEmpty()) {
            if (list != null) {
                for (File object : list) {
                    String string2 = object.getAbsolutePath();
                    if (!string2.startsWith(string) || string2.length() <= string.length()) continue;
                    if (Utilities.isWindows()) {
                        arrayList.add(string2.substring(string.length() + 1).replace(File.separatorChar, '/'));
                        continue;
                    }
                    arrayList.add(string2.substring(string.length() + 1));
                }
            }
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            String string10 = null;
            String string11 = null;
            String string12 = null;
            boolean bl = false;
            for (String string2 : list2) {
                if (string2.indexOf(HG_LOG_REVISION_OUT) == 0) {
                    string12 = string2.substring(HG_LOG_REVISION_OUT.length()).trim();
                } else if (string2.indexOf(HG_LOG_AUTHOR_OUT) == 0) {
                    string11 = string2.substring(HG_LOG_AUTHOR_OUT.length()).trim();
                } else if (string2.indexOf(HG_LOG_DESCRIPTION_OUT) == 0) {
                    string10 = string2.substring(HG_LOG_DESCRIPTION_OUT.length()).trim();
                } else if (string2.indexOf(HG_LOG_DATE_OUT) == 0) {
                    string9 = string2.substring(HG_LOG_DATE_OUT.length()).trim();
                } else if (string2.indexOf(HG_LOG_ID_OUT) == 0) {
                    string8 = string2.substring(HG_LOG_ID_OUT.length()).trim();
                } else if (string2.indexOf(HG_LOG_PARENTS_OUT) == 0) {
                    string7 = string2.substring(HG_LOG_PARENTS_OUT.length()).trim();
                } else if (string2.indexOf(HG_LOG_FILEMODS_OUT) == 0) {
                    string6 = string2.substring(HG_LOG_FILEMODS_OUT.length()).trim();
                } else if (string2.indexOf(HG_LOG_FILEADDS_OUT) == 0) {
                    string5 = string2.substring(HG_LOG_FILEADDS_OUT.length()).trim();
                } else if (string2.indexOf(HG_LOG_FILEDELS_OUT) == 0) {
                    string4 = string2.substring(HG_LOG_FILEDELS_OUT.length()).trim();
                } else if (string2.indexOf(HG_LOG_FILECOPIESS_OUT) == 0) {
                    string3 = string2.substring(HG_LOG_FILECOPIESS_OUT.length()).trim();
                } else if (string2.indexOf(HG_LOG_ENDCS_OUT) == 0) {
                    bl = true;
                }
                if (!(string12 != null & bl)) continue;
                list3.add(new HgLogMessage(string, arrayList, string12, string11, string10, string9, string8, string7, string6, string5, string4, string3));
                string3 = null;
                string4 = null;
                string5 = null;
                string6 = null;
                string7 = null;
                string8 = null;
                string9 = null;
                string10 = null;
                string11 = null;
                string12 = null;
                bl = false;
            }
        }
        return list3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HgLogMessage[] getIncomingMessages(String string, String string2, boolean bl, OutputLogger outputLogger) {
        ArrayList<HgLogMessage> arrayList = new ArrayList<HgLogMessage>(0);
        File file = new File(string);
        try {
            try {
                LinkedList<String> linkedList = new LinkedList();
                linkedList = HgCommand.doIncomingForSearch(file, string2, bl, outputLogger);
                HgCommand.processLogMessages(string, null, linkedList, arrayList);
            }
            catch (HgException hgException) {
                NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                Object var9_9 = null;
                outputLogger.closeLog();
            }
            Object var9_8 = null;
            outputLogger.closeLog();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            outputLogger.closeLog();
            throw throwable;
        }
        return arrayList.toArray(new HgLogMessage[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HgLogMessage[] getOutMessages(String string, String string2, boolean bl, OutputLogger outputLogger) {
        ArrayList<HgLogMessage> arrayList = new ArrayList<HgLogMessage>(0);
        File file = new File(string);
        try {
            try {
                LinkedList<String> linkedList = new LinkedList();
                linkedList = HgCommand.doOutForSearch(file, string2, bl, outputLogger);
                HgCommand.processLogMessages(string, null, linkedList, arrayList);
            }
            catch (HgException hgException) {
                NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                Object var9_9 = null;
                outputLogger.closeLog();
            }
            Object var9_8 = null;
            outputLogger.closeLog();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            outputLogger.closeLog();
            throw throwable;
        }
        return arrayList.toArray(new HgLogMessage[0]);
    }

    public static HgLogMessage[] getLogMessages(String string, Set<File> set, String string2, String string3, boolean bl, OutputLogger outputLogger) {
        return HgCommand.getLogMessages(string, set, string2, string3, bl, true, -1, outputLogger);
    }

    public static HgLogMessage[] getLogMessagesNoFileInfo(String string, int n, OutputLogger outputLogger) {
        return HgCommand.getLogMessages(string, null, null, null, true, false, n, outputLogger);
    }

    public static HgLogMessage[] getLogMessagesNoFileInfo(String string, Set<File> set, int n, OutputLogger outputLogger) {
        return HgCommand.getLogMessages(string, set, null, null, true, false, n, outputLogger);
    }

    public static HgLogMessage[] getLogMessagesNoFileInfo(String string, Set<File> set, OutputLogger outputLogger) {
        return HgCommand.getLogMessages(string, set, null, null, true, false, -1, outputLogger);
    }

    public static HgLogMessage[] getLogMessages(String string, int n, OutputLogger outputLogger) {
        return HgCommand.getLogMessages(string, null, null, null, true, true, n, outputLogger);
    }

    public static HgLogMessage[] getLogMessages(String string, Set<File> set, int n, OutputLogger outputLogger) {
        return HgCommand.getLogMessages(string, set, null, null, true, true, n, outputLogger);
    }

    public static HgLogMessage[] getLogMessages(String string, Set<File> set, OutputLogger outputLogger) {
        return HgCommand.getLogMessages(string, set, null, null, true, true, -1, outputLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HgLogMessage[] getLogMessages(String string, Set<File> set, String string2, String string3, boolean bl, boolean bl2, int n, OutputLogger outputLogger) {
        String string4;
        File file;
        ArrayList<HgLogMessage> arrayList;
        block5: {
            arrayList = new ArrayList<HgLogMessage>(0);
            file = new File(string);
            string4 = HgCommand.getLastRevision(file, null);
            if (string4 != null) break block5;
            HgLogMessage[] hgLogMessageArray = arrayList.toArray(new HgLogMessage[0]);
            Object var14_15 = null;
            outputLogger.closeLog();
            return hgLogMessageArray;
        }
        try {
            try {
                LinkedList<String> linkedList = new LinkedList();
                ArrayList<File> arrayList2 = set != null ? new ArrayList<File>(set) : null;
                linkedList = HgCommand.doLogForHistory(file, arrayList2, string2, string3, string4, bl, bl2, n, outputLogger);
                HgCommand.processLogMessages(string, arrayList2, linkedList, arrayList);
            }
            catch (HgException hgException) {
                NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                Object var14_17 = null;
                outputLogger.closeLog();
            }
            Object var14_16 = null;
            outputLogger.closeLog();
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            outputLogger.closeLog();
            throw throwable;
        }
        return arrayList.toArray(new HgLogMessage[0]);
    }

    public static Boolean isMergeRequired(File file) {
        if (file == null) {
            return false;
        }
        try {
            List<String> list = HgCommand.getHeadRevisions(file);
            if (!list.isEmpty() && list.size() > 1) {
                Mercurial.LOG.log(Level.FINE, "isMergeRequired(): TRUE " + list);
                return true;
            }
            Mercurial.LOG.log(Level.FINE, "isMergeRequired(): FALSE " + list);
            return false;
        }
        catch (HgException hgException) {
            return false;
        }
    }

    public static Boolean hasHistory(File file) {
        if (file == null) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_LOG_CMD);
        arrayList.add(HG_LOG_LIMIT_ONE_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        try {
            List<String> list = HgCommand.exec(arrayList);
            if (!list.isEmpty() && HgCommand.isErrorAbort(list.get(0))) {
                return false;
            }
            return !list.isEmpty();
        }
        catch (HgException hgException) {
            return false;
        }
    }

    private static File getPreviousName(File file, File file2, String string) throws HgException {
        if (file == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_LOG_CMD);
        arrayList.add(HG_OPT_FOLLOW);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        arrayList.add(HG_FLAG_REV_CMD);
        arrayList.add(string);
        arrayList.add(HG_GET_PREVIOUS_TEMPLATE_CMD);
        arrayList.add(file2.getAbsolutePath());
        List<String> list = HgCommand.exec(arrayList);
        try {
            list = HgCommand.exec(arrayList);
            if (!list.isEmpty() && HgCommand.isErrorAbort(list.get(0))) {
                return null;
            }
        }
        catch (HgException hgException) {
            return null;
        }
        String[] stringArray = list.get(0).split(" ");
        for (int i = stringArray.length - 1; i > 0; --i) {
            File file3 = new File(file, stringArray[i]);
            if (!file3.equals(file2)) continue;
            return new File(file, stringArray[i - 1]);
        }
        return null;
    }

    public static List<String> doLogShort(File file, File file2, OutputLogger outputLogger) throws HgException {
        return HgCommand.doLog(file, file2, HG_LOG_TEMPLATE_SHORT_CMD, false, outputLogger);
    }

    public static List<String> doLogLong(File file, File file2, OutputLogger outputLogger) throws HgException {
        return HgCommand.doLog(file, file2, HG_LOG_TEMPLATE_LONG_CMD, false, outputLogger);
    }

    public static List<String> doLog(File file, File file2, String string, boolean bl, OutputLogger outputLogger) throws HgException {
        if (file == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_LOG_CMD);
        if (!file2.isDirectory()) {
            arrayList.add(HG_OPT_FOLLOW);
        }
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        if (bl) {
            arrayList.add(HG_LOG_DEBUG_CMD);
        }
        arrayList.add(string);
        arrayList.add(file2.getAbsolutePath());
        List<String> list = HgCommand.exec(arrayList);
        if (!list.isEmpty()) {
            if (HgCommand.isErrorNoRepository(list.get(0))) {
                HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), outputLogger);
            } else if (HgCommand.isErrorAbort(list.get(0))) {
                HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), outputLogger);
            }
        }
        return list;
    }

    public static List<String> doLog(File file, List<File> list, String string, boolean bl, OutputLogger outputLogger) throws HgException {
        File file2;
        Object object;
        if (file == null) {
            return null;
        }
        if (list != null && list.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_VERBOSE_CMD);
        arrayList.add(HG_LOG_CMD);
        boolean bl2 = true;
        if (list != null) {
            object = list.iterator();
            while (object.hasNext()) {
                file2 = object.next();
                if (!file2.isDirectory()) continue;
                bl2 = false;
                break;
            }
        }
        if (bl2) {
            arrayList.add(HG_OPT_FOLLOW);
        }
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        if (bl) {
            arrayList.add(HG_LOG_DEBUG_CMD);
        }
        if (string != null) {
            arrayList.add(string);
        }
        if (list != null) {
            object = list.iterator();
            while (object.hasNext()) {
                file2 = (File)object.next();
                arrayList.add(file2.getAbsolutePath());
            }
        }
        if (!(object = HgCommand.exec(arrayList)).isEmpty()) {
            if (HgCommand.isErrorNoRepository((String)object.get(0))) {
                HgCommand.handleError(arrayList, (List<String>)object, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), outputLogger);
            } else if (HgCommand.isErrorAbort((String)object.get(0))) {
                HgCommand.handleError(arrayList, (List<String>)object, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), outputLogger);
            }
        }
        return object;
    }

    public static List<String> doLogForHistory(File file, List<File> list, String string, String string2, String string3, boolean bl, boolean bl2, int n, OutputLogger outputLogger) throws HgException {
        Object object;
        Object object2;
        Object object3;
        if (file == null) {
            return null;
        }
        if (list != null && list.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_VERBOSE_CMD);
        arrayList.add(HG_LOG_CMD);
        if (n >= 0) {
            arrayList.add(HG_LOG_LIMIT_CMD);
            arrayList.add(Integer.toString(n));
        }
        boolean bl3 = true;
        if (list != null) {
            object3 = list.iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                if (!((File)object2).isDirectory()) continue;
                bl3 = false;
                break;
            }
        }
        if (bl3) {
            arrayList.add(HG_OPT_FOLLOW);
        }
        if (!bl) {
            arrayList.add(HG_LOG_NO_MERGES_CMD);
        }
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        if (bl2) {
            arrayList.add(HG_LOG_DEBUG_CMD);
        }
        if ((object3 = HgCommand.handleRevDates(string, string2)) != null) {
            arrayList.add(HG_FLAG_DATE_CMD);
            arrayList.add((String)object3);
        }
        object2 = HgCommand.handleRevNumbers(string, string2, string3);
        if (object3 == null && object2 != null) {
            arrayList.add(HG_FLAG_REV_CMD);
            arrayList.add((String)object2);
        }
        if (n >= 0 && object3 == null && object2 == null) {
            arrayList.add(HG_FLAG_REV_CMD);
            arrayList.add(HG_LOG_REV_TIP_RANGE);
        }
        if (bl2) {
            arrayList.add(HG_LOG_TEMPLATE_HISTORY_CMD);
        } else {
            arrayList.add(HG_LOG_TEMPLATE_HISTORY_NO_FILEINFO_CMD);
        }
        if (list != null) {
            object = list.iterator();
            while (object.hasNext()) {
                File file2 = (File)object.next();
                arrayList.add(file2.getAbsolutePath());
            }
        }
        if (!(object = HgCommand.exec(arrayList)).isEmpty()) {
            if (HgCommand.isErrorNoRepository((String)object.get(0))) {
                HgCommand.handleError(arrayList, (List<String>)object, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), outputLogger);
            } else if (HgCommand.isErrorAbort((String)object.get(0))) {
                HgCommand.handleError(arrayList, (List<String>)object, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), outputLogger);
            }
        }
        return object;
    }

    public static List<String> doOutForSearch(File file, String string, boolean bl, OutputLogger outputLogger) throws HgException {
        List<String> list;
        if (file == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_OUT_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        if (!bl) {
            arrayList.add(HG_LOG_NO_MERGES_CMD);
        }
        arrayList.add(HG_LOG_DEBUG_CMD);
        String string2 = HgCommand.handleIncomingRevNumber(string);
        if (string2 != null) {
            arrayList.add(HG_FLAG_REV_CMD);
            arrayList.add(string2);
        }
        arrayList.add(HG_LOG_TEMPLATE_HISTORY_CMD);
        String string3 = new HgConfigFiles(file).getDefaultPush(false);
        String string4 = HgCommand.getGlobalProxyIfNeeded(string3, false, null);
        if (string4 != null) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(HG_PROXY_ENV + string4);
            list = HgCommand.execEnv(arrayList, arrayList2);
        } else {
            list = HgCommand.exec(arrayList);
        }
        if (!list.isEmpty() && !HgCommand.isErrorNoDefaultPush(list.get(0))) {
            if (HgCommand.isErrorNoRepository(list.get(0))) {
                HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), outputLogger);
            } else if (HgCommand.isErrorAbort(list.get(0))) {
                HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), outputLogger);
            }
        }
        return list;
    }

    public static List<String> doIncomingForSearch(File file, String string, boolean bl, OutputLogger outputLogger) throws HgException {
        if (file == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_INCOMING_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        if (!bl) {
            arrayList.add(HG_LOG_NO_MERGES_CMD);
        }
        arrayList.add(HG_LOG_DEBUG_CMD);
        String string2 = HgCommand.handleIncomingRevNumber(string);
        if (string2 != null) {
            arrayList.add(HG_FLAG_REV_CMD);
            arrayList.add(string2);
        }
        arrayList.add(HG_LOG_TEMPLATE_HISTORY_CMD);
        List<String> list = HgCommand.exec(arrayList);
        String string3 = new HgConfigFiles(file).getDefaultPull(false);
        String string4 = HgCommand.getGlobalProxyIfNeeded(string3, false, null);
        if (string4 != null) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(HG_PROXY_ENV + string4);
            list = HgCommand.execEnv(arrayList, arrayList2);
        } else {
            list = HgCommand.exec(arrayList);
        }
        if (!list.isEmpty() && !HgCommand.isErrorNoDefaultPath(list.get(0))) {
            if (HgCommand.isErrorNoRepository(list.get(0))) {
                HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), outputLogger);
            } else if (HgCommand.isErrorAbort(list.get(0)) || HgCommand.isErrorAbort(list.get(list.size() - 1))) {
                HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), outputLogger);
            }
        }
        return list;
    }

    private static String handleRevDates(String string, String string2) {
        Date date = null;
        Date date2 = null;
        Date date3 = new Date();
        Date date4 = null;
        try {
            date4 = new SimpleDateFormat("yyyy-MM-dd").parse(HG_EPOCH_PLUS_ONE_YEAR);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        try {
            if (string != null) {
                date = new SimpleDateFormat("yyyy-MM-dd").parse(string);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        try {
            if (string2 != null) {
                date2 = new SimpleDateFormat("yyyy-MM-dd").parse(string2);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (date != null && date2 == null && string2 == null) {
            date2 = date3;
            string2 = new SimpleDateFormat("yyyy-MM-dd").format(date2);
        }
        if (date == null && string == null && date2 != null) {
            date = date4;
            string = HG_EPOCH_PLUS_ONE_YEAR;
        }
        if (date != null && date2 == null && string2 != null || date == null && string != null && date2 != null) {
            HgUtils.warningDialog(HgCommand.class, "MSG_SEARCH_HISTORY_TITLE", "MSG_SEARCH_HISTORY_WARN_BOTHDATES_NEEDED_TEXT");
            return null;
        }
        if (date != null && date2 != null) {
            if (date4 != null && date.before(date4)) {
                date = date4;
                string = HG_EPOCH_PLUS_ONE_YEAR;
            }
            if (date3 != null && date2.after(date3)) {
                date2 = date3;
                string2 = new SimpleDateFormat("yyyy-MM-dd").format(date2);
            }
            if (date.after(date2)) {
                HgUtils.warningDialog(HgCommand.class, "MSG_SEARCH_HISTORY_TITLE", "MSG_SEARCH_HISTORY_WARN_FROM_BEFORE_TODATE_NEEDED_TEXT");
                return null;
            }
            return string + " to " + string2;
        }
        return null;
    }

    private static String handleIncomingRevNumber(String string) {
        int n = -1;
        if (string != null && (string.equalsIgnoreCase("tip") || string.equalsIgnoreCase(HG_HEAD_STR))) {
            string = "tip";
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n > -1 ? string : "tip";
    }

    private static String handleRevNumbers(String string, String string2, String string3) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        if (string != null && (string.equalsIgnoreCase("tip") || string.equalsIgnoreCase(HG_HEAD_STR))) {
            string = string3;
        }
        if (string2 != null && (string2.equalsIgnoreCase("tip") || string2.equalsIgnoreCase(HG_HEAD_STR))) {
            string2 = string3;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n3 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n3 > -1 && n2 > n3) {
            string2 = string3;
            n2 = n3;
        }
        if (n3 > -1 && n > n3) {
            string = string3;
            n = n3;
        }
        String string4 = null;
        if (n > -1 && n2 > -1) {
            string4 = string + ":" + string2;
        } else if (n > -1) {
            string4 = string + (n3 != -1 ? ":" + n3 : "");
        } else if (n2 > -1) {
            string4 = "0:" + string2;
        }
        return string4;
    }

    public static void doCat(File file, File file2, File file3, OutputLogger outputLogger) throws HgException {
        HgCommand.doCat(file, file2, file3, "tip", false, outputLogger);
    }

    public static void doCat(File file, File file2, File file3, String string, OutputLogger outputLogger) throws HgException {
        HgCommand.doCat(file, file2, file3, string, true, outputLogger);
    }

    public static void doCat(File file, File file2, File file3, String string, boolean bl, OutputLogger outputLogger) throws HgException {
        String string2;
        File file4;
        if (file == null) {
            return;
        }
        if (file2 == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_CAT_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        arrayList.add(HG_FLAG_OUTPUT_CMD);
        arrayList.add(file3.getAbsolutePath());
        if (string != null) {
            arrayList.add(HG_FLAG_REV_CMD);
            arrayList.add(string);
        }
        try {
            arrayList.add(file2.getCanonicalPath());
        }
        catch (IOException iOException) {
            Mercurial.LOG.log(Level.WARNING, "command: " + HgUtils.replaceHttpPassword(arrayList));
            Mercurial.LOG.log(Level.WARNING, null, iOException);
            throw new HgException(iOException.getMessage());
        }
        List<String> list = HgCommand.exec(arrayList);
        if (!list.isEmpty()) {
            if (HgCommand.isErrorNoRepository(list.get(0))) {
                HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), outputLogger);
            } else if (HgCommand.isErrorAbort(list.get(0))) {
                HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), outputLogger);
            }
        }
        if (file3.length() == 0L && bl && (file4 = HgCommand.getPreviousName(file, file2, string2 = Integer.toString(Integer.parseInt(string) + 1))) != null) {
            HgCommand.doCat(file, file4, file3, string, false, outputLogger);
        }
    }

    public static String getCommonAncestor(String string, String string2, String string3, OutputLogger outputLogger) throws HgException {
        String string4 = HgCommand.getCommonAncestor(string, string2, string3, false, outputLogger);
        if (string4 == null) {
            string4 = HgCommand.getCommonAncestor(string, string2, string3, true, outputLogger);
        }
        return string4;
    }

    private static String getCommonAncestor(String string, String string2, String string3, boolean bl, OutputLogger outputLogger) throws HgException {
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_COMMONANCESTOR_CMD);
        if (bl) {
            arrayList.add(".hg/store/00changelog.i");
        }
        arrayList.add(string2);
        arrayList.add(string3);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(string);
        arrayList.add(HG_OPT_CWD_CMD);
        arrayList.add(string);
        List<String> list = HgCommand.exec(arrayList);
        if (!list.isEmpty()) {
            String[] stringArray = list.get(0).split(":");
            String string4 = stringArray != null && stringArray.length >= 1 ? stringArray[0] : null;
            int n = -1;
            try {
                n = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return n > -1 ? string4 : null;
        }
        return null;
    }

    public static void doCreate(File file, OutputLogger outputLogger) throws HgException {
        if (file == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_CREATE_CMD);
        arrayList.add(file.getAbsolutePath());
        List<String> list = HgCommand.exec(arrayList);
        if (!list.isEmpty()) {
            HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_CREATE_FAILED"), outputLogger);
        }
    }

    public static List<String> doClone(File file, String string, OutputLogger outputLogger) throws HgException {
        if (file == null) {
            return null;
        }
        return HgCommand.doClone(file.getAbsolutePath(), string, outputLogger);
    }

    public static List<String> doClone(String string, String string2, OutputLogger outputLogger) throws HgException {
        if (string == null || string2 == null) {
            return null;
        }
        File file = new File(string2);
        File file2 = file.getParentFile();
        try {
            if (!file2.mkdir() && !file2.isDirectory()) {
                Mercurial.LOG.log(Level.WARNING, "File.mkdir() failed for : " + file2.getAbsolutePath());
                throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_TO_CREATE_PARENT_DIR"));
            }
        }
        catch (SecurityException securityException) {
            Mercurial.LOG.log(Level.WARNING, "File.mkdir() for : " + file2.getAbsolutePath() + " threw SecurityException " + securityException.getMessage());
            throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_TO_CREATE_PARENT_DIR"));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_CLONE_CMD);
        arrayList.add(HG_VERBOSE_CMD);
        if (string.startsWith("file://")) {
            arrayList.add(string.substring(7));
        } else {
            arrayList.add(string);
        }
        arrayList.add(string2);
        List<String> list = HgCommand.exec(arrayList);
        if (!list.isEmpty()) {
            if (HgCommand.isErrorNoRepository(list.get(0))) {
                HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), outputLogger);
            } else if (HgCommand.isErrorNoResponse(list.get(list.size() - 1))) {
                HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_RESPONSE_ERR"), outputLogger);
            } else if (HgCommand.isErrorAbort(list.get(list.size() - 1))) {
                HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), outputLogger);
            }
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void doCommit(File file, List<File> list, String string, OutputLogger outputLogger) throws HgException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_COMMIT_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        arrayList.add(HG_OPT_CWD_CMD);
        arrayList.add(file.getAbsolutePath());
        String string2 = new HgConfigFiles(file).getUserName(false);
        String string3 = HgModuleConfig.getDefault().getSysUserName();
        String string4 = null;
        if (string2 != null && string2.length() > 0) {
            string4 = string2;
        } else if (string3 != null && string3.length() > 0) {
            string4 = string3;
        }
        if (string4 != null) {
            arrayList.add("--user");
            arrayList.add(string4);
        }
        File file2 = null;
        try {
            try {
                if (string == null || string.length() == 0) {
                    string = HG_COMMIT_DEFAULT_MESSAGE;
                }
                file2 = File.createTempFile(HG_COMMIT_TEMPNAME, HG_COMMIT_TEMPNAME_SUFFIX);
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
                bufferedWriter.write(string);
                bufferedWriter.close();
                arrayList.add(HG_COMMIT_OPT_LOGFILE_CMD);
                arrayList.add(file2.getAbsolutePath());
                ArrayList arrayList2 = null;
                if (Utilities.isWindows()) {
                    arrayList2 = new ArrayList(arrayList);
                }
                ArrayList<String> arrayList3 = null;
                arrayList3 = new ArrayList<String>(arrayList);
                List<String> list2 = list.iterator();
                while (list2.hasNext()) {
                    File file3 = list2.next();
                    arrayList.add(file3.getAbsolutePath().substring(file.getAbsolutePath().length() + 1));
                }
                if (Utilities.isWindows()) {
                    int n = 0;
                    for (String string5 : arrayList) {
                        n += string5.length();
                    }
                    int n2 = Short.MAX_VALUE;
                    if (n > n2) {
                        String string5;
                        string5 = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(HgCommand.class, (String)"MSG_LONG_COMMAND_QUERY"));
                        string5.setTitle(NbBundle.getMessage(HgCommand.class, (String)"MSG_LONG_COMMAND_TITLE"));
                        string5.setMessageType(2);
                        string5.setOptionType(0);
                        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)string5);
                        if (object == NotifyDescriptor.NO_OPTION) {
                            Object var17_19 = null;
                            if (string == null) return;
                            if (file2 == null) return;
                            file2.delete();
                            return;
                        }
                        arrayList = arrayList2;
                    }
                }
                if (!(list2 = HgCommand.exec(arrayList)).isEmpty() && HgCommand.isCommitAfterMerge((String)list2.get(list2.size() - 1))) {
                    list2 = HgCommand.exec(arrayList3);
                }
                if (!list2.isEmpty() && (HgCommand.isErrorNotTracked((String)list2.get(0)) || HgCommand.isErrorCannotReadCommitMsg(list2.get(0)) || HgCommand.isErrorAbort(list2.get(list2.size() - 1)) || HgCommand.isErrorAbort(list2.get(0)))) {
                    HgCommand.handleError(arrayList, list2, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMIT_FAILED"), outputLogger);
                }
            }
            catch (IOException iOException) {
                throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_FAILED_TO_READ_COMMIT_MESSAGE"));
            }
        }
        catch (Throwable throwable) {
            Object var17_21 = null;
            if (string == null) throw throwable;
            if (file2 == null) throw throwable;
            file2.delete();
            throw throwable;
        }
        Object var17_20 = null;
        if (string == null) return;
        if (file2 == null) return;
        file2.delete();
    }

    public static void doRename(File file, File file2, File file3, OutputLogger outputLogger) throws HgException {
        HgCommand.doRename(file, file2, file3, false, outputLogger);
    }

    private static void doRename(File file, File file2, File file3, boolean bl, OutputLogger outputLogger) throws HgException {
        if (file == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_RENAME_CMD);
        if (bl) {
            arrayList.add(HG_RENAME_AFTER_CMD);
        }
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        arrayList.add(HG_OPT_CWD_CMD);
        arrayList.add(file.getAbsolutePath());
        arrayList.add(file2.getAbsolutePath().substring(file.getAbsolutePath().length() + 1));
        arrayList.add(file3.getAbsolutePath().substring(file.getAbsolutePath().length() + 1));
        List<String> list = HgCommand.exec(arrayList);
        if (!(list.isEmpty() || !HgCommand.isErrorAbort(list.get(list.size() - 1)) || bl && HgCommand.isErrorAbortNoFilesToCopy(list.get(list.size() - 1)))) {
            HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_RENAME_FAILED"), outputLogger);
        }
    }

    public static void doRenameAfter(File file, File file2, File file3, OutputLogger outputLogger) throws HgException {
        HgCommand.doRename(file, file2, file3, true, outputLogger);
    }

    public static void doAdd(File file, List<File> list, OutputLogger outputLogger) throws HgException {
        if (file == null) {
            return;
        }
        if (list.size() == 0) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_ADD_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        for (File file2 : list) {
            if (file2.isDirectory()) continue;
            arrayList.add(file2.getAbsolutePath());
        }
        List<String> list2 = HgCommand.exec(arrayList);
        if (!list2.isEmpty() && HgCommand.isErrorAlreadyTracked((String)list2.get(0))) {
            HgCommand.handleError(arrayList, list2, NbBundle.getMessage(HgCommand.class, (String)"MSG_ALREADY_TRACKED"), outputLogger);
        }
    }

    public static void doRevert(File file, List<File> list, String string, boolean bl, OutputLogger outputLogger) throws HgException {
        if (file == null) {
            return;
        }
        if (list.size() == 0) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_REVERT_CMD);
        if (!bl) {
            arrayList.add(HG_REVERT_NOBACKUP_CMD);
        }
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        if (string != null) {
            arrayList.add(HG_FLAG_REV_CMD);
            arrayList.add(string);
        }
        for (File file2 : list) {
            arrayList.add(file2.getAbsolutePath());
        }
        List<String> list2 = HgCommand.exec(arrayList);
        if (!list2.isEmpty() && HgCommand.isErrorNoChangeNeeded((String)list2.get(0))) {
            HgCommand.handleError(arrayList, list2, NbBundle.getMessage(HgCommand.class, (String)"MSG_REVERT_FAILED"), outputLogger);
        }
    }

    public static void doAdd(File file, File file2, OutputLogger outputLogger) throws HgException {
        if (file == null) {
            return;
        }
        if (file2 == null) {
            return;
        }
        if (file2.isDirectory()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_ADD_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        arrayList.add(file2.getAbsolutePath());
        List<String> list = HgCommand.exec(arrayList);
        if (!list.isEmpty() && HgCommand.isErrorAlreadyTracked(list.get(0))) {
            HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_ALREADY_TRACKED"), outputLogger);
        }
    }

    public static List<String> doAnnotate(File file, File file2, String string, OutputLogger outputLogger) throws HgException {
        if (file == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_ANNOTATE_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        if (string != null) {
            arrayList.add(HG_FLAG_REV_CMD);
            arrayList.add(string);
        }
        arrayList.add(HG_ANNOTATE_FLAGN_CMD);
        arrayList.add("--user");
        arrayList.add(HG_OPT_FOLLOW);
        arrayList.add(file2.getAbsolutePath());
        List<String> list = HgCommand.exec(arrayList);
        if (!list.isEmpty()) {
            if (HgCommand.isErrorNoRepository(list.get(0))) {
                HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), outputLogger);
            } else if (HgCommand.isErrorNoSuchFile(list.get(0))) {
                String string2;
                list = string == null ? ((string2 = HgCommand.getLastRevision(file, file2)) != null ? HgCommand.doAnnotate(file, file2, string2, outputLogger) : null) : null;
            }
        }
        return list;
    }

    public static List<String> doAnnotate(File file, File file2, OutputLogger outputLogger) throws HgException {
        return HgCommand.doAnnotate(file, file2, null, outputLogger);
    }

    public static List<String> getRevisionsForFile(File file, File[] fileArray, int n) {
        if (file == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_LOG_CMD);
        if (n >= 0) {
            arrayList.add(HG_LOG_LIMIT_CMD);
            arrayList.add(Integer.toString(n));
        }
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        arrayList.add(HG_CSET_TARGET_TEMPLATE_CMD);
        if (fileArray != null) {
            for (File file2 : fileArray) {
                arrayList.add(file2.getAbsolutePath());
            }
        }
        Object object = new ArrayList();
        try {
            object = HgCommand.exec(arrayList);
        }
        catch (HgException hgException) {
            // empty catch block
        }
        return object == null || object.isEmpty() ? null : object;
    }

    public static List<String> getRevisions(File file, int n) {
        if (file == null) {
            return null;
        }
        return HgCommand.getRevisionsForFile(file, null, n);
    }

    public static String getBranchName(File file) throws HgException {
        if (file == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_BRANCH_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        List<String> list = HgCommand.exec(arrayList);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public static int getBranchRev(File file) throws HgException {
        if (file == null) {
            return -1;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add("tip");
        arrayList.add("--template={rev}\\n");
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        List<String> list = HgCommand.exec(arrayList);
        if (!list.isEmpty()) {
            return Integer.parseInt(list.get(0));
        }
        return -1;
    }

    public static String getBranchShortChangesetHash(File file) throws HgException {
        if (file == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add("tip");
        arrayList.add(HG_BRANCH_SHORT_CS_TEMPLATE_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        List<String> list = HgCommand.exec(arrayList);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public static String getBranchInfo(File file) throws HgException {
        if (file == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add("tip");
        arrayList.add(HG_BRANCH_INFO_TEMPLATE_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        List<String> list = HgCommand.exec(arrayList);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public static List<String> getHeadRevisions(File file) throws HgException {
        return HgCommand.getHeadInfo(file, "--template={rev}\\n");
    }

    public static List<String> getHeadRevisions(String string) throws HgException {
        return HgCommand.getHeadInfo(string, "--template={rev}\\n");
    }

    public static List<String> getHeadChangeSetIds(File file) throws HgException {
        return HgCommand.getHeadInfo(file, HG_CSET_TARGET_TEMPLATE_CMD);
    }

    private static List<String> getHeadInfo(String string, String string2) throws HgException {
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_HEADS_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(string);
        arrayList.add(string2);
        return HgCommand.exec(arrayList);
    }

    private static List<String> getHeadInfo(File file, String string) throws HgException {
        if (file == null) {
            return null;
        }
        return HgCommand.getHeadInfo(file.getAbsolutePath(), string);
    }

    public static String getLastRevision(File file, File file2) throws HgException {
        return HgCommand.getLastChange(file, file2, "--template={rev}\\n");
    }

    public static String getLastChangeSetId(File file, File file2) throws HgException {
        return HgCommand.getLastChange(file, file2, HG_CSET_TEMPLATE_CMD);
    }

    private static String getLastChange(File file, File file2, String string) throws HgException {
        List<String> list;
        if (file == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_LOG_CMD);
        arrayList.add(HG_LOG_LIMIT_ONE_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        arrayList.add(string);
        if (file2 != null) {
            arrayList.add(file2.getAbsolutePath());
        }
        if (!(list = HgCommand.exec(arrayList)).isEmpty()) {
            return new StringBuffer(list.get(0)).toString();
        }
        return null;
    }

    public static FileInformation getSingleStatus(File file, String string, String string2) throws HgException {
        FileInformation fileInformation = null;
        List<String> list = HgCommand.doSingleStatusCmd(file, string, string2);
        if (list == null || list.isEmpty()) {
            return new FileInformation(0, null, false);
        }
        fileInformation = HgCommand.getFileInformationFromStatusLine(list.get(0));
        if (list.size() == 2) {
            if (list.get(1).length() > 0) {
                if (list.get(1).charAt(0) == ' ') {
                    fileInformation = new FileInformation(4096, new FileStatus(new File(new File(string), string2), true), false);
                    Mercurial.LOG.log(Level.FINE, "getSingleStatus() - Copied: Locally Added {0}, Copy Source {1}", new Object[]{list.get(0), list.get(1)});
                }
            } else {
                Mercurial.LOG.log(Level.FINE, "getSingleStatus() - Second line empty: first line: {0}", list.get(0));
            }
        }
        if (HgCommand.existsConflictFile(string + File.separator + string2)) {
            fileInformation = new FileInformation(64, null, false);
            Mercurial.LOG.log(Level.FINE, "getSingleStatus(): CONFLICT StatusLine: {0} Status: {1}  {2} RepoPath:{3} cwd:{4} CONFLICT {5}", new Object[]{list.get(0), fileInformation.getStatus(), string2, file.getAbsolutePath(), string, string + File.separator + string2 + HG_STR_CONFLICT_EXT});
        }
        Mercurial.LOG.log(Level.FINE, "getSingleStatus(): StatusLine: {0} Status: {1}  {2} RepoPath:{3} cwd:{4}", new Object[]{list.get(0), fileInformation.getStatus(), string2, file.getAbsolutePath(), string});
        return fileInformation;
    }

    public static Map<File, FileInformation> getAllStatus(File file, File file2) throws HgException {
        return HgCommand.getDirStatusWithFlags(file, file2, HG_STATUS_FLAG_ALL_CMD, true);
    }

    public static Map<File, FileInformation> getAllStatus(File file) throws HgException {
        return HgCommand.getAllStatusWithFlags(file, HG_STATUS_FLAG_ALL_CMD, true);
    }

    public static Map<File, FileInformation> getAllInterestingStatus(File file) throws HgException {
        return HgCommand.getAllStatusWithFlags(file, HG_STATUS_FLAG_INTERESTING_CMD, true);
    }

    public static Map<File, FileInformation> getInterestingStatus(File file, File file2) throws HgException {
        return HgCommand.getDirStatusWithFlags(file, file2, HG_STATUS_FLAG_INTERESTING_CMD, true);
    }

    public static Map<File, FileInformation> getAllRemovedDeletedStatus(File file) throws HgException {
        return HgCommand.getAllStatusWithFlags(file, HG_STATUS_FLAG_REM_DEL_CMD, true);
    }

    public static Map<File, FileInformation> getRemovedDeletedStatus(File file, File file2) throws HgException {
        return HgCommand.getDirStatusWithFlags(file, file2, HG_STATUS_FLAG_REM_DEL_CMD, true);
    }

    public static Map<File, FileInformation> getUnknownStatus(File file, File file2) throws HgException {
        Map<File, FileInformation> map = HgCommand.getDirStatusWithFlags(file, file2, "-u", false);
        int n = SharabilityQuery.getSharability((File)(file2 == null ? file : file2));
        Iterator<File> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            File file3 = iterator.next();
            if ((n != 3 || SharabilityQuery.getSharability((File)file3) != 2) && n != 2) continue;
            iterator.remove();
        }
        return map;
    }

    public static Map<File, FileInformation> getAllUnknownStatus(File file) throws HgException {
        return HgCommand.getUnknownStatus(file, null);
    }

    public static void doRemove(File file, List<File> list, OutputLogger outputLogger) throws HgException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_REMOVE_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        arrayList.add(HG_REMOVE_FLAG_FORCE_CMD);
        for (File file2 : list) {
            arrayList.add(file2.getAbsolutePath());
        }
        List<String> list2 = HgCommand.exec(arrayList);
        if (!list2.isEmpty() && HgCommand.isErrorAlreadyTracked((String)list2.get(0))) {
            HgCommand.handleError(arrayList, list2, NbBundle.getMessage(HgCommand.class, (String)"MSG_ALREADY_TRACKED"), outputLogger);
        }
    }

    public static void doRemove(File file, File file2, OutputLogger outputLogger) throws HgException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_REMOVE_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        arrayList.add(HG_REMOVE_FLAG_FORCE_CMD);
        arrayList.add(file2.getAbsolutePath());
        List<String> list = HgCommand.exec(arrayList);
        if (!list.isEmpty() && HgCommand.isErrorAlreadyTracked(list.get(0))) {
            HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_ALREADY_TRACKED"), outputLogger);
        }
    }

    public static List<String> doExport(File file, String string, String string2, OutputLogger outputLogger) throws HgException {
        List<String> list;
        File file2 = new File(string2);
        File file3 = file2.getParentFile();
        try {
            if (!file3.mkdir() && !file3.isDirectory()) {
                Mercurial.LOG.log(Level.WARNING, "File.mkdir() failed for : " + file3.getAbsolutePath());
                throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_TO_CREATE_PARENT_DIR"));
            }
        }
        catch (SecurityException securityException) {
            Mercurial.LOG.log(Level.WARNING, "File.mkdir() for : " + file3.getAbsolutePath() + " threw SecurityException " + securityException.getMessage());
            throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_TO_CREATE_PARENT_DIR"));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_EXPORT_CMD);
        arrayList.add(HG_VERBOSE_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        arrayList.add(HG_FLAG_OUTPUT_CMD);
        arrayList.add(string2);
        if (string != null) {
            arrayList.add(string);
        }
        if (!(list = HgCommand.exec(arrayList)).isEmpty() && HgCommand.isErrorAbort(list.get(list.size() - 1))) {
            HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_EXPORT_FAILED"), outputLogger);
        }
        return list;
    }

    public static List<String> doExportFileDiff(File file, File file2, String string, String string2, OutputLogger outputLogger) throws HgException {
        File file3 = new File(string2);
        File file4 = file3.getParentFile();
        try {
            if (!file4.mkdir() && !file4.isDirectory()) {
                Mercurial.LOG.log(Level.WARNING, "File.mkdir() failed for : " + file4.getAbsolutePath());
                throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_TO_CREATE_PARENT_DIR"));
            }
        }
        catch (SecurityException securityException) {
            Mercurial.LOG.log(Level.WARNING, "File.mkdir() for : " + file4.getAbsolutePath() + " threw SecurityException " + securityException.getMessage());
            throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_TO_CREATE_PARENT_DIR"));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_LOG_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        arrayList.add(HG_REV_CMD);
        arrayList.add(string);
        arrayList.add(HG_LOG_TEMPLATE_EXPORT_FILE_CMD);
        arrayList.add(HG_LOG_PATCH_CMD);
        arrayList.add(file2.getAbsolutePath());
        List<String> list = HgCommand.exec(arrayList);
        if (!list.isEmpty() && HgCommand.isErrorAbort(list.get(list.size() - 1))) {
            HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_EXPORT_FAILED"), outputLogger);
        } else {
            HgCommand.writeOutputFileDiff(list, string2);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeOutputFileDiff(List<String> list, String string) {
        PrintWriter printWriter = null;
        try {
            try {
                printWriter = new PrintWriter(new FileWriter(string));
                for (String string2 : list) {
                    printWriter.println(string2);
                    printWriter.flush();
                }
                Object var6_6 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (IOException iOException) {
                Object var6_7 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            throw throwable;
        }
    }

    public static List<String> doImport(File file, File file2, OutputLogger outputLogger) throws HgException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_IMPORT_CMD);
        arrayList.add(HG_VERBOSE_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        arrayList.add(HG_OPT_CWD_CMD);
        arrayList.add(file.getAbsolutePath());
        arrayList.add(file2.getAbsolutePath());
        List<String> list = HgCommand.exec(arrayList);
        if (!list.isEmpty() && HgCommand.isErrorAbort(list.get(list.size() - 1))) {
            outputLogger.output(list);
            HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_IMPORT_FAILED"), outputLogger);
        }
        return list;
    }

    private static Map<File, FileInformation> getAllStatusWithFlags(File file, String string, boolean bl) throws HgException {
        return HgCommand.getDirStatusWithFlags(file, null, string, bl);
    }

    private static Map<File, FileInformation> getDirStatusWithFlags(File file, File file2, String string, boolean bl) throws HgException {
        if (file == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        FileInformation fileInformation = null;
        List<String> list = HgCommand.doRepositoryDirStatusCmd(file, file2, string);
        HashMap<File, FileInformation> hashMap = new HashMap<File, FileInformation>(list.size());
        File file3 = null;
        for (String string2 : list) {
            FileInformation fileInformation2 = HgCommand.getFileInformationFromStatusLine(string2);
            Mercurial.LOG.log(Level.FINE, "getDirStatusWithFlags(): status line {0}  info {1}", new Object[]{string2, fileInformation2});
            if (string2.length() > 0) {
                if (string2.charAt(0) == ' ') {
                    if (file3 != null) {
                        fileInformation = new FileInformation(4096, new FileStatus(file3, true), false);
                        Mercurial.LOG.log(Level.FINE, "getDirStatusWithFlags(): prev_info {0}  filePath {1}", new Object[]{fileInformation, file3});
                        continue;
                    }
                    Mercurial.LOG.log(Level.FINE, "getDirStatusWithFlags(): repository path: {0} status flags: {1} status line {2} filepath == nullfor prev_info ", new Object[]{file.getAbsolutePath(), string, string2});
                    continue;
                }
                if (file3 != null) {
                    hashMap.put(file3, fileInformation);
                }
            }
            if (bl ? fileInformation2.getStatus() == 1 || fileInformation2.getStatus() == 0 : fileInformation2.getStatus() == 0) continue;
            StringBuffer stringBuffer = new StringBuffer(string2);
            stringBuffer.delete(0, 2);
            file3 = Utilities.isWindows() && stringBuffer.toString().startsWith(file.getAbsolutePath()) ? new File(stringBuffer.toString()) : new File(file, stringBuffer.toString());
            if (HgCommand.existsConflictFile(file3.getAbsolutePath())) {
                fileInformation2 = new FileInformation(64, null, false);
                Mercurial.LOG.log(Level.FINE, "getDirStatusWithFlags(): CONFLICT repository path: {0} status flags: {1} status line {2} CONFLICT {3}", new Object[]{file.getAbsolutePath(), string, string2, file3 + HG_STR_CONFLICT_EXT});
            }
            fileInformation = fileInformation2;
        }
        if (fileInformation != null) {
            hashMap.put(file3, fileInformation);
        }
        if (list.size() < 10) {
            Mercurial.LOG.log(Level.FINE, "getDirStatusWithFlags(): repository path: {0} status flags: {1} status list {2}", new Object[]{file.getAbsolutePath(), string, list});
        } else {
            Mercurial.LOG.log(Level.FINE, "getDirStatusWithFlags(): repository path: {0} status flags: {1} status list has {2} elements", new Object[]{file.getAbsolutePath(), string, list.size()});
        }
        return hashMap;
    }

    private static FileInformation getFileInformationFromStatusLine(String string) {
        FileInformation fileInformation = null;
        if (string == null || string.length() == 0) {
            return new FileInformation(8, null, false);
        }
        char c = string.charAt(0);
        char c2 = string.charAt(1);
        switch (c + c2) {
            case 109: {
                fileInformation = new FileInformation(16, null, false);
                break;
            }
            case 97: {
                fileInformation = new FileInformation(4096, null, false);
                break;
            }
            case 114: {
                fileInformation = new FileInformation(256, null, false);
                break;
            }
            case 99: {
                fileInformation = new FileInformation(8, null, false);
                break;
            }
            case 65: {
                fileInformation = new FileInformation(2048, null, false);
                break;
            }
            case 105: {
                fileInformation = new FileInformation(2, null, false);
                break;
            }
            case 95: {
                fileInformation = new FileInformation(4, null, false);
                break;
            }
            case 120: {
                fileInformation = new FileInformation(64, null, false);
                break;
            }
            case 195: {
                fileInformation = new FileInformation(1, null, false);
                break;
            }
            default: {
                fileInformation = new FileInformation(0, null, false);
            }
        }
        return fileInformation;
    }

    private static List<String> doSingleStatusCmd(File file, String string, String string2) throws HgException {
        Object var3_3 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_STATUS_CMD);
        arrayList.add(HG_STATUS_FLAG_ALL_CMD);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        arrayList.add(HG_OPT_CWD_CMD);
        arrayList.add(file.getAbsolutePath());
        arrayList.add(new File(string, string2).getAbsolutePath().substring(file.getAbsolutePath().length() + 1));
        return HgCommand.exec(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> doRepositoryDirStatusCmd(File file, File file2, String string) throws HgException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_STATUS_CMD);
        arrayList.add(string);
        arrayList.add(HG_OPT_REPOSITORY);
        arrayList.add(file.getAbsolutePath());
        arrayList.add(HG_OPT_CWD_CMD);
        arrayList.add(file.getAbsolutePath());
        if (file2 != null) {
            arrayList.add(file2.getAbsolutePath());
        } else {
            arrayList.add(file.getAbsolutePath());
        }
        List<String> list = HgCommand.exec(arrayList);
        if (!list.isEmpty() && HgCommand.isErrorNoRepository(list.get(0))) {
            OutputLogger outputLogger = OutputLogger.getLogger(file.getAbsolutePath());
            try {
                HgCommand.handleError(arrayList, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), outputLogger);
                Object var7_6 = null;
                outputLogger.closeLog();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                outputLogger.closeLog();
                throw throwable;
            }
        }
        return list;
    }

    private static List<String> execEnv(List<String> list, List<String> list2) throws HgException {
        return HgCommand.execEnv(list, list2, true);
    }

    /*
     * Loose catch block
     */
    private static List<String> execEnv(List<String> list, List<String> list2, boolean bl) throws HgException {
        ArrayList<String> arrayList;
        block30: {
            Object object;
            if (EventQueue.isDispatchThread()) {
                Mercurial.LOG.log(Level.FINE, "WARNING execEnv():  calling Hg command in AWT Thread - could stall UI");
            }
            assert (list != null && list.size() > 0);
            if (bl) {
                Utils.logVCSClientEvent((String)"HG", (String)"CLI");
            }
            arrayList = new ArrayList<String>();
            BufferedReader bufferedReader = null;
            Process process = null;
            if (list.size() > 10) {
                object = new ArrayList<String>();
                int n = 0;
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext()) {
                    object.add(iterator.next());
                    if (n++ <= 10) continue;
                }
                Mercurial.LOG.log(Level.FINE, "execEnv(): " + object);
            } else {
                Mercurial.LOG.log(Level.FINE, "execEnv(): " + list);
            }
            if (list2 != null && list2.size() > 0) {
                object = new ProcessBuilder(list);
                Map<String, String> map = ((ProcessBuilder)object).environment();
                for (String string : list2) {
                    map.put(string.substring(0, string.indexOf(61)), string.substring(string.indexOf(61) + 1));
                }
                process = ((ProcessBuilder)object).start();
            } else {
                process = new ProcessBuilder(list).start();
            }
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((object = bufferedReader.readLine()) != null) {
                arrayList.add((String)object);
            }
            bufferedReader.close();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((object = bufferedReader.readLine()) != null) {
                arrayList.add((String)object);
            }
            bufferedReader.close();
            bufferedReader = null;
            try {
                process.waitFor();
                if (process.exitValue() == 255) {
                    Mercurial.LOG.log(Level.FINE, "execEnv():  process returned 255");
                    if (arrayList.isEmpty()) {
                        Mercurial.LOG.log(Level.SEVERE, "command: " + list);
                        throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_EXECUTE_COMMAND"));
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                Mercurial.LOG.log(Level.FINE, "execEnv():  process interrupted " + interruptedException);
            }
            Object var11_15 = null;
            if (bufferedReader == null) break block30;
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            bufferedReader = null;
            {
                break block30;
                catch (InterruptedIOException interruptedIOException) {
                    Mercurial.LOG.log(Level.FINE, "execEnv():  execEnv(): InterruptedIOException " + interruptedIOException);
                    if (process != null) {
                        try {
                            process.getInputStream().close();
                            process.getOutputStream().close();
                            process.getErrorStream().close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        process.destroy();
                    }
                    throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_CANCELLED"));
                }
                catch (IOException iOException) {
                    Mercurial.LOG.log(Level.SEVERE, "execEnv():  execEnv(): IOException " + iOException);
                    if (HgCommand.isErrorArgsTooLong(iOException.getMessage())) {
                        assert (list.size() > 2);
                        throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_ARG_LIST_TOO_LONG_ERR", (Object)list.get(1), (Object)(list.size() - 2)));
                    }
                    if (HgCommand.isErrorNoHg(iOException.getMessage()) || HgCommand.isErrorCannotRun(iOException.getMessage())) {
                        throw new HgException(NbBundle.getMessage(Mercurial.class, (String)"MSG_VERSION_NONE_MSG"));
                    }
                    throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_EXECUTE_COMMAND"));
                }
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    bufferedReader = null;
                }
                throw throwable;
            }
        }
        return arrayList;
    }

    private static List<String> exec(List<String> list) throws HgException {
        if (!Mercurial.getInstance().isGoodVersion()) {
            return new ArrayList<String>();
        }
        return HgCommand.execEnv(list, null);
    }

    private static List<String> execForVersionCheck() throws HgException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HgCommand.getHgCommand());
        arrayList.add(HG_VERSION_CMD);
        return HgCommand.execEnv(arrayList, null, false);
    }

    private static String getHgCommand() {
        String string = HgModuleConfig.getDefault().getExecutableBinaryPath();
        if (string == null || string.length() == 0) {
            return HG_COMMAND;
        }
        if (Utilities.isWindows()) {
            return string + File.separatorChar + HG_COMMAND + HG_WINDOWS_EXE;
        }
        return string + File.separatorChar + HG_COMMAND;
    }

    private static void handleError(List<String> list, List<String> list2, String string, OutputLogger outputLogger) throws HgException {
        if (list != null && list2 != null && outputLogger != null) {
            Mercurial.LOG.log(Level.WARNING, "command: " + HgUtils.replaceHttpPassword(list));
            Mercurial.LOG.log(Level.WARNING, "output: " + HgUtils.replaceHttpPassword(list2));
            outputLogger.outputInRed(NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ERR"));
            outputLogger.output(NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_INFO_ERR", HgUtils.replaceHttpPassword(list), HgUtils.replaceHttpPassword(list2)));
        }
        if (list2 != null && (HgCommand.isErrorPossibleProxyIssue(list2.get(0)) || HgCommand.isErrorPossibleProxyIssue(list2.get(list2.size() - 1)))) {
            boolean bl = HgUtils.confirmDialog(HgCommand.class, "MSG_POSSIBLE_PROXY_ISSUE_TITLE", "MSG_POSSIBLE_PROXY_ISSUE_QUERY");
            if (bl) {
                OptionsDisplayer.getDefault().open("General");
            }
        } else {
            throw new HgException(string);
        }
    }

    public static boolean isMergeNeededMsg(String string) {
        return string.indexOf(HG_MERGE_NEEDED_ERR) > -1;
    }

    public static boolean isBackoutMergeNeededMsg(String string) {
        return string.indexOf(HG_BACKOUT_MERGE_NEEDED_ERR) > -1;
    }

    public static boolean isMergeConflictMsg(String string) {
        if (Utilities.isWindows()) {
            return string.indexOf(HG_MERGE_CONFLICT_WIN1_ERR) > -1 && string.indexOf(HG_MERGE_CONFLICT_WIN2_ERR) > -1;
        }
        return string.indexOf(HG_MERGE_CONFLICT_ERR) > -1;
    }

    public static boolean isMergeUnavailableMsg(String string) {
        return string.indexOf(HG_MERGE_UNAVAILABLE_ERR) > -1;
    }

    public static boolean isMergeAbortMultipleHeadsMsg(String string) {
        return string.indexOf(HG_MERGE_MULTIPLE_HEADS_ERR) > -1;
    }

    public static boolean isMergeAbortUncommittedMsg(String string) {
        return string.indexOf(HG_MERGE_UNCOMMITTED_ERR) > -1;
    }

    public static boolean isNoChanges(String string) {
        return string.indexOf(HG_NO_CHANGES_ERR) > -1;
    }

    private static boolean isErrorNoDefaultPush(String string) {
        return string.indexOf(HG_ABORT_NO_DEFAULT_PUSH_ERR) > -1;
    }

    private static boolean isErrorNoDefaultPath(String string) {
        return string.indexOf(HG_ABORT_NO_DEFAULT_ERR) > -1;
    }

    private static boolean isErrorPossibleProxyIssue(String string) {
        return string.indexOf(HG_ABORT_POSSIBLE_PROXY_ERR) > -1;
    }

    private static boolean isErrorNoRepository(String string) {
        return string.indexOf(HG_NO_REPOSITORY_ERR) > -1 || string.indexOf(HG_NOT_REPOSITORY_ERR) > -1 || string.indexOf(HG_REPOSITORY) > -1 && string.indexOf(HG_NOT_FOUND_ERR) > -1;
    }

    private static boolean isErrorNoHg(String string) {
        return string.indexOf(HG_NO_HG_CMD_FOUND_ERR) > -1;
    }

    private static boolean isErrorArgsTooLong(String string) {
        return string.indexOf(HG_ARG_LIST_TOO_LONG_ERR) > -1;
    }

    private static boolean isErrorCannotRun(String string) {
        return string.indexOf(HG_CANNOT_RUN_ERR) > -1;
    }

    private static boolean isErrorUpdateSpansBranches(String string) {
        return string.indexOf(HG_UPDATE_SPAN_BRANCHES_ERR) > -1;
    }

    private static boolean isErrorAlreadyTracked(String string) {
        return string.indexOf(HG_ALREADY_TRACKED_ERR) > -1;
    }

    private static boolean isErrorNotTracked(String string) {
        return string.indexOf(HG_NOT_TRACKED_ERR) > -1;
    }

    private static boolean isErrorNotFound(String string) {
        return string.indexOf(HG_NOT_FOUND_ERR) > -1;
    }

    private static boolean isErrorCannotReadCommitMsg(String string) {
        return string.indexOf(HG_CANNOT_READ_COMMIT_MESSAGE_ERR) > -1;
    }

    private static boolean isErrorAbort(String string) {
        return string.indexOf(HG_ABORT_ERR) > -1;
    }

    public static boolean isErrorAbortPush(String string) {
        return string.indexOf("abort: push creates new remote ") > -1;
    }

    public static boolean isErrorAbortNoFilesToCopy(String string) {
        return string.indexOf(HG_ABORT_NO_FILES_TO_COPY_ERR) > -1;
    }

    public static boolean isCommitAfterMerge(String string) {
        return string.indexOf(HG_COMMIT_AFTER_MERGE_ERR) > -1;
    }

    private static boolean isErrorNoChangeNeeded(String string) {
        return string.indexOf(HG_NO_CHANGE_NEEDED_ERR) > -1;
    }

    public static boolean isCreateNewBranch(String string) {
        return string.indexOf("abort: push creates new remote ") > -1;
    }

    public static boolean isHeadsCreated(String string) {
        return string.indexOf(HG_HEADS_CREATED_ERR) > -1;
    }

    public static boolean isNoRollbackPossible(String string) {
        return string.indexOf("no rollback information available") > -1;
    }

    public static boolean isNoRevStrip(String string) {
        return string.indexOf(HG_NO_REV_STRIP_ERR) > -1;
    }

    public static boolean isLocalChangesStrip(String string) {
        return string.indexOf(HG_LOCAL_CHANGES_STRIP_ERR) > -1;
    }

    public static boolean isMultipleHeadsStrip(String string) {
        return string.indexOf("no rollback information available") > -1;
    }

    public static boolean isUncommittedChangesBackout(String string) {
        return string.indexOf(HG_ABORT_UNCOMMITTED_CHANGES_ERR) > -1;
    }

    public static boolean isMergeChangesetBackout(String string) {
        return string.indexOf(HG_ABORT_BACKOUT_MERGE_CSET_ERR) > -1;
    }

    public static boolean isNoUpdates(String string) {
        return string.indexOf(HG_NO_UPDATES_ERR) > -1;
    }

    private static boolean isErrorNoView(String string) {
        return string.indexOf(HG_NO_VIEW_ERR) > -1;
    }

    private static boolean isErrorHgkNotFound(String string) {
        return string.indexOf(HG_HGK_NOT_FOUND_ERR) > -1;
    }

    private static boolean isErrorNoSuchFile(String string) {
        return string.indexOf(HG_NO_SUCH_FILE_ERR) > -1;
    }

    private static boolean isErrorNoResponse(String string) {
        return string.indexOf(HG_NO_RESPONSE_ERR) > -1;
    }

    public static void createConflictFile(String string) {
        try {
            File file = new File(string + HG_STR_CONFLICT_EXT);
            boolean bl = file.createNewFile();
            Mercurial.LOG.log(Level.FINE, "createConflictFile(): File: {0} {1}", new Object[]{string + HG_STR_CONFLICT_EXT, bl ? "Created" : "Not Created"});
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void deleteConflictFile(String string) {
        boolean bl = new File(string + HG_STR_CONFLICT_EXT).delete();
        Mercurial.LOG.log(Level.FINE, "deleteConflictFile(): File: {0} {1}", new Object[]{string + HG_STR_CONFLICT_EXT, bl ? "Deleted" : "Not Deleted"});
    }

    public static boolean existsConflictFile(String string) {
        File file = new File(string + HG_STR_CONFLICT_EXT);
        boolean bl = file.canWrite();
        if (bl) {
            Mercurial.LOG.log(Level.FINE, "existsConflictFile(): File: {0} {1}", new Object[]{string + HG_STR_CONFLICT_EXT, "Exists"});
        }
        return bl;
    }

    private HgCommand() {
    }
}

