/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.status;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import javax.swing.Action;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.HgFileNode;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.diff.DiffAction;
import org.netbeans.modules.mercurial.ui.status.VersioningPanel;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class SyncFileNode
extends AbstractNode {
    private HgFileNode node;
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_PATH = "path";
    static final String COLUMN_NAME_STATUS = "status";
    static final String COLUMN_NAME_BRANCH = "branch";
    private String htmlDisplayName;
    private RequestProcessor.Task repoload;
    private final VersioningPanel panel;
    private static final String[] zeros = new String[]{"", "00", "0", ""};

    public SyncFileNode(HgFileNode hgFileNode, VersioningPanel versioningPanel) {
        this(Children.LEAF, hgFileNode, versioningPanel);
    }

    private SyncFileNode(Children children, HgFileNode hgFileNode, VersioningPanel versioningPanel) {
        super(children, Lookups.fixed((Object[])hgFileNode.getLookupObjects()));
        this.node = hgFileNode;
        this.panel = versioningPanel;
        this.initProperties();
        this.refreshHtmlDisplayName();
    }

    public File getFile() {
        return this.node.getFile();
    }

    public FileInformation getFileInformation() {
        return this.node.getInformation();
    }

    public String getName() {
        return this.node.getName();
    }

    public Action getPreferredAction() {
        if (this.node.getInformation().getStatus() == 64) {
            return null;
        }
        return new DiffAction(null, HgUtils.getCurrentContext(null));
    }

    public Node.Cookie getCookie(Class clazz) {
        FileObject fileObject = FileUtil.toFileObject((File)this.getFile());
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                if (fileObject.equals(dataObject.getPrimaryFile())) {
                    return dataObject.getCookie(clazz);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return super.getCookie(clazz);
    }

    private void initProperties() {
        if (this.node.getFile().isDirectory()) {
            this.setIconBaseWithExtension("org/openide/loaders/defaultFolder.gif");
        }
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new NameProperty());
        set.put((Node.Property)new PathProperty());
        set.put((Node.Property)new StatusProperty());
        set.put((Node.Property)new BranchProperty());
        sheet.put(set);
        this.setSheet(sheet);
    }

    private void refreshHtmlDisplayName() {
        FileInformation fileInformation = this.node.getInformation();
        int n = fileInformation.getStatus();
        if (n == 128) {
            n = 64;
        }
        this.htmlDisplayName = Mercurial.getInstance().getMercurialAnnotator().annotateNameHtml(this.node.getFile().getName(), fileInformation, null);
        this.fireDisplayNameChange(this.node.getName(), this.node.getName());
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public void refresh() {
        this.refreshHtmlDisplayName();
    }

    public void destroy() throws IOException {
        super.destroy();
        if (this.repoload != null) {
            this.repoload.cancel();
        }
    }

    private class StatusProperty
    extends SyncFileProperty {
        public StatusProperty() {
            super(SyncFileNode.COLUMN_NAME_STATUS, String.class, NbBundle.getMessage(SyncFileNode.class, (String)"BK2007"), NbBundle.getMessage(SyncFileNode.class, (String)"BK2008"));
            String string = HgUtils.getRelativePath(SyncFileNode.this.node.getFile());
            String string2 = Integer.toString(HgUtils.getComparableStatus(SyncFileNode.this.node.getInformation().getStatus()));
            this.setValue("sortkey", zeros[string2.length()] + string2 + "\t" + string + "\t" + SyncFileNode.this.getName());
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            FileInformation fileInformation = SyncFileNode.this.node.getInformation();
            int n = SyncFileNode.this.panel.getDisplayStatuses();
            return fileInformation.getStatusText(n);
        }
    }

    private class NameProperty
    extends SyncFileProperty {
        public NameProperty() {
            super(SyncFileNode.COLUMN_NAME_NAME, String.class, NbBundle.getMessage(SyncFileNode.class, (String)"BK2005"), NbBundle.getMessage(SyncFileNode.class, (String)"BK2006"));
            this.setValue("sortkey", SyncFileNode.this.getName());
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return SyncFileNode.this.getDisplayName();
        }
    }

    private class PathProperty
    extends SyncFileProperty {
        private String shortPath;

        public PathProperty() {
            super(SyncFileNode.COLUMN_NAME_PATH, String.class, NbBundle.getMessage(SyncFileNode.class, (String)"BK2003"), NbBundle.getMessage(SyncFileNode.class, (String)"BK2004"));
            this.shortPath = HgUtils.getRelativePath(SyncFileNode.this.node.getFile());
            this.setValue("sortkey", this.shortPath + "\t" + SyncFileNode.this.getName());
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.shortPath;
        }
    }

    private class BranchProperty
    extends SyncFileProperty {
        public BranchProperty() {
            super(SyncFileNode.COLUMN_NAME_BRANCH, String.class, NbBundle.getMessage(SyncFileNode.class, (String)"BK2001"), NbBundle.getMessage(SyncFileNode.class, (String)"BK2002"));
        }

        public Object getValue() {
            String string = SyncFileNode.this.panel.getDisplayBranchInfo();
            return string == null ? "" : string;
        }
    }

    private abstract class SyncFileProperty
    extends PropertySupport.ReadOnly {
        protected SyncFileProperty(String string, Class clazz, String string2, String string3) {
            super(string, clazz, string2, string3);
        }

        public String toString() {
            try {
                return this.getValue().toString();
            }
            catch (Exception exception) {
                Mercurial.LOG.log(Level.INFO, null, exception);
                return exception.getLocalizedMessage();
            }
        }
    }
}

