/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.rollback;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.JOptionPane;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.rollback.StripAction;
import org.netbeans.modules.mercurial.ui.update.ConflictResolvedAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RollbackAction
extends ContextAction {
    private final VCSContext context;

    public RollbackAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public void performAction(ActionEvent actionEvent) {
        RollbackAction.rollback(this.context);
    }

    public static void rollback(final VCSContext vCSContext) {
        final File file = HgUtils.getRootFile(vCSContext);
        if (file == null) {
            return;
        }
        String string = file.getAbsolutePath();
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(string);
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void perform() {
                OutputLogger outputLogger;
                block10: {
                    outputLogger = this.getLogger();
                    try {
                        try {
                            block12: {
                                block13: {
                                    List<String> list;
                                    Object object;
                                    NotifyDescriptor.Confirmation confirmation;
                                    block11: {
                                        outputLogger.outputInRed(NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_TITLE"));
                                        outputLogger.outputInRed(NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_TITLE_SEP"));
                                        outputLogger.output(NbBundle.getMessage(StripAction.class, (String)"MSG_ROLLBACK_INFO_SEP", (Object)file.getAbsolutePath()));
                                        confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_CONFIRM_QUERY"));
                                        confirmation.setTitle(NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_CONFIRM"));
                                        confirmation.setMessageType(2);
                                        confirmation.setOptionType(0);
                                        object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                                        if (object == NotifyDescriptor.NO_OPTION) {
                                            outputLogger.outputInRed(NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_CANCELED", (Object)file.getAbsolutePath()));
                                            Object var7_6 = null;
                                            outputLogger.outputInRed(NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_DONE"));
                                            outputLogger.output("");
                                            return;
                                        }
                                        list = HgCommand.doRollback(file, outputLogger);
                                        if (list == null || list.isEmpty()) break block10;
                                        if (!HgCommand.isNoRollbackPossible(list.get(0))) break block11;
                                        outputLogger.output(NbBundle.getMessage(RollbackAction.class, (String)"MSG_NO_ROLLBACK"));
                                        break block12;
                                    }
                                    outputLogger.output(list.get(0));
                                    if (!HgCommand.hasHistory(file).booleanValue()) break block13;
                                    confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_CONFIRM_UPDATE_QUERY"));
                                    confirmation.setTitle(NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_CONFIRM"));
                                    confirmation.setMessageType(2);
                                    confirmation.setOptionType(0);
                                    object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                                    if (object == NotifyDescriptor.YES_OPTION) {
                                        outputLogger.output(NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_FORCE_UPDATE", (Object)file.getAbsolutePath()));
                                        list = HgCommand.doUpdateAll(file, true, null);
                                        FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
                                        if (fileStatusCache.listFiles(vCSContext, 64).length != 0) {
                                            ConflictResolvedAction.resolved(vCSContext);
                                        }
                                        HgUtils.forceStatusRefreshProject(vCSContext);
                                        Mercurial.getInstance().changesetChanged(file);
                                        if (list != null && !list.isEmpty()) {
                                            outputLogger.output(list);
                                        }
                                        break block12;
                                    } else {
                                        HgUtils.forceStatusRefreshProject(vCSContext);
                                        Mercurial.getInstance().changesetChanged(file);
                                    }
                                    break block12;
                                }
                                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_MESSAGE_NOHISTORY"), NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_MESSAGE"), 1, null);
                            }
                            outputLogger.outputInRed(NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_INFO"));
                        }
                        catch (HgException hgException) {
                            NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                            Object var7_8 = null;
                            outputLogger.outputInRed(NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_DONE"));
                            outputLogger.output("");
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        outputLogger.outputInRed(NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_DONE"));
                        outputLogger.output("");
                        throw throwable;
                    }
                }
                Object var7_7 = null;
                outputLogger.outputInRed(NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_DONE"));
                outputLogger.output("");
            }
        };
        hgProgressSupport.start(requestProcessor, string, NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_PROGRESS"));
    }

    public boolean isEnabled() {
        return HgUtils.getRootFile(this.context) != null;
    }
}

