/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.spi;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ServerCommand {
    public abstract String getCommand();

    public String getRequestMethod() {
        return "GET";
    }

    public boolean getDoOutput() {
        return false;
    }

    public String getContentType() {
        return null;
    }

    public InputStream getInputStream() {
        return null;
    }

    public boolean handleResponse(int n) {
        return n == 200;
    }

    public boolean readResponse(InputStream inputStream) throws IOException {
        boolean bl = false;
        Manifest manifest = new Manifest();
        manifest.read(inputStream);
        String string = manifest.getMainAttributes().getValue("exit-code");
        if (string.equalsIgnoreCase("Success")) {
            this.readManifest(manifest);
            bl = true;
        } else {
            String string2 = manifest.getMainAttributes().getValue("message");
            Logger.getLogger("glassfish").log(Level.WARNING, string2);
        }
        return bl;
    }

    public void readManifest(Manifest manifest) throws IOException {
    }

    public boolean processResponse() {
        return true;
    }

    public String toString() {
        return this.getCommand();
    }

    public static final class SetPropertyCommand
    extends ServerCommand {
        private final String property;
        private final String value;
        private Manifest info;

        public SetPropertyCommand(String string, String string2) {
            this.property = string;
            this.value = string2;
        }

        public String getCommand() {
            return "set?target=" + this.property + "?value=" + this.value;
        }

        public void readManifest(Manifest manifest) throws IOException {
            this.info = manifest;
        }

        public boolean processResponse() {
            return this.info != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class GetPropertyCommand
    extends ServerCommand {
        private final String property;
        private Manifest info;

        public GetPropertyCommand(String string) {
            this.property = string;
        }

        @Override
        public String getCommand() {
            return "get?pattern=" + this.property;
        }

        @Override
        public void readManifest(Manifest manifest) throws IOException {
            this.info = manifest;
        }

        @Override
        public boolean processResponse() {
            return this.info != null;
        }

        public Map<String, String> getData() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (null != this.info) {
                for (String string : this.info.getEntries().keySet()) {
                    String[] stringArray = string.split("=");
                    if (stringArray.length != 2) continue;
                    hashMap.put(stringArray[0], stringArray[1]);
                }
            }
            return hashMap;
        }
    }
}

