/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.JTextComponent;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasePanel
extends JPanel {
    protected abstract String getPrefix();

    protected abstract List<Component> getDataComponents();

    public void initializeData(String string, Map<String, String> map) {
        for (Component component : this.getDataComponents()) {
            JComponent jComponent;
            String string2 = component.getName();
            if (string2 == null) continue;
            String string3 = this.getPrefix() + string + "." + string2;
            String string4 = map.get(string3);
            if (null == string4) {
                string4 = NbBundle.getMessage(this.getClass(), (String)"ERR_DATA_NOT_FOUND", (Object)string3);
            } else {
                component.setName(string3);
            }
            if (component instanceof JTextComponent) {
                jComponent = (JTextComponent)component;
                SwingUtilities.invokeLater(new TextFieldSetter((JTextComponent)jComponent, string4));
                continue;
            }
            if (component instanceof AbstractButton) {
                jComponent = (AbstractButton)component;
                SwingUtilities.invokeLater(new ButtonSetter((AbstractButton)jComponent, string4));
                continue;
            }
            if (!(component instanceof JTable)) continue;
            jComponent = (JTable)component;
            SwingUtilities.invokeLater(new TableSetter(string2, (JTable)jComponent, map));
        }
    }

    public Map<String, String> getData() {
        HashMap<String, String> hashMap = new HashMap<String, String>(this.getDataComponents().size());
        for (Component component : this.getDataComponents()) {
            JComponent jComponent;
            String string = component.getName();
            if (string == null) continue;
            String string2 = string;
            if (component instanceof JTextComponent) {
                jComponent = (JTextComponent)component;
                hashMap.put(string2, ((JTextComponent)jComponent).getText());
                continue;
            }
            if (component instanceof AbstractButton) {
                jComponent = (AbstractButton)component;
                hashMap.put(string2, Boolean.toString(((AbstractButton)jComponent).isSelected()));
                continue;
            }
            if (!(component instanceof JTable)) continue;
            jComponent = (JTable)component;
            MyTableModel myTableModel = (MyTableModel)((JTable)jComponent).getModel();
            hashMap.putAll(myTableModel.getData());
        }
        return hashMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Error
    extends BasePanel {
        @Override
        protected String getPrefix() {
            return "";
        }

        @Override
        protected List<Component> getDataComponents() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public void initializeData(String string, Map<String, String> map) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MyTableModel
    extends AbstractTableModel {
        private String[][] rowData;
        private String pushPrefix;
        private String[] names;
        private String[] specComp;

        MyTableModel(String[][] stringArray, String[] stringArray2, String string) {
            this.rowData = stringArray;
            this.specComp = stringArray2;
            this.pushPrefix = string;
            if (stringArray.length > 0) {
                int n = stringArray[0].length;
                this.names = new String[n];
                for (int i = 0; i < n; ++i) {
                    try {
                        this.names[i] = NbBundle.getMessage(this.getClass(), (String)("column-title." + stringArray2[0] + "." + stringArray2[i + 1]));
                        continue;
                    }
                    catch (MissingResourceException missingResourceException) {
                        this.names[i] = stringArray2[i + 1];
                    }
                }
            }
        }

        @Override
        public int getRowCount() {
            return this.rowData.length;
        }

        @Override
        public int getColumnCount() {
            return this.rowData[0].length;
        }

        @Override
        public String getColumnName(int n) {
            if (n > -1 && n < this.getColumnCount()) {
                return this.names[n];
            }
            return "";
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.rowData[n][n2];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            super.setValueAt(object, n, n2);
            this.rowData[n][n2] = (String)object;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        public String getPushPrefix() {
            return this.pushPrefix;
        }

        public Map<String, String> getData() {
            HashMap<String, String> hashMap = new HashMap<String, String>(this.getRowCount() * (this.getColumnCount() - 1));
            for (int i = 0; i < this.getRowCount(); ++i) {
                String string = this.pushPrefix + this.specComp[0] + "." + this.getValueAt(i, 0) + ".";
                for (int j = 1; j < this.getColumnCount(); ++j) {
                    string = string + this.specComp[j + 1];
                    hashMap.put(string, (String)this.getValueAt(i, j));
                }
            }
            return hashMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TableSetter
    implements Runnable {
        private JTable tab;
        private Map<String, String> data;
        private String spec;

        TableSetter(String string, JTable jTable, Map<String, String> map) {
            this.tab = jTable;
            this.data = map;
            this.spec = string;
        }

        @Override
        public void run() {
            String[] stringArray = this.spec.split("\\.");
            int n = stringArray.length - 1;
            if (0 >= n) {
                return;
            }
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            String string = ".*\\." + stringArray[0] + "\\..*\\." + stringArray[1];
            Set<String> set = this.data.keySet();
            String string2 = null;
            for (String string3 : set) {
                if (!string3.matches(string)) continue;
                if (null == string2) {
                    int n2 = string3.lastIndexOf(stringArray[0]);
                    string2 = string3.substring(0, n2);
                }
                String[] stringArray2 = new String[n];
                int n3 = string3.lastIndexOf(".");
                String string4 = string3.substring(0, n3);
                stringArray2[0] = this.data.get(string3);
                for (int i = 2; i < n + 1; ++i) {
                    stringArray2[i - 1] = this.data.get(string4 + "." + stringArray[i]);
                    if (null != stringArray2[i - 1]) continue;
                    stringArray2[i - 1] = "";
                }
                arrayList.add(stringArray2);
            }
            this.tab.setModel(new MyTableModel((String[][])arrayList.toArray((T[])new String[arrayList.size()][]), stringArray, string2));
        }
    }

    static class ButtonSetter
    implements Runnable {
        private AbstractButton button;
        private String value;

        ButtonSetter(AbstractButton abstractButton, String string) {
            this.button = abstractButton;
            this.value = string;
        }

        public void run() {
            this.button.setSelected(Boolean.parseBoolean(this.value));
        }
    }

    static class TextFieldSetter
    implements Runnable {
        private JTextComponent jtc;
        private String value;

        TextFieldSetter(JTextComponent jTextComponent, String string) {
            this.jtc = jTextComponent;
            this.value = string;
        }

        public void run() {
            this.jtc.setText(this.value);
        }
    }
}

