/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.glassfish.common.BasicTask;
import org.netbeans.modules.glassfish.common.CommonServerSupport;
import org.netbeans.modules.glassfish.common.LogViewMgr;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.glassfish.spi.TreeParser;
import org.openide.ErrorManager;
import org.openide.execution.NbProcessDescriptor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartTask
extends BasicTask<GlassfishModule.OperationState> {
    public StartTask(Map<String, String> map, OperationStateListener ... operationStateListenerArray) {
        super(map, operationStateListenerArray);
    }

    @Override
    public GlassfishModule.OperationState call() {
        Logger.getLogger("glassfish").log(Level.FINEST, "StartTask.call() called on thread \"" + Thread.currentThread().getName() + "\"");
        long l = System.currentTimeMillis();
        String string = null;
        int n = 0;
        string = (String)this.ip.get("host");
        if (string == null || string.length() == 0) {
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_NOHOST", this.instanceName);
        }
        try {
            n = Integer.valueOf((String)this.ip.get("httpportnumber"));
            if (n < 0 || n > 65535) {
                return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_BADPORT", this.instanceName);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_BADPORT", this.instanceName);
        }
        Process process = this.createProcess();
        if (process == null) {
            return GlassfishModule.OperationState.FAILED;
        }
        this.fireOperationStateChanged(GlassfishModule.OperationState.RUNNING, "MSG_START_SERVER_IN_PROGRESS", this.instanceName);
        LogViewMgr logViewMgr = LogViewMgr.getInstance((String)this.ip.get("url"));
        logViewMgr.readInputStreams(process.getInputStream(), process.getErrorStream());
        while (System.currentTimeMillis() - l < 120000L) {
            if (CommonServerSupport.isRunning(string, n)) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.fireOperationStateChanged(GlassfishModule.OperationState.COMPLETED, "MSG_SERVER_STARTED", this.instanceName);
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Logger.getLogger("glassfish").log(Level.FINE, "V3 Failed to start, killing process: " + process);
        process.destroy();
        this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED", this.instanceName);
        return GlassfishModule.OperationState.FAILED;
    }

    private String[] createEnvironment() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getJdkHome();
        if (string != null) {
            String string2 = "JAVA_HOME=" + string;
            arrayList.add(string2);
            Logger.getLogger("glassfish").log(Level.FINE, "V3 Environment: " + string2);
        } else {
            Logger.getLogger("glassfish").log(Level.WARNING, "Unable to set JAVA_HOME for GlassFish V3 enviroment.");
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String getJdkHome() {
        String string = null;
        String string2 = System.getProperty("jdk.home");
        if (string2 == null || string2.length() == 0) {
            String string3 = System.getProperty("java.home");
            if (string3.endsWith(File.separatorChar + "jre")) {
                string = string3.substring(string3.length() - 4);
            }
        } else {
            string = string2;
        }
        return string;
    }

    private NbProcessDescriptor createProcessDescriptor() {
        String string = System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar + "java";
        String string2 = (String)this.ip.get("homefolder");
        File file = ServerUtilities.getJarName(string2, "glassfish-10.0");
        if (file == null) {
            this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_FNF", new String[0]);
            return null;
        }
        String string3 = file.getAbsolutePath();
        ArrayList<String> arrayList = new ArrayList<String>(10);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.readJvmArgs(this.getDomainFolder(), arrayList, hashMap);
        StringBuilder stringBuilder = new StringBuilder(1024);
        this.appendSystemVars(hashMap, stringBuilder);
        this.appendJavaOpts(arrayList, stringBuilder);
        stringBuilder.append(" -client -jar ");
        stringBuilder.append(StartTask.quote(string3));
        stringBuilder.append(" --domain " + this.getDomainName());
        stringBuilder.append(" --domaindir " + StartTask.quote(this.getDomainFolder().getAbsolutePath()));
        String string4 = stringBuilder.toString();
        Logger.getLogger("glassfish").log(Level.FINE, "V3 JVM Command: " + string + string4);
        return new NbProcessDescriptor(string, string4);
    }

    private static final String quote(String string) {
        return string.indexOf(32) == -1 ? string : "\"" + string + "\"";
    }

    private StringBuilder appendJavaOpts(List<String> list, StringBuilder stringBuilder) {
        for (String string : list) {
            stringBuilder.append(' ');
            stringBuilder.append(string);
        }
        if ("debugMode".equals(this.ip.get("jvmMode"))) {
            stringBuilder.append(" -Xdebug -Xrunjdwp:transport=dt_socket,address=");
            stringBuilder.append((String)this.ip.get("debugPort"));
            stringBuilder.append(",server=y,suspend=n");
        }
        return stringBuilder;
    }

    private StringBuilder appendSystemVars(Map<String, String> map, StringBuilder stringBuilder) {
        this.appendSystemVar(stringBuilder, "jruby.home", (String)this.ip.get("jruby.home"));
        this.appendSystemVar(stringBuilder, "v3.grizzly.cometSupport", (String)this.ip.get("v3.grizzly.cometSupport"));
        map.remove("jruby.home");
        map.remove("v3.grizzly.cometSupport");
        if (!"false".equals(System.getProperty("glassfish.use.jvm.config"))) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.appendSystemVar(stringBuilder, entry.getKey(), entry.getValue());
            }
        }
        return stringBuilder;
    }

    private StringBuilder appendSystemVar(StringBuilder stringBuilder, String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append(" -D");
            stringBuilder.append(string);
            stringBuilder.append("=");
            stringBuilder.append(StartTask.quote(string2));
        }
        return stringBuilder;
    }

    private Process createProcess() {
        Process process = null;
        NbProcessDescriptor nbProcessDescriptor = this.createProcessDescriptor();
        if (nbProcessDescriptor != null) {
            try {
                process = nbProcessDescriptor.exec(null, this.createEnvironment(), true, new File((String)this.ip.get("homefolder")));
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_PD", new String[0]);
            }
        }
        return process;
    }

    private File getDomainFolder() {
        return new File((String)this.ip.get("domainsfolder") + File.separatorChar + this.getDomainName());
    }

    private final String getDomainName() {
        return (String)this.ip.get("domainname");
    }

    private void readJvmArgs(File file, List<String> list, Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("com.sun.aas.installRoot", StartTask.fixPath((String)this.ip.get("homefolder")));
        hashMap.put("com.sun.aas.instanceRoot", StartTask.fixPath(file.getAbsolutePath()));
        hashMap.put("com.sun.aas.javaRoot", StartTask.fixPath(System.getProperty("java.home")));
        hashMap.put("com.sun.aas.derbyRoot", StartTask.fixPath((String)this.ip.get("installfolder") + File.separatorChar + "javadb"));
        File file2 = new File(file, "config/domain.xml");
        JvmConfigReader jvmConfigReader = new JvmConfigReader(list, map, hashMap);
        ArrayList<TreeParser.Path> arrayList = new ArrayList<TreeParser.Path>();
        arrayList.add(new TreeParser.Path("/domain/servers/server", jvmConfigReader.getServerFinder()));
        arrayList.add(new TreeParser.Path("/domain/configs/config", jvmConfigReader.getConfigFinder()));
        arrayList.add(new TreeParser.Path("/domain/configs/config/java-config", jvmConfigReader));
        try {
            TreeParser.readXml(file2, arrayList);
        }
        catch (IllegalStateException illegalStateException) {
            Logger.getLogger("glassfish").log(Level.WARNING, illegalStateException.getLocalizedMessage(), illegalStateException);
        }
    }

    private static final String fixPath(String string) {
        return string.replace("\\", "\\\\").replace("$", "\\$");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JvmConfigReader
    extends TreeParser.NodeReader {
        private final Map<String, String> argMap;
        private final Map<String, String> varMap;
        private final List<String> optList;
        private final String serverName = "server";
        private String serverConfigName;
        private boolean readJvmConfig = false;
        private Pattern pattern = Pattern.compile("\\$\\{([^}]+)\\}");

        public JvmConfigReader(List<String> list, Map<String, String> map, Map<String, String> map2) {
            this.optList = list;
            this.argMap = map;
            this.varMap = map2;
        }

        public TreeParser.NodeReader getServerFinder() {
            return new TreeParser.NodeReader(){

                public void readAttributes(String string, Attributes attributes) throws SAXException {
                    if ((JvmConfigReader.this.serverConfigName == null || JvmConfigReader.this.serverConfigName.length() == 0) && "server".equals(attributes.getValue("name"))) {
                        JvmConfigReader.this.serverConfigName = attributes.getValue("config-ref");
                        Logger.getLogger("glassfish").finer("DOMAIN.XML: Server profile defined by " + JvmConfigReader.this.serverConfigName);
                    }
                }
            };
        }

        public TreeParser.NodeReader getConfigFinder() {
            return new TreeParser.NodeReader(){

                public void readAttributes(String string, Attributes attributes) throws SAXException {
                    if (JvmConfigReader.this.serverConfigName != null && JvmConfigReader.this.serverConfigName.equals(attributes.getValue("name"))) {
                        JvmConfigReader.this.readJvmConfig = true;
                        Logger.getLogger("glassfish").finer("DOMAIN.XML: Reading JVM options from server profile " + JvmConfigReader.this.serverConfigName);
                    }
                }

                public void endNode(String string) throws SAXException {
                    JvmConfigReader.this.readJvmConfig = false;
                }
            };
        }

        @Override
        public void readCData(String string, char[] cArray, int n, int n2) throws SAXException {
            if (this.readJvmConfig) {
                String string2 = new String(cArray, n, n2);
                if (string2.startsWith("-D")) {
                    int n3 = string2.indexOf(61);
                    if (n3 != -1) {
                        String string3 = string2.substring(2, n3);
                        String string4 = this.doSub(string2.substring(n3 + 1));
                        if (string3.length() > 0) {
                            Logger.getLogger("glassfish").finer("DOMAIN.XML: argument name = " + string3 + ", value = " + string4);
                            this.argMap.put(string3, string4);
                        }
                    }
                } else if (string2.startsWith("-X")) {
                    int n4 = (string2 = this.doSub(string2)).indexOf(61);
                    if (n4 != -1) {
                        String string5 = string2.substring(0, n4);
                        String string6 = string2.substring(n4 + 1);
                        Logger.getLogger("glassfish").finer("DOMAIN.XML: jvm option: " + string5 + " = " + string6);
                        this.optList.add(string5 + '=' + StartTask.quote(string6));
                    } else {
                        Logger.getLogger("glassfish").finer("DOMAIN.XML: jvm option: " + string2);
                        this.optList.add(string2);
                    }
                }
            }
        }

        private String doSub(String string) {
            try {
                Matcher matcher = this.pattern.matcher(string);
                boolean bl = matcher.find();
                if (bl) {
                    StringBuffer stringBuffer = new StringBuffer();
                    do {
                        String string2;
                        String string3;
                        if ((string3 = this.varMap.get(string2 = matcher.group(1))) == null) {
                            string3 = System.getProperty(string2);
                            string3 = string3 != null ? StartTask.fixPath(string3) : "\\$\\{" + string2 + "\\}";
                        }
                        matcher.appendReplacement(stringBuffer, string3);
                    } while (bl = matcher.find());
                    matcher.appendTail(stringBuffer);
                    string = stringBuffer.toString();
                }
            }
            catch (Exception exception) {
                Logger.getLogger("glassfish").log(Level.INFO, exception.getLocalizedMessage(), exception);
            }
            return string;
        }
    }
}

