/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class SimpleIO {
    private static final int DELAY = 1000;
    private final String name;
    private final InputOutput io;
    private final CancelAction cancelAction;
    private final AtomicReference<Process> process;

    public SimpleIO(String string, Process process) {
        this.name = string;
        this.process = new AtomicReference<Process>(process);
        this.cancelAction = new CancelAction();
        this.io = IOProvider.getDefault().getIO(string, new Action[]{this.cancelAction});
        this.io.select();
    }

    public void readInputStreams(InputStream ... inputStreamArray) {
        RequestProcessor requestProcessor = RequestProcessor.getDefault();
        for (InputStream inputStream : inputStreamArray) {
            requestProcessor.post((Runnable)new IOReader(inputStream));
        }
    }

    public synchronized void write(String string) {
        this.io.getOut().print(string);
    }

    public synchronized void selectIO() {
        this.io.select();
    }

    public synchronized void closeIO() {
        this.process.set(null);
        this.cancelAction.updateEnabled();
    }

    public class CancelAction
    extends AbstractAction {
        private static final String PROP_ENABLED = "enabled";
        private static final String ICON = "org/netbeans/modules/glassfish/common/resources/stop.png";

        public CancelAction() {
            super(NbBundle.getMessage(SimpleIO.class, (String)"CTL_Cancel"), new ImageIcon(Utilities.loadImage((String)ICON)));
            this.putValue("ShortDescription", NbBundle.getMessage(SimpleIO.class, (String)"LBL_CancelDesc"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SimpleIO.this.process.get() != null) {
                String string = NbBundle.getMessage(SimpleIO.class, (String)"MSG_QueryCancel", (Object)SimpleIO.this.name);
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 0, 3);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.YES_OPTION) {
                    Process process = SimpleIO.this.process.getAndSet(null);
                    if (process != null) {
                        process.destroy();
                    } else {
                        Logger.getLogger("glassfish").log(Level.FINEST, "Process handle unexpectedly null, cancel aborted.");
                    }
                }
            }
        }

        public boolean isEnabled() {
            return SimpleIO.this.process.get() != null;
        }

        public void updateEnabled() {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    CancelAction.this.firePropertyChange(CancelAction.PROP_ENABLED, null, CancelAction.this.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
                }
            });
        }
    }

    private class IOReader
    implements Runnable {
        private InputStream inputStream;

        public IOReader(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String string = Thread.currentThread().getName();
            try {
                Thread.currentThread().setName(this.getClass().getName() + " - " + this.inputStream);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.inputStream));
                char[] cArray = new char[1024];
                int n = 0;
                while (n != -1) {
                    while ((n = bufferedReader.read(cArray)) != -1) {
                        SimpleIO.this.write(new String(cArray, 0, n));
                        SimpleIO.this.selectIO();
                        if (((Reader)bufferedReader).ready()) continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("glassfish").log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            }
            finally {
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger("glassfish").log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                }
                Thread.currentThread().setName(string);
            }
        }
    }
}

