/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.spi.AppDesc;
import org.netbeans.modules.glassfish.spi.ResourceDesc;
import org.netbeans.modules.glassfish.spi.ServerCommand;

public class Commands {
    public static final ServerCommand START = new ServerCommand(){

        public String getCommand() {
            return "start-domain";
        }
    };
    public static final ServerCommand STOP = new ServerCommand(){

        public String getCommand() {
            return "stop-domain";
        }
    };

    public static final class LocationCommand
    extends ServerCommand {
        private Manifest info;
        private String installRoot;
        private String domainRoot;

        public String getInstallRoot() {
            return this.installRoot;
        }

        public String getDomainRoot() {
            return this.domainRoot;
        }

        public String getCommand() {
            return "__locations";
        }

        public void readManifest(Manifest manifest) throws IOException {
            this.info = manifest;
        }

        public boolean processResponse() {
            if (this.info == null) {
                return false;
            }
            Attributes attributes = this.info.getMainAttributes();
            if (attributes != null) {
                this.installRoot = attributes.getValue("Base-Root_value");
                this.domainRoot = attributes.getValue("Domain-Root_value");
            }
            return true;
        }
    }

    public static final class VersionCommand
    extends ServerCommand {
        private Manifest info;

        public String getCommand() {
            return "version";
        }

        public void readManifest(Manifest manifest) throws IOException {
            this.info = manifest;
        }

        public boolean processResponse() {
            return true;
        }
    }

    public static final class UnregisterCommand
    extends ServerCommand {
        private final String name;
        private final String resourceCmdSuffix;
        private final String cmdPropertyName;
        private final boolean cascade;

        public UnregisterCommand(String string, String string2, String string3, boolean bl) {
            this.name = string;
            this.resourceCmdSuffix = string2;
            this.cmdPropertyName = string3;
            this.cascade = bl;
        }

        public String getCommand() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("delete-");
            stringBuilder.append(this.resourceCmdSuffix);
            if (this.cascade) {
                stringBuilder.append("?cascade=true");
            }
            stringBuilder.append('?');
            stringBuilder.append(this.cmdPropertyName);
            stringBuilder.append('=');
            stringBuilder.append(this.name);
            return stringBuilder.toString();
        }
    }

    public static final class UndeployCommand
    extends ServerCommand {
        private final String name;

        public UndeployCommand(String string) {
            this.name = string;
        }

        public String getCommand() {
            return "undeploy?name=" + this.name;
        }
    }

    public static final class RedeployCommand
    extends ServerCommand {
        private final String name;
        private final String contextRoot;

        public RedeployCommand(String string, String string2) {
            this.name = string;
            this.contextRoot = string2;
        }

        public String getCommand() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("redeploy?name=");
            stringBuilder.append(this.name);
            if (this.contextRoot != null && this.contextRoot.length() > 0) {
                stringBuilder.append("?contextroot=");
                stringBuilder.append(this.contextRoot);
            }
            return stringBuilder.toString();
        }
    }

    public static final class DeployCommand
    extends ServerCommand {
        private final String path;
        private final String name;
        private final String contextRoot;

        public DeployCommand(String string, String string2, String string3) {
            this.path = string;
            this.name = string2;
            this.contextRoot = string3;
        }

        public String getCommand() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("deploy?path=");
            stringBuilder.append(this.path);
            if (this.name != null && this.name.length() > 0) {
                stringBuilder.append("?name=");
                stringBuilder.append(this.name);
            }
            if (this.contextRoot != null && this.contextRoot.length() > 0) {
                stringBuilder.append("?contextroot=");
                stringBuilder.append(this.contextRoot);
            }
            stringBuilder.append("?force=true");
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ListResourcesCommand
    extends ServerCommand {
        private final String command;
        private final String cmdSuffix;
        private Manifest list;
        private List<ResourceDesc> resList;

        public ListResourcesCommand(String string) {
            this.command = "list-" + string + "s";
            this.cmdSuffix = string;
        }

        public List<ResourceDesc> getResourceList() {
            if (this.resList != null) {
                return Collections.unmodifiableList(this.resList);
            }
            return Collections.emptyList();
        }

        @Override
        public String getCommand() {
            return this.command;
        }

        @Override
        public void readManifest(Manifest manifest) throws IOException {
            this.list = manifest;
        }

        @Override
        public boolean processResponse() {
            String[] stringArray;
            if (this.list == null) {
                return false;
            }
            String string = this.list.getMainAttributes().getValue("children");
            if (string == null || string.length() == 0) {
                return true;
            }
            for (String string2 : stringArray = string.split("[,;]")) {
                if (this.skipResource(string2)) continue;
                Attributes attributes = this.list.getAttributes(string2);
                if (attributes != null) {
                    String string3 = attributes.getValue("message");
                    if (string3 == null || string3.length() <= 0) continue;
                    if (this.resList == null) {
                        this.resList = new ArrayList<ResourceDesc>();
                    }
                    this.resList.add(new ResourceDesc(string3, this.cmdSuffix));
                    continue;
                }
                Logger.getLogger("glassfish").log(Level.FINE, "No resource attributes returned for " + string2);
            }
            return true;
        }

        private boolean skipResource(String string) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ListAppsCommand
    extends ServerCommand {
        private final String container;
        private Manifest list;
        private Map<String, List<AppDesc>> appMap;
        private static final List<String> engineBias = Arrays.asList("jruby", "web", "ejb");

        public ListAppsCommand() {
            this(null);
        }

        public ListAppsCommand(String string) {
            this.container = string;
        }

        public String[] getContainers() {
            String[] stringArray = null;
            if (this.appMap != null && this.appMap.size() > 0) {
                Set<String> set = this.appMap.keySet();
                stringArray = set.toArray(new String[set.size()]);
            }
            return stringArray != null ? stringArray : new String[]{};
        }

        public Map<String, List<AppDesc>> getApplicationMap() {
            if (this.appMap != null) {
                return Collections.unmodifiableMap(this.appMap);
            }
            return Collections.emptyMap();
        }

        @Override
        public String getCommand() {
            return "list-applications";
        }

        @Override
        public void readManifest(Manifest manifest) throws IOException {
            this.list = manifest;
        }

        @Override
        public boolean processResponse() {
            String[] stringArray;
            if (this.list == null) {
                return false;
            }
            String string = this.list.getMainAttributes().getValue("children");
            if (string == null || string.length() == 0) {
                return true;
            }
            for (String string2 : stringArray = string.split(";")) {
                List<AppDesc> list;
                String string3;
                if ("null".equals(string2)) {
                    Logger.getLogger("glassfish").log(Level.WARNING, "list-applications contains an invalid result.  Check server log for possible exceptions.");
                    continue;
                }
                Attributes attributes = this.list.getAttributes(string2);
                if (attributes == null) continue;
                String string4 = this.getPreferredEngine(attributes.getValue("nb-engine_value"));
                String string5 = attributes.getValue("nb-name_value");
                if (string5 == null || string5.length() == 0) {
                    Logger.getLogger("glassfish").log(Level.FINE, "Skipping application with no name...");
                    continue;
                }
                String string6 = attributes.getValue("nb-location_value");
                if (string6.startsWith("file:")) {
                    string6 = string6.substring(5);
                }
                if ((string3 = attributes.getValue("nb-context-root_value")) == null) {
                    string3 = string5;
                }
                if (string3.startsWith("/")) {
                    string3 = string3.substring(1);
                }
                if (this.appMap == null) {
                    this.appMap = new HashMap<String, List<AppDesc>>();
                }
                if ((list = this.appMap.get(string4)) == null) {
                    list = new ArrayList<AppDesc>();
                    this.appMap.put(string4, list);
                }
                list.add(new AppDesc(string5, string6, string3));
            }
            return true;
        }

        private String getPreferredEngine(String string) {
            String[] stringArray = string.split(",");
            String string2 = null;
            int n = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.skipContainer(stringArray[i])) continue;
                stringArray[i] = stringArray[i].trim();
                int n2 = engineBias.indexOf(stringArray[i]);
                if (n2 >= 0 && (n == -1 || n2 < n)) {
                    n = n2;
                }
                if (string2 != null) continue;
                string2 = stringArray[i];
            }
            if (n != -1) {
                string2 = engineBias.get(n);
            } else if (string2 == null) {
                string2 = "unknown";
            }
            return string2;
        }

        private boolean skipContainer(String string) {
            return this.container != null ? !this.container.equals(string) : "security_ContractProvider".equals(string);
        }
    }
}

