/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.awt.Component;
import java.awt.Container;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JFrameOperator;
import org.netbeans.jemmy.operators.JMenuBarOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.NameComponentChooser;
import org.openide.awt.StatusDisplayer;
import org.openide.awt.Toolbar;
import org.openide.windows.WindowManager;

public class MainWindowOperator
extends JFrameOperator {
    private static MainWindowOperator defaultMainWindowOperator;
    private JMenuBarOperator _menuBar;
    private static StatusTextTracer statusTextTracer;

    protected MainWindowOperator() {
        super((JFrame)new QueueTool().invokeSmoothly(new QueueTool.QueueAction("getMainWindow"){

            public Object launch() {
                return WindowManager.getDefault().getMainWindow();
            }
        }));
    }

    public static synchronized MainWindowOperator getDefault() {
        if (defaultMainWindowOperator == null) {
            defaultMainWindowOperator = new MainWindowOperator();
        }
        return defaultMainWindowOperator;
    }

    public JMenuBarOperator menuBar() {
        if (this._menuBar == null) {
            this._menuBar = new JMenuBarOperator((ContainerOperator)this);
        }
        return this._menuBar;
    }

    public String getStatusText() {
        return StatusDisplayer.getDefault().getStatusText();
    }

    public void setStatusText(String string) {
        StatusDisplayer.getDefault().setStatusText(string);
    }

    public synchronized StatusTextTracer getStatusTextTracer() {
        if (statusTextTracer == null) {
            statusTextTracer = new StatusTextTracer();
        }
        return statusTextTracer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitStatusText(String string) {
        this.getStatusTextTracer().start();
        try {
            if (!this.getComparator().equals(this.getStatusText(), string)) {
                this.getStatusTextTracer().waitText(string);
            }
        }
        finally {
            this.getStatusTextTracer().stop();
        }
    }

    public ContainerOperator getToolbar(int n) {
        ToolbarChooser toolbarChooser = new ToolbarChooser();
        return new ContainerOperator((Container)MainWindowOperator.waitComponent((Container)((Container)this.getSource()), (ComponentChooser)toolbarChooser, (int)n));
    }

    public ContainerOperator getToolbar(String string) {
        ToolbarChooser toolbarChooser = new ToolbarChooser(string, this.getComparator());
        return new ContainerOperator((Container)MainWindowOperator.waitComponent((Container)((Container)this.getSource()), (ComponentChooser)toolbarChooser));
    }

    public int getToolbarCount() {
        ToolbarChooser toolbarChooser = new ToolbarChooser("Non sense name - @#$%^&*", this.getComparator());
        MainWindowOperator.findComponent((Container)((Container)this.getSource()), (ComponentChooser)toolbarChooser);
        return toolbarChooser.getCount();
    }

    public String getToolbarName(int n) {
        return ((Toolbar)this.getToolbar(n).getSource()).getDisplayName();
    }

    public JButtonOperator getToolbarButton(ContainerOperator containerOperator, String string) {
        ToolbarButtonChooser toolbarButtonChooser = new ToolbarButtonChooser(string, this.getComparator());
        return new JButtonOperator(JButtonOperator.waitJButton((Container)((Container)containerOperator.getSource()), (ComponentChooser)toolbarButtonChooser));
    }

    public JButtonOperator getToolbarButton(ContainerOperator containerOperator, int n) {
        return new JButtonOperator(containerOperator, n);
    }

    public void pushToolbarPopupMenu(String string) {
        ContainerOperator containerOperator = this.getToolbar(0);
        containerOperator.clickForPopup(containerOperator.getWidth() - 1, containerOperator.getHeight() / 2);
        new JPopupMenuOperator().pushMenu(string, "|");
    }

    public void pushToolbarPopupMenuNoBlock(String string) {
        ContainerOperator containerOperator = this.getToolbar(0);
        containerOperator.clickForPopup(containerOperator.getWidth() - 1, containerOperator.getHeight() / 2);
        new JPopupMenuOperator().pushMenuNoBlock(string, "|");
    }

    public void dragNDropToolbar(ContainerOperator containerOperator, int n, int n2) {
        Component component = MainWindowOperator.findComponent((Container)((Container)containerOperator.getSource()), (ComponentChooser)new NameComponentChooser("grip"));
        new ComponentOperator(component).dragNDrop(component.getWidth() / 2, component.getHeight() / 2, n, n2);
    }

    public void verify() {
        this.menuBar();
    }

    static {
        statusTextTracer = null;
    }

    public class StatusTextTracer
    implements ChangeListener {
        private ArrayList<String> statusTextHistory = new ArrayList();

        public void start() {
            this.stop();
            this.clear();
            StatusDisplayer.getDefault().addChangeListener((ChangeListener)this);
        }

        public void stop() {
            StatusDisplayer.getDefault().removeChangeListener((ChangeListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(ChangeEvent changeEvent) {
            StatusTextTracer statusTextTracer = this;
            synchronized (statusTextTracer) {
                this.statusTextHistory.add(StatusDisplayer.getDefault().getStatusText());
                JemmyProperties.getCurrentOutput().printTrace("Status text changed to: \"" + StatusDisplayer.getDefault().getStatusText() + "\"");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            StatusTextTracer statusTextTracer = this;
            synchronized (statusTextTracer) {
                this.statusTextHistory.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(String string, boolean bl) {
            Operator.StringComparator stringComparator = MainWindowOperator.this.getComparator();
            StatusTextTracer statusTextTracer = this;
            synchronized (statusTextTracer) {
                if (bl) {
                    while (!this.statusTextHistory.isEmpty()) {
                        String string2 = this.statusTextHistory.remove(0);
                        if (!stringComparator.equals(string2, string)) continue;
                        return true;
                    }
                } else {
                    for (int i = 0; i < this.statusTextHistory.size(); ++i) {
                        if (!stringComparator.equals(this.statusTextHistory.get(i), string)) continue;
                        return true;
                    }
                }
                return false;
            }
        }

        public void waitText(String string) {
            this.waitText(string, false);
        }

        public void waitText(final String string, final boolean bl) {
            try {
                new Waiter(new Waitable(){

                    public Object actionProduced(Object object) {
                        return StatusTextTracer.this.contains(string, bl) ? Boolean.TRUE : null;
                    }

                    public String getDescription() {
                        return "Wait status text equals to " + string;
                    }
                }).waitAction(null);
            }
            catch (InterruptedException interruptedException) {
                throw new JemmyException("Interrupted.", (Throwable)interruptedException);
            }
        }

        public void finalize() {
            this.stop();
        }

        public ArrayList getStatusTextHistory() {
            return this.statusTextHistory;
        }

        public void printStatusTextHistory(PrintStream printStream) {
            for (int i = 0; i < this.statusTextHistory.size(); ++i) {
                printStream.println(this.statusTextHistory.get(i).toString());
            }
        }
    }

    private static class ToolbarButtonChooser
    implements ComponentChooser {
        private String buttonTooltip;
        private Operator.StringComparator comparator;

        public ToolbarButtonChooser(String string, Operator.StringComparator stringComparator) {
            this.buttonTooltip = string;
            this.comparator = stringComparator;
        }

        public boolean checkComponent(Component component) {
            return this.comparator.equals(((JComponent)component).getToolTipText(), this.buttonTooltip);
        }

        public String getDescription() {
            return "Toolbar button with tooltip \"" + this.buttonTooltip + "\".";
        }
    }

    private static class ToolbarChooser
    implements ComponentChooser {
        private String toolbarName;
        private Operator.StringComparator comparator;
        private int count = 0;

        public ToolbarChooser(String string, Operator.StringComparator stringComparator) {
            this.toolbarName = string;
            this.comparator = stringComparator;
        }

        public ToolbarChooser() {
            this.comparator = null;
        }

        public boolean checkComponent(Component component) {
            if (component instanceof Toolbar) {
                ++this.count;
                if (this.comparator != null) {
                    return this.comparator.equals(((Toolbar)component).getDisplayName(), this.toolbarName);
                }
                return true;
            }
            return false;
        }

        public String getDescription() {
            return "org.openide.awt.Toolbar";
        }

        public int getCount() {
            return this.count;
        }
    }
}

