/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.validation.statics;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.model.api.Activity;
import org.netbeans.modules.bpel.model.api.ActivityHolder;
import org.netbeans.modules.bpel.model.api.BaseCorrelation;
import org.netbeans.modules.bpel.model.api.BaseScope;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Catch;
import org.netbeans.modules.bpel.model.api.Compensate;
import org.netbeans.modules.bpel.model.api.CompensateScope;
import org.netbeans.modules.bpel.model.api.CompensationHandler;
import org.netbeans.modules.bpel.model.api.CompositeActivity;
import org.netbeans.modules.bpel.model.api.Correlation;
import org.netbeans.modules.bpel.model.api.CorrelationContainer;
import org.netbeans.modules.bpel.model.api.CorrelationSet;
import org.netbeans.modules.bpel.model.api.CorrelationSetContainer;
import org.netbeans.modules.bpel.model.api.CreateInstanceActivity;
import org.netbeans.modules.bpel.model.api.Empty;
import org.netbeans.modules.bpel.model.api.EventHandlers;
import org.netbeans.modules.bpel.model.api.ExtendableActivity;
import org.netbeans.modules.bpel.model.api.Extension;
import org.netbeans.modules.bpel.model.api.FaultHandlers;
import org.netbeans.modules.bpel.model.api.Flow;
import org.netbeans.modules.bpel.model.api.ForEach;
import org.netbeans.modules.bpel.model.api.From;
import org.netbeans.modules.bpel.model.api.FromPart;
import org.netbeans.modules.bpel.model.api.FromPartContainer;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.Invoke;
import org.netbeans.modules.bpel.model.api.Link;
import org.netbeans.modules.bpel.model.api.LinkContainer;
import org.netbeans.modules.bpel.model.api.NamedElement;
import org.netbeans.modules.bpel.model.api.OnEvent;
import org.netbeans.modules.bpel.model.api.OnMessage;
import org.netbeans.modules.bpel.model.api.OperationReference;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.PartnerLinkContainer;
import org.netbeans.modules.bpel.model.api.PartnerLinkReference;
import org.netbeans.modules.bpel.model.api.PatternedCorrelation;
import org.netbeans.modules.bpel.model.api.PatternedCorrelationContainer;
import org.netbeans.modules.bpel.model.api.Pick;
import org.netbeans.modules.bpel.model.api.PortTypeReference;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.ReThrow;
import org.netbeans.modules.bpel.model.api.Receive;
import org.netbeans.modules.bpel.model.api.RepeatUntil;
import org.netbeans.modules.bpel.model.api.Reply;
import org.netbeans.modules.bpel.model.api.Requester;
import org.netbeans.modules.bpel.model.api.Responder;
import org.netbeans.modules.bpel.model.api.Scope;
import org.netbeans.modules.bpel.model.api.Sequence;
import org.netbeans.modules.bpel.model.api.Source;
import org.netbeans.modules.bpel.model.api.SourceContainer;
import org.netbeans.modules.bpel.model.api.Target;
import org.netbeans.modules.bpel.model.api.TargetContainer;
import org.netbeans.modules.bpel.model.api.TerminationHandler;
import org.netbeans.modules.bpel.model.api.ToPart;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableContainer;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.While;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.api.references.SchemaReference;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.model.api.support.ContainerIterator;
import org.netbeans.modules.bpel.model.api.support.ImportHelper;
import org.netbeans.modules.bpel.model.api.support.Initiate;
import org.netbeans.modules.bpel.model.api.support.Pattern;
import org.netbeans.modules.bpel.model.api.support.Roles;
import org.netbeans.modules.bpel.model.api.support.SimpleBpelModelVisitor;
import org.netbeans.modules.bpel.model.api.support.SimpleBpelModelVisitorAdaptor;
import org.netbeans.modules.bpel.model.api.support.TBoolean;
import org.netbeans.modules.bpel.model.api.support.Utils;
import org.netbeans.modules.bpel.validation.core.BpelValidator;
import org.netbeans.modules.soa.ui.SoaUtil;
import org.netbeans.modules.soa.validation.util.LineUtil;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.NotificationOperation;
import org.netbeans.modules.xml.wsdl.model.OneWayOperation;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Output;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.RequestResponseOperation;
import org.netbeans.modules.xml.wsdl.model.SolicitResponseOperation;
import org.netbeans.modules.xml.wsdl.model.Types;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.CorrelationProperty;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PropertyAlias;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class Validator
extends BpelValidator {
    private static final DefaultNameAccess DEFAULT_NAME_ACESS = new DefaultNameAccess();
    private static final String SUPPORTED_LANGAGE = "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0";

    protected SimpleBpelModelVisitor getVisitor() {
        return new SimpleBpelModelVisitorAdaptor(){

            private void checkDuplicate(Process process) {
                Import[] importArray = process.getImports();
                if (importArray == null) {
                    return;
                }
                LinkedList<Model> linkedList = new LinkedList<Model>();
                LinkedList<Model> linkedList2 = new LinkedList<Model>();
                for (Import object2 : importArray) {
                    SchemaModel schemaModel;
                    WSDLModel wSDLModel = ImportHelper.getWsdlModel((Import)object2, (boolean)false);
                    if (wSDLModel != null && !linkedList.contains(wSDLModel)) {
                        linkedList.add((Model)wSDLModel);
                    }
                    if ((schemaModel = ImportHelper.getSchemaModel((Import)object2, (boolean)false)) == null) continue;
                    if (linkedList2.contains(schemaModel)) {
                        Validator.this.addWarning("FIX_SA00014", (Component)object2);
                        continue;
                    }
                    linkedList2.add((Model)schemaModel);
                }
                for (Model model : linkedList) {
                    Collection collection;
                    Types types = ((WSDLModel)model).getDefinitions().getTypes();
                    if (types == null || (collection = types.getSchemas()) == null) continue;
                    for (SchemaModel schemaModel : collection) {
                        linkedList2.add((Model)schemaModel.getModel());
                    }
                }
                this.checkModels(process, linkedList);
                this.checkModels(process, linkedList2);
            }

            private void checkModels(Process process, List<Model> list) {
                for (int i = 0; i < list.size(); ++i) {
                    for (int j = i + 1; j < list.size(); ++j) {
                        this.checkDuplicate(process, list.get(i), list.get(j));
                    }
                }
            }

            private void checkDuplicate(Process process, Model model, Model model2) {
                String string = this.getTargetNamespace(model);
                if (string == null) {
                    return;
                }
                String string2 = this.getTargetNamespace(model2);
                if (string2 == null) {
                    return;
                }
                if (!string.equals(string2)) {
                    return;
                }
                if (model instanceof WSDLModel) {
                    this.checkDuplicate(process, ((WSDLModel)model).getDefinitions(), ((WSDLModel)model2).getDefinitions());
                } else if (model instanceof SchemaModel) {
                    this.checkDuplicate(process, ((SchemaModel)model).getSchema(), ((SchemaModel)model2).getSchema());
                }
            }

            private void checkDuplicate(Process process, Definitions definitions, Definitions definitions2) {
                this.checkDuplicate(process, definitions.getMessages(), definitions2.getMessages());
                this.checkDuplicate(process, definitions.getPortTypes(), definitions2.getPortTypes());
                this.checkDuplicate(process, definitions.getBindings(), definitions2.getBindings());
                this.checkDuplicate(process, definitions.getServices(), definitions2.getServices());
            }

            private void checkDuplicate(Process process, Schema schema, Schema schema2) {
                this.checkDuplicate(process, schema.getAttributes(), schema2.getAttributes());
                this.checkDuplicate(process, schema.getAttributeGroups(), schema2.getAttributeGroups());
                this.checkDuplicate(process, schema.getGroups(), schema2.getGroups());
                this.checkDuplicate(process, schema.getNotations(), schema2.getNotations());
                this.checkDuplicate(process, schema.getElements(), schema2.getElements());
                this.checkDuplicate(process, schema.getSimpleTypes(), schema2.getSimpleTypes());
                this.checkDuplicate(process, schema.getComplexTypes(), schema2.getComplexTypes());
            }

            private void checkDuplicate(Process process, Collection<? extends Named> collection, Collection<? extends Named> collection2) {
                List<Named> list = this.list(collection);
                List<Named> list2 = this.list(collection2);
                for (int i = 0; i < list.size(); ++i) {
                    this.checkDuplicate(process, list.get(i), list2);
                }
            }

            private void checkDuplicate(Process process, Named named, List<Named> list) {
                String string = named.getName();
                if (string == null || string.length() == 0) {
                    return;
                }
                String string2 = this.getFileName((Component)named);
                for (int i = 0; i < list.size(); ++i) {
                    Named named2 = list.get(i);
                    if (!string.equals(named2.getName())) continue;
                    String string3 = this.getFileName((Component)named2);
                    if (this.getPresentation((Component)named).equals(this.getPresentation((Component)named2))) {
                        if (string2 == null || string3 == null) {
                            Validator.this.addWarning("FIX_SA00014_Identical", (Component)process, named.getName());
                            continue;
                        }
                        Validator.this.addWarning("FIX_SA00014_Identical_File", (Component)process, named.getName(), string2, string3);
                        continue;
                    }
                    if (string2 == null || string3 == null) {
                        Validator.this.addError("FIX_SA00014_Different", (Component)process, named.getName());
                        continue;
                    }
                    Validator.this.addError("FIX_SA00014_Different_File", (Component)process, named.getName(), string2, string3);
                }
            }

            private String getPresentation(Component component) {
                StringBuffer stringBuffer = this.getName(component) == null ? new StringBuffer() : new StringBuffer(this.getName(component));
                stringBuffer.append("(");
                List list = component.getChildren();
                for (Object e : list) {
                    if (!(e instanceof Component)) continue;
                    stringBuffer.append(this.getPresentation((Component)e));
                }
                stringBuffer.append(")");
                return stringBuffer.toString();
            }

            private String getName(Component component) {
                if (!(component instanceof Named)) {
                    return "[]";
                }
                return ((Named)component).getName();
            }

            private String getFileName(Component component) {
                if (component == null) {
                    return null;
                }
                FileObject fileObject = SoaUtil.getFileObjectByModel((Model)component.getModel());
                if (fileObject == null) {
                    return null;
                }
                return LineUtil.getLocation((File)FileUtil.toFile((FileObject)fileObject), (Component)component);
            }

            private List<Named> list(Collection<? extends Named> collection) {
                ArrayList<Named> arrayList = new ArrayList<Named>();
                if (collection == null) {
                    return arrayList;
                }
                Iterator<? extends Named> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                return arrayList;
            }

            private String getTargetNamespace(Import import_) {
                String string = this.getTargetNamespace(ImportHelper.getWsdlModel((Import)import_, (boolean)false));
                if (string != null) {
                    return string;
                }
                return this.getTargetNamespace(ImportHelper.getSchemaModel((Import)import_, (boolean)false));
            }

            private String getTargetNamespace(Model model) {
                if (model instanceof WSDLModel) {
                    return this.getTargetNamespace((WSDLModel)model);
                }
                if (model instanceof SchemaModel) {
                    return this.getTargetNamespace((SchemaModel)model);
                }
                return null;
            }

            private String getTargetNamespace(WSDLModel wSDLModel) {
                if (wSDLModel == null) {
                    return null;
                }
                Definitions definitions = wSDLModel.getDefinitions();
                if (definitions == null) {
                    return null;
                }
                return definitions.getTargetNamespace();
            }

            private String getTargetNamespace(SchemaModel schemaModel) {
                if (schemaModel == null) {
                    return null;
                }
                Schema schema = schemaModel.getSchema();
                if (schema == null) {
                    return null;
                }
                return schema.getTargetNamespace();
            }

            public void visit(PartnerLink partnerLink) {
                if ((partnerLink.getMyRole() == null || partnerLink.getMyRole().equals("")) && (partnerLink.getPartnerRole() == null || partnerLink.getPartnerRole().equals(""))) {
                    Validator.this.addError("FIX_SA00016", (Component)partnerLink);
                }
                if ((partnerLink.getPartnerRole() == null || partnerLink.getPartnerRole().equals("")) && partnerLink.getInitializePartnerRole() != null && !partnerLink.getInitializePartnerRole().equals((Object)TBoolean.INVALID)) {
                    Validator.this.addError("FIX_SA00017", (Component)partnerLink);
                }
            }

            public void visit(Invoke invoke) {
                this.checkSolicitResponsePortType((BpelEntity)invoke, (WSDLReference<PortType>)invoke.getPortType());
                this.checkNotificationPortType((BpelEntity)invoke, (WSDLReference<PortType>)invoke.getPortType());
                this.checkOverloadedPortTypeOperation((BpelEntity)invoke, (WSDLReference<PortType>)invoke.getPortType());
                this.checkInputVariableToPartCombination(invoke);
                this.checkOutputVariableFromPartCombination(invoke);
                this.checkValidPartAttributeFromPartElement(invoke);
                this.checkValidPartAttributeToPartElement(invoke);
                this.checkPortTypeCombinedPartnerLink((PortTypeReference)invoke);
                this.checkInputOutputVariableOperation(invoke);
                this.checkAnyMissingToPartElementInInvoke(invoke);
            }

            public void visit(Receive receive) {
                this.checkSolicitResponsePortType((BpelEntity)receive, (WSDLReference<PortType>)receive.getPortType());
                this.checkNotificationPortType((BpelEntity)receive, (WSDLReference<PortType>)receive.getPortType());
                this.checkOverloadedPortTypeOperation((BpelEntity)receive, (WSDLReference<PortType>)receive.getPortType());
                this.checkReceiveVariableFromPartCombination(receive);
                this.checkPortTypeCombinedPartnerLink((PortTypeReference)receive);
                this.checkOrderOfActivities((CreateInstanceActivity)receive);
            }

            public void visit(Reply reply) {
                this.checkSolicitResponsePortType((BpelEntity)reply, (WSDLReference<PortType>)reply.getPortType());
                this.checkNotificationPortType((BpelEntity)reply, (WSDLReference<PortType>)reply.getPortType());
                this.checkOverloadedPortTypeOperation((BpelEntity)reply, (WSDLReference<PortType>)reply.getPortType());
                this.checkReplyVariableToPartCombination(reply);
                this.checkPortTypeCombinedPartnerLink((PortTypeReference)reply);
                this.checkAnyMissingToPartElementInReply(reply);
            }

            public void visit(OnMessage onMessage) {
                this.checkSolicitResponsePortType((BpelEntity)onMessage, (WSDLReference<PortType>)onMessage.getPortType());
                this.checkNotificationPortType((BpelEntity)onMessage, (WSDLReference<PortType>)onMessage.getPortType());
                this.checkOverloadedPortTypeOperation((BpelEntity)onMessage, (WSDLReference<PortType>)onMessage.getPortType());
                this.checkPortTypeCombinedPartnerLink((PortTypeReference)onMessage);
                this.checkOnMessageVariableFromPartCombination(onMessage);
            }

            public void visit(ReThrow reThrow) {
                boolean bl = Utils.hasAscendant((BpelEntity)reThrow, FaultHandlers.class);
                if (!bl) {
                    Validator.this.addError("FIX_SA00006", (Component)reThrow);
                }
            }

            public void visit(Compensate compensate) {
                this.checkCompensateOccurance((Activity)compensate);
            }

            public void visit(CompensateScope compensateScope) {
                this.checkCompensateOccurance((Activity)compensateScope);
            }

            public void visit(From from) {
                Roles roles = from.getEndpointReference();
                if (Roles.MY_ROLE.equals((Object)roles)) {
                    boolean bl;
                    BpelReference bpelReference = from.getPartnerLink();
                    boolean bl2 = bl = bpelReference != null && bpelReference.get() != null && ((PartnerLink)bpelReference.get()).getMyRole() != null;
                    if (!bl) {
                        Validator.this.addError("FIX_SA00035_SA00036", (Component)from, Roles.MY_ROLE.toString());
                    }
                } else if (Roles.PARTNER_ROLE.equals((Object)roles)) {
                    boolean bl;
                    BpelReference bpelReference = from.getPartnerLink();
                    boolean bl3 = bl = bpelReference != null && bpelReference.get() != null && ((PartnerLink)bpelReference.get()).getPartnerRole() != null;
                    if (!bl) {
                        Validator.this.addError("FIX_SA00035_SA00036", (Component)from, Roles.PARTNER_ROLE.toString());
                    }
                }
            }

            public void visit(Process process) {
                this.checkDuplicate(process);
                this.visitBaseScope((BaseScope)process);
                this.checkInstantiableActivities(process);
                this.checkPropertyAliasMultiplicity(process);
                String string = process.getQueryLanguage();
                String string2 = process.getExpressionLanguage();
                if (string != null && !Validator.SUPPORTED_LANGAGE.equals(string) || string2 != null && !Validator.SUPPORTED_LANGAGE.equals(string2)) {
                    Validator.this.addError("FIX_SA00004", (Component)process, Validator.SUPPORTED_LANGAGE);
                }
            }

            public void visit(Scope scope) {
                this.visitBaseScope((BaseScope)scope);
                TBoolean tBoolean = scope.getIsolated();
                if (TBoolean.YES.equals((Object)tBoolean)) {
                    LinkedList<Component> linkedList = new LinkedList<Component>();
                    this.collectIsolatedScopes((BpelContainer)scope, linkedList);
                    if (linkedList.size() > 0) {
                        linkedList.add((Component)scope);
                        for (Component component : linkedList) {
                            Validator.this.addError("FIX_SA00091", component);
                        }
                    }
                }
            }

            public void visit(LinkContainer linkContainer) {
                Link[] linkArray = linkContainer.getLinks();
                if (linkArray == null) {
                    return;
                }
                HashMap<String, Collection<Component>> hashMap = new HashMap<String, Collection<Component>>();
                for (Link link : linkArray) {
                    this.addNamedToMap((BpelEntity)link, hashMap);
                }
                this.addErrorForNamed(hashMap, "FIX_SA00064");
            }

            public void visit(SourceContainer sourceContainer) {
                Source[] sourceArray = sourceContainer.getSources();
                if (sourceArray == null) {
                    return;
                }
                HashMap<String, Collection<Component>> hashMap = new HashMap<String, Collection<Component>>();
                for (Source source : sourceArray) {
                    this.addNamedToMap((BpelEntity)source, hashMap, LazyHolder.SOURCE_LINK_NAME_ACCESS);
                }
                this.addErrorForNamed(hashMap, "FIX_SA00065");
            }

            public void visit(TargetContainer targetContainer) {
                Target[] targetArray = targetContainer.getTargets();
                if (targetArray == null) {
                    return;
                }
                HashMap<String, Collection<Component>> hashMap = new HashMap<String, Collection<Component>>();
                for (Target target : targetArray) {
                    this.addNamedToMap((BpelEntity)target, hashMap, LazyHolder.TARGET_LINK_NAME_ACCESS);
                }
                this.addErrorForNamed(hashMap, "FIX_SA00068_SA00069");
            }

            public void visit(ForEach forEach) {
                String string = forEach.getCounterName();
                if (string == null) {
                    return;
                }
                ContainerIterator containerIterator = new ContainerIterator((BpelEntity)forEach, BaseScope.class);
                BaseScope baseScope = (BaseScope)containerIterator.next();
                assert (baseScope != null);
                VariableContainer variableContainer = baseScope.getVariableContainer();
                if (variableContainer == null) {
                    return;
                }
                Variable[] variableArray = variableContainer.getVariables();
                if (variableArray == null) {
                    return;
                }
                for (Variable variable : variableArray) {
                    if (!string.equals(variable.getName())) continue;
                    ArrayList<Object> arrayList = new ArrayList<Object>(2);
                    arrayList.add(forEach);
                    arrayList.add(variable);
                    for (Component component : arrayList) {
                        Validator.this.addError("FIX_SA00076_SA00077_SA00078", component, string);
                    }
                    break;
                }
                this.checkVariableName((VariableDeclaration)forEach);
            }

            public void visit(VariableContainer variableContainer) {
                this.checkVariableContainer(variableContainer);
            }

            public void visit(OnEvent onEvent) {
                if (onEvent.getVariable() != null && onEvent.getMessageType() == null && onEvent.getElement() == null) {
                    Validator.this.addError("FIX_SA00090", (Component)onEvent);
                }
                this.checkPortTypeCombinedPartnerLink((PortTypeReference)onEvent);
                this.checkVariableName((VariableDeclaration)onEvent);
                this.checkMessageType(onEvent);
                this.checkImplicitlyDeclaredVars(onEvent);
                FromPartContainer fromPartContainer = onEvent.getFromPartContaner();
                if (fromPartContainer != null) {
                    for (FromPart fromPart : fromPartContainer.getFromParts()) {
                        this.checkVariableName((VariableDeclaration)fromPart);
                    }
                }
            }

            public void visit(EventHandlers eventHandlers) {
                if (eventHandlers.sizeOfOnAlarms() == 0 && eventHandlers.sizeOfOnEvents() == 0) {
                    Validator.this.addError("FIX_SA00083_SA00088", (Component)eventHandlers);
                }
            }

            public void visit(Catch catch_) {
                String string = catch_.getFaultVariable();
                SchemaReference schemaReference = catch_.getFaultElement();
                WSDLReference wSDLReference = catch_.getFaultMessageType();
                if (string != null && schemaReference == null && wSDLReference == null) {
                    Validator.this.addError("FIX_SA00081", (Component)catch_);
                }
                if (schemaReference != null && wSDLReference != null) {
                    Validator.this.addError("FIX_SA00081", (Component)catch_);
                }
                if (string == null && (schemaReference != null || wSDLReference != null)) {
                    Validator.this.addError("FIX_SA00081", (Component)catch_);
                }
                this.checkVariableName((VariableDeclaration)catch_);
            }

            public void visit(FaultHandlers faultHandlers) {
                if (faultHandlers.sizeOfCathes() == 0 && faultHandlers.getCatchAll() == null) {
                    Validator.this.addError("FIX_SA00080", (Component)faultHandlers);
                }
                this.checkFCTScope((BpelContainer)faultHandlers);
            }

            public void visit(Import import_) {
                Model model = this.getImportModel(import_);
                if (model == null) {
                    return;
                }
                String string = import_.getNamespace();
                String string2 = this.getTargetNamespace(import_);
                if (string == null) {
                    if (string2 != null) {
                        Validator.this.addError("FIX_SA00012", (Component)import_);
                    }
                } else if (!string.equals(string2)) {
                    Validator.this.addError("FIX_SA00011", (Component)import_);
                }
                this.checkImportType(import_);
            }

            public void visit(Variable variable) {
                this.checkVariableName((VariableDeclaration)variable);
                int n = variable.getType() == null ? 0 : 1;
                n += variable.getMessageType() == null ? 0 : 1;
                if ((n += variable.getElement() == null ? 0 : 1) != 1) {
                    Validator.this.addError("FIX_SA00025", (Component)variable);
                }
            }

            public void visit(Pick pick) {
                if (TBoolean.YES.equals((Object)pick.getCreateInstance()) && pick.sizeOfOnAlarms() != 0) {
                    List<Component> list = Arrays.asList((Component[])pick.getOnAlarms());
                    for (Component component : list) {
                        Validator.this.addError("FIX_SA00062", component);
                    }
                }
                this.checkOrderOfActivities((CreateInstanceActivity)pick);
            }

            public void visit(Flow flow) {
                this.checkLinks(flow);
            }

            public void visit(CompensationHandler compensationHandler) {
                this.checkFCTScope((BpelContainer)compensationHandler);
            }

            public void visit(TerminationHandler terminationHandler) {
                this.checkFCTScope((BpelContainer)terminationHandler);
            }

            public void visit(CorrelationSet correlationSet) {
                List list = correlationSet.getProperties();
                if (list == null) {
                    return;
                }
                for (WSDLReference wSDLReference : list) {
                    NamedComponentReference namedComponentReference;
                    CorrelationProperty correlationProperty = (CorrelationProperty)wSDLReference.get();
                    if (correlationProperty == null || (namedComponentReference = correlationProperty.getType()) != null && namedComponentReference.get() instanceof GlobalSimpleType) continue;
                    Validator.this.addError("FIX_SA00045", (Component)correlationSet);
                }
            }

            public void visit(PatternedCorrelation patternedCorrelation) {
                boolean bl;
                Pattern pattern = patternedCorrelation.getPattern();
                BpelContainer bpelContainer = patternedCorrelation.getParent().getParent();
                assert (bpelContainer instanceof Invoke);
                Invoke invoke = (Invoke)bpelContainer;
                WSDLReference wSDLReference = invoke.getOperation();
                if (wSDLReference == null) {
                    return;
                }
                Operation operation = (Operation)wSDLReference.get();
                if (operation == null) {
                    return;
                }
                boolean bl2 = pattern != null && operation instanceof OneWayOperation;
                boolean bl3 = pattern == null && operation instanceof RequestResponseOperation;
                boolean bl4 = bl = bl2 || bl3;
                if (bl) {
                    Validator.this.addError("FIX_SA00046", (Component)invoke);
                }
            }

            public void visit(CorrelationContainer correlationContainer) {
                BpelContainer bpelContainer = correlationContainer.getParent();
                if (bpelContainer instanceof OperationReference && bpelContainer instanceof Responder) {
                    this.checkPropertyUsageInInputMessage((OperationReference)bpelContainer, (BaseCorrelation[])correlationContainer.getCorrelations());
                }
                if (bpelContainer instanceof OperationReference && bpelContainer instanceof Requester) {
                    this.checkPropertyUsageInOutputMessage((OperationReference)bpelContainer, (BaseCorrelation[])correlationContainer.getCorrelations());
                }
            }

            public void visit(PatternedCorrelationContainer patternedCorrelationContainer) {
                BpelContainer bpelContainer = patternedCorrelationContainer.getParent();
                if (bpelContainer instanceof OperationReference && bpelContainer instanceof Responder) {
                    this.checkPropertyUsageInInputMessage((OperationReference)bpelContainer, (BaseCorrelation[])patternedCorrelationContainer.getPatternedCorrelations());
                }
                if (bpelContainer instanceof OperationReference && bpelContainer instanceof Requester) {
                    this.checkPropertyUsageInOutputMessage((OperationReference)bpelContainer, (BaseCorrelation[])patternedCorrelationContainer.getPatternedCorrelations());
                }
            }

            public void visit(CorrelationSetContainer correlationSetContainer) {
                CorrelationSet[] correlationSetArray = correlationSetContainer.getCorrelationSets();
                if (correlationSetArray == null) {
                    return;
                }
                HashMap<String, Collection<Component>> hashMap = new HashMap<String, Collection<Component>>();
                for (CorrelationSet correlationSet : correlationSetArray) {
                    this.addNamedToMap((BpelEntity)correlationSet, hashMap);
                }
                this.addErrorForNamed(hashMap, "FIX_SA00044");
            }

            public void visit(PartnerLinkContainer partnerLinkContainer) {
                PartnerLink[] partnerLinkArray = partnerLinkContainer.getPartnerLinks();
                if (partnerLinkArray == null) {
                    return;
                }
                HashMap<String, Collection<Component>> hashMap = new HashMap<String, Collection<Component>>();
                for (PartnerLink partnerLink : partnerLinkArray) {
                    this.addNamedToMap((BpelEntity)partnerLink, hashMap);
                }
                this.addErrorForNamed(hashMap, "FIX_SA00018");
            }

            public void visit(Extension extension) {
                BpelModel bpelModel;
                TBoolean tBoolean = extension.getMustUnderstand();
                if (TBoolean.YES.equals((Object)tBoolean) && !(bpelModel = extension.getBpelModel()).isSupportedExpension(extension.getNamespace())) {
                    String string = extension.getNamespace();
                    if (string == null) {
                        string = "";
                    }
                    Validator.this.addError("FIX_SA00009", (Component)extension, string);
                }
            }

            private void checkVariableName(VariableDeclaration variableDeclaration) {
                String string = variableDeclaration.getVariableName();
                if (string != null && string.indexOf(46) != -1) {
                    Validator.this.addError("FIX_SA00024", (Component)variableDeclaration);
                }
            }

            private Model getImportModel(Import import_) {
                if ("http://schemas.xmlsoap.org/wsdl/".equals(import_.getImportType())) {
                    return ImportHelper.getWsdlModel((Import)import_, (boolean)false);
                }
                if ("http://www.w3.org/2001/XMLSchema".equals(import_.getImportType())) {
                    return ImportHelper.getSchemaModel((Import)import_, (boolean)false);
                }
                return null;
            }

            public void checkNotificationPortType(BpelEntity bpelEntity, WSDLReference<PortType> wSDLReference) {
                if (wSDLReference == null || wSDLReference.get() == null) {
                    return;
                }
                Collection collection = ((PortType)wSDLReference.get()).getOperations();
                for (Operation operation : collection) {
                    if (!(operation instanceof NotificationOperation)) continue;
                    Validator.this.addError("FIX_SA00001", (Component)bpelEntity);
                }
            }

            public void checkSolicitResponsePortType(BpelEntity bpelEntity, WSDLReference<PortType> wSDLReference) {
                if (wSDLReference == null || wSDLReference.get() == null) {
                    return;
                }
                Collection collection = ((PortType)wSDLReference.get()).getOperations();
                for (Operation operation : collection) {
                    if (!(operation instanceof SolicitResponseOperation)) continue;
                    Validator.this.addError("FIX_SA00001", (Component)bpelEntity);
                }
            }

            public void checkOverloadedPortTypeOperation(BpelEntity bpelEntity, WSDLReference<PortType> wSDLReference) {
                if (wSDLReference == null || wSDLReference.get() == null) {
                    return;
                }
                Collection collection = ((PortType)wSDLReference.get()).getOperations();
                HashSet<String> hashSet = new HashSet<String>();
                for (Operation operation : collection) {
                    hashSet.add(operation.getName());
                }
                if (hashSet.size() != collection.size()) {
                    Validator.this.addError("FIX_SA00002", (Component)bpelEntity);
                }
            }

            public void checkInputVariableToPartCombination(Invoke invoke) {
                if (invoke.getInputVariable() != null && invoke.getToPartContaner() != null && invoke.getToPartContaner().sizeOfToParts() != 0) {
                    Validator.this.addError("FIX_SA00051", (Component)invoke);
                }
            }

            public void checkOutputVariableFromPartCombination(Invoke invoke) {
                if (invoke.getOutputVariable() != null && invoke.getFromPartContaner() != null && invoke.getFromPartContaner().sizeOfFromParts() != 0) {
                    Validator.this.addError("FIX_SA00052", (Component)invoke);
                }
            }

            public void checkValidPartAttributeFromPartElement(Invoke invoke) {
                if (invoke.getFromPartContaner() != null && invoke.getFromPartContaner().sizeOfFromParts() != 0) {
                    FromPart[] fromPartArray;
                    for (FromPart fromPart : fromPartArray = invoke.getFromPartContaner().getFromParts()) {
                        boolean bl = false;
                        if (fromPart == null || fromPart.getPart() == null) {
                            return;
                        }
                        WSDLReference wSDLReference = fromPart.getPart();
                        Part part = (Part)wSDLReference.get();
                        if (part != null) {
                            if (invoke.getOperation() == null || invoke.getOperation().get() == null || ((Operation)invoke.getOperation().get()).getOutput() == null || ((Operation)invoke.getOperation().get()).getOutput().getMessage() == null || ((Operation)invoke.getOperation().get()).getOutput().getMessage().get() == null || ((Message)((Operation)invoke.getOperation().get()).getOutput().getMessage().get()).getParts() == null) {
                                return;
                            }
                            for (Part part2 : ((Message)((Operation)invoke.getOperation().get()).getOutput().getMessage().get()).getParts()) {
                                if (!part2.equals(part)) continue;
                                bl = true;
                                break;
                            }
                        }
                        if (bl) continue;
                        Validator.this.addError("FIX_SA00053", (Component)fromPart);
                    }
                }
            }

            public void checkValidPartAttributeToPartElement(Invoke invoke) {
                if (invoke.getToPartContaner() != null && invoke.getToPartContaner().sizeOfToParts() != 0) {
                    ToPart[] toPartArray;
                    for (ToPart toPart : toPartArray = invoke.getToPartContaner().getToParts()) {
                        boolean bl = false;
                        if (toPart == null || toPart.getPart() == null) {
                            return;
                        }
                        WSDLReference wSDLReference = toPart.getPart();
                        Part part = (Part)wSDLReference.get();
                        if (part != null) {
                            if (invoke.getOperation() == null || invoke.getOperation().get() == null || ((Operation)invoke.getOperation().get()).getInput() == null || ((Operation)invoke.getOperation().get()).getInput().getMessage() == null || ((Operation)invoke.getOperation().get()).getInput().getMessage().get() == null || ((Message)((Operation)invoke.getOperation().get()).getInput().getMessage().get()).getParts() == null) {
                                return;
                            }
                            for (Part part2 : ((Message)((Operation)invoke.getOperation().get()).getInput().getMessage().get()).getParts()) {
                                if (!part2.equals(part)) continue;
                                bl = true;
                                break;
                            }
                        }
                        if (bl) continue;
                        Validator.this.addError("FIX_SA00054", (Component)toPart);
                    }
                }
            }

            public void checkAnyMissingToPartElementInInvoke(Invoke invoke) {
                if (invoke.getOperation() == null || invoke.getOperation().get() == null || ((Operation)invoke.getOperation().get()).getInput() == null || ((Operation)invoke.getOperation().get()).getInput().getMessage() == null || ((Operation)invoke.getOperation().get()).getInput().getMessage().get() == null || ((Message)((Operation)invoke.getOperation().get()).getInput().getMessage().get()).getParts() == null) {
                    return;
                }
                if (invoke.getToPartContaner() == null || invoke.getToPartContaner().sizeOfToParts() == 0) {
                    return;
                }
                for (Part part : ((Message)((Operation)invoke.getOperation().get()).getInput().getMessage().get()).getParts()) {
                    ToPart[] toPartArray;
                    boolean bl = false;
                    for (ToPart toPart : toPartArray = invoke.getToPartContaner().getToParts()) {
                        Part part2;
                        WSDLReference wSDLReference = toPart.getPart();
                        if (wSDLReference == null || (part2 = (Part)wSDLReference.get()) == null || !part.equals(part2)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    Validator.this.addError("FIX_SA00050", (Component)invoke);
                    break;
                }
            }

            public void checkAnyMissingToPartElementInReply(Reply reply) {
                if (reply.getOperation() == null || reply.getOperation().get() == null || ((Operation)reply.getOperation().get()).getOutput() == null || ((Operation)reply.getOperation().get()).getOutput().getMessage() == null || ((Operation)reply.getOperation().get()).getOutput().getMessage().get() == null || ((Message)((Operation)reply.getOperation().get()).getOutput().getMessage().get()).getParts() == null) {
                    return;
                }
                if (reply.getToPartContaner() == null || reply.getToPartContaner().sizeOfToParts() == 0) {
                    return;
                }
                for (Part part : ((Message)((Operation)reply.getOperation().get()).getOutput().getMessage().get()).getParts()) {
                    ToPart[] toPartArray;
                    boolean bl = false;
                    for (ToPart toPart : toPartArray = reply.getToPartContaner().getToParts()) {
                        Part part2;
                        WSDLReference wSDLReference = toPart.getPart();
                        if (wSDLReference == null || (part2 = (Part)wSDLReference.get()) == null || !part.equals(part2)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    Validator.this.addError("FIX_SA00050", (Component)reply);
                    break;
                }
            }

            public void checkReceiveVariableFromPartCombination(Receive receive) {
                WSDLReference wSDLReference;
                if (receive == null) {
                    return;
                }
                if (receive.getVariable() != null && receive.getFromPartContaner() != null && receive.getFromPartContaner().sizeOfFromParts() != 0) {
                    Validator.this.addError("FIX_SA00055", (Component)receive);
                }
                if ((wSDLReference = receive.getOperation()) == null) {
                    return;
                }
                Operation operation = (Operation)wSDLReference.get();
                if (operation == null) {
                    return;
                }
                if (this.isAbsentOutputVaribale(receive, operation)) {
                    Validator.this.addError("FIX_SA00047_4", (Component)receive);
                }
            }

            public void checkOnMessageVariableFromPartCombination(OnMessage onMessage) {
                if (onMessage == null) {
                    return;
                }
                if (onMessage.getVariable() != null && onMessage.getFromPartContaner() != null && onMessage.getFromPartContaner().sizeOfFromParts() != 0) {
                    Validator.this.addError("FIX_SA00063", (Component)onMessage);
                }
            }

            public void checkReplyVariableToPartCombination(Reply reply) {
                WSDLReference wSDLReference;
                if (reply == null) {
                    return;
                }
                if (reply.getVariable() != null && reply.getToPartContaner() != null && reply.getToPartContaner().sizeOfToParts() != 0) {
                    Validator.this.addError("FIX_SA00059", (Component)reply);
                }
                if ((wSDLReference = reply.getOperation()) == null) {
                    return;
                }
                Operation operation = (Operation)wSDLReference.get();
                if (operation == null) {
                    return;
                }
                if (this.isAbsentInputVaribale(reply, operation)) {
                    Validator.this.addError("FIX_SA00047_6", (Component)reply);
                }
            }

            private void checkPortTypeCombinedPartnerLink(PortTypeReference portTypeReference) {
                if (!(portTypeReference instanceof PartnerLinkReference)) {
                    return;
                }
                PartnerLinkReference partnerLinkReference = (PartnerLinkReference)portTypeReference;
                WSDLReference wSDLReference = portTypeReference.getPortType();
                if (wSDLReference == null) {
                    return;
                }
                BpelReference bpelReference = partnerLinkReference.getPartnerLink();
                NamedComponentReference namedComponentReference = Utils.getPortTypeRef((BpelReference)bpelReference, (Component)((Component)portTypeReference));
                if (namedComponentReference == null || !Utils.equals((Object)wSDLReference.get(), (Object)namedComponentReference.get())) {
                    Validator.this.addError("FIX_SA00005", (Component)((BpelEntity)portTypeReference));
                }
            }

            private void addNamedToMap(BpelEntity bpelEntity, Map<String, Collection<Component>> map) {
                this.addNamedToMap(bpelEntity, map, DEFAULT_NAME_ACESS);
            }

            private void addErrorForNamed(Map<String, Collection<Component>> map, String string) {
                for (Map.Entry<String, Collection<Component>> entry : map.entrySet()) {
                    String string2 = entry.getKey();
                    assert (string2 != null);
                    Collection<Component> collection = entry.getValue();
                    if (collection == null || collection.size() <= 1) continue;
                    for (Component component : collection) {
                        Validator.this.addError(string, component, this.getName(component));
                    }
                }
            }

            private void addNamedToMap(BpelEntity bpelEntity, Map<String, Collection<Component>> map, NameAccess nameAccess) {
                String string = nameAccess.getName(bpelEntity);
                if (string == null) {
                    return;
                }
                Collection<Component> collection = map.get(string);
                if (collection == null) {
                    collection = new LinkedList<Component>();
                    map.put(string, collection);
                }
                collection.add((Component)bpelEntity);
            }

            private void checkCompensateOccurance(Activity activity) {
                if (Utils.hasAscendant((BpelEntity)activity, FaultHandlers.class)) {
                    return;
                }
                if (Utils.hasAscendant((BpelEntity)activity, CompensationHandler.class)) {
                    return;
                }
                if (Utils.hasAscendant((BpelEntity)activity, TerminationHandler.class)) {
                    return;
                }
                Validator.this.addError("FIX_SA00007_SA00008", (Component)activity, activity.getPeer().getLocalName());
            }

            private void addNamedActivity(BpelEntity bpelEntity, Map<String, Collection<Component>> map) {
                if (bpelEntity instanceof ExtendableActivity && bpelEntity instanceof NamedElement) {
                    String string = ((NamedElement)bpelEntity).getName();
                    if (string == null) {
                        return;
                    }
                    Collection<Component> collection = map.get(string);
                    if (collection == null) {
                        collection = new LinkedList<Component>();
                        map.put(string, collection);
                    }
                    collection.add((Component)bpelEntity);
                }
            }

            private void collectIsolatedScopes(BpelContainer bpelContainer, Collection<Component> collection) {
                List list = bpelContainer.getChildren();
                for (BpelEntity bpelEntity : list) {
                    if (bpelEntity instanceof Scope && TBoolean.YES.equals((Object)((Scope)bpelEntity).getIsolated())) {
                        collection.add((Component)bpelEntity);
                    }
                    if (!(bpelEntity instanceof BpelContainer)) continue;
                    this.collectIsolatedScopes((BpelContainer)bpelEntity, collection);
                }
            }

            private void checkOrderOfActivities(CreateInstanceActivity createInstanceActivity) {
                if (!TBoolean.YES.equals((Object)createInstanceActivity.getCreateInstance())) {
                    return;
                }
                HashSet<CompositeActivity> hashSet = new HashSet<CompositeActivity>();
                ExtendableActivity extendableActivity = this.findPreviouslyPerformedActivities((ExtendableActivity)((Activity)createInstanceActivity), hashSet);
                if (extendableActivity == null) {
                    return;
                }
                if (this.inFlow((BpelEntity)extendableActivity) && this.hasCIAfirst((BpelEntity)extendableActivity)) {
                    return;
                }
                Validator.this.addError("FIX_SA00056", (Component)extendableActivity);
            }

            private boolean inFlow(BpelEntity bpelEntity) {
                if (bpelEntity == null) {
                    return false;
                }
                return this.isFlow((BpelEntity)bpelEntity.getParent());
            }

            private boolean isFlow(BpelEntity bpelEntity) {
                if (bpelEntity == null) {
                    return false;
                }
                if (bpelEntity instanceof Flow) {
                    return true;
                }
                return this.isFlow((BpelEntity)bpelEntity.getParent());
            }

            private boolean hasCIAfirst(BpelEntity bpelEntity) {
                if (bpelEntity == null) {
                    return false;
                }
                BpelContainer bpelContainer = bpelEntity.getParent();
                if (!(bpelContainer instanceof BpelContainer)) {
                    return false;
                }
                BpelContainer bpelContainer2 = bpelContainer;
                int n = bpelContainer2.indexOf(BpelEntity.class, bpelEntity);
                if (n == -1) {
                    return false;
                }
                List list = bpelContainer2.getChildren();
                int n2 = 0;
                for (BpelEntity bpelEntity2 : list) {
                    if (n2 >= n) break;
                    if (bpelEntity2 instanceof CreateInstanceActivity && TBoolean.YES.equals((Object)((CreateInstanceActivity)bpelEntity2).getCreateInstance())) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            private void visitBaseScope(BaseScope baseScope) {
                HashMap<String, Collection<Component>> hashMap = new HashMap<String, Collection<Component>>();
                this.collectActivitiesInScope((BpelContainer)baseScope, hashMap);
                this.addErrorForNamed(hashMap, "FIX_SA00092");
                if (TBoolean.YES.equals((Object)baseScope.getExitOnStandardFault()) && baseScope.getFaultHandlers() != null) {
                    Catch[] catchArray = baseScope.getFaultHandlers().getCatches();
                    LinkedList<Component> linkedList = new LinkedList<Component>();
                    for (Catch catch_ : catchArray) {
                        QName qName = catch_.getFaultName();
                        if (qName == null || !"http://docs.oasis-open.org/wsbpel/2.0/process/executable".equals(qName.getNamespaceURI())) continue;
                        linkedList.add((Component)catch_);
                    }
                    if (linkedList.size() > 0) {
                        this.addErrorCollection("FIX_SA00003", linkedList);
                    }
                }
            }

            private void collectActivitiesInScope(BpelContainer bpelContainer, Map<String, Collection<Component>> map) {
                List list = bpelContainer.getChildren();
                for (BpelEntity bpelEntity : list) {
                    this.addNamedActivity(bpelEntity, map);
                    if (bpelEntity instanceof BaseScope || !(bpelEntity instanceof BpelContainer)) continue;
                    this.collectActivitiesInScope((BpelContainer)bpelEntity, map);
                }
            }

            private void checkImportType(Import import_) {
                String string = import_.getImportType();
                if (!"http://schemas.xmlsoap.org/wsdl/".equals(string) && !"http://www.w3.org/2001/XMLSchema".equals(string)) {
                    Validator.this.addError("FIX_SA00013", (Component)import_);
                }
            }

            private void checkInstantiableActivities(Process process) {
                Collection<Activity> collection = this.getInstantiableActivities((BpelContainer)process);
                if (collection.size() == 0) {
                    Validator.this.addError("FIX_SA00015", (Component)process);
                }
                if (collection.size() > 0) {
                    this.checkCorellations(collection);
                }
            }

            private void checkMessageType(OnEvent onEvent) {
                WSDLReference wSDLReference = onEvent.getMessageType();
                WSDLReference wSDLReference2 = onEvent.getOperation();
                if (wSDLReference2 == null || wSDLReference2.get() == null) {
                    return;
                }
                Operation operation = (Operation)wSDLReference2.get();
                if (wSDLReference != null) {
                    if (!this.checkMessageTypeInOnEvent((WSDLReference<Message>)wSDLReference, operation)) {
                        Validator.this.addError("FIX_SA00087", (Component)onEvent);
                    }
                } else {
                    SchemaReference schemaReference = onEvent.getElement();
                    if (schemaReference == null) {
                        return;
                    }
                    if (!this.checkElementInOnEvent((SchemaReference<GlobalElement>)schemaReference, operation)) {
                        Validator.this.addError("FIX_SA00087", (Component)onEvent);
                    }
                }
            }

            private void checkLinks(Flow flow) {
                LinkContainer linkContainer = flow.getLinkContainer();
                if (linkContainer == null) {
                    return;
                }
                Link[] linkArray = linkContainer.getLinks();
                HashSet<Link> hashSet = new HashSet<Link>(Arrays.asList(linkArray));
                List list = flow.getChildren();
                HashMap<Link, Collection<Component>> hashMap = new HashMap<Link, Collection<Component>>();
                HashMap<Link, Collection<Component>> hashMap2 = new HashMap<Link, Collection<Component>>();
                for (Object object : list) {
                    this.collectLinks((BpelEntity)object, hashSet, hashMap, hashMap2);
                }
                HashMap hashMap3 = new HashMap();
                for (Link link : hashSet) {
                    boolean bl = false;
                    Collection collection = (Collection)hashMap.get(link);
                    bl = this.checkLink(link, collection, "FIX_SA00066");
                    Component component = null;
                    if (bl) {
                        component = (Component)collection.iterator().next();
                    }
                    collection = (Collection)hashMap2.get(link);
                    if (!bl || !this.checkLink(link, collection, "FIX_SA00066")) {
                        Validator.this.addError("FIX_SA00066", (Component)link);
                        continue;
                    }
                    Component component2 = (Component)collection.iterator().next();
                    this.checkLinkSingleton(hashMap3, link, component, component2);
                    this.checkLinkBoundaries(link, (BpelEntity)component, (BpelEntity)component2);
                }
            }

            private void checkInputOutputVariableOperation(Invoke invoke) {
                WSDLReference wSDLReference = invoke.getOperation();
                if (wSDLReference == null) {
                    return;
                }
                Operation operation = (Operation)wSDLReference.get();
                if (operation instanceof RequestResponseOperation) {
                    if (this.isAbsentInputVaribale(invoke, operation) || this.isAbsentOutputVaribale(invoke, operation)) {
                        Validator.this.addError("FIX_SA00047_2", (Component)invoke);
                    } else {
                        this.checkInputVariable(invoke, operation);
                        this.checkOutputVariable(invoke, operation);
                    }
                } else if (operation instanceof OneWayOperation) {
                    if (this.isAbsentInputVaribale(invoke, operation)) {
                        Validator.this.addError("FIX_SA00047", (Component)invoke);
                    } else {
                        this.checkInputVariable(invoke, operation);
                    }
                }
            }

            private void addErrorCollection(String string, Collection<Component> collection) {
                for (Component component : collection) {
                    Validator.this.addError(string, component);
                }
            }

            private void checkFCTScope(BpelContainer bpelContainer) {
                Collection<Scope> collection = this.getScopes(bpelContainer);
                for (Scope scope : collection) {
                    if (scope.getCompensationHandler() == null) continue;
                    ArrayList<Component> arrayList = new ArrayList<Component>(2);
                    arrayList.add((Component)bpelContainer);
                    arrayList.add((Component)scope);
                    this.addErrorCollection("FIX_SA00079", arrayList);
                }
            }

            private void checkPropertyAliasMultiplicity(Process process) {
                Set<PropertyAlias> set = this.getPropertyAliases(null, null, process.getBpelModel());
                HashSet<Utils.Pair> hashSet = new HashSet<Utils.Pair>();
                for (PropertyAlias propertyAlias : set) {
                    QName qName;
                    QName qName2;
                    NamedComponentReference namedComponentReference = propertyAlias.getPropertyName();
                    NamedComponentReference namedComponentReference2 = propertyAlias.getMessageType();
                    if (namedComponentReference == null || namedComponentReference2 == null) continue;
                    QName qName3 = namedComponentReference.getQName();
                    QName qName4 = new QName(qName3.getNamespaceURI(), qName3.getLocalPart());
                    Utils.Pair pair = new Utils.Pair((Object)qName4, (Object)(qName2 = new QName((qName = namedComponentReference2.getQName()).getNamespaceURI(), qName.getLocalPart())));
                    if (hashSet.contains(pair)) {
                        Validator.this.addError("FIX_SA00022", (Component)process);
                        continue;
                    }
                    hashSet.add(pair);
                }
            }

            private void checkPropertyUsageInInputMessage(OperationReference operationReference, BaseCorrelation[] baseCorrelationArray) {
                if (baseCorrelationArray.length == 0) {
                    return;
                }
                WSDLReference wSDLReference = operationReference.getOperation();
                if (wSDLReference == null) {
                    return;
                }
                Operation operation = (Operation)wSDLReference.get();
                if (operation == null) {
                    return;
                }
                Message message = this.getInputMessage(operation);
                if (message == null) {
                    return;
                }
                for (BaseCorrelation baseCorrelation : baseCorrelationArray) {
                    boolean bl = true;
                    if (baseCorrelation instanceof PatternedCorrelation) {
                        Pattern pattern = ((PatternedCorrelation)baseCorrelation).getPattern();
                        bl = Pattern.isRequestApplicable((Pattern)pattern);
                    }
                    if (!bl) continue;
                    this.checkPropertyList(baseCorrelation, message);
                }
            }

            private void checkPropertyUsageInOutputMessage(OperationReference operationReference, BaseCorrelation[] baseCorrelationArray) {
                if (baseCorrelationArray.length == 0) {
                    return;
                }
                WSDLReference wSDLReference = operationReference.getOperation();
                if (wSDLReference == null) {
                    return;
                }
                Operation operation = (Operation)wSDLReference.get();
                if (operation == null) {
                    return;
                }
                Message message = this.getOutputMessage(operation);
                if (message == null) {
                    return;
                }
                for (BaseCorrelation baseCorrelation : baseCorrelationArray) {
                    boolean bl = true;
                    if (baseCorrelation instanceof PatternedCorrelation) {
                        Pattern pattern = ((PatternedCorrelation)baseCorrelation).getPattern();
                        bl = Pattern.isResponseApplicable((Pattern)pattern);
                    }
                    if (!bl) continue;
                    this.checkPropertyList(baseCorrelation, message);
                }
            }

            private void checkVariableContainer(VariableContainer variableContainer) {
                Variable[] variableArray = variableContainer.getVariables();
                if (variableArray == null) {
                    return;
                }
                HashMap<String, Collection<Component>> hashMap = new HashMap<String, Collection<Component>>();
                for (Variable variable : variableArray) {
                    this.addNamedToMap((BpelEntity)variable, hashMap);
                }
                this.addErrorForNamed(hashMap, "FIX_SA00023");
            }

            private void checkImplicitlyDeclaredVars(OnEvent onEvent) {
                FromPartContainer fromPartContainer = onEvent.getFromPartContaner();
                if (fromPartContainer == null || fromPartContainer.getFromParts() == null) {
                    return;
                }
                HashMap<String, Collection<Component>> hashMap = new HashMap<String, Collection<Component>>();
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                for (Variable[] variableArray : fromPartContainer.getFromParts()) {
                    this.addNamedToMap((BpelEntity)variableArray, hashMap, LazyHolder.VAR_DECL_NAME_ACCESS);
                    hashMap2.put(variableArray.getVariableName(), variableArray);
                }
                this.addNamedToMap((BpelEntity)onEvent, hashMap, LazyHolder.VAR_DECL_NAME_ACCESS);
                hashMap2.put(onEvent.getVariableName(), onEvent);
                Scope scope = onEvent.getScope();
                if (scope != null && scope.getVariableContainer() != null) {
                    Variable[] variableArray;
                    VariableContainer variableContainer = scope.getVariableContainer();
                    for (Variable variable : variableArray = variableContainer.getVariables()) {
                        String string = variable.getName();
                        if (!hashMap2.containsKey(string)) continue;
                        this.addNamedToMap((BpelEntity)variable, hashMap, LazyHolder.VAR_DECL_NAME_ACCESS);
                    }
                }
                this.addErrorForNamed(hashMap, "FIX_SA00084_SA00086_SA00089");
            }

            private void checkCorellations(Collection<Activity> collection) {
                HashSet<CorrelationSet> hashSet = new HashSet<CorrelationSet>();
                boolean bl = true;
                ArrayList<Component> arrayList = new ArrayList<Component>(collection.size());
                for (Activity activity : collection) {
                    arrayList.add((Component)activity);
                    Collection<CorrelationSet> collection2 = this.getJoinedCorrelationSets(activity);
                    if (bl) {
                        bl = false;
                        hashSet.addAll(collection2);
                        continue;
                    }
                    hashSet.retainAll(collection2);
                    this.checEmptySet(hashSet, arrayList);
                }
            }

            private void checEmptySet(Set<CorrelationSet> set, Collection<Component> collection) {
                if (set.size() == 0) {
                    this.addErrorCollection("FIX_SA00057", collection);
                }
            }

            private Collection<CorrelationSet> getJoinedCorrelationSets(Activity activity) {
                if (activity.getElementType().equals(Receive.class)) {
                    Receive receive = (Receive)activity;
                    return this.getJoinedCorrelationSets(receive.getCorrelationContainer());
                }
                if (activity.getElementType().equals(Pick.class)) {
                    Pick pick = (Pick)activity;
                    OnMessage[] onMessageArray = pick.getOnMessages();
                    Collection<Object> collection = null;
                    for (OnMessage onMessage : onMessageArray) {
                        if (collection == null) {
                            collection = this.getJoinedCorrelationSets(onMessage.getCorrelationContainer());
                            continue;
                        }
                        collection.addAll(this.getJoinedCorrelationSets(onMessage.getCorrelationContainer()));
                    }
                    if (collection == null) {
                        collection = Collections.EMPTY_LIST;
                    }
                    return collection;
                }
                return Collections.EMPTY_LIST;
            }

            private void checkPropertyList(BaseCorrelation baseCorrelation, Message message) {
                BpelReference bpelReference = baseCorrelation.getSet();
                if (bpelReference == null) {
                    return;
                }
                CorrelationSet correlationSet = (CorrelationSet)bpelReference.get();
                if (correlationSet == null) {
                    return;
                }
                List list = correlationSet.getProperties();
                if (list == null) {
                    return;
                }
                for (WSDLReference wSDLReference : list) {
                    Set<PropertyAlias> set;
                    if (wSDLReference == null || (set = this.getPropertyAliases(wSDLReference.getQName(), message, baseCorrelation.getBpelModel())).size() != 0 || wSDLReference == null || wSDLReference.get() == null) continue;
                    Validator.this.addError("FIX_SA00021", (Component)baseCorrelation, ((CorrelationProperty)wSDLReference.get()).getName(), correlationSet.getName());
                }
            }

            private Set<PropertyAlias> getPropertyAliases(QName qName, Message message, BpelModel bpelModel) {
                Import[] importArray = bpelModel.getProcess().getImports();
                if (importArray.length == 0) {
                    return Collections.EMPTY_SET;
                }
                HashSet<PropertyAlias> hashSet = new HashSet<PropertyAlias>();
                for (Import import_ : importArray) {
                    this.collectPropertyAliases(qName, message, import_, hashSet);
                }
                return hashSet;
            }

            private void collectPropertyAliases(QName qName, Message message, Import import_, Set<PropertyAlias> set) {
                WSDLModel wSDLModel = ImportHelper.getWsdlModel((Import)import_);
                if (wSDLModel == null) {
                    return;
                }
                if (wSDLModel.getState() != Model.State.VALID) {
                    return;
                }
                List list = wSDLModel.getDefinitions().getExtensibilityElements(PropertyAlias.class);
                for (PropertyAlias propertyAlias : list) {
                    NamedComponentReference namedComponentReference = propertyAlias.getPropertyName();
                    if (namedComponentReference == null || qName != null && !Utils.equals((QName)namedComponentReference.getQName(), (QName)qName)) continue;
                    if (message == null) {
                        set.add(propertyAlias);
                        continue;
                    }
                    NamedComponentReference namedComponentReference2 = propertyAlias.getMessageType();
                    if (namedComponentReference2 == null || !namedComponentReference2.references((Referenceable)message)) continue;
                    set.add(propertyAlias);
                }
            }

            private Collection<CorrelationSet> getJoinedCorrelationSets(CorrelationContainer correlationContainer) {
                Correlation[] correlationArray;
                LinkedList<CorrelationSet> linkedList = new LinkedList<CorrelationSet>();
                if (correlationContainer == null) {
                    return Collections.EMPTY_LIST;
                }
                for (Correlation correlation : correlationArray = correlationContainer.getCorrelations()) {
                    BpelReference bpelReference;
                    if (!Initiate.JOIN.equals((Object)correlation.getInitiate()) || (bpelReference = correlation.getSet()) == null || bpelReference.get() == null) continue;
                    linkedList.add((CorrelationSet)bpelReference.get());
                }
                return linkedList;
            }

            private Message getInputMessage(Operation operation) {
                Input input = operation.getInput();
                if (input == null) {
                    return null;
                }
                NamedComponentReference namedComponentReference = input.getMessage();
                if (namedComponentReference == null) {
                    return null;
                }
                return (Message)namedComponentReference.get();
            }

            private Message getOutputMessage(Operation operation) {
                Output output = operation.getOutput();
                if (output == null) {
                    return null;
                }
                NamedComponentReference namedComponentReference = output.getMessage();
                if (namedComponentReference == null) {
                    return null;
                }
                return (Message)namedComponentReference.get();
            }

            private void checkInputVariable(Invoke invoke, Operation operation) {
                BpelReference bpelReference = invoke.getInputVariable();
                Message message = this.getInputMessage(operation);
                this.checkVariable(invoke, (BpelReference<VariableDeclaration>)bpelReference, message);
            }

            private void checkOutputVariable(Invoke invoke, Operation operation) {
                BpelReference bpelReference = invoke.getOutputVariable();
                Message message = this.getOutputMessage(operation);
                this.checkVariable(invoke, (BpelReference<VariableDeclaration>)bpelReference, message);
            }

            private void checkVariable(Invoke invoke, BpelReference<VariableDeclaration> bpelReference, Message message) {
                SchemaReference schemaReference;
                if (bpelReference == null) {
                    return;
                }
                VariableDeclaration variableDeclaration = (VariableDeclaration)bpelReference.get();
                if (variableDeclaration == null) {
                    return;
                }
                if (message == null) {
                    return;
                }
                WSDLReference wSDLReference = variableDeclaration.getMessageType();
                if (wSDLReference != null) {
                    if (!wSDLReference.references((Referenceable)message)) {
                        Validator.this.addError("FIX_SA00048_1", (Component)invoke);
                    }
                } else if (variableDeclaration.getElement() != null && !this.checkElementType(message, (SchemaReference<GlobalElement>)(schemaReference = variableDeclaration.getElement()))) {
                    Validator.this.addError("FIX_SA00048_2", (Component)invoke);
                }
            }

            private boolean checkElementType(Message message, SchemaReference<GlobalElement> schemaReference) {
                if (message.getParts().size() != 1) {
                    return false;
                }
                Part part = (Part)message.getParts().iterator().next();
                NamedComponentReference namedComponentReference = part.getElement();
                if (namedComponentReference == null) {
                    return false;
                }
                GlobalElement globalElement = (GlobalElement)namedComponentReference.get();
                if (globalElement == null) {
                    return false;
                }
                return schemaReference.references((Referenceable)globalElement);
            }

            private boolean isAbsentInputVaribale(Invoke invoke, Operation operation) {
                Message message = this.getInputMessage(operation);
                if (message == null) {
                    return false;
                }
                if (message.getParts().size() == 0 && invoke.getInputVariable() != null) {
                    Validator.this.addWarning("FIX_SA00047_1", (Component)invoke);
                    return false;
                }
                if (message.getParts().size() != 0 && invoke.getInputVariable() == null && (invoke.getToPartContaner() == null || invoke.getToPartContaner().sizeOfToParts() == 0)) {
                    return true;
                }
                if (message.getParts().size() == 0) {
                    return invoke.getToPartContaner() == null || invoke.getToPartContaner().sizeOfToParts() == 0;
                }
                return false;
            }

            private boolean isAbsentInputVaribale(Reply reply, Operation operation) {
                Message message = this.getInputMessage(operation);
                if (message == null) {
                    return false;
                }
                if (message.getParts().size() == 0 && reply.getVariable() != null) {
                    Validator.this.addWarning("FIX_SA00047_7", (Component)reply);
                    return false;
                }
                if (message.getParts().size() != 0 && reply.getVariable() == null && (reply.getToPartContaner() == null || reply.getToPartContaner().sizeOfToParts() == 0)) {
                    return true;
                }
                if (message.getParts().size() == 0) {
                    return reply.getToPartContaner() == null || reply.getToPartContaner().sizeOfToParts() == 0;
                }
                return false;
            }

            private boolean isAbsentOutputVaribale(Invoke invoke, Operation operation) {
                Message message = this.getOutputMessage(operation);
                if (message == null) {
                    return false;
                }
                if (message.getParts().size() == 0 && invoke.getOutputVariable() != null) {
                    Validator.this.addWarning("FIX_SA00047_3", (Component)invoke);
                    return false;
                }
                if (message.getParts().size() != 0 && invoke.getOutputVariable() == null && (invoke.getFromPartContaner() == null || invoke.getFromPartContaner().sizeOfFromParts() == 0)) {
                    return true;
                }
                if (message.getParts().size() == 0) {
                    return invoke.getFromPartContaner() == null || invoke.getFromPartContaner().sizeOfFromParts() == 0;
                }
                return false;
            }

            private boolean isAbsentOutputVaribale(Receive receive, Operation operation) {
                Message message = this.getOutputMessage(operation);
                if (message == null) {
                    return false;
                }
                if (message.getParts().size() == 0 && receive.getVariable() != null) {
                    Validator.this.addWarning("FIX_SA00047_5", (Component)receive);
                    return false;
                }
                if (message.getParts().size() != 0 && receive.getVariable() == null && (receive.getFromPartContaner() == null || receive.getFromPartContaner().sizeOfFromParts() == 0)) {
                    return true;
                }
                if (message.getParts().size() == 0) {
                    return receive.getFromPartContaner() == null || receive.getFromPartContaner().sizeOfFromParts() == 0;
                }
                return false;
            }

            private boolean checkElementInOnEvent(SchemaReference<GlobalElement> schemaReference, Operation operation) {
                GlobalElement globalElement = (GlobalElement)schemaReference.get();
                if (globalElement == null) {
                    return false;
                }
                NamedComponentReference<Message> namedComponentReference = this.getMessageRef(operation);
                if (namedComponentReference == null) {
                    return false;
                }
                Message message = (Message)namedComponentReference.get();
                if (message == null) {
                    return false;
                }
                Collection collection = message.getParts();
                if (collection.size() != 1) {
                    return false;
                }
                Part part = (Part)collection.iterator().next();
                NamedComponentReference namedComponentReference2 = part.getElement();
                if (namedComponentReference2 == null) {
                    return false;
                }
                return namedComponentReference2.references((Referenceable)globalElement);
            }

            private boolean checkMessageTypeInOnEvent(WSDLReference<Message> wSDLReference, Operation operation) {
                Message message = (Message)wSDLReference.get();
                if (message == null) {
                    return false;
                }
                NamedComponentReference<Message> namedComponentReference = this.getMessageRef(operation);
                if (namedComponentReference == null) {
                    return false;
                }
                return namedComponentReference.references((Referenceable)message);
            }

            private NamedComponentReference<Message> getMessageRef(Operation operation) {
                Input input = operation.getInput();
                if (input == null) {
                    return null;
                }
                return input.getMessage();
            }

            private Collection<Scope> getScopes(BpelContainer bpelContainer) {
                LinkedList<Scope> linkedList = new LinkedList<Scope>();
                this.collectScopes((BpelEntity)bpelContainer, linkedList);
                return linkedList;
            }

            private void collectScopes(BpelEntity bpelEntity, Collection<Scope> collection) {
                if (bpelEntity instanceof Scope) {
                    collection.add((Scope)bpelEntity);
                } else {
                    List list = bpelEntity.getChildren();
                    for (BpelEntity bpelEntity2 : list) {
                        this.collectScopes(bpelEntity2, collection);
                    }
                }
            }

            private void checkLinkSingleton(Map<Utils.Pair<Component>, Collection<Link>> map, Link link, Component component, Component component2) {
                Utils.Pair pair = new Utils.Pair((Object)component, (Object)component2);
                Collection<Link> collection = map.get(pair);
                if (collection == null) {
                    collection = new HashSet<Link>();
                    map.put((Utils.Pair<Component>)pair, collection);
                }
                if (collection.size() > 0) {
                    LinkedList<Link> linkedList = new LinkedList<Link>(collection);
                    linkedList.add(link);
                    linkedList.add((Link)component);
                    linkedList.add((Link)component2);
                    this.addErrorCollection("FIX_SA00067", linkedList);
                } else {
                    collection.add(link);
                }
            }

            private boolean checkLink(Link link, Collection<Component> collection, String string) {
                if (collection != null && collection.size() > 1) {
                    collection.add((Component)link);
                    this.addErrorCollection(string, collection);
                }
                return collection != null && collection.size() > 0;
            }

            private Collection<Activity> getInstantiableActivities(BpelContainer bpelContainer) {
                LinkedList<Activity> linkedList = new LinkedList<Activity>();
                this.collectInstantiableActivities(bpelContainer, linkedList);
                return linkedList;
            }

            private void collectInstantiableActivities(BpelContainer bpelContainer, Collection<Activity> collection) {
                List list = bpelContainer.getChildren();
                for (BpelEntity bpelEntity : list) {
                    if (bpelEntity.getElementType().equals(Receive.class) || bpelEntity.getElementType().equals(Pick.class)) {
                        TBoolean tBoolean = ((CreateInstanceActivity)bpelEntity).getCreateInstance();
                        if (!TBoolean.YES.equals((Object)tBoolean)) continue;
                        collection.add((Activity)bpelEntity);
                        continue;
                    }
                    if (!(bpelEntity instanceof BpelContainer)) continue;
                    this.collectInstantiableActivities((BpelContainer)bpelEntity, collection);
                }
            }

            private void collectLinks(BpelEntity bpelEntity, Set<Link> set, Map<Link, Collection<Component>> map, Map<Link, Collection<Component>> map2) {
                if (bpelEntity instanceof Activity) {
                    this.collectLinkInTargets((Activity)bpelEntity, set, map2);
                    this.collectLinkInSources((Activity)bpelEntity, set, map);
                }
                List list = bpelEntity.getChildren();
                for (BpelEntity bpelEntity2 : list) {
                    this.collectLinks(bpelEntity2, set, map, map2);
                }
            }

            private void collectLinkInTargets(Activity activity, Set<Link> set, Map<Link, Collection<Component>> map) {
                TargetContainer targetContainer = activity.getTargetContainer();
                if (targetContainer != null) {
                    Target[] targetArray;
                    for (Target target : targetArray = targetContainer.getTargets()) {
                        BpelReference bpelReference = target.getLink();
                        this.collectLinks(activity, set, map, (BpelReference<Link>)bpelReference);
                    }
                }
            }

            private void collectLinkInSources(Activity activity, Set<Link> set, Map<Link, Collection<Component>> map) {
                SourceContainer sourceContainer = activity.getSourceContainer();
                if (sourceContainer != null) {
                    Source[] sourceArray;
                    for (Source source : sourceArray = sourceContainer.getSources()) {
                        BpelReference bpelReference = source.getLink();
                        this.collectLinks(activity, set, map, (BpelReference<Link>)bpelReference);
                    }
                }
            }

            private void collectLinks(Activity activity, Set<Link> set, Map<Link, Collection<Component>> map, BpelReference<Link> bpelReference) {
                if (bpelReference == null) {
                    return;
                }
                Link link = (Link)bpelReference.get();
                if (set.contains(link)) {
                    Collection<Component> collection = map.get(link);
                    if (collection == null) {
                        collection = new LinkedList<Component>();
                        map.put(link, collection);
                    }
                    collection.add((Component)activity);
                }
            }

            private void checkLinkBoundaries(Link link, BpelEntity bpelEntity, BpelEntity bpelEntity2) {
                this.checkFTBoundaries(link, bpelEntity, bpelEntity2);
                this.checkRepeatableConstract(link, bpelEntity, bpelEntity2);
            }

            private void checkRepeatableConstract(Link link, BpelEntity bpelEntity, BpelEntity bpelEntity2) {
                BpelContainer bpelContainer = link.getParent().getParent();
                Class[] classArray = new Class[]{While.class, RepeatUntil.class, ForEach.class, EventHandlers.class, CompensationHandler.class};
                boolean bl = this.getContainer(bpelEntity2, bpelContainer, classArray) != null;
                boolean bl2 = this.getContainer(bpelEntity, bpelContainer, classArray) != null;
                ArrayList<Component> arrayList = new ArrayList<Component>();
                if (bl) {
                    arrayList.add((Component)bpelEntity2);
                }
                if (bl2) {
                    arrayList.add((Component)bpelEntity);
                }
                if (arrayList.size() > 0) {
                    arrayList.add((Component)link);
                    this.addErrorCollection("FIX_SA00070", arrayList);
                }
            }

            private void checkFTBoundaries(Link link, BpelEntity bpelEntity, BpelEntity bpelEntity2) {
                BpelContainer bpelContainer;
                Object object;
                BpelContainer bpelContainer2 = link.getParent().getParent();
                boolean bl = true;
                Class[] classArray = new Class[]{FaultHandlers.class, TerminationHandler.class};
                BpelContainer bpelContainer3 = this.getContainer(bpelEntity2, bpelContainer2, classArray);
                if (bpelContainer3 == null || this.hasParent(bpelEntity, bpelContainer3, bpelContainer2)) {
                    bl = false;
                }
                if (!bl && (object = this.getContainer(bpelEntity, bpelContainer2, classArray)) != null && this.hasParent(bpelEntity2, bpelContainer = object.getParent(), bpelContainer2) && !this.hasParent(bpelEntity2, (BpelContainer)object, bpelContainer2)) {
                    bl = true;
                }
                if (bl) {
                    object = new ArrayList();
                    object.add(bpelEntity2);
                    object.add(bpelEntity);
                    object.add(link);
                    this.addErrorCollection("FIX_SA00071", (Collection<Component>)object);
                }
            }

            private BpelContainer getContainer(BpelEntity bpelEntity, BpelContainer bpelContainer, Class ... classArray) {
                for (BpelContainer bpelContainer2 = bpelEntity.getParent(); bpelContainer2 != null && !bpelContainer2.equals(bpelContainer); bpelContainer2 = bpelContainer2.getParent()) {
                    for (Class clazz : classArray) {
                        if (!clazz.isAssignableFrom(bpelContainer2.getClass())) continue;
                        return bpelContainer2;
                    }
                }
                return null;
            }

            private boolean hasParent(BpelEntity bpelEntity, BpelContainer bpelContainer, BpelContainer bpelContainer2) {
                for (BpelEntity bpelEntity2 = bpelEntity; bpelEntity2 != null && bpelEntity2 != bpelContainer2; bpelEntity2 = bpelEntity2.getParent()) {
                    if (bpelEntity2 != bpelContainer) continue;
                    return true;
                }
                return false;
            }

            private ExtendableActivity findPreviouslyPerformedActivities(ExtendableActivity extendableActivity, Set<CompositeActivity> set) {
                if (!this.isAcceptableActivity(extendableActivity)) {
                    return extendableActivity;
                }
                BpelContainer bpelContainer = extendableActivity.getParent();
                if (!(bpelContainer instanceof ExtendableActivity)) {
                    return null;
                }
                if (bpelContainer instanceof ActivityHolder) {
                    return this.findPreviouslyPerformedActivities((ExtendableActivity)bpelContainer, set);
                }
                if (bpelContainer instanceof CompositeActivity) {
                    ExtendableActivity extendableActivity2 = this.findExecutableActivity((CompositeActivity)bpelContainer, extendableActivity, set);
                    if (extendableActivity2 == null) {
                        extendableActivity2 = this.findPreviouslyPerformedActivities((ExtendableActivity)bpelContainer, set);
                    }
                    return extendableActivity2;
                }
                return null;
            }

            private ExtendableActivity findExecutableActivity(CompositeActivity compositeActivity, ExtendableActivity extendableActivity, Set<CompositeActivity> set) {
                set.add(compositeActivity);
                if (compositeActivity instanceof Sequence) {
                    Sequence sequence = (Sequence)compositeActivity;
                    int n = sequence.indexOf(ExtendableActivity.class, (BpelEntity)extendableActivity);
                    return this.findExecutableActivityInSequence(sequence, n, set);
                }
                if (compositeActivity instanceof Flow) {
                    return this.findExecutableActivityInFlow((Flow)compositeActivity, extendableActivity, set);
                }
                assert (false);
                return null;
            }

            private ExtendableActivity findExecutableActivityInFlow(Flow flow, ExtendableActivity extendableActivity, Set<CompositeActivity> set) {
                Set<ExtendableActivity> set2 = this.getLogicallyPreceding(extendableActivity);
                ExtendableActivity extendableActivity2 = this.findDescendantActivity(set2);
                if (extendableActivity2 != null) {
                    return extendableActivity2;
                }
                return this.getUntargetedUnacceptableActivity((Activity)flow, set);
            }

            private ExtendableActivity getUntargetedUnacceptableActivity(Activity activity, Set<CompositeActivity> set) {
                List list = activity.getChildren(Activity.class);
                for (Activity activity2 : list) {
                    TargetContainer targetContainer;
                    if (set.contains(activity2) || (targetContainer = activity2.getTargetContainer()) != null && targetContainer.getTargets().length != 0) continue;
                    if (!this.isAcceptableActivity((ExtendableActivity)activity2)) {
                        return activity2;
                    }
                    ExtendableActivity extendableActivity = this.getUntargetedUnacceptableActivity(activity2, set);
                    if (extendableActivity == null) continue;
                    return extendableActivity;
                }
                return null;
            }

            private ExtendableActivity findDescendantActivity(Set<ExtendableActivity> set) {
                for (ExtendableActivity extendableActivity : set) {
                    ExtendableActivity extendableActivity2 = this.findDescendantActivity(extendableActivity);
                    if (extendableActivity2 == null) continue;
                    return extendableActivity2;
                }
                return null;
            }

            private Set<ExtendableActivity> getLogicallyPreceding(ExtendableActivity extendableActivity) {
                if (!(extendableActivity instanceof Activity)) {
                    return Collections.EMPTY_SET;
                }
                HashSet<ExtendableActivity> hashSet = new HashSet<ExtendableActivity>();
                this.collectPreceding((Activity)extendableActivity, hashSet);
                return hashSet;
            }

            private void collectPreceding(Activity activity, Set<ExtendableActivity> set) {
                Target[] targetArray;
                if (set.contains(activity)) {
                    return;
                }
                TargetContainer targetContainer = activity.getTargetContainer();
                if (targetContainer == null) {
                    return;
                }
                for (Target target : targetArray = targetContainer.getTargets()) {
                    BpelContainer bpelContainer;
                    Activity activity2;
                    Link link;
                    BpelReference bpelReference = target.getLink();
                    if (bpelReference == null || (link = (Link)bpelReference.get()) == null || (activity2 = this.findSource(bpelContainer = link.getParent().getParent(), link)) == null) continue;
                    set.add((ExtendableActivity)activity2);
                    this.collectPreceding(activity2, set);
                }
            }

            private Activity findSource(BpelContainer bpelContainer, Link link) {
                List list = bpelContainer.getChildren(Activity.class);
                for (Activity activity : list) {
                    Activity activity2;
                    SourceContainer sourceContainer = activity.getSourceContainer();
                    if (sourceContainer != null && this.checkSource(link, sourceContainer)) {
                        return activity;
                    }
                    if (!(activity instanceof BpelContainer) || (activity2 = this.findSource((BpelContainer)activity, link)) == null) continue;
                    return activity2;
                }
                return null;
            }

            private boolean checkSource(Link link, SourceContainer sourceContainer) {
                Source[] sourceArray;
                for (Source source : sourceArray = sourceContainer.getSources()) {
                    BpelReference bpelReference = source.getLink();
                    if (bpelReference == null || !bpelReference.references((Referenceable)link)) continue;
                    return true;
                }
                return false;
            }

            private ExtendableActivity findExecutableActivityInSequence(Sequence sequence, int n, Set<CompositeActivity> set) {
                ExtendableActivity[] extendableActivityArray = sequence.getActivities();
                for (int i = 0; i < n; ++i) {
                    ExtendableActivity extendableActivity;
                    if (set.contains(extendableActivityArray[i]) || (extendableActivity = this.findDescendantActivity(extendableActivityArray[i])) == null) continue;
                    return extendableActivity;
                }
                return null;
            }

            private ExtendableActivity findDescendantActivity(ExtendableActivity extendableActivity) {
                if (!this.isAcceptableActivity(extendableActivity)) {
                    return extendableActivity;
                }
                List list = extendableActivity.getChildren(ExtendableActivity.class);
                for (ExtendableActivity extendableActivity2 : list) {
                    ExtendableActivity extendableActivity3 = this.findDescendantActivity(extendableActivity2);
                    if (extendableActivity3 == null) continue;
                    return extendableActivity3;
                }
                return null;
            }

            private boolean isAcceptableActivity(ExtendableActivity extendableActivity) {
                if (extendableActivity instanceof CreateInstanceActivity && TBoolean.YES.equals((Object)((CreateInstanceActivity)extendableActivity).getCreateInstance())) {
                    return true;
                }
                Class clazz = extendableActivity.getElementType();
                return clazz.equals(Scope.class) || clazz.equals(Flow.class) || clazz.equals(Sequence.class) || clazz.equals(Empty.class);
            }
        };
    }

    private static interface NameAccess {
        public String getName(BpelEntity var1);
    }

    private static final class LazyHolder {
        static final NameAccess SOURCE_LINK_NAME_ACCESS = new NameAccess(){

            public String getName(BpelEntity bpelEntity) {
                BpelReference bpelReference;
                if (bpelEntity instanceof Source && (bpelReference = ((Source)bpelEntity).getLink()) != null && bpelReference.getRefString() != null) {
                    return bpelReference.getRefString();
                }
                return null;
            }
        };
        static final NameAccess TARGET_LINK_NAME_ACCESS = new NameAccess(){

            public String getName(BpelEntity bpelEntity) {
                BpelReference bpelReference;
                if (bpelEntity instanceof Target && (bpelReference = ((Target)bpelEntity).getLink()) != null && bpelReference.getRefString() != null) {
                    return bpelReference.getRefString();
                }
                return null;
            }
        };
        static final NameAccess VAR_DECL_NAME_ACCESS = new NameAccess(){

            public String getName(BpelEntity bpelEntity) {
                if (bpelEntity instanceof VariableDeclaration) {
                    return ((VariableDeclaration)bpelEntity).getVariableName();
                }
                return null;
            }
        };

        private LazyHolder() {
        }
    }

    private static class DefaultNameAccess
    implements NameAccess {
        private DefaultNameAccess() {
        }

        public String getName(BpelEntity bpelEntity) {
            if (bpelEntity instanceof NamedElement) {
                return ((NamedElement)bpelEntity).getName();
            }
            return null;
        }
    }
}

