/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.history;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.modules.db.sql.history.SQLHistory;
import org.netbeans.modules.db.sql.history.SQLHistoryPersistenceManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLHistoryManager {
    public static final String SQL_HISTORY_FOLDER = "Databases/SQLHISTORY";
    public static final String SQL_HISTORY_FILE_NAME = "sql_history";
    private static SQLHistoryManager _instance = null;
    private static final Logger LOGGER = Logger.getLogger(SQLHistory.class.getName());
    private List<SQLHistory> sqlList = new ArrayList<SQLHistory>();
    private int listSize;

    private SQLHistoryManager() {
    }

    public static SQLHistoryManager getInstance() {
        if (_instance == null) {
            _instance = new SQLHistoryManager();
        }
        return _instance;
    }

    public int getListSize() {
        return this.listSize;
    }

    public void setListSize(int n) {
        this.listSize = n;
    }

    public void saveSQL(SQLHistory sQLHistory) {
        this.sqlList.add(sQLHistory);
    }

    public void save(FileObject fileObject) {
        FileObject fileObject2 = fileObject.getFileObject(SQL_HISTORY_FOLDER);
        if (fileObject2 == null) {
            try {
                fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)SQL_HISTORY_FOLDER);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        try {
            SQLHistoryPersistenceManager.getInstance().create(fileObject2, this.sqlList);
            this.sqlList.clear();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public List<SQLHistory> getSQLHistory() {
        return this.sqlList;
    }

    public List<SQLHistory> retrieve() {
        return new ArrayList<SQLHistory>();
    }

    public List<String> retrieve(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.getUrlsUsed().isEmpty()) {
            for (SQLHistory sQLHistory : this.sqlList) {
                String string2 = sQLHistory.getSql();
                if (!string.equals(sQLHistory.getUrl())) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private List<String> getUrlsUsed() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SQLHistory sQLHistory : this.sqlList) {
            String string = sQLHistory.getUrl();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public int updateList(int n, String string, FileObject fileObject) {
        List<Object> list = new ArrayList();
        int n2 = 0;
        try {
            list = SQLHistoryPersistenceManager.getInstance().retrieve(string, fileObject);
            if (n >= list.size()) {
                return -1;
            }
            n2 = list.size() - n;
            for (int i = 0; i < n2; ++i) {
                list.remove(0);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Exceptions.printStackTrace((Throwable)classNotFoundException);
        }
        this.sqlList = list;
        return n2;
    }
}

