/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax.traversal;

import java.util.Arrays;
import java.util.HashSet;
import org.netbeans.tax.TreeCharacterData;
import org.netbeans.tax.TreeComment;
import org.netbeans.tax.TreeEntityReference;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeNodeDecl;
import org.netbeans.tax.TreeProcessingInstruction;
import org.netbeans.tax.TreeReference;
import org.netbeans.tax.traversal.Util;

public final class TreeNodeFilter {
    public static final short FILTER_ACCEPT = 0;
    public static final short FILTER_REJECT = 1;
    public static final short ACCEPT_TYPES = 10;
    public static final short REJECT_TYPES = 11;
    private Class[] nodeTypes;
    private short acceptPolicy;
    public static final TreeNodeFilter SHOW_ALL_FILTER = new TreeNodeFilter();
    public static final TreeNodeFilter SHOW_DATA_ONLY_FILTER = new TreeNodeFilter(new Class[]{TreeComment.class, TreeProcessingInstruction.class}, 11);

    public TreeNodeFilter(Class[] classArray, short s) throws IllegalArgumentException {
        for (int i = 0; i < classArray.length; ++i) {
            if (TreeNodeFilter.isValidNodeType(classArray[i])) continue;
            throw new IllegalArgumentException();
        }
        this.nodeTypes = classArray;
        this.acceptPolicy = s;
    }

    public TreeNodeFilter(Class[] classArray) {
        this(classArray, 10);
    }

    public TreeNodeFilter() {
        this(new Class[]{TreeNode.class});
    }

    public short acceptNode(TreeNode treeNode) {
        short s;
        short s2;
        if (this.acceptPolicy == 10) {
            s2 = 0;
            s = 1;
        } else {
            s2 = 1;
            s = 0;
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("+ TreeNodeFilter::acceptNode: this = " + this);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("+               ::acceptNode: node = " + treeNode);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("+               ::acceptNode: acceptPolicy = " + this.acceptPolicy);
        }
        for (int i = 0; i < this.nodeTypes.length; ++i) {
            if (!this.nodeTypes[i].isInstance(treeNode)) continue;
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("+               ::acceptNode: RETURN " + s2);
            }
            return s2;
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("+               ::acceptNode: RETURN " + s);
        }
        return s;
    }

    public boolean equals(Object object) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("-=#| TreeNodeFilter.equals");
        }
        if (!(object instanceof TreeNodeFilter)) {
            return false;
        }
        TreeNodeFilter treeNodeFilter = (TreeNodeFilter)object;
        HashSet<Class> hashSet = new HashSet<Class>(Arrays.asList(this.nodeTypes));
        HashSet<Class> hashSet2 = new HashSet<Class>(Arrays.asList(treeNodeFilter.nodeTypes));
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("-=#|    thisSet = " + hashSet);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("-=#|    peerSet = " + hashSet2);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("-=#|    acceptPolicy? " + (this.acceptPolicy == treeNodeFilter.acceptPolicy));
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("-=#|    nodeTypes   ? " + ((Object)hashSet).equals(hashSet2));
        }
        if (this.acceptPolicy != treeNodeFilter.acceptPolicy) {
            return false;
        }
        return ((Object)hashSet).equals(hashSet2);
    }

    public Class[] getNodeTypes() {
        return this.nodeTypes;
    }

    public short getAcceptPolicy() {
        return this.acceptPolicy;
    }

    public static boolean isValidNodeType(Class clazz) {
        if (TreeNode.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (TreeCharacterData.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (TreeReference.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (TreeEntityReference.class.isAssignableFrom(clazz)) {
            return true;
        }
        return TreeNodeDecl.class.isAssignableFrom(clazz);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append(" [ ");
        stringBuffer.append("acceptPolicy= [").append(this.acceptPolicy).append("] ");
        if (this.acceptPolicy == 10) {
            stringBuffer.append("ACCEPT");
        } else {
            stringBuffer.append("REJECT");
        }
        stringBuffer.append(" | nodeTypes= [");
        for (int i = 0; i < this.nodeTypes.length; ++i) {
            if (i != 0) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append(this.nodeTypes[i].getName());
        }
        stringBuffer.append("] ]");
        return stringBuffer.toString();
    }
}

