/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.instruments;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoActionObject;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.instruments.GraduatedScale;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AbstractIndicator
extends JGoDrawable
implements JGoActionObject {
    public static final int ChangedValue = 13300;
    public static final int ChangedScale = 13301;
    public static final int ChangedQuantized = 13302;
    public static final int ChangedQuantBase = 13303;
    public static final int ChangedQuantUnit = 13304;
    public static final int ChangedActionEnabled = 13305;
    private double byte = 0.0;
    private GraduatedScale for = null;
    private boolean new = false;
    private double a = 0.0;
    private double try = 1.0;
    private boolean case = false;
    private boolean int = false;
    private transient GeneralPath do = null;
    private transient JGoObject if = null;
    private transient double char = 0.0;

    protected AbstractIndicator() {
        this.setSelectable(false);
        this.setBrush(JGoBrush.red);
    }

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        AbstractIndicator abstractIndicator = (AbstractIndicator)super.copyObject(jGoCopyEnvironment);
        abstractIndicator.for = (GraduatedScale)jGoCopyEnvironment.get((Object)this.for);
        abstractIndicator.byte = this.byte;
        abstractIndicator.new = this.new;
        abstractIndicator.a = this.a;
        abstractIndicator.try = this.try;
        abstractIndicator.case = this.case;
        abstractIndicator.int = this.int;
        return abstractIndicator;
    }

    public double getValue() {
        return this.byte;
    }

    public void setValue(double d) {
        double d2 = this.byte;
        double d3 = this.validValue(d);
        if (d2 != d3) {
            this.byte = d3;
            this.resetPath();
            this.update(13300, 0, new Double(d2));
        }
    }

    public GraduatedScale getScale() {
        return this.for;
    }

    public void setScale(GraduatedScale graduatedScale) {
        GraduatedScale graduatedScale2 = this.for;
        if (graduatedScale2 != graduatedScale) {
            this.for = graduatedScale;
            this.resetPath();
            this.update(13301, 0, graduatedScale2);
        }
    }

    public double validValue(double d) {
        GraduatedScale graduatedScale = this.getScale();
        if (graduatedScale == null) {
            return d;
        }
        if (d > graduatedScale.getMaximum()) {
            d = graduatedScale.getMaximum();
        } else if (d < graduatedScale.getMinimum()) {
            d = graduatedScale.getMinimum();
        }
        d = this.quantizeValue(d);
        return d;
    }

    public boolean isQuantized() {
        return this.new;
    }

    public void setQuantized(boolean bl) {
        boolean bl2 = this.new;
        if (bl2 != bl) {
            this.new = bl;
            this.update(13302, bl2 ? 1 : 0, null);
        }
    }

    public double getQuantizeBase() {
        return this.a;
    }

    public void setQuantizeBase(double d) {
        double d2 = this.a;
        if (d2 != d) {
            this.a = d;
            this.update(13303, 0, new Double(d2));
        }
    }

    public double getQuantizeUnit() {
        return this.try;
    }

    public void setQuantizeUnit(double d) {
        double d2 = this.try;
        if (d2 != d) {
            this.try = d;
            this.update(13304, 0, new Double(d2));
        }
    }

    public double quantizeValue(double d) {
        if (!this.isQuantized()) {
            return d;
        }
        double d2 = (d - this.getQuantizeBase()) % this.getQuantizeUnit();
        if (d2 != 0.0) {
            d = d2 >= this.getQuantizeUnit() / 2.0 ? d - d2 + this.getQuantizeUnit() : (d -= d2);
            GraduatedScale graduatedScale = this.getScale();
            if (graduatedScale != null) {
                if (d > graduatedScale.getMaximum()) {
                    d -= this.getQuantizeUnit();
                } else if (d < graduatedScale.getMinimum()) {
                    d += this.getQuantizeUnit();
                }
            }
        }
        return d;
    }

    public boolean isActionEnabled() {
        return this.case;
    }

    public void setActionEnabled(boolean bl) {
        boolean bl2 = this.case;
        if (bl2 != bl) {
            this.case = bl;
            this.update(13305, bl2 ? 1 : 0, null);
        }
    }

    public boolean isActionActivated() {
        return this.int;
    }

    public void setActionActivated(boolean bl) {
        this.int = bl;
        if (this.int) {
            this.char = this.getValue();
        }
    }

    public void onActionAdjusted(JGoView jGoView, int n, Point point, Point point2, int n2) {
        if ((n & 0x10) != 0 && this.getScale() != null) {
            boolean bl = this.isSkipsUndoManager();
            this.setSkipsUndoManager(true);
            double d = this.getValueForPoint(point);
            this.setValue(d);
            this.setSkipsUndoManager(bl);
        }
    }

    public void onAction(JGoView jGoView, int n, Point point, Point point2) {
        double d = this.getValueForPoint(point);
        if (this.getValue() == d) {
            boolean bl = this.isSkipsUndoManager();
            this.setSkipsUndoManager(true);
            this.setValue(this.char);
            this.setSkipsUndoManager(bl);
        }
        if (jGoView != null) {
            jGoView.getDocument().startTransaction();
        }
        this.setValue(d);
        if (jGoView != null) {
            jGoView.getDocument().endTransaction("adjusted value");
        }
    }

    public void onActionCancelled(JGoView jGoView) {
        boolean bl = this.isSkipsUndoManager();
        this.setSkipsUndoManager(true);
        this.setValue(this.char);
        this.setSkipsUndoManager(bl);
    }

    public double getValueForPoint(Point point) {
        return this.getScale().getValueAtPoint(new Point2D.Float(point.x, point.y));
    }

    public boolean doUncapturedMouseMove(int n, Point point, Point point2, JGoView jGoView) {
        if (this.isActionEnabled()) {
            jGoView.setCursor(Cursor.getPredefinedCursor(12));
        }
        return true;
    }

    public JGoObject getPartner() {
        return this.if;
    }

    public void setPartner(JGoObject jGoObject) {
        this.if = jGoObject;
    }

    protected void geometryChange(Rectangle rectangle) {
        super.geometryChange(rectangle);
        this.resetPath();
    }

    protected void computePath(GeneralPath generalPath) {
    }

    public GeneralPath getPath() {
        if (this.do == null) {
            this.do = this.makePath();
        }
        return this.do;
    }

    protected void resetPath() {
        this.do = null;
    }

    public GeneralPath makePath() {
        GeneralPath generalPath = new GeneralPath();
        this.computePath(generalPath);
        return generalPath;
    }

    public void paint(Graphics2D graphics2D, JGoView jGoView) {
        GeneralPath generalPath = this.getPath();
        AbstractIndicator.drawPath((Graphics2D)graphics2D, (JGoPen)this.getPen(), (JGoBrush)this.getBrush(), (GeneralPath)generalPath);
    }

    public void expandRectByPenWidth(Rectangle rectangle) {
        super.expandRectByPenWidth(rectangle);
        GeneralPath generalPath = this.getPath();
        Rectangle rectangle2 = generalPath.getBounds();
        rectangle.grow(rectangle2.width, rectangle2.height);
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 13300: {
                jGoDocumentChangedEdit.setNewValueDouble(this.getValue());
                return;
            }
            case 13301: {
                jGoDocumentChangedEdit.setNewValue((Object)this.getScale());
                return;
            }
            case 13302: {
                jGoDocumentChangedEdit.setNewValueBoolean(this.isQuantized());
                return;
            }
            case 13303: {
                jGoDocumentChangedEdit.setNewValueDouble(this.getQuantizeBase());
                return;
            }
            case 13304: {
                jGoDocumentChangedEdit.setNewValueDouble(this.getQuantizeUnit());
                return;
            }
            case 13305: {
                jGoDocumentChangedEdit.setNewValueBoolean(this.isActionEnabled());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 1: {
                super.changeValue(jGoDocumentChangedEdit, bl);
                this.resetPath();
                return;
            }
            case 13300: {
                this.setValue(jGoDocumentChangedEdit.getValueDouble(bl));
                return;
            }
            case 13301: {
                this.setScale((GraduatedScale)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 13302: {
                this.setQuantized(jGoDocumentChangedEdit.getValueBoolean(bl));
                return;
            }
            case 13303: {
                this.setQuantizeBase(jGoDocumentChangedEdit.getValueDouble(bl));
                return;
            }
            case 13304: {
                this.setQuantizeUnit(jGoDocumentChangedEdit.getValueDouble(bl));
                return;
            }
            case 13305: {
                this.setActionEnabled(jGoDocumentChangedEdit.getValueBoolean(bl));
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.instruments.AbstractIndicator", domElement);
            domElement2.setAttribute("value", Double.toString(this.byte));
            domElement2.setAttribute("isquantized", this.new ? "true" : "false");
            domElement2.setAttribute("quantbase", Double.toString(this.a));
            domElement2.setAttribute("quantunit", Double.toString(this.try));
            domElement2.setAttribute("isactionenabled", this.case ? "true" : "false");
            domElement2.setAttribute("isactivated", this.int ? "true" : "false");
            if (this.for != null) {
                domDoc.registerReferencingNode(domElement2, "scale", (Object)this.for);
            }
        }
        if (domDoc.SVGOutputEnabled()) {
            this.generateSVGOutput(domDoc, domElement);
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public void generateSVGOutput(DomDoc domDoc, DomElement domElement) {
        DomElement domElement2 = domDoc.createElement("path");
        GeneralPath generalPath = this.getPath();
        AbstractIndicator.SVGAddPathArgs((DomElement)domElement2, (GeneralPath)generalPath);
        this.SVGWriteAttributes(domElement2);
        domElement.appendChild((DomNode)domElement2);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            this.byte = Double.parseDouble(domElement2.getAttribute("value"));
            this.new = domElement2.getAttribute("isquantized").equals("true");
            this.a = Double.parseDouble(domElement2.getAttribute("quantbase"));
            this.try = Double.parseDouble(domElement2.getAttribute("quantunit"));
            this.case = domElement2.getAttribute("isactionenabled").equals("true");
            this.int = domElement2.getAttribute("isactivated").equals("true");
            String string = domElement2.getAttribute("scale");
            domDoc.registerReferencingObject((Object)this, "scale", string);
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }

    public void SVGUpdateReference(String string, Object object) {
        super.SVGUpdateReference(string, object);
        if (string.equals("scale")) {
            this.setScale((GraduatedScale)object);
        }
        Point point = this.getTopLevelObject().getLocation();
        point.translate(1, 1);
        this.getTopLevelObject().setLocation(point);
        point.translate(-1, -1);
        this.getTopLevelObject().setLocation(point);
    }
}

