/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.css.gsf.AstUtils;
import org.netbeans.modules.css.gsf.CSSParserResult;
import org.netbeans.modules.css.gsf.CssAnalyser;
import org.netbeans.modules.css.parser.CssParserAccess;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.gsf.api.ColoringAttributes;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.SemanticAnalyzer;
import org.netbeans.modules.gsf.api.TranslatedSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSSemanticAnalyzer
implements SemanticAnalyzer {
    private boolean cancelled;
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights;

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void run(CompilationInfo compilationInfo) throws Exception {
        this.cancelled = false;
        if (this.cancelled) {
            return;
        }
        final HashMap<OffsetRange, Set<ColoringAttributes>> hashMap = new HashMap<OffsetRange, Set<ColoringAttributes>>();
        ParserResult parserResult = (ParserResult)compilationInfo.getEmbeddedResults("text/x-css").iterator().next();
        final TranslatedSource translatedSource = parserResult.getTranslatedSource();
        SimpleNode simpleNode = ((CSSParserResult)parserResult).root();
        if (simpleNode == null) {
            this.semanticHighlights = hashMap;
            return;
        }
        NodeVisitor nodeVisitor = new NodeVisitor(){

            public void visit(SimpleNode simpleNode) {
                OffsetRange offsetRange;
                if (simpleNode.kind() == 23 || simpleNode.kind() == 22 || simpleNode.kind() == 25 || simpleNode.kind() == 26 || simpleNode.kind() == 24) {
                    OffsetRange offsetRange2 = CSSSemanticAnalyzer.this.getOffsetRange(simpleNode.startOffset(), simpleNode.endOffset(), translatedSource);
                    int n = AstUtils.documentPosition(simpleNode.startOffset(), translatedSource);
                    int n2 = AstUtils.documentPosition(simpleNode.endOffset(), translatedSource);
                    if (!offsetRange2.isEmpty() && n2 > n) {
                        hashMap.put(offsetRange2, ColoringAttributes.METHOD_SET);
                    }
                } else if (simpleNode.kind() == 17 && !(offsetRange = CSSSemanticAnalyzer.this.getOffsetRange(simpleNode.startOffset(), simpleNode.endOffset(), translatedSource)).isEmpty()) {
                    String string = simpleNode.image().trim();
                    if (CssParserAccess.containsGeneratedCode(string)) {
                        return;
                    }
                    if (CssAnalyser.isVendorSpecificProperty(string)) {
                        hashMap.put(offsetRange, ColoringAttributes.CUSTOM2_SET);
                    } else {
                        hashMap.put(offsetRange, ColoringAttributes.CUSTOM1_SET);
                    }
                }
            }
        };
        simpleNode.visitChildren(nodeVisitor);
        this.semanticHighlights = hashMap;
    }

    private OffsetRange getOffsetRange(int n, int n2, TranslatedSource translatedSource) {
        if (translatedSource != null) {
            int n3 = n2 - n;
            if ((n = translatedSource.getLexicalOffset(n)) == -1) {
                n = 0;
            }
            n2 = n + n3;
        }
        return new OffsetRange(n, n2);
    }
}

