/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.css.lexer.api.CSSTokenId;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Formatter;
import org.openide.util.Exceptions;

public class CSSFormatter
implements Formatter {
    public boolean needsParserResult() {
        return false;
    }

    public void reformat(Document document, int n, int n2, CompilationInfo compilationInfo) {
        this.reindent(document, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindent(Document document, int n, int n2) {
        BaseDocument baseDocument = (BaseDocument)document;
        org.netbeans.editor.Formatter formatter = baseDocument.getFormatter();
        try {
            int n3 = IndentUtils.indentLevelSize((Document)document);
            int n4 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)baseDocument.getLength());
            int[] nArray = new int[n4 + 1];
            int[] nArray2 = new int[n4 + 1];
            boolean[] blArray = new boolean[n4 + 1];
            baseDocument.atomicLock();
            int n5 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            for (LanguagePath languagePath : tokenHierarchy.languagePaths()) {
                if (languagePath.innerLanguage() != CSSTokenId.language()) continue;
                for (TokenSequence tokenSequence : tokenHierarchy.tokenSequenceList(languagePath, 0, baseDocument.getLength())) {
                    int n6;
                    int n7;
                    TextBounds textBounds = this.findTokenSequenceBounds(baseDocument, tokenSequence);
                    if (textBounds.getAbsoluteEnd() < n || textBounds.getAbsoluteStart() > n2 || textBounds.getStartPos() == -1) continue;
                    if (n == n2) {
                        if (n5 == 1) {
                            return;
                        }
                        tokenSequence.move(n5);
                        while (tokenSequence.movePrevious()) {
                            Token token = tokenSequence.token();
                            if (token.id() == CSSTokenId.IDENT || token.id() == CSSTokenId.RBRACE) {
                                n7 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)token.offset(tokenHierarchy));
                                formatter.changeRowIndent(baseDocument, n5, n7);
                                return;
                            }
                            if (token.id() != CSSTokenId.LBRACE) continue;
                            n7 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)token.offset(tokenHierarchy));
                            formatter.changeRowIndent(baseDocument, n5, n7 + n3);
                            return;
                        }
                        continue;
                    }
                    int n8 = textBounds.getStartLine();
                    n7 = textBounds.getEndLine();
                    int n9 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)textBounds.getStartPos());
                    for (n6 = n8; n6 <= n7; ++n6) {
                        nArray2[n6] = n9;
                        blArray[n6] = true;
                    }
                    n6 = 0;
                    for (int i = n8; i <= n7; ++i) {
                        Token[] tokenArray;
                        int n10 = i;
                        if (n10 == 0 && (tokenArray = this.findRule(tokenSequence, n5)) != null) {
                            n6 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)tokenArray[0].offset(tokenHierarchy));
                            n6 += n3;
                        }
                        int n11 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)i);
                        int n12 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n11);
                        tokenSequence.move(n11);
                        int n13 = -1;
                        int n14 = -1;
                        int n15 = -1;
                        while (tokenSequence.moveNext() && tokenSequence.offset() < n12) {
                            Token token = tokenSequence.token();
                            if (token.id() == CSSTokenId.LBRACE) {
                                n13 = tokenSequence.offset();
                                continue;
                            }
                            if (token.id() == CSSTokenId.RBRACE) {
                                n14 = tokenSequence.offset();
                                continue;
                            }
                            if (token.id() != CSSTokenId.IDENT) continue;
                            n15 = tokenSequence.offset();
                        }
                        if (n13 != -1 && n14 == -1) {
                            nArray[n10] = n6;
                            n6 += n3;
                            continue;
                        }
                        if (n13 == -1 && n14 != -1) {
                            if (n15 != -1 && n15 < n14) {
                                nArray[n10] = n6;
                                n6 -= n3;
                                continue;
                            }
                            nArray[n10] = n6 -= n3;
                            continue;
                        }
                        nArray[n10] = n6;
                    }
                }
            }
            int n16 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n);
            int n17 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n2);
            for (int i = n16; i <= n17; ++i) {
                if (!blArray[i]) continue;
                int n18 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)i);
                formatter.changeRowIndent(baseDocument, n18, nArray[i] + nArray2[i]);
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        finally {
            baseDocument.atomicUnlock();
        }
    }

    private Token[] findRule(TokenSequence tokenSequence, int n) {
        tokenSequence.move(n);
        while (tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            if (token.id() == CSSTokenId.RBRACE) {
                return null;
            }
            if (token.id() != CSSTokenId.LBRACE) continue;
            while (tokenSequence.moveNext()) {
                Token token2 = tokenSequence.token();
                if (token2.id() != CSSTokenId.RBRACE) continue;
                return new Token[]{token, token2};
            }
            break block0;
        }
        return null;
    }

    public int indentSize() {
        return 4;
    }

    public int hangingIndentSize() {
        return 4;
    }

    private TextBounds findTokenSequenceBounds(BaseDocument baseDocument, TokenSequence tokenSequence) throws BadLocationException {
        tokenSequence.moveStart();
        if (!tokenSequence.moveNext()) {
            return new TextBounds(0, 0);
        }
        int n = tokenSequence.offset();
        tokenSequence.moveEnd();
        tokenSequence.movePrevious();
        int n2 = tokenSequence.offset() + tokenSequence.token().length();
        while (this.isWSToken(tokenSequence.token())) {
            if (tokenSequence.movePrevious()) continue;
            return new TextBounds(n, n2);
        }
        int n3 = 0;
        while (Character.isWhitespace(tokenSequence.token().text().charAt(tokenSequence.token().length() - 1 - n3))) {
            ++n3;
        }
        int n4 = tokenSequence.offset() + tokenSequence.token().length() - n3;
        tokenSequence.moveStart();
        do {
            tokenSequence.moveNext();
        } while (this.isWSToken(tokenSequence.token()));
        int n5 = 0;
        while (Character.isWhitespace(tokenSequence.token().text().charAt(n5))) {
            ++n5;
        }
        int n6 = tokenSequence.offset() + n5;
        int n7 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n6);
        int n8 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n4);
        return new TextBounds(n, n2, n6, n4, n7, n8);
    }

    protected boolean isWSToken(Token token) {
        return this.isOnlyWhiteSpaces(token.text());
    }

    protected boolean isOnlyWhiteSpaces(CharSequence charSequence) {
        for (int i = 0; i < charSequence.length(); ++i) {
            if (Character.isWhitespace(charSequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static class TextBounds {
        private int absoluteStart;
        private int absoluteEnd;
        private int startPos = -1;
        private int endPos = -1;
        private int startLine = -1;
        private int endLine = -1;

        public TextBounds(int n, int n2) {
            this.absoluteStart = n;
            this.absoluteEnd = n2;
        }

        public TextBounds(int n, int n2, int n3, int n4, int n5, int n6) {
            this.absoluteStart = n;
            this.absoluteEnd = n2;
            this.startPos = n3;
            this.endPos = n4;
            this.startLine = n5;
            this.endLine = n6;
        }

        public int getEndPos() {
            return this.endPos;
        }

        public int getStartPos() {
            return this.startPos;
        }

        public int getEndLine() {
            return this.endLine;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public int getAbsoluteEnd() {
            return this.absoluteEnd;
        }

        public int getAbsoluteStart() {
            return this.absoluteStart;
        }

        public String toString() {
            return "pos " + this.startPos + "-" + this.endPos + ", lines " + this.startLine + "-" + this.endLine;
        }
    }
}

