/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core.wizard;

import java.awt.Dialog;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.wizard.EclipseWizardIterator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectImporterWizard {
    private List<EclipseProject> projects;
    private String destination;
    private boolean recursively;
    private boolean cancelled;
    private int numberOfImportedProjects;
    private List<WizardDescriptor.Panel<WizardDescriptor>> extraPanels;

    public void start() {
        final EclipseWizardIterator eclipseWizardIterator = new EclipseWizardIterator();
        final WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)eclipseWizardIterator);
        eclipseWizardIterator.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)eclipseWizardIterator.getErrorMessage());
            }
        });
        wizardDescriptor.setTitleFormat(new MessageFormat("{1}"));
        wizardDescriptor.setTitle(ProjectImporterWizard.getMessage("CTL_WizardTitle"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl = this.cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!this.cancelled) {
            this.projects = eclipseWizardIterator.getProjects();
            this.destination = eclipseWizardIterator.getDestination();
            this.recursively = eclipseWizardIterator.getRecursively();
            this.numberOfImportedProjects = eclipseWizardIterator.getNumberOfImportedProject();
            this.extraPanels = eclipseWizardIterator.getExtraPanels();
        }
    }

    public List<EclipseProject> getProjects() {
        return this.projects;
    }

    public int getNumberOfImportedProject() {
        return this.numberOfImportedProjects;
    }

    public String getDestination() {
        return this.destination;
    }

    public boolean getRecursively() {
        return this.recursively;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    static String getMessage(String string) {
        return NbBundle.getMessage(ProjectImporterWizard.class, (String)string);
    }

    static String getMessage(String string, Object object) {
        return NbBundle.getMessage(ProjectImporterWizard.class, (String)string, (Object)object);
    }

    public List<WizardDescriptor.Panel<WizardDescriptor>> getExtraPanels() {
        return this.extraPanels;
    }
}

