/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core.spi;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.modules.projectimport.eclipse.core.ClassPathContainerResolver;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProjectReference;
import org.netbeans.modules.projectimport.eclipse.core.EclipseUtils;
import org.netbeans.modules.projectimport.eclipse.core.spi.DotClassPathEntry;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectImportModel;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectFactorySupport {
    private static final Logger LOG = Logger.getLogger(ProjectFactorySupport.class.getName());

    public static void updateProjectClassPath(AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, ProjectImportModel projectImportModel, List<String> list) throws IOException {
        if (projectImportModel.getEclipseSourceRoots().size() == 0) {
            list.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_NoSourceRootsFound"));
            return;
        }
        FileObject fileObject = FileUtil.toFileObject((File)projectImportModel.getEclipseSourceRootsAsFileArray()[0]);
        for (DotClassPathEntry dotClassPathEntry : projectImportModel.getEclipseClassPathEntries()) {
            ProjectFactorySupport.addItemToClassPath(antProjectHelper, referenceHelper, dotClassPathEntry, projectImportModel, list, fileObject);
        }
    }

    public static String synchronizeProjectClassPath(Project project, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, ProjectImportModel projectImportModel, String string, String string2, List<String> list) throws IOException {
        String string3;
        if (projectImportModel.getEclipseSourceRoots().size() == 0) {
            list.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_NoSourceRootsFound"));
            return string;
        }
        FileObject fileObject = FileUtil.toFileObject((File)projectImportModel.getEclipseSourceRootsAsFileArray()[0]);
        String string4 = string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (string3.startsWith("src") || string3.startsWith("output") || string3.startsWith("jre") || string.contains(string3)) continue;
            DotClassPathEntry dotClassPathEntry = ProjectFactorySupport.findEntryByEncodedValue(projectImportModel.getEclipseClassPathEntries(), string3);
            ProjectFactorySupport.addItemToClassPath(antProjectHelper, referenceHelper, dotClassPathEntry, projectImportModel, list, fileObject);
            if (!Boolean.FALSE.equals(dotClassPathEntry.getImportSuccessful())) continue;
            string4 = string4.replace(string3 + ";", "");
        }
        stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (string3.startsWith("src") || string3.startsWith("output") || string3.startsWith("jre") || string2.contains(string3) || ProjectFactorySupport.removeOldItemFromClassPath(project, antProjectHelper, string3.substring(0, string3.indexOf("=")), string3.substring(string3.indexOf("=") + 1), list, fileObject, projectImportModel.getEclipseProjectFolder())) continue;
            string4 = string4 + string3 + ";";
        }
        return string4;
    }

    public static void updateSourceRootLabels(List<DotClassPathEntry> list, SourceRoots sourceRoots) {
        URL[] uRLArray = sourceRoots.getRootURLs();
        String[] stringArray = new String[uRLArray.length];
        block2: for (int i = 0; i < uRLArray.length; ++i) {
            for (DotClassPathEntry dotClassPathEntry : list) {
                String string;
                try {
                    string = new File(uRLArray[i].toURI()).getPath();
                }
                catch (URISyntaxException uRISyntaxException) {
                    LOG.info("cannot convert '" + uRLArray[i].toExternalForm() + "' to file: " + uRISyntaxException.toString());
                    continue;
                }
                if (string.endsWith("/") || string.endsWith("\\")) {
                    string = string.substring(0, string.length() - 1);
                }
                if (!string.equals(dotClassPathEntry.getAbsolutePath())) continue;
                stringArray[i] = dotClassPathEntry.getRawPath();
                continue block2;
            }
        }
        sourceRoots.putRoots(uRLArray, stringArray);
    }

    public static String calculateKey(ProjectImportModel projectImportModel) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<DotClassPathEntry> arrayList = new ArrayList<DotClassPathEntry>();
        arrayList.addAll(projectImportModel.getEclipseSourceRoots());
        arrayList.addAll(projectImportModel.getEclipseTestSourceRoots());
        arrayList.addAll(projectImportModel.getEclipseClassPathEntries());
        for (DotClassPathEntry dotClassPathEntry : arrayList) {
            String string;
            if (dotClassPathEntry.getImportSuccessful() != null && !dotClassPathEntry.getImportSuccessful().booleanValue() || (string = ProjectFactorySupport.encodeDotClassPathEntryToKey(dotClassPathEntry)) == null) continue;
            stringBuffer.append(string);
            stringBuffer.append(";");
        }
        if (projectImportModel.getJavaPlatform() != null) {
            stringBuffer.append("jre=" + projectImportModel.getJavaPlatform().getDisplayName() + ";");
        }
        if (projectImportModel.getOutput() != null) {
            stringBuffer.append("output=" + projectImportModel.getOutput().getRawPath() + ";");
        }
        return stringBuffer.toString().replace("con=;", "");
    }

    private static String encodeDotClassPathEntryToKey(DotClassPathEntry dotClassPathEntry) {
        if (ClassPathContainerResolver.isJUnit(dotClassPathEntry)) {
            return null;
        }
        String string = ProjectFactorySupport.getValueTag(dotClassPathEntry);
        if (string == null || string.length() == 0) {
            return null;
        }
        return ProjectFactorySupport.getKindTag(dotClassPathEntry.getKind()) + "=" + string;
    }

    private static String getKindTag(DotClassPathEntry.Kind kind) {
        switch (kind) {
            case PROJECT: {
                return "prj";
            }
            case LIBRARY: {
                return "file";
            }
            case VARIABLE: {
                return "var";
            }
            case CONTAINER: {
                return "ant";
            }
            case OUTPUT: {
                return "out";
            }
        }
        return "src";
    }

    private static String getValueTag(DotClassPathEntry dotClassPathEntry) {
        switch (dotClassPathEntry.getKind()) {
            case PROJECT: {
                return dotClassPathEntry.getRawPath().substring(1);
            }
            case VARIABLE: {
                String[] stringArray = EclipseUtils.splitVariable(dotClassPathEntry.getRawPath());
                return PropertyUtils.getUsablePropertyName((String)stringArray[0]) + stringArray[1];
            }
            case CONTAINER: {
                return dotClassPathEntry.getContainerMapping();
            }
        }
        return dotClassPathEntry.getRawPath();
    }

    private static boolean addItemToClassPath(AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, DotClassPathEntry dotClassPathEntry, ProjectImportModel projectImportModel, List<String> list, FileObject fileObject) throws IOException {
        String string;
        if (ClassPathContainerResolver.isJUnit(dotClassPathEntry) && (projectImportModel.getEclipseSourceRoots().size() != 1 || projectImportModel.getEclipseTestSourceRoots().size() != 0)) {
            return true;
        }
        if (dotClassPathEntry.getKind() == DotClassPathEntry.Kind.PROJECT) {
            EclipseProject eclipseProject;
            Project object2 = null;
            for (Project object3 : projectImportModel.getAlreadyImportedProjects()) {
                if (!dotClassPathEntry.getRawPath().substring(1).equals(((ProjectInformation)object3.getLookup().lookup(ProjectInformation.class)).getDisplayName())) continue;
                object2 = object3;
                break;
            }
            if (object2 == null) {
                for (Project project : OpenProjects.getDefault().getOpenProjects()) {
                    if (!dotClassPathEntry.getRawPath().substring(1).equals(((ProjectInformation)project.getLookup().lookup(ProjectInformation.class)).getDisplayName())) continue;
                    object2 = project;
                    break;
                }
            }
            if (object2 == null) {
                list.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_RequiredProjectNotFound", (Object)dotClassPathEntry.getRawPath().substring(1)));
                dotClassPathEntry.setImportSuccessful(Boolean.FALSE);
                return false;
            }
            Project[] projectArray = AntArtifactQuery.findArtifactsByType(object2, (String)"jar");
            ArrayList<URI> arrayList = new ArrayList<URI>();
            for (Project project : projectArray) {
                arrayList.addAll(Arrays.asList(project.getArtifactLocations()));
            }
            if (projectArray.length == 0) {
                list.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_RequiredProjectHasNoArtifacts", (Object)object2.getProjectDirectory()));
                dotClassPathEntry.setImportSuccessful(Boolean.FALSE);
                return false;
            }
            ProjectClassPathModifier.addAntArtifacts((AntArtifact[])projectArray, (URI[])arrayList.toArray(new URI[arrayList.size()]), (FileObject)fileObject, (String)"classpath/compile");
            EclipseProjectReference eclipseProjectReference = EclipseProjectReference.read(object2);
            if (eclipseProjectReference != null && (eclipseProject = eclipseProjectReference.getEclipseProject(false)) != null) {
                for (DotClassPathEntry dotClassPathEntry2 : eclipseProject.getClassPathEntries()) {
                    boolean bl;
                    if (!dotClassPathEntry2.isExported() || (bl = ProjectFactorySupport.addItemToClassPath(antProjectHelper, referenceHelper, dotClassPathEntry2, projectImportModel, list, fileObject))) continue;
                    list.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_TransitiveExportCannotBeResolved", (Object)dotClassPathEntry2.getRawPath()));
                    dotClassPathEntry.setImportSuccessful(Boolean.FALSE);
                    return false;
                }
            }
            dotClassPathEntry.setImportSuccessful(Boolean.TRUE);
        } else if (dotClassPathEntry.getKind() == DotClassPathEntry.Kind.LIBRARY) {
            File file = new File(dotClassPathEntry.getAbsolutePath());
            if (!file.exists()) {
                list.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_MissingClasspathEntry", (Object)file.getPath()));
            }
            try {
                ProjectClassPathModifier.addRoots((URL[])new URL[]{FileUtil.urlForArchiveOrDir((File)file)}, (FileObject)fileObject, (String)"classpath/compile");
                dotClassPathEntry.setImportSuccessful(Boolean.TRUE);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                list.add(unsupportedOperationException.getMessage());
                dotClassPathEntry.setImportSuccessful(false);
            }
            ProjectFactorySupport.updateSourceAndJavadoc(antProjectHelper, file, null, dotClassPathEntry, false);
        } else if (dotClassPathEntry.getKind() == DotClassPathEntry.Kind.VARIABLE) {
            String string2 = ProjectFactorySupport.createFileReference(antProjectHelper, referenceHelper, dotClassPathEntry);
            ProjectFactorySupport.addToBuildProperties(antProjectHelper, "javac.classpath", string2);
            ProjectFactorySupport.testProperty(string2, antProjectHelper, list);
            ProjectFactorySupport.updateSourceAndJavadoc(antProjectHelper, null, string2, dotClassPathEntry, false);
            dotClassPathEntry.setImportSuccessful(Boolean.TRUE);
        } else if (dotClassPathEntry.getKind() == DotClassPathEntry.Kind.CONTAINER && (string = dotClassPathEntry.getContainerMapping()) != null && string.length() > 0) {
            String string3 = "${" + string + "}";
            ProjectFactorySupport.addToBuildProperties(antProjectHelper, "javac.classpath", string3);
            ProjectFactorySupport.testProperty(string3, antProjectHelper, list);
            dotClassPathEntry.setImportSuccessful(Boolean.TRUE);
        }
        return true;
    }

    private static void testProperty(String string, AntProjectHelper antProjectHelper, List<String> list) {
        String[] stringArray;
        String string2 = antProjectHelper.getStandardPropertyEvaluator().evaluate(string);
        if (string2.contains("${")) {
            list.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_CannotResolveClasspathEntry", (Object)string));
            return;
        }
        for (String string3 : stringArray = PropertyUtils.tokenizePath((String)string2)) {
            File file = new File(string3);
            if (file.exists()) continue;
            list.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_ClasspathEntryDoesNotExist", (Object)string3));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean removeOldItemFromClassPath(Project project, AntProjectHelper antProjectHelper, String string, String string2, List<String> list, FileObject fileObject, File file) throws IOException {
        if ("prj".equals(string)) {
            SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
            if (subprojectProvider == null) throw new IllegalStateException("project " + project.getProjectDirectory() + " does not have SubprojectProvider in its lookup");
            boolean bl = false;
            for (Project project2 : subprojectProvider.getSubprojects()) {
                ProjectInformation projectInformation = (ProjectInformation)project2.getLookup().lookup(ProjectInformation.class);
                if (!projectInformation.getDisplayName().equals(string2)) continue;
                AntArtifact[] antArtifactArray = AntArtifactQuery.findArtifactsByType((Project)project2, (String)"jar");
                ArrayList<URI> arrayList = new ArrayList<URI>();
                for (AntArtifact antArtifact : antArtifactArray) {
                    arrayList.addAll(Arrays.asList(antArtifact.getArtifactLocations()));
                }
                boolean bl2 = ProjectClassPathModifier.removeAntArtifacts((AntArtifact[])antArtifactArray, (URI[])arrayList.toArray(new URI[arrayList.size()]), (FileObject)fileObject, (String)"classpath/compile");
                if (bl2) return true;
                list.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_CannotRemoveReference", (Object)string2));
                return false;
            }
            if (bl) return true;
            list.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_ReferenceToProjectNotFound", (Object)string2));
            return false;
        }
        if ("file".equals(string)) {
            File file2 = new File(string2);
            if (!file2.isAbsolute()) {
                file2 = new File(file, string2);
            }
            ProjectFactorySupport.updateSourceAndJavadoc(antProjectHelper, file2, null, null, true);
            boolean bl = ProjectClassPathModifier.removeRoots((URL[])new URL[]{FileUtil.urlForArchiveOrDir((File)file2)}, (FileObject)fileObject, (String)"classpath/compile");
            if (bl) return true;
            list.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_ReferenceNotRemoved", (Object)string2));
            return false;
        }
        if ("var".equals(string)) {
            String[] stringArray = EclipseUtils.splitVariable(string2);
            String string3 = ProjectFactorySupport.findFileReference(antProjectHelper, "${var." + stringArray[0] + "}" + stringArray[1]);
            ProjectFactorySupport.updateSourceAndJavadoc(antProjectHelper, null, string3, null, true);
            boolean bl = ProjectFactorySupport.removeFromBuildProperties(antProjectHelper, "javac.classpath", string3);
            if (bl) return true;
            list.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_VariableReferenceNotRemoved", (Object)string2));
            return false;
        }
        if (!"ant".equals(string)) return true;
        boolean bl = ProjectFactorySupport.removeFromBuildProperties(antProjectHelper, "javac.classpath", "${" + string2 + "}");
        if (bl) return true;
        list.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_ContainerReferenceNotRemoved", (Object)string2));
        return false;
    }

    private static String createFileReference(AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, DotClassPathEntry dotClassPathEntry) {
        String string = dotClassPathEntry.getAbsolutePath();
        if (string == null) {
            string = dotClassPathEntry.getRawPath();
        }
        String string2 = referenceHelper.createForeignFileReferenceAsIs(string, null);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        editableProperties.setProperty(CommonProjectUtils.getAntPropertyName((String)string2), ProjectFactorySupport.asAntVariable(dotClassPathEntry));
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        return string2;
    }

    private static String findFileReference(AntProjectHelper antProjectHelper, String string) {
        for (Map.Entry entry : antProjectHelper.getProperties("nbproject/project.properties").entrySet()) {
            if (!string.equals(entry.getValue())) continue;
            return "${" + (String)entry.getKey() + "}";
        }
        return string;
    }

    private static void addToBuildProperties(AntProjectHelper antProjectHelper, String string, String string2) {
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        String string3 = editableProperties.getProperty(string);
        string3 = string3 == null ? "" : string3 + ":";
        string3 = string3 + string2;
        String[] stringArray = PropertyUtils.tokenizePath((String)string3);
        int n = 0;
        while (n < stringArray.length - 1) {
            int n2 = n++;
            stringArray[n2] = stringArray[n2] + ":";
        }
        editableProperties.setProperty(string, stringArray);
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
    }

    private static boolean removeFromBuildProperties(AntProjectHelper antProjectHelper, String string, String string2) {
        String string3;
        boolean bl = true;
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        String string4 = string3 = editableProperties.getProperty(string);
        if (string3 != null && string2 != null) {
            string3 = string3.replace(string2, "");
        }
        if (string3.equals(string4)) {
            bl = false;
        }
        String[] stringArray = PropertyUtils.tokenizePath((String)string3);
        int n = 0;
        while (n < stringArray.length - 1) {
            int n2 = n++;
            stringArray[n2] = stringArray[n2] + ":";
        }
        editableProperties.setProperty(string, stringArray);
        if (string2.startsWith("${file.reference.") && ProjectFactorySupport.isLastReference(editableProperties, CommonProjectUtils.getAntPropertyName((String)string2))) {
            editableProperties.remove((Object)CommonProjectUtils.getAntPropertyName((String)string2));
        }
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        return bl;
    }

    private static boolean isLastReference(EditableProperties editableProperties, String string) {
        for (String string2 : editableProperties.values()) {
            if (!string.equals(string2)) continue;
            return false;
        }
        return true;
    }

    private static DotClassPathEntry findEntryByEncodedValue(List<DotClassPathEntry> list, String string) {
        for (DotClassPathEntry dotClassPathEntry : list) {
            if (!string.equals(ProjectFactorySupport.encodeDotClassPathEntryToKey(dotClassPathEntry))) continue;
            return dotClassPathEntry;
        }
        throw new IllegalStateException("cannot find entry '" + string + "' in " + list);
    }

    private static String asAntVariable(DotClassPathEntry dotClassPathEntry) {
        if (dotClassPathEntry.getKind() != DotClassPathEntry.Kind.VARIABLE) {
            throw new IllegalStateException("not a VARIABLE entry " + dotClassPathEntry);
        }
        String[] stringArray = EclipseUtils.splitVariable(dotClassPathEntry.getRawPath());
        String string = PropertyUtils.getUsablePropertyName((String)stringArray[0]);
        return "${var." + string + "}" + stringArray[1];
    }

    private static void updateSourceAndJavadoc(AntProjectHelper antProjectHelper, File file, String string, DotClassPathEntry dotClassPathEntry, boolean bl) {
        if (!bl && dotClassPathEntry.getProperty("javadoc_location") == null && dotClassPathEntry.getProperty("sourcepath") == null) {
            return;
        }
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        if (string == null && (string = ProjectFactorySupport.findReferenceName(antProjectHelper, editableProperties, file)) == null) {
            return;
        }
        if (!(string = CommonProjectUtils.getAntPropertyName((String)string)).startsWith("file.reference")) {
            return;
        }
        String string2 = string.substring(15);
        if (bl) {
            editableProperties.remove((Object)("javadoc.reference." + string2));
            editableProperties.remove((Object)("source.reference." + string2));
        } else {
            if (dotClassPathEntry.getProperty("javadoc_location") != null) {
                editableProperties.put("javadoc.reference." + string2, ProjectFactorySupport.makeRelative(antProjectHelper, dotClassPathEntry.getProperty("javadoc_location")));
            }
            if (dotClassPathEntry.getProperty("sourcepath") != null) {
                editableProperties.put("source.reference." + string2, ProjectFactorySupport.makeRelative(antProjectHelper, dotClassPathEntry.getProperty("sourcepath")));
            }
        }
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
    }

    private static String findReferenceName(AntProjectHelper antProjectHelper, EditableProperties editableProperties, File file) {
        for (Map.Entry entry : editableProperties.entrySet()) {
            File file2;
            String string;
            if (!((String)entry.getKey()).startsWith("file.reference.") || (string = (String)entry.getValue()) == null || !file.equals(file2 = antProjectHelper.resolveFile(string))) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    private static String makeRelative(AntProjectHelper antProjectHelper, String string) {
        String string2;
        File file = new File(string);
        if (!file.isAbsolute()) {
            return string;
        }
        File file2 = FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory());
        if (CollocationQuery.areCollocated((File)file, (File)file2) && (string2 = PropertyUtils.relativizeFile((File)file2, (File)file)) != null) {
            return string2;
        }
        return string;
    }

    public static void setupSourceExcludes(AntProjectHelper antProjectHelper, ProjectImportModel projectImportModel, List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        int n2 = 0;
        for (DotClassPathEntry dotClassPathEntry : projectImportModel.getEclipseSourceRoots()) {
            String string = dotClassPathEntry.getProperty("excluding");
            if (string != null) {
                if (string.contains("**/*.java")) {
                    list.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_ExcludesWarning1"));
                    continue;
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(string.replace('|', ','));
                ++n;
            }
            if ((string = dotClassPathEntry.getProperty("including")) == null) continue;
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(",");
            }
            stringBuffer2.append(string.replace('|', ','));
            ++n2;
        }
        if (n > 1 || n2 > 1) {
            list.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_ExcludesWarning2"));
        }
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        boolean bl = false;
        if (stringBuffer.length() > 0) {
            bl = true;
            editableProperties.setProperty("excludes", stringBuffer.toString());
        }
        if (stringBuffer2.length() > 0) {
            bl = true;
            editableProperties.setProperty("includes", stringBuffer2.toString());
        }
        if (bl) {
            antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        }
    }

    public static boolean areSourceRootsOwned(ProjectImportModel projectImportModel, List<String> list) {
        for (File file : projectImportModel.getEclipseSourceRootsAsFileArray()) {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project == null) continue;
            list.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_SourceRootOwned", (Object)projectImportModel.getProjectName(), (Object)file.getPath(), (Object)project.getProjectDirectory().getPath()));
            return true;
        }
        return false;
    }
}

