/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.EclipseUtils;
import org.netbeans.modules.projectimport.eclipse.core.PreferredVMParser;
import org.netbeans.modules.projectimport.eclipse.core.ProjectFactory;
import org.netbeans.modules.projectimport.eclipse.core.ProjectImporterException;
import org.netbeans.modules.projectimport.eclipse.core.UserLibraryParser;
import org.netbeans.modules.projectimport.eclipse.core.Util;
import org.netbeans.modules.projectimport.eclipse.core.Workspace;
import org.netbeans.modules.projectimport.eclipse.core.spi.LaunchConfiguration;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WorkspaceParser {
    private static final Logger logger = Logger.getLogger(WorkspaceParser.class.getName());
    private static final String VM_XML = "org.eclipse.jdt.launching.PREF_VM_XML";
    private static final String IGNORED_CP_ENTRY = "##<cp entry ignore>##";
    private static final String VARIABLE_PREFIX = "org.eclipse.jdt.core.classpathVariable.";
    private static final int VARIABLE_PREFIX_LENGTH = "org.eclipse.jdt.core.classpathVariable.".length();
    private static final String RESOURCES_VARIABLE_PREFIX = "pathvariable.";
    private static final int RESOURCES_VARIABLE_PREFIX_LENGTH = "pathvariable.".length();
    private static final String USER_LIBRARY_PREFIX = "org.eclipse.jdt.core.userLibrary.";
    private static final int USER_LIBRARY_PREFIX_LENGTH = "org.eclipse.jdt.core.userLibrary.".length();
    private static final String JSF_LIB_NS = "http://www.eclipse.org/webtools/jsf/schema/jsflibraryregistry.xsd";
    private final Workspace workspace;

    WorkspaceParser(Workspace workspace) {
        this.workspace = workspace;
    }

    void parse() throws ProjectImporterException {
        try {
            this.parseLaunchingPreferences();
            this.parseCorePreferences();
            this.parseResourcesPreferences();
            this.parseWorkspaceProjects();
            this.parseJSFLibraryRegistryV2();
            this.parseLaunchConfigurations();
        }
        catch (IOException iOException) {
            throw new ProjectImporterException("Cannot load workspace properties", iOException);
        }
    }

    private void parseLaunchingPreferences() throws IOException, ProjectImporterException {
        if (!this.workspace.getLaunchingPrefsFile().exists()) {
            this.workspace.setJREContainers(new HashMap<String, String>());
            return;
        }
        for (Map.Entry<String, String> entry : EclipseUtils.loadProperties(this.workspace.getLaunchingPrefsFile()).entrySet()) {
            if (!entry.getKey().equals(VM_XML)) continue;
            Map<String, String> map = PreferredVMParser.parse(entry.getValue());
            this.workspace.setJREContainers(map);
        }
    }

    private void parseCorePreferences() throws IOException, ProjectImporterException {
        for (Map.Entry<String, String> entry : EclipseUtils.loadProperties(this.workspace.getCorePreferenceFile()).entrySet()) {
            Object object;
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (string.startsWith(VARIABLE_PREFIX)) {
                object = new Workspace.Variable(string.substring(VARIABLE_PREFIX_LENGTH), string2);
                this.workspace.addVariable((Workspace.Variable)object);
                continue;
            }
            if (!string.startsWith(USER_LIBRARY_PREFIX) || string2.startsWith(IGNORED_CP_ENTRY)) continue;
            object = string.substring(USER_LIBRARY_PREFIX_LENGTH);
            this.workspace.addUserLibrary((String)object, UserLibraryParser.getJars(string2));
        }
    }

    void parseJSFLibraryRegistryV2() throws IOException {
        Document document;
        if (!this.workspace.getUserJSFLibraries().exists()) {
            return;
        }
        try {
            document = XMLUtil.parse((InputSource)new InputSource(this.workspace.getUserJSFLibraries().toURI().toString()), (boolean)false, (boolean)true, (ErrorHandler)Util.defaultErrorHandler(), null);
        }
        catch (SAXException sAXException) {
            IOException iOException = (IOException)new IOException(this.workspace.getUserJSFLibraries() + ": " + sAXException.toString()).initCause(sAXException);
            throw iOException;
        }
        Element element = document.getDocumentElement();
        if (!"JSFLibraryRegistry".equals(element.getLocalName()) || !JSF_LIB_NS.equals(element.getNamespaceURI())) {
            return;
        }
        for (Element element2 : Util.findSubElements(element)) {
            String string = element2.getAttribute("Name");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Element element3 : Util.findSubElements(element2)) {
                String string2 = element3.getAttribute("SourceLocation");
                if (!"false".equals(element3.getAttribute("RelativeToWorkspace"))) {
                    string2 = new File(this.workspace.getDirectory(), string2).getPath();
                }
                arrayList.add(string2);
            }
            this.workspace.addUserLibrary(string, arrayList);
        }
    }

    private void parseResourcesPreferences() throws IOException, ProjectImporterException {
        if (!this.workspace.getResourcesPreferenceFile().exists()) {
            return;
        }
        for (Map.Entry<String, String> entry : EclipseUtils.loadProperties(this.workspace.getResourcesPreferenceFile()).entrySet()) {
            String string = entry.getKey();
            if (!string.startsWith(RESOURCES_VARIABLE_PREFIX)) continue;
            Workspace.Variable variable = new Workspace.Variable(string.substring(RESOURCES_VARIABLE_PREFIX_LENGTH), entry.getValue());
            this.workspace.addResourcesVariable(variable);
        }
    }

    private void parseWorkspaceProjects() throws ProjectImporterException {
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        HashSet<File> hashSet = new HashSet<File>();
        File[] fileArray = this.workspace.getDirectory().listFiles(fileFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (!EclipseUtils.isRegularProject(file)) continue;
            logger.finest("Found a regular Eclipse Project in: " + file.getAbsolutePath());
            if (!hashSet.contains(file)) {
                this.addLightProject(hashSet, file, true);
                continue;
            }
            logger.finest("Trying to add the same project twice: " + file.getAbsolutePath());
        }
        File[] fileArray2 = this.workspace.getResourceProjectsDir().listFiles(fileFilter);
        for (int i = 0; i < fileArray2.length; ++i) {
            File comparable = fileArray2[i];
            File file = WorkspaceParser.getLocation(comparable);
            if (file == null) continue;
            if (EclipseUtils.isRegularProject(file)) {
                logger.finest("Found a regular Eclipse Project in: " + file.getAbsolutePath());
                if (!hashSet.contains(file)) {
                    this.addLightProject(hashSet, file, false);
                    continue;
                }
                logger.finest("Trying to add the same project twice: " + file.getAbsolutePath());
                continue;
            }
            logger.finest(file.getAbsolutePath() + " does not contain regular project");
        }
        for (EclipseProject eclipseProject : this.workspace.getProjects()) {
            eclipseProject.setWorkspace(this.workspace);
            ProjectFactory.getInstance().load(eclipseProject);
        }
        for (EclipseProject eclipseProject : this.workspace.getProjects()) {
            eclipseProject.replaceContainers();
        }
    }

    private void addLightProject(Set<File> set, File file, boolean bl) {
        EclipseProject eclipseProject = EclipseProject.createProject(file);
        if (eclipseProject != null) {
            eclipseProject.setName(file.getName());
            eclipseProject.setInternal(bl);
            this.workspace.addProject(eclipseProject);
            set.add(file);
        }
    }

    private static File getLocation(File file) throws ProjectImporterException {
        if (".org.eclipse.jdt.core.external.folders".equals(file.getName())) {
            return null;
        }
        File file2 = new File(file, ".location");
        if (file2.isFile()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file2);
                File file3 = WorkspaceParser.getLocation(fileInputStream);
                return file3;
            }
            catch (IOException iOException) {
                throw new ProjectImporterException("Error during reading .location file", iOException);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        throw new ProjectImporterException(iOException);
                    }
                }
            }
        }
        return null;
    }

    static File getLocation(InputStream inputStream) throws IOException {
        for (long i = 17L; i != 0L; i -= inputStream.skip(i)) {
        }
        int n = inputStream.read();
        byte[] byArray = new byte[n];
        int n2 = inputStream.read(byArray);
        assert (n2 == n);
        String string = new String(byArray, "ISO-8859-1");
        if (string.startsWith("URI//")) {
            string = string.substring(string.indexOf(58) + 1);
        }
        if (string.length() == 0) {
            return null;
        }
        return new File(string);
    }

    private void parseLaunchConfigurations() throws IOException, ProjectImporterException {
        ArrayList<LaunchConfiguration> arrayList = new ArrayList<LaunchConfiguration>();
        File[] fileArray = new File(this.workspace.getDirectory(), ".metadata/.plugins/org.eclipse.debug.core/.launches").listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".launch");
            }
        });
        if (fileArray != null) {
            for (File file : fileArray) {
                Document document;
                try {
                    document = XMLUtil.parse((InputSource)new InputSource(file.toURI().toString()), (boolean)false, (boolean)false, null, null);
                }
                catch (SAXException sAXException) {
                    throw new ProjectImporterException("Could not parse " + file, sAXException);
                }
                Element element = document.getDocumentElement();
                String string = element.getAttribute("type");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                NodeList nodeList = element.getElementsByTagName("stringAttribute");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element2 = (Element)nodeList.item(i);
                    hashMap.put(element2.getAttribute("key"), element2.getAttribute("value"));
                }
                arrayList.add(new LaunchConfiguration(file.getName().replaceFirst("\\.launch$", ""), string, (String)hashMap.get("org.eclipse.jdt.launching.PROJECT_ATTR"), (String)hashMap.get("org.eclipse.jdt.launching.MAIN_TYPE"), (String)hashMap.get("org.eclipse.jdt.launching.PROGRAM_ARGUMENTS"), (String)hashMap.get("org.eclipse.jdt.launching.VM_ARGUMENTS")));
            }
        }
        this.workspace.setLaunchConfigurations(arrayList);
    }
}

