/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.projectimport.eclipse.core.ProjectImporterException;
import org.openide.ErrorManager;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UserLibraryParser
extends DefaultHandler {
    private static final String USER_LIBRARY = "userlibrary";
    private static final String ARCHIVE = "archive";
    private static final String ATTRIBUTES = "attributes";
    private static final String ATTRIBUTE = "attribute";
    private static final String PATH_ATTR = "path";
    private static final int POSITION_NONE = 0;
    private static final int POSITION_USER_LIBRARY = 1;
    private static final int POSITION_ARCHIVE = 2;
    private static final int POSITION_ATTRIBUTES = 3;
    private static final int POSITION_ATTRIBUTE = 4;
    private int position = 0;
    private StringBuffer chars;
    private List<String> jars;

    private UserLibraryParser() {
    }

    static List<String> getJars(String string) throws ProjectImporterException {
        UserLibraryParser userLibraryParser = new UserLibraryParser();
        userLibraryParser.load(new InputSource(new StringReader(string)));
        return userLibraryParser.jars;
    }

    private void load(InputSource inputSource) throws ProjectImporterException {
        try {
            XMLReader xMLReader = XMLUtil.createXMLReader((boolean)false, (boolean)true);
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            this.chars = new StringBuffer();
            xMLReader.parse(inputSource);
        }
        catch (IOException iOException) {
            throw new ProjectImporterException(iOException);
        }
        catch (SAXException sAXException) {
            throw new ProjectImporterException(sAXException);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.chars.append(cArray, n, n2);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.chars.setLength(0);
        switch (this.position) {
            case 0: {
                if (string2.equals(USER_LIBRARY)) {
                    this.position = 1;
                    this.jars = new ArrayList<String>();
                    break;
                }
                throw new SAXException("First element has to be userlibrary, but is " + string2);
            }
            case 1: {
                if (!string2.equals(ARCHIVE)) break;
                this.jars.add(attributes.getValue(PATH_ATTR));
                this.position = 2;
                break;
            }
            case 2: {
                if (!string2.equals(ATTRIBUTES)) break;
                this.position = 3;
                break;
            }
            case 3: {
                if (!string2.equals(ATTRIBUTE)) break;
                this.position = 4;
                break;
            }
            default: {
                throw new SAXException("Unknown element reached: " + string2);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        switch (this.position) {
            case 1: {
                this.position = 0;
                break;
            }
            case 2: {
                this.position = 1;
                break;
            }
            case 3: {
                this.position = 2;
                break;
            }
            case 4: {
                this.position = 3;
                break;
            }
            default: {
                ErrorManager.getDefault().log(16, "Unknown state reached in UserLibraryParser, position: " + this.position);
            }
        }
        this.chars.setLength(0);
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        ErrorManager.getDefault().log(16, "Warning occurred: " + sAXParseException);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        ErrorManager.getDefault().log(16, "Error occurres: " + sAXParseException);
        throw sAXParseException;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        ErrorManager.getDefault().log(16, "Fatal error occurres: " + sAXParseException);
        throw sAXParseException;
    }
}

