/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProjectReference;
import org.netbeans.modules.projectimport.eclipse.core.UpdateEclipseReferencePanel;
import org.netbeans.modules.projectimport.eclipse.core.Workspace;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UpgradableProject {
    private Project project;
    private EclipseProjectReference reference;
    private boolean initialized;
    private boolean createdFromEclipse;

    public UpgradableProject(Project project) {
        this.project = project;
    }

    public boolean isEclipseProjectReachable() {
        if (!this.isUpgradable()) {
            return false;
        }
        return this.getEclipseProjectReference().isEclipseProjectReachable();
    }

    public boolean isUpgradable() {
        return this.getEclipseProjectReference() != null;
    }

    public boolean isUpToDate(boolean bl) {
        assert (this.isUpgradable() && this.isEclipseProjectReachable());
        return this.getEclipseProjectReference().isUpToDate(bl);
    }

    public void update(final List<String> list) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    UpgradableProject.this.getEclipseProjectReference().update(list);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            IOException iOException = new IOException();
            iOException.initCause(mutexException.getCause());
            throw iOException;
        }
    }

    private EclipseProjectReference getEclipseProjectReference() {
        if (!this.initialized) {
            this.reference = EclipseProjectReference.read(this.project);
            this.initialized = this.reference == null ? true : this.reference.isEclipseProjectReachable();
            this.createdFromEclipse = this.reference != null;
        }
        return this.reference;
    }

    boolean isCreatedFromEclipse() {
        this.getEclipseProjectReference();
        return this.createdFromEclipse;
    }

    public boolean updateBrokenEclipseReference(Map<String, String> map) {
        return UpdateEclipseReferencePanel.showEclipseReferenceResolver(this.getEclipseProjectReference(), map);
    }

    File getStoredEclipseProjectFolder() {
        return this.getEclipseProjectReference().getFallbackEclipseProjectLocation();
    }

    File getStoredEclipseWorkspaceFolder() {
        return this.getEclipseProjectReference().getFallbackWorkspaceProjectLocation();
    }

    Workspace getWorkspace() {
        return this.getEclipseProjectReference().getEclipseProject(false).getWorkspace();
    }

    EclipseProject getEclipseProject() {
        return this.getEclipseProjectReference().getEclipseProject(false);
    }

    public Project getProject() {
        return this.project;
    }
}

