/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProjectReference;
import org.netbeans.modules.projectimport.eclipse.core.EclipseUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UpdateEclipseReferencePanel
extends JPanel
implements DocumentListener {
    private DialogDescriptor dd;
    private String projName;
    private JButton browseProjectButton;
    private JButton browseWorkspaceButton;
    private JTextField eclipseProjectTextField;
    private JTextField eclipseWorkspaceTextField;
    private JLabel error;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;

    private UpdateEclipseReferencePanel(EclipseProjectReference eclipseProjectReference) {
        this.projName = ((ProjectInformation)eclipseProjectReference.getProject().getLookup().lookup(ProjectInformation.class)).getDisplayName();
        this.initComponents();
        this.eclipseProjectTextField.setText(eclipseProjectReference.getEclipseProjectLocation().getPath());
        this.eclipseProjectTextField.setEnabled(!eclipseProjectReference.getEclipseProjectLocation().exists());
        this.browseProjectButton.setEnabled(!eclipseProjectReference.getEclipseProjectLocation().exists());
        this.eclipseWorkspaceTextField.setText(eclipseProjectReference.getEclipseWorkspaceLocation().getPath());
        this.eclipseWorkspaceTextField.setEnabled(!eclipseProjectReference.getEclipseWorkspaceLocation().exists());
        this.browseWorkspaceButton.setEnabled(!eclipseProjectReference.getEclipseWorkspaceLocation().exists());
    }

    public void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.dd = dialogDescriptor;
        this.eclipseProjectTextField.getDocument().addDocumentListener(this);
        this.eclipseWorkspaceTextField.getDocument().addDocumentListener(this);
        this.updateStatus();
    }

    private void updateStatus() {
        String string = null;
        if (this.eclipseProjectTextField.isEnabled() && !EclipseUtils.isRegularProject(this.eclipseProjectTextField.getText())) {
            string = NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"MSG_SelectProject");
        }
        if (string == null && this.eclipseWorkspaceTextField.isEnabled()) {
            String string2 = this.eclipseWorkspaceTextField.getText();
            if (string2 == null || string2.trim().length() == 0) {
                string = NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"MSG_SelectWorkspace");
            } else if (!EclipseUtils.isRegularWorkSpace(FileUtil.normalizeFile((File)new File(string2.trim())))) {
                string = NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"MSG_SelectWorkspace");
            }
        }
        this.dd.setValid(string == null);
        this.error.setText(string == null ? " " : string);
    }

    public static boolean showEclipseReferenceResolver(EclipseProjectReference eclipseProjectReference, Map<String, String> map) {
        Serializable serializable;
        if (!eclipseProjectReference.getEclipseWorkspaceLocation().exists() && map.get(eclipseProjectReference.getEclipseWorkspaceLocation().getPath()) != null) {
            eclipseProjectReference.updateReference(null, map.get(eclipseProjectReference.getEclipseWorkspaceLocation().getPath()));
        }
        if (!eclipseProjectReference.getEclipseProjectLocation().exists() && map.get(eclipseProjectReference.getEclipseProjectLocation().getParent()) != null) {
            serializable = new File(map.get(eclipseProjectReference.getEclipseProjectLocation().getParent()));
            if (((File)(serializable = new File((File)serializable, eclipseProjectReference.getEclipseProjectLocation().getName()))).exists()) {
                eclipseProjectReference.updateReference(((File)serializable).getPath(), null);
            }
        }
        if (eclipseProjectReference.isEclipseProjectReachable()) {
            return true;
        }
        serializable = new UpdateEclipseReferencePanel(eclipseProjectReference);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)serializable, NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"TITLE_Synchronize_with_Eclipse"), true, 2, null, null);
        ((UpdateEclipseReferencePanel)serializable).setDialogDescriptor(dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            if (((UpdateEclipseReferencePanel)serializable).eclipseProjectTextField.isEnabled()) {
                map.put(eclipseProjectReference.getEclipseProjectLocation().getParent(), ((UpdateEclipseReferencePanel)serializable).eclipseProjectTextField.getText());
            }
            if (((UpdateEclipseReferencePanel)serializable).eclipseWorkspaceTextField.isEnabled()) {
                map.put(eclipseProjectReference.getEclipseWorkspaceLocation().getPath(), ((UpdateEclipseReferencePanel)serializable).eclipseWorkspaceTextField.getText());
            }
            eclipseProjectReference.updateReference(((UpdateEclipseReferencePanel)serializable).eclipseProjectTextField.isEnabled() ? ((UpdateEclipseReferencePanel)serializable).eclipseProjectTextField.getText() : null, ((UpdateEclipseReferencePanel)serializable).eclipseWorkspaceTextField.isEnabled() ? ((UpdateEclipseReferencePanel)serializable).eclipseWorkspaceTextField.getText() : null);
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.eclipseProjectTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.eclipseWorkspaceTextField = new JTextField();
        this.browseProjectButton = new JButton();
        this.browseWorkspaceButton = new JButton();
        this.error = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel1.setText(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"UpdateEclipseReferencePanel.jLabel1.text"));
        this.eclipseProjectTextField.setText(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"UpdateEclipseReferencePanel.eclipseProjectTextField.text"));
        this.jLabel2.setText(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"UpdateEclipseReferencePanel.jLabel2.text"));
        this.eclipseWorkspaceTextField.setText(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"UpdateEclipseReferencePanel.eclipseWorkspaceTextField.text"));
        this.browseProjectButton.setText(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"UpdateEclipseReferencePanel.browseProjectButton.text"));
        this.browseProjectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UpdateEclipseReferencePanel.this.browseProjectButtonActionPerformed(actionEvent);
            }
        });
        this.browseWorkspaceButton.setText(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"UpdateEclipseReferencePanel.browseWorkspaceButton.text"));
        this.browseWorkspaceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UpdateEclipseReferencePanel.this.browseWorkspaceButtonActionPerformed(actionEvent);
            }
        });
        this.error.setForeground(Color.red);
        this.error.setText(" ");
        this.jLabel3.setText(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"UpdateEclipseReferencePanel.jLabel3.text", (Object)this.projName));
        this.jLabel4.setText(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"UpdateEclipseReferencePanel.jLabel4.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel3, -1, 528, Short.MAX_VALUE).add((Component)this.jLabel4, -1, 528, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.eclipseProjectTextField, -1, 319, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.browseProjectButton)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.eclipseWorkspaceTextField, -1, 319, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.browseWorkspaceButton)))).add((Component)this.error, -1, 528, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jLabel4).add(12, 12, 12).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.eclipseProjectTextField, -2, -1, -2).add((Component)this.browseProjectButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.eclipseWorkspaceTextField, -2, -1, -2).add((Component)this.jLabel2).add((Component)this.browseWorkspaceButton)).addPreferredGap(0).add((Component)this.error).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void browseProjectButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setDialogTitle(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"TITLE_Select_Eclipse_Project"));
        if (0 == jFileChooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            this.eclipseProjectTextField.setText(file.getAbsolutePath());
        }
    }

    private void browseWorkspaceButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setDialogTitle(NbBundle.getMessage(UpdateEclipseReferencePanel.class, (String)"TITLE_Select_Eclipse_Workspace"));
        if (0 == jFileChooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            this.eclipseWorkspaceTextField.setText(file.getAbsolutePath());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateStatus();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateStatus();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }
}

