/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.netbeans.modules.httpserver.HttpServerSettings;
import org.netbeans.modules.httpserver.HttpServerURLMapper;
import org.netbeans.modules.httpserver.NbBaseServlet;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

public class WrapperServlet
extends NbBaseServlet {
    private static final long serialVersionUID = 8009602136746998361L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (!this.checkAccess(httpServletRequest)) {
            httpServletResponse.sendError(403, NbBundle.getMessage(WrapperServlet.class, (String)"MSG_HTTP_FORBIDDEN"));
            return;
        }
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        try {
            int n;
            String string = this.getRequestURL(httpServletRequest);
            HttpServerURLMapper httpServerURLMapper = new HttpServerURLMapper();
            FileObject[] fileObjectArray = httpServerURLMapper.getFileObjects(new URL(string));
            if (fileObjectArray == null || fileObjectArray.length != 1) {
                throw new IOException();
            }
            URL uRL = URLMapper.findURL((FileObject)fileObjectArray[0], (int)0);
            URLConnection uRLConnection = uRL.openConnection();
            httpServletResponse.setContentType(uRLConnection.getContentType());
            InputStream inputStream = uRLConnection.getInputStream();
            byte[] byArray = new byte[256];
            while ((n = inputStream.read(byArray)) != -1) {
                servletOutputStream.write(byArray, 0, n);
                servletOutputStream.flush();
            }
            inputStream.close();
        }
        catch (MalformedURLException malformedURLException) {
            try {
                httpServletResponse.sendError(404, NbBundle.getMessage(WrapperServlet.class, (String)"MSG_HTTP_NOT_FOUND"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (IOException iOException) {
            try {
                httpServletResponse.sendError(500);
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
        finally {
            try {
                servletOutputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private String getRequestURL(HttpServletRequest httpServletRequest) throws UnknownHostException, MalformedURLException {
        HttpServerSettings httpServerSettings = HttpServerSettings.getDefault();
        String string = httpServletRequest.getPathInfo();
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        URL uRL = new URL("http", InetAddress.getLocalHost().getHostName(), httpServerSettings.getPort(), httpServerSettings.getWrapperBaseURL() + string.toString());
        return uRL.toExternalForm();
    }

    public String getServletInfo() {
        return NbBundle.getMessage(WrapperServlet.class, (String)"MSG_WrapperServletDescr");
    }
}

