/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.common.ui.actions;

import java.io.PrintWriter;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.compapp.projects.common.Helper;
import org.netbeans.modules.compapp.projects.common.ImplicitCatalogValidator;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class ValidateImplicitCatalogActionPerformer
implements ProjectActionPerformer {
    public static final String COMMAND = "validate-implicit-catalog";

    public boolean enable(Project project) {
        assert (project != null);
        return Helper.hasImplicitCatalogSupport(project);
    }

    public void perform(Project project) {
        ImplicitCatalogValidator implicitCatalogValidator = null;
        ImplicitCatalogValidator.ResultPrinter resultPrinter = null;
        final String string = NbBundle.getMessage(ValidateImplicitCatalogActionPerformer.class, (String)"icat.validator.output.title");
        resultPrinter = new ImplicitCatalogValidator.ResultPrinter(){

            protected void initWriters() {
                InputOutput inputOutput = IOProvider.getDefault().getIO(string, false);
                this.setOutWriter((PrintWriter)inputOutput.getOut());
                this.setErrorWriter((PrintWriter)inputOutput.getErr());
            }
        };
        try {
            implicitCatalogValidator = ImplicitCatalogValidator.newInstance(project);
            implicitCatalogValidator.setResultPrinter(resultPrinter);
            implicitCatalogValidator.validate();
        }
        catch (Exception exception) {
            resultPrinter.println(exception.getMessage());
        }
    }

    public static Action createProjectSensitiveAction() {
        ValidateImplicitCatalogActionPerformer validateImplicitCatalogActionPerformer = new ValidateImplicitCatalogActionPerformer();
        String string = NbBundle.getMessage(ValidateImplicitCatalogActionPerformer.class, (String)"LBL_ValidateImplicitCatalogAction");
        return ProjectSensitiveActions.projectSensitiveAction((ProjectActionPerformer)validateImplicitCatalogActionPerformer, (String)string, null);
    }
}

