/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.common.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.compapp.projects.common.ui.ImplicitNamespaceChildren;
import org.netbeans.modules.compapp.projects.common.ui.ImplicitReferenceDataNode;
import org.netbeans.modules.xml.catalogsupport.DefaultProjectCatalogSupport;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ui.ModelCookie;
import org.netbeans.modules.xml.xam.ui.customizer.AbstractReferenceCustomizer;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceDataNode;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceDecorator;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceNode;
import org.netbeans.modules.xml.xam.ui.customizer.FolderNode;
import org.netbeans.modules.xml.xam.ui.customizer.RetrievedFilesChildren;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.TreeTableView;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NamespaceReferenceCreator<T extends Component>
extends AbstractReferenceCustomizer<T>
implements ExplorerManager.Provider,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private Map<DataObject, NodeSet> registeredNodes = new HashMap<DataObject, NodeSet>();
    private transient FileObject sourceFO;
    private transient DefaultProjectCatalogSupport catalogSupport;
    public JLabel locationLabel;
    public JPanel locationPanel;
    public JLabel messageLabel;
    public JLabel namespaceLabel;
    public JTextField namespaceTextField;

    public NamespaceReferenceCreator(T t, Model model) {
        super(t);
        this.initComponents();
        this.sourceFO = (FileObject)t.getModel().getModelSource().getLookup().lookup(FileObject.class);
        this.catalogSupport = DefaultProjectCatalogSupport.getInstance((FileObject)this.sourceFO);
        this.init(t, model);
        LocationView locationView = new LocationView();
        locationView.setDefaultActionAllowed(false);
        locationView.setPopupAllowed(false);
        locationView.setSelectionMode(1);
        locationView.setRootVisible(false);
        locationView.getAccessibleContext().setAccessibleName(this.locationLabel.getToolTipText());
        locationView.getAccessibleContext().setAccessibleDescription(this.locationLabel.getToolTipText());
        Node.Property[] propertyArray = new Node.Property[]{new Column("name", String.class, true), new ImportColumn(this.referenceTypeName()), new Column("prefix", String.class, false)};
        locationView.setProperties(propertyArray);
        locationView.setTreePreferredWidth(200);
        locationView.setTableColumnPreferredWidth(0, 25);
        locationView.setTableColumnPreferredWidth(1, 25);
        this.locationPanel.add((java.awt.Component)((Object)locationView), "Center");
        this.explorerManager = new ExplorerManager();
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.explorerManager.setRootContext(this.createRootNode());
    }

    public void applyChanges() throws IOException {
    }

    protected abstract String getTargetNamespace(Model var1);

    protected List<Node> getSelectedNodes() {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        Collection<NodeSet> collection = this.registeredNodes.values();
        for (NodeSet nodeSet : collection) {
            List<ExternalReferenceDataNode> list;
            if (!nodeSet.isSelected() || (list = nodeSet.getNodes()).size() <= 0) continue;
            linkedList.add((Node)list.get(0));
        }
        return linkedList;
    }

    private boolean isValidPrefix(ExternalReferenceDataNode externalReferenceDataNode) {
        DataObject dataObject = (DataObject)externalReferenceDataNode.getLookup().lookup(DataObject.class);
        NodeSet nodeSet = this.registeredNodes.get(dataObject);
        Collection<NodeSet> collection = this.registeredNodes.values();
        for (NodeSet nodeSet2 : collection) {
            if (nodeSet2.equals(nodeSet) || !nodeSet2.isSelected()) continue;
            ExternalReferenceDataNode externalReferenceDataNode2 = nodeSet2.getNodes().get(0);
            if (!externalReferenceDataNode.getPrefix().equals(externalReferenceDataNode2.getPrefix())) continue;
            return false;
        }
        return true;
    }

    private int countSelectedNodes() {
        int n = 0;
        Collection<NodeSet> collection = this.registeredNodes.values();
        for (NodeSet nodeSet : collection) {
            List<ExternalReferenceDataNode> list;
            if (!nodeSet.isSelected() || (list = nodeSet.getNodes()).size() <= 0) continue;
            ++n;
        }
        return n;
    }

    protected abstract Map<String, String> getPrefixes(Model var1);

    protected abstract ExternalReferenceDecorator getNodeDecorator();

    public abstract boolean mustNamespaceDiffer();

    protected abstract String referenceTypeName();

    protected void init(T t, Model model) {
    }

    protected void initializeUI() {
        if (!this.mustNamespaceDiffer()) {
            this.namespaceLabel.setVisible(false);
            this.namespaceTextField.setVisible(false);
        }
    }

    public ExternalReferenceDataNode createExternalReferenceNode(Node node) {
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        NodeSet nodeSet = this.registeredNodes.get(dataObject);
        if (nodeSet == null) {
            nodeSet = new NodeSet(this);
            this.registeredNodes.put(dataObject, nodeSet);
        }
        ImplicitReferenceDataNode implicitReferenceDataNode = new ImplicitReferenceDataNode(node, this.getNodeDecorator());
        nodeSet.add(implicitReferenceDataNode);
        if (nodeSet.isSelected() && implicitReferenceDataNode.canSelect()) {
            implicitReferenceDataNode.setSelected(true);
        }
        implicitReferenceDataNode.addPropertyChangeListener(this);
        return implicitReferenceDataNode;
    }

    protected boolean allowEmptySelection() {
        return false;
    }

    private void validateInput(ExternalReferenceNode externalReferenceNode) {
        ExternalReferenceDataNode externalReferenceDataNode;
        String string = null;
        if (this.mustNamespaceDiffer() && externalReferenceNode instanceof ExternalReferenceDataNode) {
            externalReferenceDataNode = (ExternalReferenceDataNode)externalReferenceNode;
            Map<String, String> map = this.getPrefixes(this.getModelComponent().getModel());
            String string2 = externalReferenceDataNode.getPrefix();
            if (string2.length() == 0 || map.containsKey(string2) || !this.isValidPrefix(externalReferenceDataNode) && externalReferenceDataNode.isSelected()) {
                string = NbBundle.getMessage(NamespaceReferenceCreator.class, (String)"LBL_ExternalReferenceCreator_InvalidPrefix");
            }
        }
        if (externalReferenceNode instanceof RetrievedFilesChildren.RetrievedFileNode && !(externalReferenceDataNode = (RetrievedFilesChildren.RetrievedFileNode)externalReferenceNode).isValid()) {
            string = NbBundle.getMessage(NamespaceReferenceCreator.class, (String)"LBL_ExternalReferenceCreator_InvalidCatalogEntry");
        }
        if (string != null) {
            this.showMessage(string);
        }
        int n = this.countSelectedNodes();
        this.setSaveEnabled((this.allowEmptySelection() || n > 0) && string == null);
    }

    protected void showMessage(String string) {
        if (string == null) {
            this.messageLabel.setText(" ");
            this.messageLabel.setIcon(null);
        } else {
            this.messageLabel.setText(string);
            this.messageLabel.setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/xml/xam/ui/resources/error.gif")));
        }
    }

    protected Node createRootNode() {
        Project project;
        Object object2;
        Set set = null;
        if (this.catalogSupport.supportsCrossProject()) {
            set = this.catalogSupport.getProjectReferences();
        }
        ExternalReferenceDecorator externalReferenceDecorator = this.getNodeDecorator();
        Node[] nodeArray = new Node[1 + (set == null ? 0 : set.size())];
        Project project2 = FileOwnerQuery.getOwner((FileObject)this.sourceFO);
        LogicalViewProvider logicalViewProvider = (LogicalViewProvider)project2.getLookup().lookup(LogicalViewProvider.class);
        nodeArray[0] = externalReferenceDecorator.createExternalReferenceNode(logicalViewProvider.createLogicalView());
        int n = 1;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        arrayList.add(project2.getProjectDirectory());
        if (set != null) {
            for (Object object2 : set) {
                project = (Project)object2;
                logicalViewProvider = (LogicalViewProvider)project.getLookup().lookup(LogicalViewProvider.class);
                nodeArray[n++] = externalReferenceDecorator.createExternalReferenceNode(logicalViewProvider.createLogicalView());
                arrayList.add(project.getProjectDirectory());
            }
        }
        FileObject[] fileObjectArray = arrayList.toArray(new FileObject[arrayList.size()]);
        object2 = new Children.Array();
        object2.add(nodeArray);
        project = new FolderNode(object2);
        project.setDisplayName(NbBundle.getMessage(NamespaceReferenceCreator.class, (String)"LBL_ExternalReferenceCreator_Category_By_File"));
        ImplicitNamespaceChildren implicitNamespaceChildren = new ImplicitNamespaceChildren(fileObjectArray, externalReferenceDecorator);
        FolderNode folderNode = new FolderNode((Children)implicitNamespaceChildren);
        folderNode.setDisplayName(NbBundle.getMessage(NamespaceReferenceCreator.class, (String)"LBL_ExternalReferenceCreator_Category_By_Namespace"));
        Children.Array array = new Children.Array();
        array.add(new Node[]{project, folderNode});
        AbstractNode abstractNode = new AbstractNode((Children)array);
        abstractNode.setDisplayName(NbBundle.getMessage(NamespaceReferenceCreator.class, (String)"CTL_ExternalReferenceCreator_Column_Name_name"));
        abstractNode.setShortDescription(NbBundle.getMessage(NamespaceReferenceCreator.class, (String)"CTL_ExternalReferenceCreator_Column_Desc_name"));
        return abstractNode;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("selectedNodes".equals(string)) {
            ExternalReferenceNode externalReferenceNode;
            Model model;
            this.showMessage(null);
            Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
            if (nodeArray != null && nodeArray.length > 0 && nodeArray[0] instanceof ExternalReferenceNode && (model = (externalReferenceNode = (ExternalReferenceNode)nodeArray[0]).getModel()) != null) {
                String string2 = this.getNodeDecorator().validate(externalReferenceNode);
                if (string2 != null) {
                    this.showMessage(string2);
                } else {
                    this.validateInput(externalReferenceNode);
                }
            }
        } else if (string.equals("prefix")) {
            ExternalReferenceDataNode externalReferenceDataNode = (ExternalReferenceDataNode)propertyChangeEvent.getSource();
            String string3 = (String)propertyChangeEvent.getNewValue();
            DataObject dataObject = (DataObject)externalReferenceDataNode.getLookup().lookup(DataObject.class);
            NodeSet nodeSet = this.registeredNodes.get(dataObject);
            assert (nodeSet != null) : "node not created by customizer";
            if (nodeSet == null) {
                nodeSet = new NodeSet(this);
                nodeSet.add(externalReferenceDataNode);
            }
            nodeSet.setPrefix(string3);
            this.validateInput((ExternalReferenceNode)externalReferenceDataNode);
        } else if (string.equals("selected")) {
            ExternalReferenceDataNode externalReferenceDataNode = (ExternalReferenceDataNode)propertyChangeEvent.getSource();
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            DataObject dataObject = (DataObject)externalReferenceDataNode.getLookup().lookup(DataObject.class);
            NodeSet nodeSet = this.registeredNodes.get(dataObject);
            assert (nodeSet != null) : "node not created by customizer";
            if (nodeSet == null) {
                nodeSet = new NodeSet(this);
                nodeSet.add(externalReferenceDataNode);
            }
            nodeSet.setSelected(bl);
            this.validateInput((ExternalReferenceNode)externalReferenceDataNode);
        }
    }

    protected String getLocation(Node node) {
        String string = "";
        return string;
    }

    protected String getNamespace(Node node) {
        String string = null;
        if (node instanceof RetrievedFilesChildren.RetrievedFileNode) {
            RetrievedFilesChildren.RetrievedFileNode retrievedFileNode = (RetrievedFilesChildren.RetrievedFileNode)node;
            if (!retrievedFileNode.isValid()) {
                return null;
            }
            string = retrievedFileNode.getNamespace();
        } else {
            DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
            if (dataObject != null && dataObject.isValid()) {
                ModelCookie modelCookie = (ModelCookie)dataObject.getCookie(ModelCookie.class);
                try {
                    Model model;
                    if (modelCookie != null && (model = modelCookie.getModel()) != this.getModelComponent().getModel()) {
                        string = this.getTargetNamespace(model);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return string;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    private void initComponents() {
        this.locationLabel = new JLabel();
        this.locationPanel = new JPanel();
        this.namespaceLabel = new JLabel();
        this.namespaceTextField = new JTextField();
        this.messageLabel = new JLabel();
        this.locationLabel.setLabelFor(this.locationPanel);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getBundle(NamespaceReferenceCreator.class).getString("LBL_ExternalReferenceCreator_Location"));
        this.locationLabel.setToolTipText(NbBundle.getBundle(NamespaceReferenceCreator.class).getString("TIP_ExternalReferenceCreator_Location"));
        this.locationPanel.setBorder(BorderFactory.createEtchedBorder());
        this.locationPanel.setLayout(new BorderLayout());
        this.namespaceLabel.setLabelFor(this.namespaceTextField);
        Mnemonics.setLocalizedText((JLabel)this.namespaceLabel, (String)NbBundle.getBundle(NamespaceReferenceCreator.class).getString("LBL_ExternalReferenceCreator_Namespace"));
        this.namespaceLabel.setToolTipText(NbBundle.getBundle(NamespaceReferenceCreator.class).getString("TIP_ExternalReferenceCreator_Namespace"));
        this.namespaceTextField.setEditable(false);
        this.messageLabel.setForeground(new Color(255, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)" ");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((java.awt.Component)this.locationPanel, -1, 382, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((java.awt.Component)this.namespaceLabel).addPreferredGap(0).add((java.awt.Component)this.namespaceTextField, -1, 319, Short.MAX_VALUE)).add((java.awt.Component)this.locationLabel).add((java.awt.Component)this.messageLabel, -1, 382, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((java.awt.Component)this.locationLabel).addPreferredGap(0).add((java.awt.Component)this.locationPanel, -1, 329, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((java.awt.Component)this.namespaceLabel).add((java.awt.Component)this.namespaceTextField, -2, -1, -2)).addPreferredGap(0).add((java.awt.Component)this.messageLabel).addContainerGap()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeSet {
        private PropertyChangeListener listener;
        private List<ExternalReferenceDataNode> nodes;
        private boolean selected;

        public NodeSet(PropertyChangeListener propertyChangeListener) {
            this.listener = propertyChangeListener;
        }

        public void add(ExternalReferenceDataNode externalReferenceDataNode) {
            if (this.nodes == null) {
                this.nodes = new LinkedList<ExternalReferenceDataNode>();
            }
            this.nodes.add(externalReferenceDataNode);
        }

        public List<ExternalReferenceDataNode> getNodes() {
            return this.nodes;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setPrefix(String string) {
            for (ExternalReferenceDataNode externalReferenceDataNode : this.nodes) {
                if (externalReferenceDataNode.getPrefix().equals(string)) continue;
                externalReferenceDataNode.removePropertyChangeListener(this.listener);
                externalReferenceDataNode.setPrefix(string);
                externalReferenceDataNode.addPropertyChangeListener(this.listener);
            }
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
            for (ExternalReferenceDataNode externalReferenceDataNode : this.nodes) {
                if (!externalReferenceDataNode.canSelect()) continue;
                externalReferenceDataNode.removePropertyChangeListener(this.listener);
                externalReferenceDataNode.setSelected(bl);
                externalReferenceDataNode.addPropertyChangeListener(this.listener);
            }
        }
    }

    protected class ImportColumn
    extends PropertySupport.ReadOnly {
        private String key;

        public ImportColumn(String string) {
            super("selected", Boolean.TYPE, string, NbBundle.getMessage(Column.class, (String)"CTL_ExternalReferenceCreator_Column_Desc_selected"));
            this.key = "selected";
            this.setValue("TreeColumnTTV", Boolean.FALSE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.key;
        }
    }

    protected class Column
    extends PropertySupport.ReadOnly {
        private String key;

        public Column(String string, Class clazz, boolean bl) {
            super(string, clazz, NbBundle.getMessage(Column.class, (String)("CTL_ExternalReferenceCreator_Column_Name_" + string)), NbBundle.getMessage(Column.class, (String)("CTL_ExternalReferenceCreator_Column_Desc_" + string)));
            this.key = string;
            this.setValue("TreeColumnTTV", bl);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.key;
        }
    }

    private class LocationView
    extends TreeTableView {
        private static final long serialVersionUID = 1L;

        public LocationView() {
            this.tree.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    ExternalReferenceDataNode externalReferenceDataNode;
                    Object object;
                    Node node;
                    TreePath treePath = LocationView.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath != null && (node = Visualizer.findNode((Object)(object = treePath.getLastPathComponent()))) instanceof ExternalReferenceDataNode && (externalReferenceDataNode = (ExternalReferenceDataNode)node).canSelect()) {
                        Model model;
                        boolean bl = !externalReferenceDataNode.isSelected();
                        String string = null;
                        if (bl && (model = externalReferenceDataNode.getModel()) != null) {
                            string = NamespaceReferenceCreator.this.getTargetNamespace(model);
                        }
                        NamespaceReferenceCreator.this.namespaceTextField.setText(string);
                        externalReferenceDataNode.setSelected(bl);
                    }
                }
            });
        }
    }
}

