/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.base.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.compapp.projects.base.ui.customizer.VisualClassPathItem;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class AntArtifactChooser
extends JPanel
implements PropertyChangeListener {
    private String artifactType;
    private JLabel jLabelJarFiles;
    private JLabel jLabelName;
    private JList jListArtifacts;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldName;

    public AntArtifactChooser(String string, JFileChooser jFileChooser) {
        this.artifactType = string;
        this.initComponents();
        this.jListArtifacts.setModel(new DefaultListModel());
        jFileChooser.addPropertyChangeListener(this);
    }

    private void initComponents() {
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabelJarFiles = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListArtifacts = new JList();
        this.setMinimumSize(new Dimension(190, 80));
        this.setPreferredSize(new Dimension(270, 187));
        this.jLabelName.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/compapp/projects/base/ui/customizer/Bundle").getString("LBL_AACH_ProjectName_LabelMnemonic").charAt(0));
        this.jLabelName.setText(NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AACH_ProjectName_JLabel"));
        this.jTextFieldName.setEditable(false);
        this.jTextFieldName.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/compapp/projects/base/ui/customizer/Bundle").getString("ACS_AACH_ProjectName_A11YDesc"));
        this.jLabelJarFiles.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/compapp/projects/base/ui/customizer/Bundle").getString("LBL_AACH_ProjectJarFiles_LabelMnemonic").charAt(0));
        this.jLabelJarFiles.setText(NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AACH_ProjectJarFiles_JLabel"));
        this.jScrollPane1.setViewportView(this.jListArtifacts);
        this.jListArtifacts.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/compapp/projects/base/ui/customizer/Bundle").getString("ACS_AACH_ProjectJarFiles_A11YDesc"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabelName).add((Component)this.jTextFieldName, -1, 250, Short.MAX_VALUE).add((Component)this.jLabelJarFiles).add((Component)this.jScrollPane1, -1, 250, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabelName).addPreferredGap(0).add((Component)this.jTextFieldName, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabelJarFiles).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 100, Short.MAX_VALUE).addContainerGap()));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
            JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
            File file = jFileChooser.getSelectedFile();
            DefaultListModel defaultListModel = (DefaultListModel)this.jListArtifacts.getModel();
            Project project = this.getProject(file);
            this.populateAccessory(project);
        }
    }

    private Project getProject(File file) {
        try {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject != null) {
                Project project = ProjectManager.getDefault().findProject(fileObject);
                return project;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private void populateAccessory(Project project) {
        AntArtifact[] antArtifactArray;
        AntArtifactProvider antArtifactProvider;
        DefaultListModel defaultListModel = (DefaultListModel)this.jListArtifacts.getModel();
        defaultListModel.clear();
        this.jTextFieldName.setText(project == null ? "" : ProjectUtils.getInformation((Project)project).getDisplayName());
        if (project != null && (antArtifactProvider = (AntArtifactProvider)project.getLookup().lookup(AntArtifactProvider.class)) != null && (antArtifactArray = antArtifactProvider.getBuildArtifacts()) != null && antArtifactArray.length > 0) {
            for (int i = 0; i < antArtifactArray.length; ++i) {
                if (!antArtifactArray[i].getType().startsWith(this.artifactType)) continue;
                defaultListModel.addElement(new ArtifactItem(antArtifactArray[i]));
            }
        }
    }

    public static AntArtifact[] showDialog(String string, DefaultListModel defaultListModel, Project project) {
        JFileChooser jFileChooser = ProjectChooser.projectChooser();
        jFileChooser.setDialogTitle(NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AACH_Title"));
        jFileChooser.setApproveButtonText(NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AACH_SelectProject"));
        AntArtifactChooser antArtifactChooser = new AntArtifactChooser(string, jFileChooser);
        jFileChooser.setAccessory(antArtifactChooser);
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            Project project2 = antArtifactChooser.getProject(file = FileUtil.normalizeFile((File)file));
            if (project2 == null) {
                return null;
            }
            if (project2.getProjectDirectory().equals(project.getProjectDirectory())) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AntArtifactChooser.class, (String)"MSG_AACH_RefToItself"), 1));
                return null;
            }
            if (defaultListModel != null) {
                int n2 = defaultListModel.getSize();
                for (int i = 0; i < n2; ++i) {
                    AntArtifact antArtifact;
                    VisualClassPathItem visualClassPathItem = (VisualClassPathItem)defaultListModel.get(i);
                    if (visualClassPathItem == null || !project2.equals((antArtifact = (AntArtifact)visualClassPathItem.getObject()).getProject())) continue;
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AntArtifactChooser.class, (String)"MSG_AACH_AlreadySelected"), 1));
                    return null;
                }
            }
            if (ProjectUtils.hasSubprojectCycles((Project)project, (Project)project2)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AntArtifactChooser.class, (String)"MSG_AACH_Cycles"), 1));
                return null;
            }
            DefaultListModel defaultListModel2 = (DefaultListModel)antArtifactChooser.jListArtifacts.getModel();
            AntArtifact[] antArtifactArray = new AntArtifact[defaultListModel2.size()];
            for (int i = 0; i < antArtifactArray.length; ++i) {
                antArtifactArray[i] = ((ArtifactItem)defaultListModel2.getElementAt(i)).getArtifact();
            }
            return antArtifactArray;
        }
        return null;
    }

    public static AntArtifact[] showDialog(String string, Project project) {
        int n;
        FileObject fileObject;
        JFileChooser jFileChooser = ProjectChooser.projectChooser();
        jFileChooser.setDialogTitle(NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AACH_Title"));
        jFileChooser.setApproveButtonText(NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AACH_SelectProject"));
        AntArtifactChooser antArtifactChooser = new AntArtifactChooser(string, jFileChooser);
        jFileChooser.setAccessory(antArtifactChooser);
        if (project != null && (fileObject = project.getProjectDirectory().getParent()) != null) {
            jFileChooser.setCurrentDirectory(FileUtil.toFile((FileObject)fileObject));
        }
        if ((n = jFileChooser.showOpenDialog(null)) == 0) {
            DefaultListModel defaultListModel = (DefaultListModel)antArtifactChooser.jListArtifacts.getModel();
            AntArtifact[] antArtifactArray = new AntArtifact[defaultListModel.size()];
            for (int i = 0; i < antArtifactArray.length; ++i) {
                antArtifactArray[i] = ((ArtifactItem)defaultListModel.getElementAt(i)).getArtifact();
            }
            return antArtifactArray;
        }
        return null;
    }

    private static class ArtifactItem {
        private AntArtifact artifact;

        ArtifactItem(AntArtifact antArtifact) {
            this.artifact = antArtifact;
        }

        AntArtifact getArtifact() {
            return this.artifact;
        }

        public String toString() {
            URI[] uRIArray = this.artifact.getArtifactLocations();
            if (uRIArray != null && uRIArray.length > 0) {
                return uRIArray[0].toString();
            }
            return null;
        }
    }
}

