/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.services.strikeiron.ui;

import com.strikeiron.search.AUTHENTICATIONSTYLE;
import com.strikeiron.search.LicenseInfo;
import com.strikeiron.search.MarketPlaceService;
import com.strikeiron.search.RegisteredUser;
import com.strikeiron.search.SISearchService;
import com.strikeiron.search.SISearchServiceSoap;
import com.strikeiron.search.SORTBY;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;
import javax.xml.namespace.QName;
import org.netbeans.modules.websvc.saas.services.strikeiron.ui.SiServiceData;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlServiceData;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlServiceProxyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceTableModel
extends DefaultTableModel {
    public static final QName SI_SEARCH_SERVICE = new QName("http://www.strikeiron.com", "SISearchService");
    public static final String STRIKE_IRON_HOME = WsdlServiceProxyDescriptor.WEBSVC_HOME + "/strikeiron";
    public static final String SEARCH_PROPERTIES = "search.properties";
    public static final String WSDL_LOCATION = "wsdlLocation";
    public static final String USERID = "userId";
    public static final String PASSWORD = "password";
    private static final String DEFAULT_USERID = "Sun_Search@strikeiron.com";
    private static final String DEFAULT_PASSWORD = "SearchSun.01";
    private static final String DEFAULT_URL = "http://ws.strikeiron.com/Searchsunsi01.StrikeIron/MarketplaceSearch?WSDL";
    static final int COLUMN_WS_NAME = 1;
    static final int COLUMN_SELECT = 0;
    private String wsdlLocation;
    private String userId = "Sun_Search@strikeiron.com";
    private String password = "SearchSun.01";
    private AUTHENTICATIONSTYLE authenticationStyle = AUTHENTICATIONSTYLE.SIMPLE_PARAM;
    private Boolean useCustomWSDL = Boolean.TRUE;
    private SORTBY sortBy = SORTBY.NAME;
    private SISearchService sservice;
    private List<? extends WsdlServiceData> result;
    private String status;
    private boolean warnsOrErrors = false;
    private Set<Integer> selectedRows = new HashSet<Integer>();
    private RequestProcessor.Task searchTask;
    public static final String SEARCH_COMPLETE = "searchCompleted";
    public static final String SEARCH_CANCELLED = "searchCancelled";
    public static final String SEARCH_ERROR = "searchError";
    List<SearchListener> listeners = new ArrayList<SearchListener>();

    public ServiceTableModel() {
        this.init();
    }

    private void init() {
        Properties properties = new Properties();
        File file = new File(STRIKE_IRON_HOME, SEARCH_PROPERTIES);
        if (file.isFile()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.wsdlLocation = properties.getProperty(WSDL_LOCATION);
        if (this.wsdlLocation == null) {
            this.wsdlLocation = DEFAULT_URL;
        }
        this.userId = properties.getProperty(USERID);
        if (this.userId == null) {
            this.userId = DEFAULT_USERID;
        }
        this.password = properties.getProperty(PASSWORD);
        if (this.password == null) {
            this.password = DEFAULT_PASSWORD;
        }
    }

    public AUTHENTICATIONSTYLE getAuthenticationStyle() {
        return this.authenticationStyle;
    }

    public void setAuthenticationStyle(AUTHENTICATIONSTYLE aUTHENTICATIONSTYLE) {
        this.authenticationStyle = aUTHENTICATIONSTYLE;
    }

    public SORTBY getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(SORTBY sORTBY) {
        this.sortBy = sORTBY;
    }

    private String getUserId() {
        return this.userId;
    }

    private String getPassword() {
        return this.password;
    }

    public String getSearchServiceUrl() {
        return this.getWsdlLocation().toExternalForm();
    }

    public WsdlServiceData getService(int n) {
        return this.result.get(n);
    }

    public void addEventListener(SearchListener searchListener) {
        this.listeners.add(searchListener);
    }

    public void removeEventListener(SearchListener searchListener) {
        this.listeners.remove(searchListener);
    }

    private void fireSearchEnded() {
        for (SearchListener searchListener : this.listeners) {
            searchListener.searchCompleted(new ChangeEvent(this));
        }
    }

    private void fireServiceSelectionChanged() {
        for (SearchListener searchListener : this.listeners) {
            searchListener.serviceSelectionChanged(new ChangeEvent(this));
        }
    }

    public void doSearch(final String string) {
        this.cancelSearch();
        this.searchTask = RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                ServiceTableModel.this.callSearch(string);
            }
        });
    }

    public boolean cancelSearch() {
        if (this.searchTask != null) {
            boolean bl = this.searchTask.cancel();
            this.searchTask = null;
            this.fireSearchEnded();
            return bl;
        }
        return true;
    }

    public Set<? extends WsdlServiceData> getSelectedServices() {
        HashSet<WsdlServiceData> hashSet = new HashSet<WsdlServiceData>();
        for (int n : this.selectedRows) {
            hashSet.add(this.result.get(n));
        }
        return hashSet;
    }

    public String getStatusMessage() {
        return this.status;
    }

    public boolean hasWarnsOrErrors() {
        return this.warnsOrErrors;
    }

    private URL getWsdlLocation() {
        if (this.wsdlLocation == null) {
            return null;
        }
        try {
            return new URL(this.wsdlLocation);
        }
        catch (Exception exception) {
            Logger.global.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            return null;
        }
    }

    private List<? extends WsdlServiceData> convertResult(List<MarketPlaceService> list) {
        ArrayList<SiServiceData> arrayList = new ArrayList<SiServiceData>();
        if (list != null) {
            for (MarketPlaceService marketPlaceService : list) {
                SiServiceData siServiceData = new SiServiceData(marketPlaceService);
                arrayList.add(siServiceData);
            }
        }
        return arrayList;
    }

    private void clearStatusMessage() {
        this.status = "";
        this.warnsOrErrors = false;
    }

    private void setErrorMessage(String string) {
        this.status = string;
        this.warnsOrErrors = true;
    }

    private void setStatusMessage(String string) {
        this.status = string;
        this.warnsOrErrors = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callSearch(String string) {
        this.clearStatusMessage();
        this.selectedRows = new HashSet<Integer>();
        this.result = new ArrayList<WsdlServiceData>();
        this.fireTableDataChanged();
        try {
            Object object;
            if (this.sservice == null) {
                object = this.getWsdlLocation();
                this.sservice = object == null ? new SISearchService() : new SISearchService((URL)object, SI_SEARCH_SERVICE);
            }
            object = this.sservice.getSISearchServiceSoap();
            this.setHeaderParameters((SISearchServiceSoap)object);
            this.fireTableDataChanged();
        }
        catch (Exception exception) {
            this.setErrorMessage(exception.getLocalizedMessage());
        }
        finally {
            this.fireSearchEnded();
            this.searchTask = null;
        }
    }

    private void setHeaderParameters(SISearchServiceSoap sISearchServiceSoap) {
        RegisteredUser registeredUser = new RegisteredUser();
        registeredUser.setUserID(this.userId);
        registeredUser.setPassword(this.password);
        LicenseInfo licenseInfo = new LicenseInfo();
        licenseInfo.setRegisteredUser(registeredUser);
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 1: {
                return NbBundle.getMessage(ServiceTableModel.class, (String)"LBL_ServiceName");
            }
            case 0: {
                return NbBundle.getMessage(ServiceTableModel.class, (String)"LBL_Select");
            }
        }
        throw new IllegalArgumentException("column > 1");
    }

    public boolean isSearching() {
        return this.searchTask != null && this.result == null;
    }

    @Override
    public int getRowCount() {
        if (this.isSearching()) {
            return 1;
        }
        return this.result != null ? this.result.size() : 0;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.isSearching()) {
            return NbBundle.getMessage(ServiceTableModel.class, (String)"MSG_Searching");
        }
        if (this.result == null) {
            throw new IllegalStateException("Search has not started or has no results");
        }
        WsdlServiceData wsdlServiceData = this.result.get(n);
        switch (n2) {
            case 1: {
                return wsdlServiceData.getServiceName();
            }
            case 0: {
                return this.selectedRows.contains(n) || wsdlServiceData.isInRepository();
            }
        }
        throw new IllegalArgumentException("column = " + n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0 && object instanceof Boolean) {
            boolean bl = (Boolean)object;
            if (bl) {
                this.selectedRows.add(n);
            } else {
                this.selectedRows.remove(n);
            }
            this.fireServiceSelectionChanged();
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            case 0: {
                return !this.getService(n).isInRepository();
            }
        }
        return false;
    }

    public static interface SearchListener
    extends EventListener {
        public void searchCompleted(ChangeEvent var1);

        public void serviceSelectionChanged(ChangeEvent var1);
    }
}

