/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.mobility.e2e.classdata.ClassDataRegistry;
import org.netbeans.modules.mobility.e2e.classdata.MethodData;
import org.netbeans.modules.mobility.e2e.mapping.JavonMappingImpl;
import org.netbeans.modules.mobility.end2end.E2EDataNode;
import org.netbeans.modules.mobility.end2end.classdata.AbstractService;
import org.netbeans.modules.mobility.end2end.classdata.ClassData;
import org.netbeans.modules.mobility.end2end.classdata.OperationData;
import org.netbeans.modules.mobility.end2end.classdata.WSDLService;
import org.netbeans.modules.mobility.end2end.client.config.ClientConfiguration;
import org.netbeans.modules.mobility.end2end.client.config.Configuration;
import org.netbeans.modules.mobility.end2end.client.config.ConfigurationReader;
import org.netbeans.modules.mobility.end2end.client.config.ConfigurationWriter;
import org.netbeans.modules.mobility.end2end.client.config.ServerConfiguration;
import org.netbeans.modules.mobility.end2end.util.Util;
import org.netbeans.modules.xml.multiview.DesignMultiViewDesc;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.netbeans.modules.xml.multiview.XmlMultiViewEditorSupport;
import org.netbeans.spi.mobility.end2end.E2EServiceProvider;
import org.netbeans.spi.mobility.end2end.ServiceGeneratorResult;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class E2EDataObject
extends XmlMultiViewDataObject {
    public static RequestProcessor rp;
    protected transient Configuration configuration;
    private transient Project clientProject;
    private transient Project serverProject;
    protected transient Set<SaveCallback> saveCallbacks;
    protected transient boolean generating;
    public static final String PROP_GENERATING = "generating";
    private static final String TRUE = "true";
    private ModelSynchronizer synchronizer = new ModelSynchronizer(this);
    private XmlMultiViewEditorSupport editorSupport;

    public E2EDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.saveCallbacks = new HashSet<SaveCallback>();
    }

    public void addSaveCallback(SaveCallback saveCallback) {
        this.saveCallbacks.add(saveCallback);
    }

    public void removeSaveCallback(SaveCallback saveCallback) {
        this.saveCallbacks.remove(saveCallback);
    }

    protected Node createNodeDelegate() {
        E2EDataNode e2EDataNode = new E2EDataNode(this);
        return e2EDataNode;
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
        if (bl) {
            this.synchronizer.requestUpdateData();
        }
    }

    public Configuration getConfiguration() {
        if (this.configuration == null) {
            try {
                this.configuration = ConfigurationReader.read((DataObject)this);
            }
            catch (Exception exception) {
                this.configuration = null;
                ErrorManager.getDefault().log(exception.getMessage());
            }
        }
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        this.setModified(true);
    }

    public Project getClientProject() {
        if (this.clientProject == null) {
            this.clientProject = FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile());
        }
        return this.clientProject;
    }

    public Project getServerProject() {
        Configuration configuration = this.getConfiguration();
        if (this.serverProject == null) {
            OpenProjects openProjects = OpenProjects.getDefault();
            Project[] projectArray = openProjects.getOpenProjects();
            if (configuration.getServerConfigutation() == null) {
                return null;
            }
            String string = configuration.getServerConfigutation().getProjectName();
            for (Project project : projectArray) {
                ProjectInformation projectInformation = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
                String string2 = projectInformation.getName();
                if (!string.equals(string2)) continue;
                this.serverProject = project;
                break;
            }
            if (this.serverProject == null) {
                // empty if block
            }
        }
        return this.serverProject;
    }

    public JavonMappingImpl getMapping() throws Exception {
        Object object;
        Object object2;
        Object object3;
        Configuration configuration = this.getConfiguration();
        ArrayList<String> arrayList = new ArrayList<String>();
        ServerConfiguration serverConfiguration = configuration.getServerConfigutation();
        Properties properties = serverConfiguration.getProperties();
        Sources sources = (Sources)this.getServerProject().getLookup().lookup(Sources.class);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        ArrayList<ClasspathInfo> arrayList2 = new ArrayList<ClasspathInfo>();
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            object3 = ClassPath.getClassPath((FileObject)sourceGroupArray[i].getRootFolder(), (String)"classpath/source");
            object2 = object3.getRoots();
            for (int j = 0; j < ((FileObject[])object2).length; ++j) {
                object = FileUtil.toFile((FileObject)object2[j]);
                if (object != null) {
                    arrayList.add(((File)object).getAbsolutePath());
                }
                arrayList2.add(ClasspathInfo.create((FileObject)object2[j]));
            }
        }
        ArrayList<ClasspathInfo> arrayList3 = new ArrayList<ClasspathInfo>();
        arrayList3.add(ClasspathInfo.create((FileObject)sourceGroupArray[0].getRootFolder()));
        if (configuration.getServiceType().equals("wsdlClass") && (object3 = this.getServerProject().getProjectDirectory().getFileObject("build/generated/wsimport/client")) != null) {
            arrayList3.add(ClasspathInfo.create((FileObject)object3));
        }
        object3 = ClassDataRegistry.getRegistry("default", arrayList3);
        object2 = new JavonMappingImpl((ClassDataRegistry)object3);
        ClientConfiguration clientConfiguration = configuration.getClientConfiguration();
        object = new JavonMappingImpl.Client();
        Properties properties2 = clientConfiguration.getProperties();
        ((JavonMappingImpl.Client)object).setClassName(clientConfiguration.getClassDescriptor().getLeafClassName());
        ((JavonMappingImpl.Client)object).setPackageName(clientConfiguration.getClassDescriptor().getPackageName());
        Sources sources2 = (Sources)this.getClientProject().getLookup().lookup(Sources.class);
        SourceGroup sourceGroup = Util.getPreselectedGroup(sources2.getSourceGroups("java"), clientConfiguration.getClassDescriptor().getLocation());
        ((JavonMappingImpl.Client)object).setOutputDirectory(FileUtil.toFile((FileObject)sourceGroup.getRootFolder()).getPath());
        ((JavonMappingImpl)object2).setProperty("create-stubs", properties2.getProperty("createStubs").equals(TRUE));
        ((JavonMappingImpl)object2).setProperty("databinding", properties2.getProperty("DataBinding"));
        ((JavonMappingImpl)object2).setProperty("floatingPoint", properties2.getProperty("floatingPoint").equals(TRUE));
        ((JavonMappingImpl)object2).setClientMapping((JavonMappingImpl.Client)object);
        ProjectInformation projectInformation = (ProjectInformation)this.getServerProject().getLookup().lookup(ProjectInformation.class);
        JavonMappingImpl.Server server = new JavonMappingImpl.Server();
        server.setProjectName(projectInformation.getName());
        server.setClassName(serverConfiguration.getClassDescriptor().getLeafClassName());
        server.setPackageName(serverConfiguration.getClassDescriptor().getPackageName());
        server.setOutputDirectory(FileUtil.toFile((FileObject)Util.getPreselectedGroup(sourceGroupArray, serverConfiguration.getClassDescriptor().getLocation()).getRootFolder()).getPath());
        server.setLocation(Util.getServerLocation(this.getServerProject()));
        server.setPort(Util.getServerPort(this.getServerProject()));
        server.setServletLocation(this.configuration.getServerConfigutation().getProjectName() + "/servlet/" + this.configuration.getServerConfigutation().getClassDescriptor().getType());
        ((JavonMappingImpl)object2).setServerMapping(server);
        int n = 1;
        List<AbstractService> list = configuration.getServices();
        List<ClassData> list2 = list.get(0).getData();
        for (ClassData classData : list2) {
            Object object4;
            JavonMappingImpl.Service service = new JavonMappingImpl.Service();
            service.setPackageName(classData.getPackageName());
            if ("wsdlClass".equals(configuration.getServiceType())) {
                object4 = (WSDLService)list.get(0);
                service.setClassName(((WSDLService)object4).getType());
            } else {
                service.setClassName(classData.getClassName());
            }
            object4 = classData.getProxyClassType();
            if (object4 == null) {
                object4 = classData.getType();
            }
            ((JavonMappingImpl)object2).setProperty("instance", object4);
            Thread.sleep(5000L);
            ((ClassDataRegistry)object3).updateClassDataTree();
            org.netbeans.modules.mobility.e2e.classdata.ClassData classData2 = ((ClassDataRegistry)object3).getClassData((String)object4);
            if (classData2 == null) continue;
            List<OperationData> list3 = classData.getOperations();
            List<MethodData> list4 = classData2.getMethods();
            for (int i = 0; i < list3.size(); ++i) {
                String string = null;
                string = "wsdlClass".equals(configuration.getServiceType()) ? list3.get(i).getMethodName() : list3.get(i).getName();
                int n2 = this.findMethodIndex(list4, string);
                if (n2 < 0) continue;
                MethodData methodData = list4.get(n2);
                methodData.setRequestID(n++);
                service.addMethod(methodData);
            }
            ((JavonMappingImpl)object2).addServiceMaping(service);
        }
        ((JavonMappingImpl)object2).setServletURL(Util.getServerURL(this.getServerProject(), this.getConfiguration()));
        return object2;
    }

    private int findMethodIndex(List<MethodData> list, String string) {
        int n = 0;
        for (MethodData methodData : list) {
            if (methodData.getName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected String getPrefixMark() {
        return "";
    }

    protected boolean parseDocument(boolean bl) {
        return true;
    }

    protected boolean isModelCreated() {
        return false;
    }

    protected String generateDocumentFromModel() {
        return "";
    }

    public synchronized void generate() {
        this.generating = true;
        try {
            this.getEditorSupport().saveDocument();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.firePropertyChange(PROP_GENERATING, Boolean.FALSE, Boolean.TRUE);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (rp == null) {
                    rp = new RequestProcessor("End2EndGenerator", 5);
                }
                rp.post(new Runnable(){

                    public void run() {
                        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(E2EServiceProvider.class));
                        for (E2EServiceProvider e2EServiceProvider : result.allInstances()) {
                            if (!E2EDataObject.this.getConfiguration().getServiceType().equals(e2EServiceProvider.getServiceType())) continue;
                            ServiceGeneratorResult serviceGeneratorResult = e2EServiceProvider.generateStubs(Lookups.singleton((Object)((Object)E2EDataObject.this)));
                        }
                        E2EDataObject.this.generating = false;
                        E2EDataObject.this.firePropertyChange(E2EDataObject.PROP_GENERATING, Boolean.TRUE, Boolean.FALSE);
                    }
                });
            }
        });
    }

    public boolean isGenerating() {
        return this.generating;
    }

    protected DesignMultiViewDesc[] getMultiViewDesc() {
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(E2EServiceProvider.class));
        for (E2EServiceProvider e2EServiceProvider : result.allInstances()) {
            if (!this.getConfiguration().getServiceType().equals(e2EServiceProvider.getServiceType())) continue;
            return e2EServiceProvider.getMultiViewDesc(Lookups.singleton((Object)((Object)this)));
        }
        return null;
    }

    protected synchronized XmlMultiViewEditorSupport getEditorSupport() {
        if (this.editorSupport == null) {
            this.editorSupport = new ValidatedXmlMultiViewEditorSupport(this);
        }
        return this.editorSupport;
    }

    private class ModelSynchronizer
    extends XmlMultiViewDataSynchronizer {
        public ModelSynchronizer(XmlMultiViewDataObject xmlMultiViewDataObject) {
            super(xmlMultiViewDataObject, 100);
        }

        protected boolean mayUpdateData(boolean bl) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateDataFromModel(Object object, FileLock fileLock, boolean bl) {
            if (object == null) {
                return;
            }
            for (SaveCallback object2 : E2EDataObject.this.saveCallbacks) {
                object2.save();
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                if (E2EDataObject.this.configuration != null) {
                    try {
                        ConfigurationWriter.write(byteArrayOutputStream, (Configuration)object);
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify((Throwable)exception);
                    }
                }
                byteArrayOutputStream.close();
                OutputStream outputStream = E2EDataObject.this.getDataCache().createOutputStream(fileLock, bl);
                try {
                    outputStream.write(byteArrayOutputStream.toByteArray());
                }
                finally {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }

        protected Object getModel() {
            return E2EDataObject.this.getConfiguration();
        }

        protected void reloadModelFromData() {
            E2EDataObject.this.getConfiguration();
        }
    }

    private static class ValidatedXmlMultiViewEditorSupport
    extends XmlMultiViewEditorSupport {
        protected final E2EDataObject dataObject;

        public ValidatedXmlMultiViewEditorSupport(XmlMultiViewDataObject xmlMultiViewDataObject) {
            super(xmlMultiViewDataObject);
            this.dataObject = (E2EDataObject)xmlMultiViewDataObject;
        }

        public void open() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Configuration configuration = ValidatedXmlMultiViewEditorSupport.this.dataObject.getConfiguration();
                    if (configuration == null) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(E2EDataObject.class, (String)"ERR_ConfigurationFileCorrupted"));
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                        return;
                    }
                    if (ValidatedXmlMultiViewEditorSupport.this.dataObject.getConfiguration().getServerConfigutation() != null && ValidatedXmlMultiViewEditorSupport.this.dataObject.getServerProject() == null) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(E2EDataObject.class, (String)"ERR_ServerProjectNotOpened", (Object)configuration.getServerConfigutation().getProjectName()));
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                        if (Util.openProject(ValidatedXmlMultiViewEditorSupport.this.dataObject.getConfiguration().getServerConfigutation().getProjectPath()) == null) {
                            return;
                        }
                        return;
                    }
                    ValidatedXmlMultiViewEditorSupport.this.openme();
                }
            });
        }

        protected void openme() {
            super.open();
        }
    }

    public static interface SaveCallback {
        public void save();
    }
}

