/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.ui.TreeRootNode;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceNodeFactory
implements NodeFactory {
    public NodeList<?> createNodes(Project project) {
        GrailsProject grailsProject = (GrailsProject)project.getLookup().lookup(GrailsProject.class);
        assert (grailsProject != null);
        return new SourcesNodeList(grailsProject);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SourceGroupKey
    implements Comparable<SourceGroupKey> {
        public final SourceGroup group;
        public final FileObject fileObject;

        SourceGroupKey(SourceGroup sourceGroup) {
            this.group = sourceGroup;
            this.fileObject = sourceGroup.getRootFolder();
        }

        public int hashCode() {
            return this.fileObject.hashCode();
        }

        @Override
        public int compareTo(SourceGroupKey sourceGroupKey) {
            return this.group.getDisplayName().compareTo(sourceGroupKey.group.getDisplayName());
        }

        public boolean equals(Object object) {
            if (!(object instanceof SourceGroupKey)) {
                return false;
            }
            SourceGroupKey sourceGroupKey = (SourceGroupKey)object;
            String string = this.group.getDisplayName();
            String string2 = sourceGroupKey.group.getDisplayName();
            return this.fileObject.equals(sourceGroupKey.fileObject) && string == null ? string2 == null : string.equals(string2);
        }

        public String toString() {
            return this.group.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SourcesNodeList
    implements NodeList<SourceGroupKey>,
    ChangeListener {
        private GrailsProject project;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        public SourcesNodeList(GrailsProject grailsProject) {
            this.project = grailsProject;
        }

        public List<SourceGroupKey> keys() {
            FileObject fileObject = this.project.getProjectDirectory();
            if (fileObject == null || !fileObject.isValid()) {
                return Collections.emptyList();
            }
            Sources sources = this.getSources();
            ArrayList<SourceGroupKey> arrayList = new ArrayList<SourceGroupKey>();
            for (FileObject fileObject2 : fileObject.getChildren()) {
                SourceGroup[] sourceGroupArray;
                int n;
                FileObject[] fileObjectArray;
                if ("grails-app".equals(fileObject2.getName())) {
                    fileObjectArray = fileObject2.getChildren();
                    int n2 = fileObjectArray.length;
                    for (n = 0; n < n2; ++n) {
                        FileObject fileObject3 = fileObjectArray[n];
                        if (!fileObject3.isFolder()) continue;
                        for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("grails-app/" + fileObject3.getName())) {
                            arrayList.add(new SourceGroupKey(sourceGroup));
                        }
                    }
                    continue;
                }
                if ("src".equals(fileObject2.getName())) {
                    fileObjectArray = fileObject2.getChildren();
                    int n3 = fileObjectArray.length;
                    for (n = 0; n < n3; ++n) {
                        FileObject fileObject4 = fileObjectArray[n];
                        if (!fileObject4.isFolder()) continue;
                        for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("src/" + fileObject4.getName())) {
                            arrayList.add(new SourceGroupKey(sourceGroup));
                        }
                    }
                    continue;
                }
                if ("test".equals(fileObject2.getName())) {
                    fileObjectArray = fileObject2.getChildren();
                    int n4 = fileObjectArray.length;
                    for (n = 0; n < n4; ++n) {
                        FileObject fileObject5 = fileObjectArray[n];
                        if (!fileObject5.isFolder()) continue;
                        for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("test/" + fileObject5.getName())) {
                            arrayList.add(new SourceGroupKey(sourceGroup));
                        }
                    }
                    continue;
                }
                if (!fileObject2.isFolder()) continue;
                FileObject[] fileObjectArray2 = fileObjectArray = sources.getSourceGroups(fileObject2.getName());
                n = fileObjectArray2.length;
                for (int i = 0; i < n; ++i) {
                    sourceGroupArray = fileObjectArray2[i];
                    arrayList.add(new SourceGroupKey((SourceGroup)sourceGroupArray));
                }
            }
            return arrayList;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        public Node node(SourceGroupKey sourceGroupKey) {
            return new TreeRootNode(sourceGroupKey.group, this.project);
        }

        public void addNotify() {
            this.getSources().addChangeListener((ChangeListener)this);
        }

        public void removeNotify() {
            this.getSources().removeChangeListener((ChangeListener)this);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SourcesNodeList.this.changeSupport.fireChange();
                }
            });
        }

        private Sources getSources() {
            return ProjectUtils.getSources((Project)this.project);
        }
    }
}

