/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.groovy.grailsproject.ui.DebugCustomizerPanel;
import org.netbeans.modules.groovy.grailsproject.ui.GeneralCustomizerPanel;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionStarterService;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.NbBundle;

public class GrailsProjectCustomizerProvider
implements CustomizerProvider {
    private ProjectCustomizer.Category[] categories;
    private ProjectCustomizer.CategoryComponentProvider panelProvider;
    private static final String GENERAL_CATEGORY = "GeneralCategory";
    private static final String DEBUG_CATEGORY = "DebugCategory";
    Project project;

    public GrailsProjectCustomizerProvider(Project project) {
        this.project = project;
    }

    private void init() {
        ArrayList<ProjectCustomizer.Category> arrayList = new ArrayList<ProjectCustomizer.Category>();
        ProjectCustomizer.Category category = ProjectCustomizer.Category.create((String)GENERAL_CATEGORY, (String)NbBundle.getMessage(GrailsProjectCustomizerProvider.class, (String)"LBL_GeneralSettings"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        arrayList.add(category);
        HashMap<ProjectCustomizer.Category, JPanel> hashMap = new HashMap<ProjectCustomizer.Category, JPanel>();
        hashMap.put(category, new GeneralCustomizerPanel(this.project));
        if (WebClientToolsSessionStarterService.isAvailable()) {
            ProjectCustomizer.Category category2 = ProjectCustomizer.Category.create((String)DEBUG_CATEGORY, (String)NbBundle.getMessage(GrailsProjectCustomizerProvider.class, (String)"DEBUG_CATEGORY"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
            arrayList.add(category2);
            hashMap.put(category2, new DebugCustomizerPanel(this.project));
        }
        this.categories = arrayList.toArray(new ProjectCustomizer.Category[0]);
        this.panelProvider = new PanelProvider(hashMap);
    }

    public void showCustomizer() {
        this.init();
        OptionListener optionListener = new OptionListener(this.project);
        Dialog dialog = ProjectCustomizer.createCustomizerDialog((ProjectCustomizer.Category[])this.categories, (ProjectCustomizer.CategoryComponentProvider)this.panelProvider, null, (ActionListener)optionListener, null);
        dialog.addWindowListener(optionListener);
        dialog.setTitle(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        dialog.setVisible(true);
    }

    private static class PanelProvider
    implements ProjectCustomizer.CategoryComponentProvider {
        private Map panels;
        private JPanel EMPTY_PANEL = new JPanel();

        public PanelProvider(Map map) {
            this.panels = map;
        }

        public JComponent create(ProjectCustomizer.Category category) {
            JComponent jComponent = (JComponent)this.panels.get(category);
            return jComponent == null ? this.EMPTY_PANEL : jComponent;
        }
    }

    private class OptionListener
    extends WindowAdapter
    implements ActionListener {
        private Project project;

        OptionListener(Project project) {
            this.project = project;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
        }
    }
}

