/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.plugins;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.extexecution.api.ExecutionDescriptor;
import org.netbeans.modules.extexecution.api.ExecutionService;
import org.netbeans.modules.extexecution.api.input.InputProcessor;
import org.netbeans.modules.extexecution.api.input.InputProcessors;
import org.netbeans.modules.extexecution.api.input.LineProcessor;
import org.netbeans.modules.groovy.grails.api.ExecutionSupport;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.actions.RefreshProjectRunnable;
import org.netbeans.modules.groovy.grailsproject.plugins.GrailsPlugin;
import org.netbeans.modules.groovy.grailsproject.plugins.InstallingPluginPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrailsPluginsManager {
    private final GrailsProject project;

    private GrailsPluginsManager(GrailsProject grailsProject) {
        this.project = grailsProject;
    }

    public static GrailsPluginsManager getInstance(GrailsProject grailsProject) {
        return new GrailsPluginsManager(grailsProject);
    }

    public List<GrailsPlugin> refreshAvailablePlugins() {
        ProjectInformation projectInformation = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
        String string = projectInformation.getDisplayName() + " (" + "list-plugins" + ")";
        Callable callable = ExecutionSupport.getInstance().createSimpleCommand("list-plugins", GrailsProjectConfig.forProject((Project)this.project), new String[0]);
        final PluginProcessor pluginProcessor = new PluginProcessor();
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().frontWindow(true);
        executionDescriptor = executionDescriptor.outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

            public InputProcessor newInputProcessor() {
                return InputProcessors.bridge((LineProcessor)pluginProcessor);
            }
        });
        ExecutionService executionService = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)executionDescriptor, (String)string);
        try {
            executionService.run().get();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            Exceptions.printStackTrace((Throwable)executionException.getCause());
        }
        return pluginProcessor.getPlugins();
    }

    public List<GrailsPlugin> refreshInstalledPlugins() {
        ArrayList<GrailsPlugin> arrayList = new ArrayList<GrailsPlugin>();
        try {
            FileObject fileObject = this.project.getProjectDirectory().getFileObject("plugins");
            if (fileObject != null && fileObject.isFolder()) {
                fileObject.refresh();
                for (FileObject fileObject2 : fileObject.getChildren()) {
                    FileObject fileObject3;
                    if (!fileObject2.isFolder() || (fileObject3 = fileObject2.getFileObject("plugin.xml")) == null || !fileObject3.canRead()) continue;
                    arrayList.add(this.getPluginFromInputStream(fileObject3.getInputStream(), null));
                }
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public boolean uninstallPlugins(Collection<GrailsPlugin> collection) {
        FileObject fileObject;
        if (collection != null && collection.size() > 0 && (fileObject = this.project.getProjectDirectory().getFileObject("plugins")) != null && fileObject.isFolder() && fileObject.canWrite()) {
            fileObject.refresh();
            try {
                for (GrailsPlugin grailsPlugin : collection) {
                    FileObject fileObject2;
                    FileObject fileObject3 = fileObject.getFileObject(grailsPlugin.getDirName());
                    if (fileObject3 != null && fileObject3.isValid()) {
                        fileObject3.delete();
                    }
                    if ((fileObject2 = fileObject.getFileObject(grailsPlugin.getZipName())) == null || !fileObject2.isValid()) continue;
                    fileObject2.delete();
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        return true;
    }

    public boolean installPlugins(Collection<GrailsPlugin> collection) {
        if (collection == null || collection.size() <= 0) {
            return false;
        }
        boolean bl = true;
        JButton[] jButtonArray = this.getProgressDlgButtons();
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        for (GrailsPlugin grailsPlugin : collection) {
            final Dialog dialog = this.getProgressDialog(grailsPlugin, jButtonArray);
            jButtonArray[0].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            });
            Callable<Boolean> callable = this.getInstallPluginCallable(grailsPlugin, jButtonArray[1], dialog);
            Future<Boolean> future = executorService.submit(callable);
            dialog.setVisible(true);
            try {
                bl = bl && future.get() != false;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (ExecutionException executionException) {
                Exceptions.printStackTrace((Throwable)(executionException.getCause() != null ? executionException.getCause() : executionException));
            }
        }
        executorService.shutdown();
        return bl;
    }

    private Callable<Boolean> getInstallPluginCallable(final GrailsPlugin grailsPlugin, final JButton jButton, final Dialog dialog) {
        return new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() {
                Constable constable;
                String[] stringArray;
                ProjectInformation projectInformation = (ProjectInformation)GrailsPluginsManager.this.project.getLookup().lookup(ProjectInformation.class);
                String string = projectInformation.getDisplayName() + " (" + "install-plugin" + ")";
                if (grailsPlugin.getPath() == null) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = grailsPlugin.getName();
                    stringArray = stringArray2;
                    stringArray2[1] = grailsPlugin.getVersion();
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = grailsPlugin.getPath();
                }
                String[] stringArray4 = stringArray;
                Callable callable = ExecutionSupport.getInstance().createSimpleCommand("install-plugin", GrailsProjectConfig.forProject((Project)GrailsPluginsManager.this.project), stringArray4);
                ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().frontWindow(true).postExecution((Runnable)new RefreshProjectRunnable(GrailsPluginsManager.this.project));
                ExecutionService executionService = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)executionDescriptor, (String)string);
                final Future future = executionService.run();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        jButton.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                future.cancel(true);
                            }
                        });
                    }
                });
                boolean bl = false;
                boolean bl2 = false;
                try {
                    try {
                        constable = (Integer)future.get();
                        if (constable != 0) {
                            bl = true;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        bl2 = true;
                        future.cancel(true);
                        bl = true;
                    }
                    catch (ExecutionException executionException) {
                        bl = true;
                        Exceptions.printStackTrace((Throwable)(executionException.getCause() != null ? executionException.getCause() : executionException));
                    }
                    catch (CancellationException cancellationException) {
                        bl = true;
                    }
                    if (bl) {
                        GrailsPluginsManager.this.uninstallPlugins(Collections.singletonList(grailsPlugin));
                    }
                    constable = Boolean.valueOf(!bl);
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            dialog.setVisible(false);
                            dialog.dispose();
                        }
                    });
                    if (bl2) {
                        Thread.currentThread().interrupt();
                    }
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                if (bl2) {
                    Thread.currentThread().interrupt();
                }
                return constable;
            }
        };
    }

    private Dialog getProgressDialog(GrailsPlugin grailsPlugin, JButton[] jButtonArray) {
        String string = NbBundle.getMessage(GrailsPluginsManager.class, (String)"Installation");
        InstallingPluginPanel installingPluginPanel = new InstallingPluginPanel(NbBundle.getMessage(GrailsPluginsManager.class, (String)"PluginPleaseWait", (Object)grailsPlugin.getName()));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)installingPluginPanel, string, true, (Object[])jButtonArray, (Object)jButtonArray[0], 0, new HelpCtx(InstallingPluginPanel.class), null);
        dialogDescriptor.setModal(true);
        return DialogDisplayer.getDefault().createDialog(dialogDescriptor);
    }

    private JButton[] getProgressDlgButtons() {
        JButton jButton = new JButton(NbBundle.getMessage(GrailsPluginsManager.class, (String)"CTL_Close"));
        JButton jButton2 = new JButton(NbBundle.getMessage(GrailsPluginsManager.class, (String)"CTL_Cancel"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GrailsPluginsManager.class, (String)"CTL_Close"));
        jButton.setEnabled(false);
        return new JButton[]{jButton, jButton2};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GrailsPlugin getPluginFromZipFile(String string) {
        GrailsPlugin grailsPlugin = null;
        try {
            ZipFile zipFile = new ZipFile(new File(string));
            try {
                ZipEntry zipEntry = zipFile.getEntry("plugin.xml");
                if (zipEntry != null) {
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    grailsPlugin = this.getPluginFromInputStream(inputStream, string);
                }
            }
            finally {
                zipFile.close();
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        return grailsPlugin;
    }

    private GrailsPlugin getPluginFromInputStream(InputStream inputStream, String string) throws Exception {
        Document document = XMLUtil.parse((InputSource)new InputSource(inputStream), (boolean)false, (boolean)false, null, null);
        Node node = document.getFirstChild();
        String string2 = node.getAttributes().getNamedItem("name").getTextContent();
        String string3 = null;
        String string4 = null;
        if (node.getAttributes().getNamedItem("version") != null) {
            string3 = node.getAttributes().getNamedItem("version").getTextContent();
        }
        if (document.getElementsByTagName("title") != null && document.getElementsByTagName("title").getLength() > 0) {
            string4 = document.getElementsByTagName("title").item(0).getTextContent();
        }
        return new GrailsPlugin(string2, string3, string4, string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PluginProcessor
    implements LineProcessor {
        private final List<GrailsPlugin> plugins = Collections.synchronizedList(new ArrayList());
        private static final Pattern PLUGIN_PATTERN = Pattern.compile("(.+)[\\s]+<([\\w\\s.-]+)>[\\s]+--(.+)");

        private PluginProcessor() {
        }

        public void processLine(String string) {
            GrailsPlugin grailsPlugin = null;
            Matcher matcher = PLUGIN_PATTERN.matcher(string);
            if (matcher.matches() && !"no releases".equals(matcher.group(2))) {
                grailsPlugin = new GrailsPlugin(matcher.group(1).trim(), matcher.group(2), matcher.group(3));
            }
            if (grailsPlugin != null) {
                this.plugins.add(grailsPlugin);
            }
        }

        public void reset() {
        }

        public void close() {
        }

        public List<GrailsPlugin> getPlugins() {
            return this.plugins;
        }
    }
}

