/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.awt.Image;
import java.text.DateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.netbeans.modules.web.monitor.client.DeleteAction;
import org.netbeans.modules.web.monitor.client.EditReplayAction;
import org.netbeans.modules.web.monitor.client.ReplayAction;
import org.netbeans.modules.web.monitor.client.SaveAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class TransactionNode
extends AbstractNode {
    String id;
    String method;
    String uri;
    String name = null;
    String timestamp = null;
    boolean current;
    private int statusCode;
    static boolean showTimeStamp = true;

    public TransactionNode(String string, String string2, String string3, boolean bl, int n) {
        super(Children.LEAF);
        this.id = string;
        this.method = string2;
        this.uri = string3;
        this.current = bl;
        this.statusCode = n;
        this.setProperties();
    }

    public TransactionNode(String string, String string2, String string3, Children children, boolean bl, int n) {
        super(children);
        this.id = string;
        this.method = string2;
        this.uri = string3;
        this.current = bl;
        this.statusCode = n;
        this.setProperties();
    }

    public String getLongName() {
        StringBuffer stringBuffer = new StringBuffer(this.method);
        stringBuffer.append(" ");
        stringBuffer.append(this.uri);
        if (this.timestamp == null) {
            this.setTimeStamp();
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.timestamp);
        return stringBuffer.toString();
    }

    public Image getIcon(int n) {
        Image image;
        Image image2 = this.method.equals("GET") ? Utilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/get.gif") : (this.method.equals("POST") ? Utilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/post.gif") : Utilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/other.gif"));
        if (this.statusCode >= 400 || this.statusCode < 0) {
            image = Utilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/infoBadge.gif");
        } else if (this.statusCode >= 300) {
            image = Utilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/warningBadge.gif");
        } else {
            if (this.statusCode >= 200) {
                return image2;
            }
            image = Utilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/errorBadge.gif");
        }
        return Utilities.mergeImages((Image)image2, (Image)image, (int)0, (int)0);
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public String getID() {
        return this.id;
    }

    public String getMethod() {
        return this.method;
    }

    public String getURI() {
        return this.uri;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean bl) {
        this.current = bl;
    }

    protected SystemAction[] createActions() {
        if (this.current) {
            return new SystemAction[]{SystemAction.get((Class)SaveAction.class), null, SystemAction.get((Class)ReplayAction.class), SystemAction.get((Class)EditReplayAction.class), null, SystemAction.get((Class)DeleteAction.class)};
        }
        return new SystemAction[]{SystemAction.get((Class)ReplayAction.class), SystemAction.get((Class)EditReplayAction.class), null, SystemAction.get((Class)DeleteAction.class)};
    }

    public SystemAction[] getActions() {
        if (this.current) {
            return new SystemAction[]{SystemAction.get((Class)SaveAction.class), null, SystemAction.get((Class)ReplayAction.class), SystemAction.get((Class)EditReplayAction.class), null, SystemAction.get((Class)DeleteAction.class)};
        }
        return new SystemAction[]{SystemAction.get((Class)ReplayAction.class), SystemAction.get((Class)EditReplayAction.class), null, SystemAction.get((Class)DeleteAction.class)};
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return false;
    }

    public static void toggleTimeStamp() {
        showTimeStamp = !showTimeStamp;
    }

    public static boolean showTimeStamp() {
        return showTimeStamp;
    }

    private void setProperties() {
        this.setNameString();
        this.setShortDescription(this.uri);
    }

    public void setNameString() {
        Object object;
        String string = null;
        if (this.uri.equals("/")) {
            string = this.uri;
        } else {
            object = new StringTokenizer(this.uri, "/");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string = ((StringTokenizer)object).nextToken();
            }
        }
        object = new StringBuilder(this.method);
        ((StringBuilder)object).append(' ');
        ((StringBuilder)object).append(string);
        if (showTimeStamp) {
            if (this.timestamp == null) {
                this.setTimeStamp();
            }
            ((StringBuilder)object).append(' ');
            ((StringBuilder)object).append(this.timestamp);
        }
        this.setName(((StringBuilder)object).toString());
    }

    private void setTimeStamp() {
        try {
            long l = Long.valueOf(this.id);
            Date date = new Date(l);
            StringBuilder stringBuilder = new StringBuilder(91);
            DateFormat dateFormat = DateFormat.getTimeInstance(3);
            stringBuilder.append(dateFormat.format(date));
            stringBuilder.append(" ");
            dateFormat = DateFormat.getDateInstance(3);
            stringBuilder.append(dateFormat.format(date));
            stringBuilder.append(']');
            this.timestamp = stringBuilder.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TransactionNode: ");
        stringBuilder.append(this.getName());
        stringBuilder.append('\n');
        stringBuilder.append("id=");
        stringBuilder.append(this.id);
        stringBuilder.append('\n');
        stringBuilder.append("method=");
        stringBuilder.append(this.method);
        stringBuilder.append('\n');
        stringBuilder.append("uri=");
        stringBuilder.append(this.uri);
        stringBuilder.append('\n');
        stringBuilder.append("current=");
        stringBuilder.append(String.valueOf(this.current));
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }
}

