/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;

public class ComboBoxTableCellEditor
extends DefaultCellEditor
implements TableCellEditor {
    private JPanel editor;
    private boolean tableListenerAdded = false;
    private JTable table;
    private Runnable comboBoxFocusRequester;
    private Runnable comboBoxOpener;
    private int currentRow = -1;
    private Object prevItem;
    private Object initialValue;
    private boolean consumeComboBoxActionEvent = true;
    private EventObject startEditingEvent = null;

    public ComboBoxTableCellEditor(Object[] objectArray, ListCellRenderer listCellRenderer) {
        super(new JComboBox());
        this.setItems(objectArray);
        this.editor = new JPanel(new BorderLayout());
        this.setClickCountToStart(1);
        this.editor.addMouseListener(new MouseAdapter(){

            public final void mousePressed(MouseEvent mouseEvent) {
                ComboBoxTableCellEditor.this.eventEditorMousePressed();
            }
        });
        JComboBox jComboBox = this.getComboBox();
        if (listCellRenderer != null) {
            jComboBox.setRenderer(listCellRenderer);
        }
        jComboBox.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                ComboBoxTableCellEditor.this.eventComboBoxActionPerformed();
            }
        });
        this.comboBoxFocusRequester = new Runnable(){

            public final void run() {
                ComboBoxTableCellEditor.this.getComboBox().requestFocus();
            }
        };
        this.comboBoxOpener = new Runnable(){

            public final void run() {
                if (ComboBoxTableCellEditor.this.startEditingEvent instanceof MouseEvent) {
                    try {
                        ComboBoxTableCellEditor.this.getComboBox().setPopupVisible(true);
                    }
                    catch (IllegalComponentStateException illegalComponentStateException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    public ComboBoxTableCellEditor(Object[] objectArray) {
        this(objectArray, null);
    }

    public ComboBoxTableCellEditor() {
        this(new Object[0], null);
    }

    public ComboBoxTableCellEditor(ListCellRenderer listCellRenderer) {
        this(new Object[0], listCellRenderer);
    }

    public final Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (!this.tableListenerAdded) {
            this.tableListenerAdded = true;
            this.table = jTable;
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public final void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ComboBoxTableCellEditor.this.eventTableSelectionChanged();
                }
            });
        }
        this.currentRow = n;
        this.initialValue = object;
        return this.getEditorComponent(jTable, object, bl, n, n2);
    }

    protected Component getEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.setSelectedItem(object);
        bl = jTable.isRowSelected(n);
        if (bl) {
            SwingUtilities.invokeLater(this.comboBoxFocusRequester);
            SwingUtilities.invokeLater(this.comboBoxOpener);
            return this.getComboBox();
        }
        this.editor.removeAll();
        return this.editor;
    }

    public boolean isCellEditable(EventObject eventObject) {
        this.startEditingEvent = eventObject;
        if (eventObject instanceof MouseEvent && eventObject.getSource() instanceof JTable) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            JTable jTable = (JTable)mouseEvent.getSource();
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            int n = jTable.rowAtPoint(point);
            int n2 = jTable.columnAtPoint(point);
            Rectangle rectangle = jTable.getCellRect(n, n2, false);
            if (mouseEvent.getY() >= rectangle.y + rectangle.height || mouseEvent.getX() >= rectangle.x + rectangle.width) {
                return false;
            }
        }
        return super.isCellEditable(eventObject);
    }

    public Object getCellEditorValue() {
        return this.prevItem;
    }

    protected void setSelectedItem(Object object) {
        if (this.getComboBox().getSelectedItem() != object) {
            this.consumeComboBoxActionEvent = false;
            this.getComboBox().setSelectedItem(object);
            this.consumeComboBoxActionEvent = true;
        }
    }

    public final void setItems(Object[] objectArray) {
        JComboBox jComboBox = this.getComboBox();
        jComboBox.removeAllItems();
        int n = objectArray != null ? objectArray.length : 0;
        for (int i = 0; i < n; ++i) {
            jComboBox.addItem(objectArray[i]);
        }
    }

    final void eventEditorMousePressed() {
        this.editor.add(this.getComboBox());
        this.editor.revalidate();
        SwingUtilities.invokeLater(this.comboBoxFocusRequester);
    }

    protected void eventTableSelectionChanged() {
        if (!this.table.isRowSelected(this.currentRow)) {
            this.stopCellEditing();
        }
    }

    protected void eventComboBoxActionPerformed() {
        Object object = this.getComboBox().getSelectedItem();
        if (object != null) {
            this.prevItem = object;
        }
        if (this.consumeComboBoxActionEvent) {
            this.stopCellEditing();
        }
    }

    public final JComboBox getComboBox() {
        return (JComboBox)this.getComponent();
    }

    public final Object getInitialValue() {
        return this.initialValue;
    }

    public final int getCurrentRow() {
        return this.currentRow;
    }
}

