/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.config.ds;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.jboss4.config.JBossDatasource;
import org.netbeans.modules.j2ee.jboss4.config.ResourceConfigurationHelper;
import org.netbeans.modules.j2ee.jboss4.config.gen.Datasources;
import org.netbeans.modules.j2ee.jboss4.config.gen.LocalTxDatasource;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasourceSupport {
    private static final String DS_RESOURCE_NAME = "jboss-ds.xml";
    private File resourceDir;
    private Datasources datasources;
    private File datasourcesFile;
    private FileObject datasourcesFO;

    public DatasourceSupport(File file) {
        assert (file != null) : "Resource directory can't be null";
        this.resourceDir = file;
        this.datasourcesFile = new File(file, DS_RESOURCE_NAME);
        this.ensureDatasourcesFOExists();
    }

    private void ensureDatasourcesFOExists() {
        if (!this.datasourcesFile.exists()) {
            return;
        }
        if (this.datasourcesFO == null || !this.datasourcesFO.isValid()) {
            this.datasourcesFO = FileUtil.toFileObject((File)this.datasourcesFile);
            assert (this.datasourcesFO != null);
            this.datasourcesFO.addFileChangeListener((FileChangeListener)new DatasourceFileListener());
        }
    }

    public Set<Datasource> getDatasources() throws ConfigurationException {
        HashSet<Datasource> hashSet = new HashSet<Datasource>();
        Datasources datasources = this.getDatasourcesGraph();
        if (datasources != null) {
            LocalTxDatasource[] localTxDatasourceArray = this.datasources.getLocalTxDatasource();
            for (int i = 0; i < localTxDatasourceArray.length; ++i) {
                if (localTxDatasourceArray[i].getJndiName().length() <= 0) continue;
                hashSet.add(new JBossDatasource(localTxDatasourceArray[i].getJndiName(), localTxDatasourceArray[i].getConnectionUrl(), localTxDatasourceArray[i].getUserName(), localTxDatasourceArray[i].getPassword(), localTxDatasourceArray[i].getDriverClass()));
            }
        }
        return hashSet;
    }

    private synchronized Datasources getDatasourcesGraph() {
        block7: {
            try {
                if (this.datasourcesFile.exists()) {
                    try {
                        if (this.datasources == null) {
                            this.datasources = Datasources.createGraph(this.datasourcesFile);
                        }
                        break block7;
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    catch (RuntimeException runtimeException) {}
                    break block7;
                }
                this.datasources = new Datasources();
                ResourceConfigurationHelper.writeFile(this.datasourcesFile, this.datasources);
                this.ensureDatasourcesFOExists();
            }
            catch (ConfigurationException configurationException) {
                Exceptions.printStackTrace((Throwable)configurationException);
            }
        }
        return this.datasources;
    }

    public JBossDatasource createDatasource(String string, String string2, String string3, String string4, String string5) throws UnsupportedOperationException, ConfigurationException, DatasourceAlreadyExistsException {
        JBossDatasource jBossDatasource = this.modifyDSResource(new DSResourceModifier(string, string2, string3, string4, string5){

            JBossDatasource modify(Datasources datasources) throws DatasourceAlreadyExistsException {
                LocalTxDatasource[] localTxDatasourceArray = datasources.getLocalTxDatasource();
                for (int i = 0; i < localTxDatasourceArray.length; ++i) {
                    String string = localTxDatasourceArray[i].getJndiName();
                    if (!this.rawName.equals(JBossDatasource.getRawName(string))) continue;
                    JBossDatasource jBossDatasource = new JBossDatasource(string, localTxDatasourceArray[i].getConnectionUrl(), localTxDatasourceArray[i].getUserName(), localTxDatasourceArray[i].getPassword(), localTxDatasourceArray[i].getDriverClass());
                    throw new DatasourceAlreadyExistsException((Datasource)jBossDatasource);
                }
                LocalTxDatasource localTxDatasource = new LocalTxDatasource();
                localTxDatasource.setJndiName(this.rawName);
                localTxDatasource.setConnectionUrl(this.url);
                localTxDatasource.setDriverClass(this.driver);
                localTxDatasource.setUserName(this.username);
                localTxDatasource.setPassword(this.password);
                localTxDatasource.setMinPoolSize("5");
                localTxDatasource.setMaxPoolSize("20");
                localTxDatasource.setIdleTimeoutMinutes("5");
                datasources.addLocalTxDatasource(localTxDatasource);
                return new JBossDatasource(this.rawName, this.url, this.username, this.password, this.driver);
            }
        });
        return jBossDatasource;
    }

    private JBossDatasource modifyDSResource(DSResourceModifier dSResourceModifier) throws ConfigurationException, DatasourceAlreadyExistsException {
        JBossDatasource jBossDatasource = null;
        try {
            Datasources datasources;
            this.ensureResourceDirExists();
            this.ensureDatasourcesFileExists();
            DataObject dataObject = DataObject.find((FileObject)this.datasourcesFO);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            StyledDocument styledDocument = editorCookie.getDocument();
            if (styledDocument == null) {
                styledDocument = editorCookie.openDocument();
            }
            Datasources datasources2 = null;
            try {
                byte[] byArray = styledDocument.getText(0, styledDocument.getLength()).getBytes();
                datasources2 = Datasources.createGraph(new ByteArrayInputStream(byArray));
            }
            catch (RuntimeException runtimeException) {
                datasources = this.getDatasourcesGraph();
                if (datasources == null) {
                    throw new ConfigurationException(NbBundle.getMessage(DatasourceSupport.class, (String)"MSG_datasourcesXmlCannotParse", (Object)DS_RESOURCE_NAME));
                }
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(DatasourceSupport.class, (String)"MSG_datasourcesXmlNotValid", (Object)DS_RESOURCE_NAME), 2);
                Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (object == NotifyDescriptor.CANCEL_OPTION) {
                    return null;
                }
                datasources2 = datasources;
            }
            jBossDatasource = dSResourceModifier.modify(datasources2);
            boolean bl = dataObject.isModified();
            ResourceConfigurationHelper.replaceDocument(styledDocument, datasources2);
            if (!bl) {
                datasources = (SaveCookie)dataObject.getCookie(SaveCookie.class);
                datasources.save();
            }
            this.datasources = datasources2;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(DatasourceSupport.class, (String)"MSG_CannotUpdateFile", (Object)this.datasourcesFile.getAbsolutePath());
            throw new ConfigurationException(string, (Throwable)iOException);
        }
        return jBossDatasource;
    }

    private void ensureResourceDirExists() {
        if (!this.resourceDir.exists()) {
            this.resourceDir.mkdir();
        }
    }

    private void ensureDatasourcesFileExists() {
        if (!this.datasourcesFile.exists()) {
            this.getDatasourcesGraph();
        }
    }

    private abstract class DSResourceModifier {
        String rawName;
        String url;
        String username;
        String password;
        String driver;

        DSResourceModifier(String string, String string2, String string3, String string4, String string5) {
            this.rawName = JBossDatasource.getRawName(string);
            this.url = string2;
            this.username = string3;
            this.password = string4;
            this.driver = string5;
        }

        abstract JBossDatasource modify(Datasources var1) throws DatasourceAlreadyExistsException;
    }

    private class DatasourceFileListener
    extends FileChangeAdapter {
        private DatasourceFileListener() {
        }

        public void fileChanged(FileEvent fileEvent) {
            assert (fileEvent.getSource() == DatasourceSupport.this.datasourcesFO);
            DatasourceSupport.this.datasources = null;
        }

        public void fileDeleted(FileEvent fileEvent) {
            assert (fileEvent.getSource() == DatasourceSupport.this.datasourcesFO);
            DatasourceSupport.this.datasources = null;
        }
    }
}

