/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xpath.ext.metadata.impl;

import java.util.ArrayList;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.xpath.ext.metadata.XPathMetadataUtils;
import org.netbeans.modules.xml.xpath.ext.metadata.XPathType;

public abstract class XPathTypes {

    public static final class XPathAnyType
    implements XPathType {
        public XPathType.MetaType getMetaType() {
            return XPathType.MetaType.ANY_TYPE;
        }

        public String getName() {
            return "Any Type";
        }

        public boolean isAssignableFrom(XPathType xPathType) {
            return true;
        }
    }

    public static final class XPathNodeType
    implements XPathType {
        public XPathType.MetaType getMetaType() {
            return XPathType.MetaType.NODE;
        }

        public String getName() {
            return "Node";
        }

        public boolean isAssignableFrom(XPathType xPathType) {
            return xPathType instanceof XPathNodeType;
        }
    }

    public static final class XPathNodeSetType
    implements XPathType {
        public XPathType.MetaType getMetaType() {
            return XPathType.MetaType.NODE_SET;
        }

        public String getName() {
            return "Node Set";
        }

        public boolean isAssignableFrom(XPathType xPathType) {
            return xPathType instanceof XPathNodeSetType || xPathType instanceof XPathNodeType;
        }
    }

    public static final class XPathNumberType
    implements XPathType {
        private ArrayList<GlobalType> mNumberTypes = new ArrayList();

        public XPathNumberType() {
            this.mNumberTypes.add(XPathMetadataUtils.findPrimitiveType("decimal"));
            this.mNumberTypes.add(XPathMetadataUtils.findPrimitiveType("double"));
            this.mNumberTypes.add(XPathMetadataUtils.findPrimitiveType("float"));
            this.mNumberTypes.add(XPathMetadataUtils.findPrimitiveType("hexBinary"));
        }

        public XPathType.MetaType getMetaType() {
            return XPathType.MetaType.NUMBER;
        }

        public String getName() {
            return "Number";
        }

        public boolean isAssignableFrom(XPathType xPathType) {
            if (xPathType instanceof XPathNumberType) {
                return true;
            }
            if (xPathType instanceof XPathType.XPathSchemaType) {
                SchemaComponent schemaComponent = ((XPathType.XPathSchemaType)xPathType).getSchemaType();
                for (GlobalType globalType : this.mNumberTypes) {
                    if (schemaComponent == globalType) {
                        return true;
                    }
                    if (!XPathMetadataUtils.isTypeDerived((SchemaComponent)globalType, schemaComponent)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
    }

    public static final class XPathBooleanType
    extends XPathType.XPathSchemaType {
        public XPathBooleanType() {
            super((SchemaComponent)XPathMetadataUtils.findPrimitiveType("boolean"));
        }

        public XPathType.MetaType getMetaType() {
            return XPathType.MetaType.BOOLEAN;
        }

        public String getName() {
            return "Boolean";
        }

        public boolean isAssignableFrom(XPathType xPathType) {
            if (xPathType instanceof XPathBooleanType) {
                return true;
            }
            if (xPathType instanceof XPathType.XPathSchemaType) {
                SchemaComponent schemaComponent = ((XPathType.XPathSchemaType)xPathType).getSchemaType();
                if (schemaComponent == this.mSchemaType) {
                    return true;
                }
                return XPathMetadataUtils.isTypeDerived(this.mSchemaType, schemaComponent);
            }
            return false;
        }
    }

    public static final class XPathStringType
    extends XPathType.XPathSchemaType {
        public XPathStringType() {
            super((SchemaComponent)XPathMetadataUtils.findPrimitiveType("string"));
        }

        public XPathType.MetaType getMetaType() {
            return XPathType.MetaType.STRING;
        }

        public String getName() {
            return "String";
        }

        public boolean isAssignableFrom(XPathType xPathType) {
            if (xPathType instanceof XPathStringType) {
                return true;
            }
            if (xPathType instanceof XPathType.XPathSchemaType) {
                SchemaComponent schemaComponent = ((XPathType.XPathSchemaType)xPathType).getSchemaType();
                if (schemaComponent == this.mSchemaType) {
                    return true;
                }
                return XPathMetadataUtils.isTypeDerived(this.mSchemaType, schemaComponent);
            }
            return false;
        }
    }
}

