/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.beans.IntrospectionException;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.modules.i18n.I18nUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.BeanNode;
import org.openide.util.HelpCtx;
import org.openide.util.NbPreferences;

public class I18nOptions {
    private static final I18nOptions INSTANCE = new I18nOptions();
    public static final String PROP_INIT_JAVA_CODE = "initJavaCode";
    public static final String PROP_REPLACE_JAVA_CODE = "replaceJavaCode";
    public static final String PROP_REGULAR_EXPRESSION = "regularExpression";
    public static final String PROP_I18N_REGULAR_EXPRESSION = "i18nRegularExpression";
    public static final String PROP_REPLACE_RESOURCE_VALUE = "replaceResourceValue";
    public static final String PROP_LAST_RESOURCE2 = "lastResource2";

    private I18nOptions() {
    }

    public static I18nOptions getDefault() {
        return INSTANCE;
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(I18nOptions.class);
    }

    public String displayName() {
        return I18nUtil.getBundle().getString("LBL_Internationalization");
    }

    public String getInitJavaCode() {
        return I18nOptions.getPreferences().get(PROP_INIT_JAVA_CODE, I18nUtil.getInitFormatItems().get(0));
    }

    public void setInitJavaCode(String string) {
        I18nOptions.getPreferences().put(PROP_INIT_JAVA_CODE, string);
    }

    public String getReplaceJavaCode() {
        return I18nOptions.getPreferences().get(PROP_REPLACE_JAVA_CODE, I18nUtil.getDefaultReplaceFormat(false));
    }

    public void setReplaceJavaCode(String string) {
        I18nOptions.getPreferences().put(PROP_REPLACE_JAVA_CODE, string);
    }

    public String getRegularExpression() {
        return I18nOptions.getPreferences().get(PROP_REGULAR_EXPRESSION, I18nUtil.getRegExpItems().get(0));
    }

    public void setRegularExpression(String string) {
        I18nOptions.getPreferences().put(PROP_REGULAR_EXPRESSION, string);
    }

    public String getI18nRegularExpression() {
        return I18nOptions.getPreferences().get(PROP_I18N_REGULAR_EXPRESSION, I18nUtil.getI18nRegExpItems().get(0));
    }

    public void setI18nRegularExpression(String string) {
        I18nOptions.getPreferences().put(PROP_I18N_REGULAR_EXPRESSION, string);
    }

    public boolean isReplaceResourceValue() {
        return I18nOptions.getPreferences().getBoolean(PROP_REPLACE_RESOURCE_VALUE, false);
    }

    public void setReplaceResourceValue(boolean bl) {
        I18nOptions.getPreferences().putBoolean(PROP_REPLACE_RESOURCE_VALUE, bl);
    }

    public DataObject getLastResource2() {
        FileObject fileObject;
        String string = I18nOptions.getPreferences().get(PROP_LAST_RESOURCE2, null);
        FileObject fileObject2 = fileObject = string != null ? I18nOptions.findFileObject(string) : null;
        if (fileObject != null && !fileObject.isFolder() && fileObject.isValid()) {
            try {
                return DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                I18nOptions.getPreferences().remove(PROP_LAST_RESOURCE2);
            }
        }
        return null;
    }

    public void setLastResource2(DataObject dataObject) {
        if (dataObject == null) {
            return;
        }
        I18nOptions.getPreferences().put(PROP_LAST_RESOURCE2, dataObject.getPrimaryFile().getPath());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(I18nOptions.class);
    }

    private static FileSystem[] getFileSystems() {
        ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>();
        for (File file : File.listRoots()) {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject == null) continue;
            try {
                arrayList.add(fileObject.getFileSystem());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Logger.getLogger(I18nOptions.class.getName()).log(Level.INFO, null, fileStateInvalidException);
            }
        }
        return arrayList.toArray(new FileSystem[arrayList.size()]);
    }

    private static FileObject findFileObject(String string) {
        for (FileSystem fileSystem : I18nOptions.getFileSystems()) {
            FileObject fileObject = fileSystem.findResource(string);
            if (fileObject == null) continue;
            return fileObject;
        }
        return null;
    }

    private static BeanNode createViewNode() throws IntrospectionException {
        return new BeanNode((Object)I18nOptions.getDefault());
    }
}

